<?php 

// NOTE: !is_admin() FRONT END ONLY

// UPDATED 2021 06 09

// ENTEX THEME CONTEXTUAL ENGINE
/* Everything we need to label on current view is within here */
/* translators: Yes and No is NOT output anywhere */
/* To easy track things: data as 'Yes' is simpler then '1' or true */

/* The main function is cached */
/* Do not run the function to early */
/* All Theme filters must be applied on first run */
/* 'wp' before output JSON should be fine */

// Note:
// First run: entex_template_init_current() is within entex-template-actions.php

function entex_theme_fn_init_current(){
	
	
	$current['conditionals'] = '';
	$current['conditional'] = '';
	$current['dynamic-part'] = '';
	$current['is'] = '';
	$current['is-taxonomy'] = '';
	$current['is-post-type-archive'] = '';
	$current['is-endpoint'] = '';
	$current['is-post-type'] = '';
	$current['is-hierarchical'] = '';
	$current['is-multipage'] = entex_theme_fn_get_entex_is_multipage();
	$current['is-paged'] = entex_on_multipage() ? 'Yes' : 'No';
	$current['paged'] = entex_on_multipage() ? entex_on_multipage() : '';
	$current['post-type-archive'] = '';
	$current['post-type-archive-for'] = '';
	$current['taxonomy'] = '';
	$current['term'] = '';
	$current['built-in-term'] = '';
	$current['format-type'] = '';
	$current['post-type'] = '';
	$current['singular'] = '';
	$current['plural'] = '';
	$current['taxonomy-for'] = '';
	$current['archive-for'] = '';
	$current['one'] = '';
	$current['many'] = '';
	$current['has-post-type-archive'] = '';
	$current['_has-post-type-archive'] = '';
	$current['has-taxonomies'] = '';
	$current['post-format'] = '';
	$current['endpoints'] = '';
	$current['archive-label'] = '';
	$current['action'] = '';
	$current['filtered'] = '';
	
	$current['setup'] = 'Based on setup:';
	$current['id'] = (get_queried_object_id() ? : esc_attr_x('Not based on id', 'Contextual data', 'entex'));
	$current['site-name'] = entex_theme_fn_get_blogname();
	$current['wordpress-title'] = '';
	$current['unfiltered-title'] = '';
	$current['filtered-title'] = '';
	$current['extended-titles'] = '';
	$current['extended-title-above'] = '';
	$current['extended-title-below'] = '';
	$current['title'] = esc_attr_x('Please filter the label', 'Contextual data', 'entex');
	$current['extended-subtitle'] = '';
	
	$current['labels'] = entex_theme_fn_init_current_labels($current);
	
	$current['_filter'] = '';
	$current['_filter-item'] = '';
	$current['_filter-group'] = '';
	$current['_filtered'] = '';
	$current['_filtered-item'] = '';
	$current['_filtered-group'] = '';
	
	/* not in use */
	$current['_wp-blog-settings'] = esc_attr_x('Current blog settings', 'Contextual data', 'entex');
	$current['url'] = '';

	return $current;
}

function entex_theme_fn_init_current_labels($current){
	
	$label['singular'] = '';
	$label['plural'] = '';
	$label['has-one'] = '';
	$label['has-many'] = '';
	$label['item'] = '';
	$label['items'] = '';
	$label['endpoint-one'] = '';
	$label['endpoint-many'] = '';
	$label['content-is'] = '';
	$label['status-is'] = '';
	$label['collection-is'] = '';
	$label['archive-is'] = '';
	$label['multipage'] = ($current['is-multipage'] != 'No') ? $current['is-multipage'] : '';
	$label['action'] = '';
	
	$label['title-before'] = '';
	$label['title'] = '';
	$label['title-after'] = '';
	$label['description'] = '';

	$label['object-is'] = '';
	$label['status-is'] = esc_attr_x('Published', 'Contextual data', 'entex');
	$label['entries-are'] = '';

	$label['breadcrumbs-end'] = '';
	$label['visible'] = '';
	$label['schema-endpoint'] = '';

	$label['filter-singular'] = '';
	$label['filter-archive'] = '';
	$label['filter-conditional'] = '';
	$label['filter-dynamic-part'] = '';

	return $label;
}

function entex_contextual_pre_alter_labels($label, $current){
	return $label;
}





function entex_contextual_post_filter_labels($label, $current){ 
	
	/* we actually need this most for monitor */
	/* The definitions must be translated within the final context later */
	
	$default = esc_html_x('Content', 'Contextual: Content (generic) label [ collection-is ] LIKE: Content published at ... | Published Content at ...', 'entex');
	$entries = esc_html_x('Content', 'Contextual: Content (generic) label [ entries-are ] LIKE: Content by author | Content by date | Content by category ...', 'entex');
	if(is_category() || is_tag() || is_author() || is_date() || is_tax('post_format')) $entries = esc_html_x('Entries', 'Contextual: Entries (generic) label [ entries-are ] LIKE: Entries by author | Entries by date | Entries by category ...', 'entex');
	$single = esc_html_x('Single', 'Contextual: Single (generic) singular label LIKE: Single page | Single product', 'entex');
	
	$specific = false;
	$label['collection-is'] = $default;
	$label['content-is'] = esc_html_x('Generic', 'Contextual data', 'entex');
	
	if(is_singular()){
		if($label['singular'] != $label['item']) $specific = true;
		if($label['plural'] != $label['items']) $specific = true;
		if($specific){
			$label['collection-is'] = $label['item'];
			$label['content-is'] = esc_html_x('Specified', 'Contextual data', 'entex');
		} else {
			$label['collection-is'] = $label['has-one'];
			if($label['plural'] != $label['has-many']) $label['collection-is'] = $label['has-many'];
			if($label['singular'] != $label['has-one']) $label['collection-is'] = $label['has-one'];
		}
		$label['object-is'] = $label['collection-is'];
	} else {
		if($label['items'] != $label['has-many']) $specific = true;
		if($specific) $label['content-is'] = esc_html_x('Specified', 'Contextual data', 'entex');
		$label['collection-is'] = $label['items'];
		$label['object-is'] = (is_post_type_archive() ? $label['plural'] : $label['singular']);
		/* We want 'content' instead of 'posts' */
		if(!$specific && $current['archive-for'] == 'post') $label['collection-is'] = $default;
	}

	
	/* filters */
	
	$object = $label['object-is'];
	$content = $label['collection-is'];
	
	if(is_singular()){
		$filter = 'singular';
		$label['filter-singular'] = 'entex_theme_labels_'. $filter;
		/* filter */
		$label = apply_filters($label['filter-singular'], $label, $object, $content, $current);
	} else {
		$filter = 'archive';
		$label['filter-archive'] = 'entex_theme_labels_'. $filter;
		/* filter */
		$label = apply_filters($label['filter-archive'], $label, $object, $content, $current);
	}
	
	$conditional = $current['conditional'];
	if(is_category() || is_tag() || is_tax()) $conditional = 'is_taxonomy';
	$dynamic = $current['dynamic-part'];
	
	if($conditional != $dynamic){
		$filter = $conditional;
		$label['filter-conditional'] = 'entex_theme_labels_'. $filter;
		/* filter */
		$label = apply_filters($label['filter-conditional'], $label, $object, $content, $current);
	}
	
	$filter = $dynamic;
	$label['filter-dynamic-part'] = 'entex_theme_labels_'. $filter;
	$label = apply_filters($label['filter-dynamic-part'], $label, $object, $content, $current);
	
	/* end */
	
	
	
	
	if(!$label['archive-is']){
		$label['archive-is'] = $current['archive-label'];
		if(!$label['archive-is']){
			$value = $label['collection-is'];
			/* translators: */
			$label['archive-is'] = esc_html(sprintf(_x('Published %1$s', 'Contextual Undefined archive label: (generic) Published label [ collection-is ] (singular) LIKE: Published page', 'entex'), entex_fn_lowercase($value)));
		}
	}
	
	// Note: $label['entries-are']
	/* Default populated as 'Entries' or 'Single' */
	/* Allowed to be '' (empty) by any applied filter to remove prefixed 'Entries by ...' */
	/* Post type archives (and blog) has default set as empty */
	
	if(!isset($label['entries'])){
		if(is_singular()) $label['entries-are'] = $single;
			else $label['entries-are'] = $entries;
		if(is_home()) $label['entries-are'] = '';
		if(is_post_type_archive()) $label['entries-are'] = '';
	} else {
		$label['entries-are'] = $label['entries'];
	}
	
	/* validate */
	if($label['visible']){
		$valid = false;
		if($label['visible'] == 'Yes') $valid = true;
		if($label['visible'] == 'No') $valid = true;
		if(!$valid) $label['visible'] = '';
	}
	
	if(!$label['breadcrumbs-end']){
	
		if(is_singular()){

			if($label['object-is'] != $current['singular']){
				
				/* translators: Single status page */
				if($label['entries-are']) $label['breadcrumbs-end'] = esc_html(sprintf( _x('Single %1$s page', 'Contextual breadcrumb: Single [ object-is ] page', 'entex'), entex_fn_lowercase($label['object-is']) ));
					else $label['breadcrumbs-end'] = $label['object-is'];
					
			} else if($current['post-type'] != 'post' && $current['post-type'] != 'page'){
				
				/* translators: Single product page */
				if($label['entries-are']) $label['breadcrumbs-end'] = esc_html(sprintf( _x('Single %1$s page', 'Contextual breadcrumb: Single [ object-is ] page', 'entex'), entex_fn_lowercase($label['object-is']) ));
					else $label['breadcrumbs-end'] = $label['object-is'];
					
			} else {
				
				/* translators: Single post */
				if($label['entries-are']) $label['breadcrumbs-end'] = esc_html(sprintf( _x('Single %1$s', 'Contextual breadcrumb: Single [ object-is ]', 'entex'), entex_fn_lowercase($label['object-is']) ));
					else $label['breadcrumbs-end'] = $label['object-is'];
			}
			
			/* filter */ // Final - Translating contextual adjustments
			$filter = 'entex_label_breadcrumb';
			$label['breadcrumbs-end'] = apply_filters($filter, $label['breadcrumbs-end'], $label, $current);
			
			/* We only allow languages to define pagination at the end of the phrase */
			/* $label['multipage'] is already translated here */
			
			if(!isset($label['paged'])){
				if($label['multipage']){
					/* translators: */
					$label['breadcrumbs-end'] = esc_html(sprintf(_x('%1$s - %2$s', 'Contextual pagination: [ object-is ] - Page 1 of 2', 'entex'), $label['object-is'], entex_fn_lowercase($label['multipage'])));
					if(!$label['visible']) $label['visible'] = 'Yes';
				}
			}
			
			if(!$label['visible']) $label['visible'] = 'No';
		
		} else {
			
			/* translators: */
			if($label['entries-are']) $label['breadcrumbs-end'] = esc_html(sprintf( _x('%1$s by %2$s', 'Contextual breadcrumb: label [ entries-are ] by label [ object-is ]', 'entex'), $label['entries-are'], entex_fn_lowercase($label['object-is']) ));
				else $label['breadcrumbs-end'] = $label['object-is'];
			if(!$label['visible']) $label['visible'] = 'Yes';
			
			/* filter */ // Final - Translating contextual adjustments
			$filter = 'entex_label_breadcrumb';
			$label['breadcrumbs-end'] = esc_html(apply_filters($filter, $label['breadcrumbs-end'], $label, $current));
			
			/* We only allow languages to define pagination at the end of the phrase */
			/* $label['multipage'] is already translated here */
			
			if(!isset($label['paged'])){
				if($label['multipage'] && is_paged()){
					/* translators: */
					$label['breadcrumbs-end'] = esc_html(sprintf(_x('%1$s - %2$s', 'Contextual pagination: [ object-is ] - Page 1 of 2', 'entex'), $label['object-is'], entex_fn_lowercase($label['multipage'])));
					if(!$label['visible']) $label['visible'] = 'Yes';
				}
			}
		}
	}
	
	if(!$label['title-before']) $label['title-before'] = $current['extended-title-above'];
	if(!$label['title-after'] && !$label['title-before']) $label['title-after'] = $current['extended-title-below'];

	if(!$label['title']){
		/* Note: entex_mb_ucfirst() is Entex extended PHP function */
		if($current['filtered-title']) $label['title'] = entex_mb_ucfirst($current['filtered-title']);
			else $label['title'] = entex_mb_ucfirst($current['unfiltered-title']);
	} else {
		/* isset */
		$label['filtered-title'] = $label['title'];
	}
	
	if(!$label['schema-endpoint']){
		$label['schema-endpoint'] = $label['title'];
		if(isset($label['paged'])){
			/* translators: */
			if($label['multipage']) $label['schema-endpoint'] = esc_html(sprintf(_x('%1$s - %2$s', 'Contextual: Schema if multipage LIKE: Hello world - page 1 of 8', 'entex'), $label['schema-endpoint'], entex_fn_lowercase($label['multipage'])));
		}
	}
	
	/* keep translation synced with the default meta fallback */
	/* translators: */
	if(!$label['description']) $label['description'] = wp_kses_post(sprintf(_x( 'Content published at %s', 'Meta LIKE: Content published at Entex media LTD', 'entex'), entex_theme_fn_get_home_link()));
	
	return $label;
}






// LAST
function entex_contextual_final_map_current($current){
	
	$label = $current['labels'];
	
	$current['title'] =  trim($label['title-before'].' '.$label['title'].' '.$label['title-after']);
	if(isset($label['filtered-title'])) $current['filtered-title'] = $label['filtered-title'];
	$current['extended-title-above'] = $label['title-before'];
	$current['extended-title-below'] = $label['title-after'];
	
	// Public
	$current['status'] = $label['status-is'];
	$current['content'] = $label['collection-is'];
	$current['breadcrumb'] = $label['breadcrumbs-end'];
	$current['breadcrumb-schema'] = $label['schema-endpoint'];
	$current['breadcrumb-visible'] = $label['visible'];
	$current['description'] = $label['description'];
	$current['archive'] = $label['archive-is'];
	
	return $current;
}




/**
 * Main function
 * Follows the conditional calculations as breadcrumbs do
 * Also as WordPress default archive title function do
 *
 * Each conditional shares some collection function(s)
 * Some conditionals dont
 * The filter to change or add labels are visible in Entex monitor
 * 
 * WordPress archives by slug:
 *
 * is_author()
 * is_date()
 * is_year()
 * is_month()
 * is_day()
 * is_time()
 * is_search()
 * is_404()
 *
 * REMARK: They have no labels, we populate the defaults in this function
 * The defaults are simulated fork from the core files
 * They should be translated by WordPress core
 *
 * All other should already be populated by their register functions
 * We do not change the defaults
 * We add a new level call 'labels' and add our changes there
 * The default labels inherits the registered labels
 * But this Theme filters most of them:
 *
 * /inc/entex-template-contextual-filters.php
 *
**/

function entex_theme_fn_get_is(){

	static $cache = false;
	static $counter = 0;
	$counter++;
	
	if($cache) return $cache;
	if($counter > 20) die('Someone is calling a filter');
	
	/* action */
	do_action('entex_theme_contextual_setup_before');
	
	$current = entex_theme_fn_init_current();
	$current['conditionals'] = entex_theme_fn_get_wordpress_conditionals();
	
	if( is_attachment() ){

		$current['conditional'] = 'is_attachment';
		$current = entex_theme_fn_get_is_singular($current);
		
	} else if( is_page() ){
		
		$current['conditional'] = 'is_page';
		$current = entex_theme_fn_get_is_singular($current);
		
	} else if( is_single() ){
		
		$current['conditional'] = 'is_single';
		$current = entex_theme_fn_get_is_singular($current);
		
	} else if( is_category() ){
		
		$current['conditional'] = 'is_category';
		$current = entex_theme_fn_get_is_taxonomies($current);

	} else if( is_tag() ){
		
		$current['conditional'] = 'is_tag';
		$current = entex_theme_fn_get_is_taxonomies($current);

	} else if( is_author() ){
		
		$current['conditional'] = 'is_author';
		$current['singular'] = esc_html__('Author', 'entex');
		$current['plural'] = esc_html__('Authors', 'entex');
		/* WordPress default method: */
		/* translators: */
		$current['wordpress-title'] = strip_tags(sprintf(__('Author: %s', 'entex'), '<span class="vcard">'. get_the_author() .'</span>'));
		$current['unfiltered-title'] = get_the_author();
		$current['filtered-title'] = $current['unfiltered-title'];
		
		$current['archive-label'] = esc_html_x('Author archive', 'Contextual: Author archive', 'entex');
		$current = entex_theme_fn_get_is_archive($current);
		
	} else if( is_year() ){
		
		$current['conditional'] = 'is_year';
		$current['singular'] = esc_html__('Year', 'entex');
		$current['plural'] = esc_html__('Years', 'entex');
		/* WordPress default method: */
		/* translators: */
		$current['wordpress-title'] = esc_html(sprintf(__('Year: %s', 'entex'), get_the_date(_x('Y', 'yearly archives date format', 'entex'))));
		$current['unfiltered-title'] = esc_html(get_the_date(_x('Y', 'yearly archives date format', 'entex')));
		/* translators: */
		$current['filtered-title'] = esc_html(sprintf(__('Year %s', 'entex'), get_the_date(_x('Y', 'yearly archives date format', 'entex'))));

		$current['archive-label'] = esc_html_x('Date archive', 'Contextual: Date archive', 'entex');
		$current = entex_theme_fn_get_is_archive($current);
		
	} else if( is_month() ){
		
		$current['conditional'] = 'is_month';
		$current['singular'] = esc_html__('Month', 'entex');
		$current['plural'] = esc_html__('Months', 'entex');
		/* WordPress default method: */
		/* translators: */
		$current['wordpress-title'] = esc_html(sprintf(__('Month: %s', 'entex'), get_the_date(_x('F Y', 'monthly archives date format', 'entex'))));
		$current['unfiltered-title'] = esc_html(get_the_date(_x('F Y', 'monthly archives date format', 'entex')));
		$current['filtered-title'] = $current['unfiltered-title'];
		
		$current['archive-label'] = esc_html_x('Date archive', 'Contextual: Date archive', 'entex');
		$current = entex_theme_fn_get_is_archive($current);
		
	} else if ( is_day() ) {
		
		$current['conditional'] = 'is_day';
		$current['singular'] = esc_html__('Day', 'entex');
		$current['plural'] = esc_html__('Days', 'entex');
		/* WordPress default method: */
		/* translators: */
		$current['wordpress-title'] = esc_html(sprintf(__('Day: %s', 'entex'), get_the_date(_x('F j, Y', 'daily archives date format', 'entex'))));
		$current['unfiltered-title'] = esc_html(get_the_date(_x('F j, Y', 'daily archives date format', 'entex')));
		$current['filtered-title'] = $current['unfiltered-title'];
		
		$current['archive-label'] = esc_html_x('Date archive', 'Contextual: Date archive', 'entex');
		$current = entex_theme_fn_get_is_archive($current);
		
	} else if( is_tax( 'post_format' ) ){
		
		$current['conditional'] = 'is_tax';

		if(is_tax('post_format', 'post-format-aside')){
			$title = esc_html_x('Asides', 'post format archive title', 'entex');
		} else if(is_tax('post_format', 'post-format-gallery')){
			$title = esc_html_x('Galleries', 'post format archive title', 'entex');
		} else if(is_tax('post_format', 'post-format-image')){
			$title = esc_html_x('Images', 'post format archive title', 'entex');
		} else if(is_tax('post_format', 'post-format-video')){
			$title = esc_html_x('Videos', 'post format archive title', 'entex');
		} else if(is_tax('post_format', 'post-format-quote')){
			$title = esc_html_x('Quotes', 'post format archive title', 'entex');
		} else if(is_tax('post_format', 'post-format-link')){
			$title = esc_html_x('Links', 'post format archive title', 'entex');
		} else if(is_tax('post_format', 'post-format-status')){
			$title = esc_html_x('Statuses', 'post format archive title', 'entex');
		} else if(is_tax('post_format', 'post-format-audio')){
			$title = esc_html_x('Audio', 'post format archive title', 'entex');
		} else if(is_tax('post_format', 'post-format-chat')){
			$title = esc_html_x('Chats', 'post format archive title', 'entex');
		}
		/* WordPress default method: */
		$current['wordpress-title'] = $title;
		$current['unfiltered-title'] = $title;
		/* translators: */
		$current['filtered-title'] = esc_html(sprintf(_x('Posted %2$s', 'Contextual Post format [ filtered-title ] LIKE: Posted links | %2$s = lowercase', 'entex'), $title, entex_fn_lowercase($title)));

		$current = entex_theme_fn_get_is_taxonomies($current);
		
	} else if(is_post_type_archive()){
		
		$current['conditional'] = 'is_post_type_archive';
		
		$post_types = get_query_var('post_type');

		/* this occurs on redirected placeholder pages */
		/* like product search woocommerce shop page */
		/* Or when post types array is not numeric */
		if(is_array($post_types)){
			if(isset($post_types[0])){
				$post_type = $post_types[0];
			} else {
				$value = filter_input( 
					INPUT_GET,
					'post_type',
					FILTER_SANITIZE_STRING 
				);
				if($value){
					$post_type = $value;
				} else $post_type = 'post';
			}
		} else $post_type = $post_types;

		$post_type_obj = get_post_type_object($post_type);
		$has_archive = str_replace('/', '', str_replace(get_home_url(), '', get_post_type_archive_link($post_type)));

		$taxonomies = get_object_taxonomies($post_type);
		if(!empty($taxonomies)) $taxonomies = 'Yes';
			else $taxonomies = 'No';

		$singular = (!empty($post_type_obj->labels->singular_name) ? $post_type_obj->labels->singular_name : $post_type_obj->label);
		$plural = (!empty($post_type_obj->labels->name) ? $post_type_obj->labels->name : $post_type_obj->label);
		
		$current['is'] = 'collection';
		$current['is-taxonomy'] = 'No';
		$current['is-post-type-archive'] = 'Yes';
		$current['is-endpoint'] = 'No';
		$current['is-post-type'] = 'No';
		$current['is-hierarchical'] = 'No';
		$current['post-type-archive'] = $has_archive;
		$current['post-type-archive-for'] = $post_type;
		$current['singular'] = $singular;
		$current['plural'] = $plural;

		/* translators: */
		$current['archive-label'] = esc_html(sprintf( _x('%s archive', 'Contextual LIKE: Product archive', 'entex'), $singular ));
		$current['action'] = '';
		$current['dynamic-part'] = $current['conditional'] .'_'. $post_type;
		/* translators: */
		$current['wordpress-title'] = esc_html(sprintf(__('Archives: %s', 'entex'), post_type_archive_title('', false)));
		$current['unfiltered-title'] = $current['plural'];
		$current['filtered-title'] = $current['unfiltered-title'];
		$current = entex_theme_fn_get_is_filtered_title($current);

		$label = $current['labels'];
	
		$label['singular'] = $current['singular'];
		$label['plural'] = $current['plural'];
		$label['has-one'] = $current['singular'];
		$label['has-many'] = $current['plural'];
		$label['item'] = $current['singular'];
		$label['items'] = $current['plural'];
		$label['content-is'] = '';
		$label['status-is'] = '';
		$label['collection-is'] = '';
		//$label['archive-is'] = $current['archive-label'];
		$label['action'] = $current['action'];
		$label = entex_contextual_pre_alter_labels($label, $current);
		
		$filter = $current['dynamic-part'];
		
		/* filter */
		$current['_filter'] = 'entex_theme_contextual_labels_'. $current['conditional'];
		$changes = apply_filters($current['_filter'], $label, $current);
		
		if(!empty($changes) && is_array($changes)){
			if($changes != $label){
				$current['_filtered'] = 'Yes';
			}
			$label = $changes;
		}

		/* filter */
		$current['_filter-item'] = 'entex_theme_contextual_labels_'. $filter;
		$changes = apply_filters($current['_filter-item'], $label, $current);
		if(!empty($changes) && is_array($changes)){
			if($changes != $label){
				$current['_filtered-item'] = 'Yes';
			}
			$label = $changes;
		}

		$label = entex_contextual_post_filter_labels($label, $current);
		$current['labels'] = $label;
		$current = entex_contextual_final_map_current($current);

	} else if( is_tax() ){
		
		$current['conditional'] = 'is_tax';
		$current = entex_theme_fn_get_is_taxonomies($current);
		
	} else if( is_search() ){

		$current['conditional'] = 'is_search';
		$current['singular'] = esc_html_x('Search', 'Contextual Search: [ singlar ] LIKE: Showing collection by Search', 'entex');
		$current['plural'] = esc_html_x('Searches', 'Contextual Search: [ plural ] LIKE: Many Searches has been done at this website', 'entex');
		$current['action'] = esc_html__('Search', 'entex');
		$current['filtered'] = esc_html(get_search_query());
		
		/* WordPress default method: */
		$current['wordpress-title'] = esc_html__('Archives', 'entex');
		$current['unfiltered-title'] = esc_html__('Archives', 'entex');
		$current['filtered-title'] = esc_html(get_search_query());

		$current['archive-label'] = esc_html_x('Search results', 'Contextual: Search archive', 'entex');
		$current = entex_theme_fn_get_is_archive($current);

	} else if( is_404() ){
		
		/* not in use yet - index.php is hardcoded */
		$current['is'] = 'single-item';
		$current['is-taxonomy'] = 'No';
		$current['is-post-type-archive'] = 'No';
		$current['is-endpoint'] = 'No';
		$current['is-post-type'] = 'No';
		$current['is-hierarchical'] = 'No';
		$current['conditional'] = 'is_404';
		$current['singular'] = esc_html__('Page', 'entex');
		$current['plural'] = esc_html__('Pages', 'entex');
		$current['dynamic-part'] = $current['conditional'];
		
		/* WordPress default method: */
		$current['wordpress-title'] = esc_html__('Archives', 'entex');
		$current['unfiltered-title'] = esc_html__('Archives', 'entex');
		$current['filtered-title'] = $current['unfiltered-title'];
		$current['archive-label'] = esc_html_x('Recommendations', 'Contextual: 404 archive', 'entex');
		$current['archive-label'] = esc_html_x('Undefined content', 'Contextual: 404 archive', 'entex');
		
		$label = $current['labels'];
		
		$label['singular'] = $current['singular'];
		$label['plural'] = $current['plural'];
		$label['has-one'] = $current['singular'];
		$label['has-many'] = $current['plural'];
		$label['item'] = $current['singular'];
		$label['items'] = $current['plural'];
		//$label['archive-is'] = $current['archive-label'];
		$label['action'] = $current['action'];
		$label['breadcrumb-end'] = '404';

		$filter = $current['conditional'];

		/* filter */
		$current['_filter'] = 'entex_theme_contextual_labels_'. $filter;
		$changes = apply_filters($current['_filter'], $label, $current);
		if(!empty($changes) && is_array($changes)){
			if($changes != $label){
				$current['_filtered'] = 'Yes';
			}
			$label = $changes;
		}
		$current['labels'] = $label;
		$current = entex_contextual_final_map_current($current);

	} elseif ( is_home() ){
		
		$current['conditional'] = 'is_home';
		$current['singular'] = esc_html__('Blog', 'entex');
		$current['plural'] = esc_html__('Blogs', 'entex');
		/* WordPress default method: */
		$current['wordpress-title'] = esc_html__('Archives', 'entex');
		$current['unfiltered-title'] = esc_html__('Archives', 'entex');
		$current['filtered-title'] = $current['unfiltered-title'];
		
		/* Entex method */
		if(get_queried_object_id()){
			
			/* Should match get_option('page_for_posts', true) */
			$post_id = get_queried_object_id();
			$_post = get_queried_object();

			$current['filtered-title'] = $_post->post_title;
			$current = entex_theme_fn_get_is_extended_titles($current, $post_id);

		} else {
			/* home.php or index.php */ // Title must be filtered-in or hardcoded in template
			$current['extended-titles'] = esc_html_x('Unknown', 'Contextual data', 'entex');
			$current['filtered-title'] = esc_html__('Index', 'entex');
		}
		
		$current['archive-label'] = esc_html_x('Post archive', 'Contextual: Blog archive', 'entex');
		$current = entex_theme_fn_get_is_archive($current);
		
	} else {
		
		/* This should not occur */

		$current['conditional'] = 'is_archive';
		$current['singular'] = esc_html__('Archive', 'entex');
		$current['plural'] = esc_html__('Archives', 'entex');
		$current['one'] = esc_html__('Entry', 'entex');
		$current['many'] = esc_html__('Entries', 'entex');
		/* WordPress default method: */
		$current['wordpress-title'] = esc_html__('Archives', 'entex');
		$current['unfiltered-title'] = esc_html__('Archives', 'entex');
		$current['filtered-title'] = $current['unfiltered-title'];

		$current['archive-label'] = esc_html_x('Archive', 'Contextual: Archive', 'entex');
		$current = entex_theme_fn_get_is_archive($current);
	}
	
	global $wp;
	$url = home_url($wp->request).'/';
	if(isset($_SERVER['QUERY_STRING'])) $query_string = esc_url_raw(wp_unslash($_SERVER['QUERY_STRING']));
		else $query_string = '';
	$current['url'] = $query_string ? $url .'?'. $query_string : $url;
	$current['url-canonical'] = home_url($wp->request).'/';
	$current['url-request'] = $query_string ? $query_string : '';
	
	/* filter */ // - WARNING changes with care - no validation - use label filter if possible
	$current = apply_filters('entex_theme_fn_get_'. $current['conditional'], $current);

	/* action */
	do_action('entex_theme_contextual_setup_after');
	
	$cache = $current;
	return $current;
}



/* archives */
function entex_theme_fn_get_is_archive($current){

	$current['is'] = 'collection';
	$current['is-taxonomy'] = 'No';
	$current['is-post-type-archive'] = 'No';
	$current['is-endpoint'] = 'No';
	$current['is-post-type'] = 'No';
	$current['is-hierarchical'] = 'No';
	if(!$current['one']) $current['one'] = esc_html__('Post', 'entex');
	if(!$current['many']) $current['many'] = esc_html__('Posts', 'entex');
	$current['archive-for'] = 'post';
	
	$current['dynamic-part'] = $current['conditional'];
	if(is_date()) $current['dynamic-part'] = 'is_date';

	$current = entex_theme_fn_get_is_filtered_title($current);
	
	$label = $current['labels'];
	
	$label['singular'] = $current['singular'];
	$label['plural'] = $current['plural'];
	$label['has-one'] = $current['one'];
	$label['has-many'] = $current['many'];
	$label['item'] = $current['one'];
	$label['items'] = $current['many'];
	$label['content-is'] = '';
	$label['status-is'] = '';
	$label['collection-is'] = '';
	//$label['archive-is'] = $current['archive-label'];
	$label['action'] = $current['action'];
	$label = entex_contextual_pre_alter_labels($label, $current);

	$filter = $current['dynamic-part'];
	
	/* filter */
	$current['_filter'] = 'entex_theme_contextual_labels_'. $filter;
	$changes = apply_filters($current['_filter'], $label, $current);
	if(!empty($changes) && is_array($changes)){
		if($changes != $label){
			$current['_filtered'] = 'Yes';
		}
		$label = $changes;
	}
	
	if(is_day() || is_month() || is_year() || is_time()){
	
		/* filter */ // - NOTE: Date archives only
		$current['_filter-item'] = 'entex_theme_contextual_labels_'.$current['conditional'];
		$changes = apply_filters($current['_filter-item'], $label, $current);
		
		if(!empty($changes) && is_array($changes)){
			if($changes != $label){
				$current['_filtered-item'] = 'Yes';
			}
			$label = $changes;
		}
	} else if(is_author()){
		
		/* filter */ // - NOTE: Author archives only - has user id
		$current['_filter-item'] = 'entex_theme_contextual_labels_'. $filter .'-'. $current['id'];
		$changes = apply_filters($current['_filter-item'], $label, $current);
		
		if(!empty($changes) && is_array($changes)){
			if($changes != $label){
				$current['_filtered-item'] = 'Yes';
			}
			$label = $changes;
		}
	} 
	
	$label = entex_contextual_post_filter_labels($label, $current);
	$current['labels'] = $label;
	$current = entex_contextual_final_map_current($current);

	return $current;
}



/* singular */
function entex_theme_fn_get_is_singular($current){
	
	$post_type = get_post_type();
	$post_type_obj = get_post_type_object($post_type);
	$taxonomies = get_object_taxonomies($post_type);
	if($post_type_obj->has_archive){
		$current['_has-post-type-archive'] = str_replace('/', '', str_replace(get_home_url(), '', get_post_type_archive_link($post_type)));
		$has_archive = $current['_has-post-type-archive'];
	} else $has_archive = 'No';
	if($post_type == 'post') $has_archive = $current['_wp-blog-settings'];
	
	$singular = (!empty($post_type_obj->labels->singular_name) ? $post_type_obj->labels->singular_name : $post_type_obj->label);
	$plural = (!empty($post_type_obj->labels->name) ? $post_type_obj->labels->name : $post_type_obj->label);
	$post_format = get_post_format();
	$format = ($post_format == 'standard' ? '' : $post_format);
	
	/* visual only */
	if(!$post_format) $post_format = 'standard';
	if(!in_array('post_format', $taxonomies)) $post_format = esc_html_x('Not supported', 'Contextual data', 'entex');
	
	$hierarchical = 'No';
	if(is_post_type_hierarchical($post_type)) $hierarchical = 'Yes';
	
	/* endpoints */ // - filter inside function 
	$endpoints = entex_theme_fn_get_is_endpoints();

	$current['is'] = 'single-item';
	$current['is-taxonomy'] = 'No';
	$current['is-post-type-archive'] = 'No';
	$current['is-endpoint'] = (is_array($endpoints) ? 'Yes' : 'No');
	$current['is-post-type'] = 'Yes';
	$current['is-hierarchical'] = $hierarchical;
	$current['post-type'] = $post_type;
	$current['singular'] = $singular;
	$current['plural'] = $plural;
	$current['has-post-type-archive'] = $has_archive;
	$current['has-taxonomies'] = $taxonomies;
	$current['post-format'] = $post_format;
	$current['endpoints'] = $endpoints;
	$current['action'] = '';
	$current['dynamic-part'] = 'is_'. $current['post-type'];
	
	$_post = get_queried_object();

	$current['wordpress-title'] = esc_html_x('( Unfiltered from database )', 'Contextual data', 'entex');
	$current['unfiltered-title'] = $_post->post_title;
	$current['filtered-title'] = $current['unfiltered-title'];
	$current = entex_theme_fn_get_is_extended_titles($current, $_post->ID);
	$current = entex_theme_fn_get_is_filtered_title($current);
	
	$label = $current['labels'];
	
	$label['singular'] = $current['singular'];
	$label['plural'] = $current['plural'];
	$label['has-one'] = $current['singular'];
	$label['has-many'] = $current['plural'];
	$label['item'] = $current['singular'];
	$label['items'] = $current['plural'];
	$label['endpoint-one'] = '';
	$label['endpoint-many'] = '';
	$label['content-is'] = '';
	$label['status-is'] = '';
	$label['collection-is'] = '';
	//$label['archive-is'] = $current['archive-label'];
	$label['action'] = $current['action'];
	$label = entex_contextual_pre_alter_labels($label, $current);
	
	if($format){
		$label = entex_theme_fn_populate_format_labels($label, $format);
	}
	
	// Move away
	if(is_array($endpoints)){
		/* Make values accessible in $label array */
		if($endpoints['title']) $label['endpoint-title'] = $endpoints['title'];
		if($endpoints['singular'] != $endpoints['endpoint']) $label['endpoint-one'] = $endpoints['singular'];
		if($endpoints['plural'] != $endpoints['endpoint']) $label['endpoint-many'] = $endpoints['plural'];
		if($endpoints['action']) $label['action'] = $endpoints['action'];
	}
	
	$filter = $current['dynamic-part'];
	
	/* filter */
	$current['_filter'] = 'entex_theme_contextual_labels_'. $filter;
	$changes = apply_filters($current['_filter'], $label, $current);
	if(!empty($changes) && is_array($changes)){
		if($changes != $label){
			$current['_filtered'] = 'Yes';
		}
		$label = $changes;
	} 
	
	/* filter */
	$current['_filter-item'] = 'entex_theme_contextual_labels_'. $filter .'-'. $current['id'];
	$changes = apply_filters($current['_filter-item'], $label, $current);
	if(!empty($changes) && is_array($changes)){
		if($changes != $label){
			$current['_filtered-item'] = 'Yes';
		}
		$label = $changes;
	}

	$label = entex_contextual_post_filter_labels($label, $current);
	$current['labels'] = $label;
	$current = entex_contextual_final_map_current($current);
	
	return $current;
}


function entex_theme_fn_get_is_taxonomies($current){
	
	$taxonomy = get_queried_object()->taxonomy;
	$taxonomy_object = get_taxonomy($taxonomy);
	$post_types = $taxonomy_object->object_type;
	if(isset($post_types[0])){
		$post_type = $post_types[0];
		$post_type_obj = get_post_type_object($post_type);
		$one = (!empty($post_type_obj->labels->singular_name) ? $post_type_obj->labels->singular_name : $post_type_obj->label);
		$many = (!empty($post_type_obj->labels->name) ? $post_type_obj->labels->name : $post_type_obj->label);
		if($post_type_obj->has_archive){
			$current['_has-post-type-archive'] = str_replace('/', '', str_replace(get_home_url(), '', get_post_type_archive_link($post_type)));
			$has_archive = $current['_has-post-type-archive'];
		} else $has_archive = 'No';
	} else {
		$one = '';
		$many = '';
		$has_archive = 'No';
	}
	if($post_type == 'post') $has_archive = $current['_wp-blog-settings'];
	
	if(is_tax('post_format')){
		$term = get_queried_object()->slug;
		$format = str_replace('post-format-', '', get_queried_object()->slug);
	} else {
		$term = '';
		$format = '';
	}
	
	$hierarchical = 'No';
	if(is_taxonomy_hierarchical($taxonomy)) $hierarchical = 'Yes';
	
	$singular = $taxonomy_object->labels->singular_name;
	$plural = $taxonomy_object->label;
	
	$current['is'] = 'collection';
	$current['is-taxonomy'] = 'Yes';
	$current['is-post-type-archive'] = 'No';
	$current['is-endpoint'] = 'No';
	$current['is-post-type'] = 'No';
	$current['is-hierarchical'] = $hierarchical;
	$current['taxonomy'] = $taxonomy;
	$current['built-in-term'] = $term;
	$current['format-type'] = $format;
	$current['singular'] = $singular;
	$current['plural'] = $plural;
	$current['taxonomy-for'] = $post_types;
	$current['one'] = $one;
	$current['many'] = $many;
	$current['has-post-type-archive'] = $current['_has-post-type-archive'];
	$current['action'] = '';
	$current['dynamic-part'] = 'is_'. $current['taxonomy'];
	
	$term = get_queried_object();
	$current['term'] = $term->name;
	
	/* Forked from get_the_archive_title() */
	/* translators: */
	if(is_category()) $title = esc_html(sprintf(__('Category: %s', 'entex'), single_cat_title('', false)));
	/* translators: */
	if(is_tag()) $title = esc_html(sprintf(__('Tag: %s', 'entex'), single_tag_title('', false)));
	/* translators: */
	if(is_tax()) $title = esc_html(sprintf(_x('%1$s: %2$s', 'Contextual: Taxonomy archive | %1$s = singular %2$s = single term title', 'entex'), $singular, single_term_title('', false)));
	
	if(is_tax('post_format')){
		// Titles populated in main function
		$current = entex_theme_fn_get_is_filtered_title($current);

	} else {
		$current['wordpress-title'] = $title;
		$current['unfiltered-title'] = $term->name;
		$current['filtered-title'] = $current['unfiltered-title'];
		$current = entex_theme_fn_get_is_filtered_title($current);
		
	}
	/* translators: */
	$current['archive-label'] = esc_html(sprintf( _x('%1$s archive', 'Contextual: Taxonomy archive | %1$s = singular %2$s = plural', 'entex'), $singular, $plural ));
	
	$label = $current['labels'];

	$label['singular'] = $current['singular'];
	$label['plural'] = $current['plural'];
	$label['has-one'] = $current['one'];
	$label['has-many'] = $current['many'];
	$label['item'] = $current['one'];
	$label['items'] = $current['many'];
	$label['content-is'] = '';
	$label['status-is'] = '';
	$label['collection-is'] = '';
	//$label['archive-is'] = $current['archive-label'];
	$label['action'] = $current['action'];
	$label = entex_contextual_pre_alter_labels($label, $current);
	
	if($current['taxonomy'] == 'post_format'){
		$label = entex_theme_fn_populate_format_labels($label, $format);
	}
	
	$filter = 'is_taxonomy';
	
	/* filter */
	$current['_filter-group'] = 'entex_theme_contextual_labels_'. $filter;
	$changes = apply_filters($current['_filter-group'], $label, $current);
	if(!empty($changes) && is_array($changes)){
		if($changes != $label){
			$current['_filtered-group'] = 'Yes';
		}
		$label = $changes;
	}
	
	
	$filter = $current['dynamic-part'];
	

	/* filter */
	$current['_filter'] = 'entex_theme_contextual_labels_'. $filter;
	$changes = apply_filters($current['_filter'], $label, $current);
	if(!empty($changes) && is_array($changes)){
		if($changes != $label){
			$current['_filtered'] = 'Yes';
		}
		$label = $changes;
	}
	
	/* filter */
	$current['_filter-item'] = 'entex_theme_contextual_labels_'. $filter .'-'. $current['id'];
	$changes = apply_filters($current['_filter-item'], $label, $current);
	if(!empty($changes) && is_array($changes)){
		if($changes != $label){
			$current['_filtered-item'] = 'Yes';
		}
		$label = $changes;
	}
	
	$label = entex_contextual_post_filter_labels($label, $current);
	$current['labels'] = $label;
	$current = entex_contextual_final_map_current($current);

	return $current;
}

// CONTEXTUAL ENDPOINTS
/* Note: entex_is_endpoint() is Entex function */
/* Populate endpoints, do not filter as label here */
/* Add label filter to current contextual, should be 'page' */
/* Return empty string if no endpoints for easier validation later */
function entex_theme_fn_get_is_endpoints(){
	
	$endpoints = array();
	if(function_exists('is_endpoint')){
		if(entex_is_endpoint()){
			$endpoint = entex_get_endpoint();
			$endpoints['endpoint'] = $endpoint;
			$endpoints['value'] = entex_get_endpoint($endpoint, true);
			$endpoints['title'] = entex_fn_titlecase($endpoint);
			
			/* Populates label base as endpoint variable */
			/* to make final label easier to translate */
			/* We dont know what the 'labels' are here */
			/* They must be added manually within filters */
			
			$endpoints['singular'] = $endpoint;
			$endpoints['plural'] = $endpoint;
			$endpoints['action'] = '';
			
			/* The variables are for monitor purposes */
			
			/* filter */ // All endpoints - WARNING - filter with care, no validation
			$endpoints['_filter-endpoints'] = 'entex_theme_contextual_endpoints';
			$endpoints = apply_filters($endpoints['_filter-endpoints'], $endpoints, 10, 1);
			
			/* filter */ // Current endpoint - WARNING - filter with care, no validation
			$endpoints['_filter-endpoint'] = 'entex_theme_contextual_endpoint_'. $endpoint;
			$endpoints = apply_filters($endpoints['_filter-endpoint'], $endpoints, 10, 1);

		}
	} else {
		
		/* filter */ // All endpoints - WARNING - filter with care, no validation
		$endpoints = apply_filters('entex_theme_contextual_endpoints', $endpoints, 10, 1);
	}
	
	if(is_array($endpoints) && empty($endpoints)) $endpoints = '';

	
	return $endpoints;
}









/* forked from WP core to keep translations */
function entex_theme_fn_populate_format_labels($label, $post_format){
	
	if ($post_format == 'aside'){
		$label['item'] = esc_html_x('Aside', 'Post format', 'entex');
		$label['items'] = esc_html_x('Asides', 'post format archive title', 'entex');
	} else if ($post_format == 'gallery'){
		$label['item'] = esc_html_x('Gallery', 'Post format', 'entex');
		$label['items'] = esc_html_x('Galleries', 'post format archive title', 'entex');
	} else if ($post_format == 'image'){
		$label['item'] = esc_html_x('Image', 'Post format', 'entex');
		$label['items'] = esc_html_x('Images', 'post format archive title', 'entex');
	} else if ($post_format == 'video'){
		$label['item'] = esc_html_x('Video', 'Post format', 'entex');
		$label['items'] = esc_html_x('Videos', 'post format archive title', 'entex');
	} else if ($post_format == 'quote'){
		$label['item'] = esc_html_x('Quote', 'Post format', 'entex');
		$label['items'] = esc_html_x('Quotes', 'post format archive title', 'entex');
	} else if ($post_format == 'link'){
		$label['item'] = esc_html_x('Link', 'Post format', 'entex');
		$label['items'] = esc_html_x('Links', 'post format archive title', 'entex');
	} else if ($post_format == 'status'){
		$label['item'] = esc_html_x('Status', 'Post format', 'entex');
		$label['items'] = esc_html_x('Statuses', 'post format archive title', 'entex');
	} else if ($post_format == 'audio'){
		$label['item'] = esc_html_x('Audio', 'Post format', 'entex');
		$label['items'] = esc_html_x('Audio', 'post format archive title', 'entex');
	} else if ($post_format == 'chat'){
		$label['item'] = esc_html_x('Chat', 'Post format', 'entex');
		$label['items'] = esc_html_x('Chats', 'post format archive title', 'entex');
	} 
	
	/* filter */ // NOTE - CURRENT post format label(s) ONLY
	$changes = apply_filters('entex_theme_contextual_labels_is_post_format_'. $post_format, $label);
	if(!empty($changes) && is_array($changes)){
		$label = $changes;
	}
	
	return $label;
}







/* Building array of conditional hierarchy */
function entex_theme_fn_get_wordpress_conditionals() {
	
	$is = array();
	
	if(is_front_page()) $is[] = 'is_front_page';
	if(is_home()) $is[] = 'is_home';
	
	/* singular */
	if(is_attachment()) $is[] = 'is_attachment';
	if(is_page()) $is[] = 'is_page';
	if(is_single()) $is[] = 'is_single';
	if(is_singular()) $is[] = 'is_singular';

	/* archives */
	if(is_category()) $is[] = 'is_category';
	if(is_tag()) $is[] = 'is_tag';
	if(is_author()) $is[] = 'is_author';
	if(is_year()) $is[] = 'is_year';
	if(is_month()) $is[] = 'is_month';
	if(is_day()) $is[] = 'is_day';
	if(is_time()) $is[] = 'is_time';
	if(is_date()) $is[] = 'is_date';
	if(is_post_type_archive()) $is[] = 'is_post_type_archive';
	if(is_tax()) $is[] = 'is_tax';
	if(is_search()) $is[] = 'is_search';
	if(is_404()) $is[] = 'is_404';
	if(is_archive()) $is[] = 'is_archive';
	
	// In progress:
	if(is_singular() && is_page_template()) $is[] = 'is_page_template';
	if(is_singular() && is_page_template()) $is[] = get_page_template_slug(get_queried_object_id());
	if(is_sticky()) $is[] = 'is_sticky';
	
	return $is;
}

/* ******************** */






/* -------------------- */
// EXTENDED TITLES

function entex_theme_fn_get_is_extended_titles($current, $post_id = null){
	
	if(!function_exists('entex_theme_get_extended_main_title')) return $current;
	if(defined('DISABLE_ENTEX_EXTENDED_TITLE')){
		$current['extended-titles'] = 'Disabled';
		return $current;
	}
	
	$current = entex_theme_fn_get_is_extended_title($current, $post_id);
	$current['extended-subtitle'] = entex_theme_get_extended_sub_title($post_id);
	return $current;
}

function entex_theme_fn_get_is_extended_title($current, $post_id = null){
	
	if(!function_exists('entex_theme_get_extended_main_title')) return $current;
	
	$position = entex_theme_get_extended_main_title_position($post_id);
	if($position) $current['extended-title-above'] = entex_theme_get_extended_main_title($post_id);
		else $current['extended-title-below'] = entex_theme_get_extended_main_title($post_id);
	return $current;
}


/* -------------------- */
// MAIN TITLE FILTER (and current pre filter)

function entex_theme_fn_get_is_filtered_title($current){
	
	/* Implement endpoint settings if exists */
	if(is_array($current['endpoints'])){
		if($current['endpoints']['title']) $current['filtered-title'] = $current['endpoints']['title'];
	}
	
	/* filter */ // ALL
	$current = apply_filters('entex_theme_contextual_pre_filter_current', $current);
	
	/* filter */ // DYNAMIC 
	$current = apply_filters('entex_theme_contextual_pre_filter_current_'. $current['dynamic-part'], $current);

	return $current;
}

/* ******************** */

// -- END FILE -- //