<?php 

// !is_admin() FRONT END ONLY

// Updated 2020 07 13
// Translations collected at the top of this file
// They are handy for many cases
// Do not change the Contextual context
// If so, they wont be found in .MO translated file

// TRANSLATION STRINGS
/* Prepare and include for diffrent scenarios */

$translation = _x('Result', 'Contextual: Singular label', 'entex');
$translation = _x('Results', 'Contextual: Plural label', 'entex');
$translation = _x('Type', 'Contextual: Singular label', 'entex');
$translation = _x('Types', 'Contextual: Plural label', 'entex');
$translation = _x('Item', 'Contextual: Singular label', 'entex');
$translation = _x('Items', 'Contextual: Plural label', 'entex');
$translation = _x('Booking', 'Contextual: Singular label', 'entex');
$translation = _x('Bookings', 'Contextual: Plural label', 'entex');
$translation = _x('Appointment', 'Contextual: Singular label', 'entex');
$translation = _x('Appointments', 'Contextual: Plural label', 'entex');
$translation = _x('Rental', 'Contextual: Singular label', 'entex');
$translation = _x('Rentals', 'Contextual: Plural label', 'entex');
$translation = _x('Treatment', 'Contextual: Singular label', 'entex');
$translation = _x('Treatments', 'Contextual: Plural label', 'entex');
$translation = _x('Meeting', 'Contextual: Singular label', 'entex');
$translation = _x('Meetings', 'Contextual: Plural label', 'entex');
$translation = _x('Session', 'Contextual: Singular label', 'entex');
$translation = _x('Sessions', 'Contextual: Plural label', 'entex');
$translation = _x('Download', 'Contextual: Plural label', 'entex');
$translation = _x('Downloads', 'Contextual: Plural label', 'entex');

/* Posted | Published | Filtered | Selected | Offered | Available | Overview */
/* translators: */
$translation = sprintf(_x('Posted %1$s', 'Contextual: Posted (items)', 'entex'), '');
/* translators: */
$translation = sprintf(_x('Published %1$s', 'Contextual: Published (items)', 'entex'), '');
/* translators: */
$translation = sprintf(_x('Filtered %1$s', 'Contextual: Filtered (items)', 'entex'), '');
/* translators: */
$translation = sprintf(_x('Selected %1$s', 'Contextual: Selected (items)', 'entex'), '');
/* translators: */
$translation = sprintf(_x('Offered %1$s', 'Contextual: Filtered (items)', 'entex'), '');
/* translators: */
$translation = sprintf(_x('Available %1$s', 'Contextual: Available (items)', 'entex'), '');
/* translators: */
$translation = sprintf(_x('Deleted %1$s', 'Contextual: Deleted (items)', 'entex'), '');

/* Swapping variables use: */
// entex_fn_lowercase($value)
// entex_fn_titlecase($value)

// NOTE EXAMPLE: $current['labels'] array is NOT AVAILABLE HERE
// EX $current['labels']['items'] is populated here by $labels['items']
// NOTE: Track the priorities as this is a FILTER SETUP




/* -------------------- */
// CUSTOM CONTEXTUAL FILTERS :


// CATEGORY ID: Events 
function entex_theme_filter_contextual_labels_is_category_events($label, $current){

	$label['item'] = _x('Event', 'Contextual: Singular label', 'entex');
	$label['items'] = _x('Events', 'Contextual: Plural label', 'entex');

	$placeholder_1 = $label['item'];
	$placeholder_2 = $label['items'];
	$placeholder_3 = entex_fn_lowercase($label['item']);
	$placeholder_4 = entex_fn_lowercase($label['items']);
	$placeholder_5 = entex_theme_fn_get_home_link();
	/* translators: */
	$label['description'] = sprintf(_x( 'Published %4$s at %5$s', 'Contextual description LIKE: Published products at Entex media LTD | %1$s = singuar %2$s = plural %3$s = lowercase %4$s = lowercase %5$s = sitelink', 'entex'), $placeholder_1, $placeholder_2, $placeholder_3, $placeholder_4, $placeholder_5 );
	
	return $label;
}
add_filter('entex_theme_contextual_labels_is_category-999', 'entex_theme_filter_contextual_labels_is_category_events', 10, 2);



// PLUGIN: Woocommerce
function entex_theme_filter_contextual_labels_is_product_software($label, $current){

	$label['item'] = _x('Software', 'Contextual: Singular label', 'entex');
	$label['items'] = _x('Softwares', 'Contextual: Plural label', 'entex');
	return $label;
}
add_filter('entex_theme_contextual_labels_is_product-999999', 'entex_theme_filter_contextual_labels_is_product_software', 30, 2);



// PLUGIN: Yoast locations - 'Locations' are offices
function entex_theme_filter_contextual_labels_is_wpseo_locations($label, $current){

	$label['item'] = _x('Office', 'Contextual: Singular label', 'entex');
	$label['items'] = _x('Offices', 'Contextual: Plural label', 'entex');
	return $label;
}
//add_filter('entex_theme_contextual_labels_is_wpseo_locations', 'entex_theme_filter_contextual_labels_is_wpseo_locations', 30, 2);
//add_filter('entex_theme_contextual_labels_is_wpseo_locations_category', 'entex_theme_filter_contextual_labels_is_wpseo_locations', 30, 2);



// PLUGIN: Entex media library extended
function entex_theme_filter_contextual_labels_is_attachment_category($label, $current){
	
	$label['item'] = _x('Media file', 'Contextual: Singular label', 'entex');
	$label['items'] = _x('Media files', 'Contextual: Plural label', 'entex');
	
	$placeholder_1 = $label['has-one'];
	$placeholder_2 = $label['has-many'];
	$placeholder_3 = entex_fn_lowercase($label['has-one']);
	$placeholder_4 = entex_fn_lowercase($label['has-many']);
	$placeholder_5 = entex_theme_fn_get_home_link();
	/* translators: */
	$label['description'] = sprintf(_x( 'Published %4$s at %5$s', 'Contextual description LIKE: Published products at Entex media LTD | %1$s = singuar %2$s = plural %3$s = lowercase %4$s = lowercase %5$s = sitelink', 'entex'), $placeholder_1, $placeholder_2, $placeholder_3, $placeholder_4, $placeholder_5 );

	return $label;
}
add_filter('entex_theme_contextual_labels_is_attachment_category', 'entex_theme_filter_contextual_labels_is_attachment_category', 30, 2);


// END : CONTEXTUAL FILTERS
/* ******************** */






/* -------------------- */
// CONTEXTUAL LABELS


// WordPress Post format taxonomy
/* Rename 'Format' to WordPress default slug: 'Type' for consistance */

function entex_theme_filter_contextual_labels_is_post_format($label, $current){

	$label['singular'] = _x('Type', 'Contextual Post format: Singular label', 'entex');
	$label['plural'] = _x('Types', 'Contextual Post format: Plural label', 'entex');
	
	if($current['format-type'] == 'status'){
		
		$label['title'] = _x('Posted Updates', 'Contextual Post format status: [ title ]', 'entex');
		
		$label['item'] = _x('Update', 'Contextual: Singular label', 'entex');
		$label['items'] = _x('Updates', 'Contextual: Plural label', 'entex');
		
		$placeholder_1 = $label['item'];
		$placeholder_2 = $label['items'];
		$placeholder_3 = entex_fn_lowercase($label['item']);
		$placeholder_4 = entex_fn_lowercase($label['items']);
		$placeholder_5 = entex_theme_fn_get_home_link();
		/* translators: */
		$label['description'] = sprintf(_x( 'Current %4$s at %5$s', 'Contextual description LIKE: Currend updates at Entex media LTD | %1$s = singuar %2$s = plural %3$s = lowercase %4$s = lowercase %5$s = sitelink', 'entex'), $placeholder_1, $placeholder_2, $placeholder_3, $placeholder_4, $placeholder_5 );

	}
	return $label;
}
add_filter('entex_theme_contextual_labels_is_post_format', 'entex_theme_filter_contextual_labels_is_post_format', 10, 2);


// NOTE: This is a unique pre-filter for each post format and the labels 
// WordPress EXAMPLE - Link as resource
function entex_theme_filter_contextual_labels_is_post_format_link($label){
	
	$label['item'] = _x('Resource', 'Contextual: Singular label', 'entex');
	$label['items'] = _x('Resources', 'Contextual: Plural label', 'entex');
	return $label;
}
add_filter('entex_theme_contextual_labels_is_post_format_link', 'entex_theme_filter_contextual_labels_is_post_format_link', 10, 1);



// WordPress is_author() Contributor
function entex_theme_filter_contextual_labels_is_contributor($label, $current){

	$label['singular'] = _x('Contributor', 'Contextual: Singular label', 'entex');
	$label['plural'] = _x('Contributors', 'Contextual: Plural label', 'entex');
	return $label;
}
add_filter('entex_theme_contextual_labels_is_author-8', 'entex_theme_filter_contextual_labels_is_contributor', 10, 2);



// ALL TAXONOMIES - priority 5
function entex_theme_filter_contextual_labels_is_taxonomy($label, $current){

	$placeholder_1 = $label['item'];
	$placeholder_2 = $label['items'];
	$placeholder_3 = entex_fn_lowercase($label['item']);
	$placeholder_4 = entex_fn_lowercase($label['items']);
	$placeholder_5 = entex_theme_fn_get_home_link();
	/* translators: */
	$label['description'] = sprintf(_x( 'Collection of published %4$s at %5$s', 'Contextual description LIKE: Collection of published products at Entex media LTD | %1$s = singuar %2$s = plural %3$s = lowercase %4$s = lowercase %5$s = sitelink', 'entex'), $placeholder_1, $placeholder_2, $placeholder_3, $placeholder_4, $placeholder_5 );
	return $label;
}
add_filter('entex_theme_contextual_labels_is_taxonomy', 'entex_theme_filter_contextual_labels_is_taxonomy', 5, 2);



// WordPress CATEGORY - use default meta
function entex_theme_filter_contextual_labels_is_category($label, $current){

	$label['description'] = '';
	return $label;
}
add_filter('entex_theme_contextual_labels_is_category', 'entex_theme_filter_contextual_labels_is_category', 10, 2);



// WordPress TAGS
function entex_theme_filter_contextual_labels_is_post_tag($label, $current){

	/* translators: */
	$label['description'] = sprintf(_x( 'Collection of published entries at %s', 'Contextual description LIKE: Collection of published entries at Entex media LTD', 'entex'), entex_theme_fn_get_home_link() );
	return $label;
}
add_filter('entex_theme_contextual_labels_is_post_tag', 'entex_theme_filter_contextual_labels_is_post_tag', 10, 2);



// WordPress HOME - use default meta
function entex_theme_filter_contextual_labels_is_home($label, $current){

	$label['description'] = '';
	return $label;
}
add_filter('entex_theme_contextual_labels_is_home', 'entex_theme_filter_contextual_labels_is_home', 10, 2);



// WordPress is_attachment() - activate visible breadcrumb
function entex_theme_filter_contextual_labels_is_attachment($label, $current){

	$label['entries'] = '';
	$label['visible'] = 'Yes';
	return $label;
}
add_filter('entex_theme_contextual_labels_is_attachment', 'entex_theme_filter_contextual_labels_is_attachment', 10, 2);



// WordPress is_search() archive
function entex_theme_filter_contextual_labels_is_search($label, $current){
	
	$label['item'] = _x('Result', 'Contextual: Singular label', 'entex');
	$label['items'] = _x('Results', 'Contextual: Plural label', 'entex');
	
	$placeholder_1 = $label['item'];
	$placeholder_2 = $label['items'];
	$placeholder_3 = entex_fn_lowercase($label['item']);
	$placeholder_4 = entex_fn_lowercase($label['items']);
	$placeholder_5 = entex_theme_fn_get_home_link();
	/* translators: */
	$label['description'] = sprintf(_x( 'Search %4$s at %5$s', 'Contextual description LIKE: Search results at Entex media LTD | %1$s = singuar %2$s = plural %3$s = lowercase %4$s = lowercase %5$s = sitelink', 'entex'), $placeholder_1, $placeholder_2, $placeholder_3, $placeholder_4, $placeholder_5 );
	return $label;
}
add_filter('entex_theme_contextual_labels_is_search', 'entex_theme_filter_contextual_labels_is_search', 10, 2);



// WordPress is_author() archive
function entex_theme_filter_contextual_labels_is_author($label, $current){

	/* default item is post */
	
	$placeholder_1 = $label['item'];
	$placeholder_2 = $label['items'];
	$placeholder_3 = entex_fn_lowercase($label['item']);
	$placeholder_4 = entex_fn_lowercase($label['items']);
	$placeholder_5 = entex_theme_fn_get_home_link();
	/* translators: */
	$label['description'] = sprintf(_x( 'Author archive at %5$s', 'Contextual description LIKE: Date archive at Entex media LTD | %1$s = singuar %2$s = plural %3$s = lowercase %4$s = lowercase %5$s = sitelink', 'entex'), $placeholder_1, $placeholder_2, $placeholder_3, $placeholder_4, $placeholder_5 );
	return $label;
}
add_filter('entex_theme_contextual_labels_is_author', 'entex_theme_filter_contextual_labels_is_author', 5, 2);


 
// WordPress is_date() | is_year() | is_month() | is_day() | is_time()
function entex_theme_filter_contextual_labels_is_date($label, $current){

	/* default item is post */

	$placeholder_1 = $label['item'];
	$placeholder_2 = $label['items'];
	$placeholder_3 = entex_fn_lowercase($label['item']);
	$placeholder_4 = entex_fn_lowercase($label['items']);
	$placeholder_5 = entex_theme_fn_get_home_link();
	/* translators: */
	$label['description'] = sprintf(_x( 'Date archive at %5$s', 'Contextual description LIKE: Date archive at Entex media LTD | %1$s = singuar %2$s = plural %3$s = lowercase %4$s = lowercase %5$s = sitelink', 'entex'), $placeholder_1, $placeholder_2, $placeholder_3, $placeholder_4, $placeholder_5 );

	return $label;
}
add_filter('entex_theme_contextual_labels_is_date', 'entex_theme_filter_contextual_labels_is_date', 5, 2);



// 404
function entex_theme_filter_contextual_labels_is_404($label, $current){

	$label['description'] = '';
	return $label;
}
add_filter('entex_theme_contextual_labels_is_404', 'entex_theme_filter_contextual_labels_is_404', 10, 2);

// END : CONTEXTUAL LABELS
/* ******************** */






/* -------------------- */
// THEME LABELS FILTERS :
/* applies after 'entex_theme_filter_contextual_labels_' filters */
/* passed arguments are calculated by the filter above */

function entex_theme_filter_labels_is_author($label, $object, $content, $current){
	/* translators: */
	$title_before = sprintf(_x('%1$s published by', 'Contextual: [ title-before ] Author: Content published by [ name ]', 'entex'), $content);
	$label['title-before'] = $title_before;
	return $label;
}
add_filter('entex_theme_labels_is_author', 'entex_theme_filter_labels_is_author', 5, 4);

function entex_theme_filter_labels_is_time($label, $object, $content, $current){
	/* translators: */
	$title_before = sprintf(_x('%1$s published', 'Contextual: [ title-before ] Time: Content published at [ time ]', 'entex'), $content);
	$label['title-before'] = $title_before;
	return $label;
}
add_filter('entex_theme_labels_is_time', 'entex_theme_filter_labels_is_time', 5, 4);

function entex_theme_filter_labels_is_day($label, $object, $content, $current){
	/* translators: */
	$title_before = sprintf(_x('%1$s published on', 'Contextual: [ title-before ] Day: Content published on [ day ]', 'entex'), $content);
	$label['title-before'] = $title_before;
	return $label;
}
add_filter('entex_theme_labels_is_day', 'entex_theme_filter_labels_is_day', 5, 4);

function entex_theme_filter_labels_is_month($label, $object, $content, $current){
	/* translators: */
	$title_before = sprintf(_x('%1$s published during', 'Contextual: [ title-before ] Month: Content published during [ month ]', 'entex'), $content);
	$label['title-before'] = $title_before;
	return $label;
}
add_filter('entex_theme_labels_is_month', 'entex_theme_filter_labels_is_month', 5, 4);

function entex_theme_filter_labels_is_year($label, $object, $content, $current){
	/* translators: */
	$title_before = sprintf(_x('%1$s published', 'Contextual: [ title-before ] Year: Content published [ year ]', 'entex'), $content);
	$label['title-before'] = $title_before;
	return $label;
}
add_filter('entex_theme_labels_is_year', 'entex_theme_filter_labels_is_year', 5, 4);

function entex_theme_filter_labels_is_search($label, $object, $content, $current){
	/* translators: */
	$title_before = sprintf(_x('%1$s found by', 'Contextual: [ title-before ] Search: Content found by [ keyword ]', 'entex'), $content);
	$label['title-before'] = $title_before;
	return $label;
}
add_filter('entex_theme_labels_is_search', 'entex_theme_filter_labels_is_search', 5, 4);

// END : THEME LABELS FILTERS
/* ******************** */






/* -------------------- */
// ENTEX AJAX CALENDAR PLUGIN FILTER
/* provided as example of use */

// ENTEX CALENDAR AS NATIVE is_date() | is_year() | is_month() | is_day() | is_time()
function entex_theme_filter_contextual_labels_is_date_calendar_native($label, $current){

	if(!filter_input(INPUT_GET, 'acal_get_post_type', FILTER_SANITIZE_STRING)) return $label;

	/* default item is post */

	$placeholder_1 = $label['item'];
	$placeholder_2 = $label['items'];
	$placeholder_3 = entex_fn_lowercase($label['item']);
	$placeholder_4 = entex_fn_lowercase($label['items']);
	$placeholder_5 = entex_theme_fn_get_home_link();
	
	/* translators: */
	$label['description'] = sprintf(_x( 'Calendar archive at %5$s', 'Contextual description LIKE: Calendar archive at Entex media LTD | %1$s = singuar %2$s = plural %3$s = lowercase %4$s = lowercase %5$s = sitelink', 'entex'), $placeholder_1, $placeholder_2, $placeholder_3, $placeholder_4, $placeholder_5 );

	if($acal_get_event = filter_input(INPUT_GET, 'acal_get_event', FILTER_SANITIZE_STRING)){
		
		remove_filter('entex_theme_labels_is_day', 'entex_theme_filter_labels_is_day', 5, 4);
		remove_filter('entex_theme_labels_is_month', 'entex_theme_filter_labels_is_month', 5, 4);
		remove_filter('entex_theme_labels_is_year', 'entex_theme_filter_labels_is_year', 5, 4);
		
		/* translators: */
		$title_before = sprintf(_x('Content during', 'Contextual: [ title-before ] Date archive LIKE: Content during [ month ]', 'entex'), $name);
		$label['title-before'] = $title_before;
	}
	
	
	if(!$acal_get_term_id = filter_input(INPUT_GET, 'acal_get_term_id', FILTER_SANITIZE_STRING)) return $label;
	
	remove_filter('entex_theme_labels_is_day', 'entex_theme_filter_labels_is_day', 5, 4);
	remove_filter('entex_theme_labels_is_month', 'entex_theme_filter_labels_is_month', 5, 4);
	remove_filter('entex_theme_labels_is_year', 'entex_theme_filter_labels_is_year', 5, 4);
	
	$name = get_term($acal_get_term_id)->name;
	
	/* translators: */
	$title_before = sprintf(_x('Content by %1$s during', 'Contextual: [ title-before ] Date archive LIKE: Content by [ filter ] during [ month ]', 'entex'), $name);
	$label['title-before'] = $title_before;
	
	return $label;
}
add_filter('entex_theme_contextual_labels_is_date', 'entex_theme_filter_contextual_labels_is_date_calendar_native', 10, 2);

// END : ENTEX CALENDAR PLUGIN FILTER
/* ******************** */






/* -------------------- */
// SINGULAR BREADCRUMB FILTER
/* Translation mechanism */
/* NOTE: $label['breadcrumbs-end'] return format ONLY */

function entex_theme_filter_label_breadcrumb($breadcrumb, $label, $current){
	
	return $breadcrumb; // Under construction
	
	/* Empty variable always creates default post type translated word */
	if(!$label['entries-are']) return $breadcrumb;
	
	$placeholder_1 = '';
	$placeholder_2 = '';
	$placeholder_3 = '';
	$placeholder_4 = '';
	$placeholder_5 = '';
	
	$locale = get_locale();
	
	if(is_singular()){
		if($current['dynamic-part'] == 'is_post'){
			/* translators: */
			if($locale == 'sv_SE') $breadcrumb = sprintf( _x('Single %2$s page', 'Contextual breadcrumb sv_SE | is_post LIKE: Single product page | %2$s = lowercase', 'entex'), $label['object-is'], entex_fn_lowercase($label['object-is']) );
		}
		if($current['dynamic-part'] == 'is_page'){
			/* translators: */
			if($locale == 'sv_SE') $breadcrumb = sprintf( _x('Single %2$s page', 'Contextual breadcrumb sv_SE | is_page LIKE: Single product page | %2$s = lowercase', 'entex'), $label['object-is'], entex_fn_lowercase($label['object-is']) );
		}
	} else {
		$sniffer = 'BUG';
	}
	return $breadcrumb;
}
add_filter('entex_label_breadcrumb', 'entex_theme_filter_label_breadcrumb', 10, 3);

/* ******************** */





/* -------------------- */
// CONTEXTUAL ARCHIVE META

function entex_theme_filter_contextual_archive_meta($content){
	
	$current = entex_theme_fn_get_is();

	// DEFAULT: ( Already populated ) within: entex_template_get_archive_meta()
	/* translators: */
	// $default = sprintf(_x( 'Content published at %s', 'Meta LIKE: Content published at Entex media LTD', 'entex'), entex_theme_fn_get_home_link());
	
	$content = $current['labels']['description'];
	return $content;
}
add_filter('entex_theme_filter_get_archive_meta_contextual', 'entex_theme_filter_contextual_archive_meta', 10, 1);

/* ******************** */

// -- END FILE -- //