<?php
/**
 * Entex theme back compat functionality
 *
 * Prevents Entex theme from running on WordPress versions prior to 5.4,
 * since this theme is not meant to be backward compatible beyond that and
 * relies on many newer functions and markup changes introduced in 5.4.
 *
 * @package Entex
 * @subpackage Entex
 * @since entex 1.0
 * 
 * Documentation: https://entex.info
 * Contributor: Jonas Lundman
 */


function entex_theme_back_compat_switch_theme(){
	switch_theme(WP_DEFAULT_THEME, WP_DEFAULT_THEME);
	unset( $_GET['activated'] );
	add_action('admin_notices', 'entex_theme_back_compat_upgrade_notice');
}
add_action('after_switch_theme', 'entex_theme_back_compat_switch_theme');


function entex_theme_back_compat_upgrade_notice(){
	/* translators: */
	$message = sprintf(_x('This theme requires at least WordPress version 5.4. You are running version %s. Please upgrade and try again.', 'Data', 'entex'), $GLOBALS['wp_version']);
	printf('<div class="error"><p>%s</p></div>', esc_html($message));
}


function entex_theme_back_compat_customize(){
	/* translators: */
	wp_die(esc_html(sprintf(_x('This theme requires at least WordPress version 5.4. You are running version %s. Please upgrade and try again.', 'Data', 'entex'), $GLOBALS['wp_version'])), '', array(
		'back_link' => true,
	));
}
add_action('load-customize.php', 'entex_theme_back_compat_customize');

function entex_theme_back_compat_preview() {
	if(isset($_GET['preview'])){
		/* translators: */
		wp_die(esc_html(sprintf(_x('This theme requires at least WordPress version 5.4. You are running version %s. Please upgrade and try again.', 'Data', 'entex' ), $GLOBALS['wp_version'])));
	}
}
add_action('template_redirect', 'entex_theme_back_compat_preview');

// -- END FILE -- //