<?php if(!defined('ABSPATH')) die(); 
/**
 * The template for displaying the site header
 *
 * Displays all of the head element and everything up until if(has_post()).
 *
 * @package Entex
 * @subpackage Entex
 * @version 2.20925
 */

/**
 * HOOKS - This will be updated in next release
 *
 * do_action('entex_template_before_template', args)
 * @hooked: entex_template_comment_before_template', 10, 5
 *
 * wp_head()
 * @hooked: entex_template_output_javascript_detection, -5
 * @hooked: entex_template_output_wp_head_default, -5
 *
 * do_action('entex_template_header_column_1', 4, true)
 * @hooked: entex_template_output_header_branding, 10, 2
 *
 * do_action('entex_template_header_column_2', 4, true)
 * @hooked: None (But uses optional background presentations)
 *
 * do_action('entex_template_before_main_section', 0)
 * @hooked: None (dynamically applied by custom meta)
 *
 * do_action('entex_template_shortcut_tabs_top', indent, $position, $root)
 * @hooked: entex_template_output_shortcut_tabs, 10, 3
 *
 * do_action('entex_template_before_main_content', 5)
 * @hooked: entex_template_output_breadcrumbs, 10, 1
 *
 * do_action('entex_template_after_template', args)
 * @hooked: entex_template_comment_after_template', 10, 4
 *
 * NOTE: entex_template_output_action_comment, 5, 1
 * is not documented as it hooks into every action
 * As of all source comments, define responding constant to disable
 *
 */

?><!DOCTYPE html>
<?php do_action('entex_template_before_template', 0, '', __FILE__, entex_backtrace(), false); ?>
<html <?php language_attributes(); ?> class="<?php entex_template_output_html_class(array('no-js')); ?>">
<head>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: -->
<?php wp_head(); ?>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: -->
</head>
<?php entex_template_output_source_comment('Document BODY HTML start', __FILE__); ?>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: -->
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: -->
<a id="ua-id-skip-content" class="skip-link screen-reader-text" href="#content"><?php esc_html_e('Skip to content', 'entex'); ?></a>
<a id="ua-id-skip-navigation" class="skip-link screen-reader-text" href="#ua-nav-expander"><?php esc_html_e('Skip to navigation', 'entex'); ?></a>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: -->
<div id="ua-window-background" class="ua-window-background" role="presentation"></div>
<div id="ua-window-wr" class="ua-init ua-window-wr">

<?php if(has_nav_menu('top-primary') || has_nav_menu('top-secondary')) : ?>
 <div class="" id="ua-id-navigation-top" role="navigation">
  <div class="ua-grid-root ua-set-sitewidth ua-grid-right ua-grid-menu ua-rem-nav-pad">
<?php if(has_nav_menu('top-primary')) : ?>
   <div class="ua-grid-item-1 ua-grid-span ua-nav-wr"><div class="ua-grid-inner">
    <nav class="ua-nav ua-menu-mix">
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- MENU TOP 1 -->

<?php wp_nav_menu(array('theme_location' => 'top-primary', 'menu_class' => false, 'menu_id' => false, 'container' => false)); ?>

<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- END MENU TOP 1 -->
    </nav>
   </div></div>
<?php endif; ?>
<?php if(has_nav_menu('top-secondary')) : ?>
   <div class="ua-grid-item-2 ua-nav-wr"><div class="ua-grid-inner">
    <nav class='ua-nav ua-menu-mix'>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- MENU TOP 2 -->

<?php wp_nav_menu(array('theme_location' => 'top-secondary', 'menu_class' => false, 'menu_id' => false, 'container' => false)); ?>

<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- END MENU TOP 2 -->
    </nav>
   </div></div>
<?php endif; ?>
  </div>
 </div>
<?php endif; ?>



 <div class="" id="ua-id-navigation" role="navigation">
  <div class="ua-grid-root ua-set-sitewidth ua-grid-right ua-grid-menu ua-rem-nav-pad">
   <div class="ua-grid-item-1 ua-grid-span ua-nav-wr"><div class="ua-grid-inner">
    <nav class="ua-nav ua-menu-mix">
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- PRIMARY MENU -->

<?php wp_nav_menu(array('theme_location' => 'primary', 'menu_class' => false, 'menu_id' => false, 'container' => false)); ?>

<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- END PRIMARY MENU -->
    </nav>
   </div></div>
<?php if(has_nav_menu('secondary')) : ?>
   <div class="ua-grid-item-2"><div class="ua-grid-inner">
    <nav class='ua-nav ua-menu-mix ua-icons-only'>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- SECONDARY MENU -->

<?php wp_nav_menu(array('theme_location' => 'secondary', 'menu_class' => false, 'menu_id' => false, 'container' => false)); ?>

<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- END SECONDARY MENU -->
    </nav>
   </div></div>
<?php endif; ?>
  </div>
 </div>
 
<?php if(has_nav_menu('social-primary') || has_nav_menu('social-secondary')) : ?>
 <div class="ua-root" id="ua-id-navigation-social" role="navigation">
  <div class="ua-grid-root ua-set-sitewidth ua-grid-right ua-grid-menu ua-rem-nav-pad">
<?php if(has_nav_menu('social-primary')) : ?>
   <div class="ua-grid-item-1 ua-grid-span ua-nav-wr"><div class="ua-grid-inner">
    <nav class="ua-nav ua-nav-x ua-icons-only">
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- MENU SOCIAL -->

<?php wp_nav_menu(array('theme_location' => 'social-primary', 'menu_class' => false, 'menu_id' => false, 'container' => false)); ?>

<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- END MENU SOCIAL -->
    </nav>
   </div></div>
<?php endif; ?>
<?php if(has_nav_menu('social-secondary')) : ?>
   <div class="ua-grid-item-2 ua-nav-wr"><div class="ua-grid-inner">
    <nav class='ua-nav ua-nav-x ua-icons-only'>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- MENU SOCIAL -->

<?php wp_nav_menu(array('theme_location' => 'social-secondary', 'menu_class' => false, 'menu_id' => false, 'container' => false)); ?>

<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- END MENU SOCIAL -->
    </nav>
   </div></div>
<?php endif; ?>
  </div>
 </div>
<?php endif; ?>


 <div id="ua-id-header" class="">
<?php if(has_nav_menu('header-primary')) : ?>
  <div id="ua-id-header-nav">
   <div class="ua-grid-root ua-set-sitewidth ua-grid-right ua-meta ua-rem-nav-pad">
    <div class="ua-grid-item-1 ua-grid-span"><div class="ua-grid-inner">
     <nav class="ua-nav ua-nav-x">
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- PRIMARY MENU -->

<?php wp_nav_menu(array('theme_location' => 'header-primary', 'menu_class' => false, 'menu_id' => false, 'container' => false)); ?>

<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- END PRIMARY MENU -->
     </nav>
    </div></div>
   </div>
  </div>
<?php endif; ?>
  <div id="ua-id-header-content" class="ua-grid-root ua-set-sitewidth">
   <div class="ua-grid-item-1 ua-grid-span ua-keep-column">
    <div id="ua-id-branding" class="ua-branding-wr ua-wrapper">
	 <?php do_action('entex_template_header_column_1', 5); ?>
	 <button id="ua-nav-expander" data-menu-close="<?php echo esc_attr_x('Close navigation menu', 'Menu button', 'entex'); ?>">
	  <span class="screen-reader-text"><?php echo esc_html_x('Menu', 'Menu button', 'entex'); ?></span>
      <span>
       <span></span>
       <span></span>
       <span></span>
      </span>
      <span></span>
     </button>
    </div>
   </div>
   <div id="ua-id-header-column" class="ua-grid-item-2"><?php do_action('entex_template_header_column', 3, ''); ?></div>
  </div>
 </div>

<?php if(is_customize_preview()): ?>
 <div class="ua-root ua-root-section-preview ua-init-form">
  <div class="ua-grid-root ua-grid-box ua-set-sitewidth">
   <div id="ua-customizer-preview-main" class="ua-grid-item-1 ua-grid-span ua-main ua-content"><?php do_action('entex_template_preview_main', 3, ''); ?></div>
   <div id="ua-customizer-preview-not-main" class="ua-grid-item-2 ua-not-main ua-content"><?php do_action('entex_template_preview_not_main', 3, ''); ?></div>
  </div>
 </div>
<?php endif; ?>

<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- SECTION INCLUSION START -->
<?php do_action('entex_template_after_header', 0, 'ua-root-section-merged'); ?>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- END SECTION INCLUSION -->

<!-- section in here -->

<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- TABS TOP START -->
<?php do_action('entex_template_shortcut_tabs_top', 1, 'top', true); ?>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- END TABS -->

 <div class="ua-root ua-root-content ua-root-main ua-init-form">
  <div class="ua-grid-root <?php echo esc_attr(apply_filters('entex_template_filter_main_root_attributes', 'ua-grid-box ua-set-sitewidth')); ?>">
   <main id="content" role="main" class="ua-grid-item-1 ua-grid-span ua-main ua-content">
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- MAIN CONTENT START -->
<?php do_action('entex_template_before_main_content', 4); ?>
<?php do_action('entex_template_after_template', 4, '', __FILE__, entex_backtrace(), false); ?>