<?php if(!defined('ABSPATH')) die(); ?>
<?php
/**
 * The template for displaying the site footer
 *
 * Displays all of the site elements from endif:has_post() until end.
 *
 * @package Entex
 * @subpackage Entex
 * @since Entex 1.0
 * @version 2.20915
 */

/**
 * HOOKS
 *
 * do_action('entex_template_before_template', args)
 * @hooked: entex_template_comment_before_template', 10, 4
 *
 * do_action('entex_template_after_main_content')
 * @hooked: none
 *
 * do_action('entex_template_before_sidebar')
 * @hooked: none
 *
 * do_action('entex_template_sidebar')
 * @hooked: entex_template_output_sidebar, 10, 1
 *
 * do_action('entex_template_shortcut_tabs_bottom', $indent, $position, $root)
 * @hooked: entex_template_output_shortcut_tabs, 10, 3
 *
 * do_action('entex_template_after_main_section')
 * @hooked: none (dynamically applied by custom meta)
 *
 * do_action('entex_template_socle')
 * @hooked: entex_template_output_socle, 10, 2 (dynamically applied by widget)
 *
 * do_action('entex_template_footer_column_1')
 * @hooked: entex_template_output_footer_branding, 10, 1
 *
 * do_action('entex_template_footer_column_2')
 * @hooked: None
 *
 * do_action('entex_template_footer_column_3')
 * @hooked: entex_template_output_footer_signature, 10, 1
 *
 * do_action('entex_template_before_wp_footer')
 * @hooked: none
 *
 * do_action('entex_template_after_template', args)
 * @hooked: entex_template_comment_after_template', 10, 4
 *
 * NOTE: entex_template_output_action_comment, 5, 1
 * is not documented as it hooks into every action
 * As of all source comments, define responding constant to disable
 *
 */
?>
<?php do_action('entex_template_before_template', 4, '', __FILE__, entex_backtrace(), false); ?>
<?php do_action('entex_template_after_main_content', 4); ?>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- END MAIN CONTENT -->
   </main>
<?php if(true == apply_filters('entex_template_aside', true)) : ?>
   <aside role="complementary" class="ua-grid-item-2 ua-content <?php echo (esc_attr(apply_filters('entex_template_aside_classname', ''))); ?>">
<?php do_action('entex_template_before_sidebar', 4); ?>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- DEFAULT SIDEBAR Content -->
<?php 
	/* indent will be reset but passed anyway */
	do_action('entex_template_sidebar', 4);
?>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- END DEFAULT SIDEBAR Content -->
   </aside>
<?php endif; ?>
  </div>
 </div>
 
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- TABS BOTTOM START -->
<?php do_action('entex_template_shortcut_tabs_bottom', 1, 'bottom', true); ?>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- END TABS -->

<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- SECTION INCLUSION START -->
<?php do_action('entex_template_before_main_section', 0, 'ua-root-section-above ua-root-content'); ?>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- END SECTION INCLUSION -->

<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- SECTION INCLUSION START -->
<?php do_action('entex_template_after_main_section', 0, 'ua-root-section-below ua-root-content'); ?>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- END SECTION INCLUSION -->

 <div class="ua-root" id="ua-id-fillout">
  <div class="ua-grid-root ua-set-sitewidth">
   <div class="ua-grid-item-1"><a href="#"><?php echo esc_html(_x('Move to top', 'Template', 'entex')); ?></a></div>
  </div>
 </div>
 <?php do_action('entex_template_socle', 1); ?>
 <div id="ua-id-spacer"></div>
 <div class="" id="ua-id-footer">
  <div class="ua-grid-root ua-set-sitewidth ua-grid-right">
   <div class="ua-grid-item-1"><div class="ua-grid-inner"><?php do_action('entex_template_footer_column_1', 4); ?></div></div>
   <div class="ua-grid-item-2"><div class="ua-grid-inner">
    <div class="ua-nav ua-nav-x">
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- MENU BOTTOM -->

<?php wp_nav_menu(array('theme_location' => 'footer', 'menu_class' => false, 'menu_id' => false, 'container' => false)); ?>

<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- END MENU BOTTOM -->
    </div>
   </div></div>
   <div class="ua-grid-item-3"><div class="ua-grid-inner"><?php do_action('entex_template_footer_column_3', 4); ?></div></div>
  </div>
 </div>
</div><!-- END #ua-window-wr -->
<div id='ua-window-splash' class='ua-window-background' role='presentation'></div>
<?php do_action('entex_template_before_wp_footer', 0); ?>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- WP FOOTER -->


<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::  D A T A  ::::::::::::::::::::::::::::::::::::::::::::::::::: -->

<?php wp_footer(); ?>

<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: -->
</body>
<?php entex_template_output_source_comment('Document BODY HTML end', __FILE__); ?>
<?php do_action('entex_template_after_template', 0, 'Template hierarchy END', __FILE__, entex_backtrace()); ?>
</html>