<?php if(!defined('ABSPATH')) die();
/**
 * Modify default panels and controllers
 *
 * @package Entex
 * @subpackage Entex
 * @updated 2.0180923
 * 
 * Documentation: http://entex.info
 * Contributor: Jonas Lundman
 *
 */
 
/* -------------------- */
// CONTROLLER SET

function entex_theme_customize_wordpress_default_controllers($wp_customize){

	if(!isset($wp_customize)) return;
	
	// REMOVE DEFAULTS:
	$wp_customize->remove_control('display_header_text');

	
	// -- Custom header panel -- //
	
	// RE-USE DEFAULT CUSTOM HEADER PANEL - removed theme support for now
	/*
	 * Keeping default custom header panel as we activated theme support for this
	 * We also wanna have control of the appearance or default updates
	 * In case other plugins hook into this default WordPress section
	**/
	

	// -- Custom Logo -- //
	/* synced with footer logo */
	/* if footer logo not edited */
	
	if(defined('ENTEX_THEME_INITIAL_LOGO')) $logo = ENTEX_THEME_INITIAL_LOGO;
		else $logo = 'theme-logo-initial.png';
	
	$wp_customize->get_setting('custom_logo')->transport = 'refresh';
	$wp_customize->add_setting('site_logo_upload', array(
		'default' => get_template_directory_uri() . '/assets/images/'.$logo,
		'sanitize_callback' => 'esc_url_raw'
	));
	
	
	/* NO CSS - REMOVES THE MARKUP IN TEMPLATE FILE */
	$wp_customize->add_setting('entex_theme_custom_logo_visibility',
		array(
			'default' => 0,
			'transport' => 'refresh',
			'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox',
		)
	);
	
	$wp_customize->add_control('entex_theme_custom_logo_visibility',
		array(
			'label' => esc_html_x('Do not generate header logotype', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => 'This option removes the html markup',
			'section' => 'title_tagline',
			'priority' => 11,
			'type' => 'checkbox'
		)
	);
	
	$wp_customize->add_setting('entex_theme_footer_logo_visibility',
		array(
			'default' => 0,
			'transport' => 'refresh',
			'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox',
		)
	);
	
	$wp_customize->add_control('entex_theme_footer_logo_visibility',
		array(
			'label' => esc_html_x('Do not generate footer logotype', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => 'This option removes the html markup',
			'section' => 'title_tagline',
			'priority' => 11,
			'type' => 'checkbox'
		)
	);
	

	
	// -- Title Tagline panel -- //
	
	$wp_customize->get_setting('blogname')->transport = 'postMessage';
	$wp_customize->get_setting('blogdescription')->transport = 'postMessage';
	
	/* site title and description visibility */
	/* NO CSS - REMOVES THE MARKUP IN TEMPLATE FILE */
	$wp_customize->add_setting('entex_theme_site_title_visibility',
		array(
			'default' => 0,
			'transport' => 'refresh',
			'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox',
		)
	);
	
	$wp_customize->add_control('entex_theme_site_title_visibility',
		array(
			'label' => esc_html_x('Do not generate header title', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('This option removes the html markup', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => 'title_tagline',
			'priority' => 11,
			'type' => 'checkbox'
		)
	);
	
	$wp_customize->add_setting('entex_theme_site_description_visibility',
		array(
			'default' => 0,
			'transport' => 'refresh',
			'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox',
		)
	);
	
	$wp_customize->add_control('entex_theme_site_description_visibility',
		array(
			'label' => esc_html_x('Do not generate header tagline', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('This option removes the html markup', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => 'title_tagline',
			'priority' => 11,
			'type' => 'checkbox'
		)
	);
	
	$wp_customize->add_setting('entex_theme_footer_description_visibility',
		array(
			'default' => 0,
			'transport' => 'refresh',
			'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox',
		)
	);
	
	$wp_customize->add_control('entex_theme_footer_description_visibility',
		array(
			'label' => esc_html_x('Do not generate footer tagline', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('This option removes the html markup', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => 'title_tagline',
			'priority' => 11,
			'type' => 'checkbox'
		)
	);

}
add_action('customize_register', 'entex_theme_customize_wordpress_default_controllers');

/* ******************** */
// END: CONTROLLER SET

// -- END FILE -- //