<?php if(!defined('ABSPATH')) die();
/**
 * Entex theme customizer panel
 *
 * @package Entex
 * @subpackage Entex
 * @updated 2.0190814
 * 
 * Documentation: http://entex.info
 * Contributor: Jonas Lundman
 *
 * IMPORTANT:
 * Labels are NOT translatable
 * As they are considered as CSS data labels
 *
 */

/* -------------------- */
// CONTROLLER SET

function entex_theme_customize_register_panel_typo($wp_customize, $_TARGET, $data){

	if(!isset($wp_customize)) return;
	if(defined('ENTEX_THEME_CUSTOMIZER_PANELS_OFF')) return;

	if(!$_TARGET) return;
	if(!$data['label']) $_LABEL = $_TARGET;
		else $_LABEL = esc_attr($data['label']);
	$unit = $data['unit'];
	
	// CREATE SUB PANEL
	
	$_PANEL = 'entex_panel_'.$_TARGET;
	if($data['visibility'] == 'typo'){
		$wp_customize->add_section($_PANEL,
			array(
				'title' => $_LABEL,
				'description' => $data['description'],
				'priority' => $data['panel-priority'],
				'panel' => $data['in-master-panel']
			)
		);
	}
	
	$priority = 10;
	
	// -- EARLY CONTROLLERS -- //
	
	$id = 'entex_theme_panel_'. $_TARGET .'_init_visibility';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Ignore this panel settings on save', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('This function is not in use', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	
	// -- EXTEND EARLY -- //
	
	$priority 	= 20;
	do_action('entex_theme_customize_register_panel_'. $_TARGET .'_priority_'.$priority, $wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority);
	$priority 	= 40;

	
	/* TARGET font control */
	
	// HEADING
	$id = 'entex_theme_typo_'. $_TARGET .'_space_font_control';
	$wp_customize->add_setting($id, array('default' => '', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				'label' => esc_html_x('Font settings', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'border' => 50,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET font-family */
	
	$id = 'entex_theme_'. $_TARGET .'_font_control';
	$wp_customize->add_setting($id, array('default' => entex_theme_font_control_defaults(), 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_font'));
	$wp_customize->add_control(
		new entex_customize_font_control(
			$wp_customize, 
			$id, array(
				/* translators: */
				'label' =>  sprintf(esc_html_x('%s font settings', 'Customizer data: DO NOT TRANSLATE', 'entex'), $_LABEL),
				'description' => '',
				'section' => $_PANEL,
				'priority' => $priority,
				'master' => false,
				'master_id' => 'entex_theme_html_font_control',
				'input_attrs' => array(
					'font_count' => 0,
					'orderby' => 'alpha',
				),
			)
		)
	);
	/* memory */
	$id = 'entex_theme_'. $_TARGET . '_memory_control';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'sanitize_text_field'));
	$wp_customize->add_control(
		new entex_customize_memory_control(
			$wp_customize, 
			$id, array(
				/* translators: */
				'label' => sprintf(esc_html_x('%s memory settings', 'Customizer data: DO NOT TRANSLATE', 'entex'), $_LABEL),
				'description' => '',
				'section' => $_PANEL,
				'priority' => $priority,
				'master' => 'entex_theme_'. $_TARGET .'_font_control'
			)
		)
	);
	
	
	
	/* TARGET text transform */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_text_transform_choices';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'sanitize_text_field'));
	$wp_customize->add_control($id,
		array(
			'type' => 'select',
			'label' => esc_html_x('Text transform', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => '',
			'section' => $_PANEL,
			'priority' => $priority,
			'choices' => entex_customizer_cc_select_text_transform()
		)
	);

	
	/* TARGET letter spacing */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_letter_spacing_choices';
	$wp_customize->add_setting($id, array('default' => -0.11, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Letter spacing (em)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'break' => false,
				'min' => -0.11,
				'max' => 1,
				'step' => 0.01,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	// -- FONT DISPLAY -- //
	
	// HEADING
	$id = 'entex_theme_typo_'. $_TARGET .'_space_text_font_display';
	$wp_customize->add_setting($id, array('default' => '', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				'label' => esc_html_x('Font size', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'border' => 50,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);

	/** font-size and line-height settings **/

	if($unit == 'clamp'){
		
		$id = 'entex_theme_typo_'. $_TARGET .'_font_size_clamp_1';
		$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
		$wp_customize->add_control(new entex_customize_range_control( $wp_customize, $id, array('label'	=> esc_html_x('Minimum (px)', 'Customizer data: DO NOT TRANSLATE', 'entex'), 'description' => '', 'break' => false, 'ghost' => true, 'min' => 0, 'max' => 73, 'step' => 1, 'section' => $_PANEL, 'priority' => $priority)));
	
		$id = 'entex_theme_typo_'. $_TARGET .'_font_size_clamp_2';
		$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
		$wp_customize->add_control(new entex_customize_range_control( $wp_customize, $id, array('label'	=> esc_html_x('Scale (Viewport With)', 'Customizer data: DO NOT TRANSLATE', 'entex'), 'description' => '', 'break' => false, 'ghost' => true, 'min' => 0, 'max' => 10, 'step' => 0.01, 'section' => $_PANEL, 'priority' => $priority)));
	
		$id = 'entex_theme_typo_'. $_TARGET .'_font_size_clamp_3';
		$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
		$wp_customize->add_control(new entex_customize_range_control( $wp_customize, $id, array('label'	=> esc_html_x('Maximum (px)', 'Customizer data: DO NOT TRANSLATE', 'entex'), 'description' => '', 'break' => false, 'ghost' => true, 'min' => 0, 'max' => 73, 'step' => 1, 'section' => $_PANEL, 'priority' => $priority)));

		$id = 'entex_theme_typo_'. $_TARGET .'_font_size_clamp';
		$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
		$wp_customize->add_control(
			new entex_customize_range_control(
				$wp_customize, 
				$id, array(
					'calculated' => true,
					'section' => $_PANEL,
					'priority' => $priority
				)
			)
		);
	} // END if unit clamp
	
	

	if($data['unit'] != 'clamp'){
		
		/* TARGET font size initial */ 
		if(strpos($data['remove'], 'font_size_initial') === FALSE){
			$id = 'entex_theme_typo_'. $_TARGET .'_font_size_initial';
			$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
			$description = '';
	
			if($data['unit'] == 'vw'){
				$wp_customize->add_control(
					new entex_customize_range_control(
						$wp_customize, 
						$id, array(
							'label'	=> esc_html_x('Scaled font size (vw)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
							'description' => $description,
							'break' => false,
							'min' => 0,
							'max' => 5,
							'step' => 0.01,
							'section' => $_PANEL,
							'priority' => $priority
						)
					)
				);
			} else {
				$wp_customize->add_control(
					new entex_customize_range_control(
						$wp_customize, 
						$id, array(
							/* translators: */
							'label'	=> sprintf(esc_html_x('Initial font size (%s)', 'Customizer data: DO NOT TRANSLATE', 'entex'), $unit),
							'description' => $description,
							'break' => false,
							'min' => 0,
							'max' => 73,
							'step' => 1,
							'section' => $_PANEL,
							'priority' => $priority
						)
					)
				);
			}
		}
	} // END if unit NOT clamp
	
	
	/* TARGET line height */
	if(strpos($data['remove'], 'line_height_initial') === FALSE){

		/* GHOST */
		$id = 'entex_theme_typo_'. $_TARGET .'_line_height_initial';
		$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
		$wp_customize->add_control(
			new entex_customize_range_control(
				$wp_customize, 
				$id, array(
					'label'	=> esc_html_x('Line height (number)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
					'ghost' => true,
					'min' => 0,
					'max' => 73,
					'step' => 1,
					'section' => $_PANEL,
					'priority' => $priority
				)
			)
		);
	
		/* CALCULATED */
		$id = 'entex_theme_typo_'. $_TARGET .'_line_height_initial_calculated';
		$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
		$wp_customize->add_control(
			new entex_customize_range_control(
				$wp_customize, 
				$id, array(
					'label'	=> esc_html_x('Line height', 'Customizer data: DO NOT TRANSLATE', 'entex'),
					'calculated' => true,
					'monitor' => true,
					'section' => $_PANEL,
					'priority' => $priority
				)
			)
		);
	}
	
	
	/** font-size **/ // MAIN
	
	if($data['unit'] != 'clamp'){
	
		if(strpos($data['remove'], 'font_size_main') === FALSE){
			$id = 'entex_theme_typo_'. $_TARGET .'_font_size_main';
			$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
			$description = esc_html_x('Tablet portrait and desktop main areas', 'Customizer data: DO NOT TRANSLATE', 'entex');
			$wp_customize->add_control(
				new entex_customize_range_control(
					$wp_customize, 
					$id, array(
						'label'	=> esc_html_x('Responsive font size (rem)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
						'description' => $description,
						'break' => true,
						'min' => 0,
						'max' => 121,
						'step' => 1,
						'monitor' => true,
						'section' => $_PANEL,
						'priority' => $priority
					)
				)
			);
		}
	
		if(strpos($data['remove'], 'line_height_main') === FALSE){
			
			/* TARGET line height main */
			/* GHOST */
			$id = 'entex_theme_typo_'. $_TARGET .'_line_height_main';
			$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
			$wp_customize->add_control(
				new entex_customize_range_control(
					$wp_customize, 
					$id, array(
						'label'	=> esc_html_x('Line height (number)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
						'description' => '',
						'break' => false,
						'ghost' => true,
						'monitor' => true,
						'min' => 0,
						'max' => 73,
						'step' => 1,
						'section' => $_PANEL,
						'priority' => $priority
					)
				)
			);
	
			/* CALCULATED */
			$id = 'entex_theme_typo_'. $_TARGET .'_line_height_main_calculated';
			$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
			$wp_customize->add_control(
				new entex_customize_range_control(
					$wp_customize, 
					$id, array(
						'label'	=> esc_html_x('Line height', 'Customizer data: DO NOT TRANSLATE', 'entex'),
						'calculated' => true,
						'monitor' => true,
						'section' => $_PANEL,
						'priority' => $priority
					)
				)
			);
		} // END if remove
	} // END if unit NOT clamp
	
	
	// -- END FONT -- //
	
	
	/* simple space */
	$id = 'entex_theme_typo_'. $_TARGET .'_space_whatever';
	$wp_customize->add_setting($id, array('default' => '','sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(new entex_customize_space_control($wp_customize, $id, array('label' => '', 'description' => '', 'border' => 0, 'break' => true, 'height' => 0, 'section' => $_PANEL, 'priority' => $priority)));
	
	
	/* TARGET text-align */
	
	if(strpos($data['remove'], 'text_align') === FALSE){
	$id = 'entex_theme_typo_'. $_TARGET .'_text_align_choices';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'sanitize_text_field'));
	$wp_customize->add_control($id,
		array(
			'type' => 'select',
			'label' => esc_html_x('Text align', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('This should only be used in special cases', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'choices' => entex_customizer_cc_select_text_align()
		)
	);
	}
	
	
	// -- EXTEND FONT PROPERTIES -- //
	
	$priority = 50;
	do_action('entex_theme_customize_register_panel_'. $_TARGET .'_priority_'.$priority, $wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority);
	$priority = 60;

	if(strpos($data['remove'], '__color__') === FALSE){

		// HEADING
		$id = 'entex_theme_typo_'. $_TARGET .'_space_foreground_color';
		$wp_customize->add_setting($id, array('default' => '','sanitize_callback' => 'entex_theme_customize_sanitize_default'));
		$wp_customize->add_control(
			new entex_customize_space_control(
				$wp_customize, 
				$id, array(
					'label' => esc_html_x('Font color', 'Customizer data: DO NOT TRANSLATE', 'entex'),
					'description' => '',
					'border' => 50,
					'break' => false,
					'height' => 0,
					'section' => $_PANEL,
					'priority' => $priority
				)
			)
		);
	
	
		/* TARGET color */
	
		if(strpos($data['remove'], 'foreground_color') === FALSE){
			$id = 'entex_theme_typo_'. $_TARGET .'_foreground_color';
			$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability' => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
			$wp_customize->add_control(
				new entex_customize_color_control(
					$wp_customize, $id,
					array(
						/* translators: */
						'label' => sprintf(esc_html_x('Foreground color', 'Customizer data: DO NOT TRANSLATE', 'entex'), $_LABEL),
						'section' => $_PANEL,
						'priority' => $priority,
						'settings' => $id,
						'show_opacity' => true, 
						'palette' => entex_customizer_cc_background_color_palette_default()
					)
				)
			);
		}
	
	
		/* TARGET text-shadow color */
	
		if(strpos($data['remove'], 'foreground_text_shadow_color') === FALSE){
			$id = 'entex_theme_typo_'. $_TARGET .'_foreground_text_shadow_color';
			$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability' => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
			$wp_customize->add_control(
				new entex_customize_color_control(
					$wp_customize, $id,
					array(
						/* translators: */
						'label' => sprintf(esc_html_x('Text shadow', 'Customizer data: DO NOT TRANSLATE', 'entex'), $_LABEL),
						'section' => $_PANEL,
						'priority' => $priority,
						'settings' => $id,
						'show_opacity' => true, 
						'palette' => entex_customizer_cc_background_color_palette_default()
					)
				)
			);
		}
	}
	
	
	// -- EXTENDED COLOR SETTINGS -- //
	
	$priority = 70;
	do_action('entex_theme_customize_register_panel_'. $_TARGET .'_priority_'.$priority, $wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority);
	$priority = 80;
	
	


	// -- PADDING -- //
	
	if(strpos($data['remove'], '__padding__') === FALSE){
		
	// HEADING
	$id = 'entex_theme_typo_'. $_TARGET .'_space_padding_top_bottom';
	$wp_customize->add_setting($id, array('default' => '','sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				'label' => esc_html_x('Padding', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'border' => 50,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET padding-top */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_padding_top';
	$wp_customize->add_setting($id, array('default' => -0.25, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Padding top (em)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'break' => false,
				'monitor' => true,
				'min' => -0.25,
				'max' => 3,
				'step' => 0.025,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET padding-bottom */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_padding_bottom';
	$wp_customize->add_setting($id, array('default' => -0.25, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Padding bottom (em)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'monitor' => true,
				'min' => -0.25,
				'max' => 3,
				'step' => 0.025,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	} // END if remove
	
	// -- EXTEND PADDING -- //
	
	// 80
	do_action('entex_theme_customize_register_panel_'. $_TARGET .'_priority_'.$priority, $wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority);
	$priority = 90;
	
	
	// -- DISPLAY -- //
	
	if(strpos($data['remove'], 'extended_display') === FALSE){
		
	// HEADING
	$id = 'entex_theme_typo_'. $_TARGET .'_space_extended_display';
	$wp_customize->add_setting($id, array('default' => '','sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				'label' => esc_html_x('Visibility', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'border' => 50,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	/* TARGET viewporter */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_extended_display_viewport';
	$wp_customize->add_setting($id, array( 'default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Apply on mobile view only', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => 'entex_panel_'.$_TARGET,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	/* TARGET display */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_extended_display_choices';
	$wp_customize->add_setting($id, array( 'default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'sanitize_text_field'));
	$wp_customize->add_control($id,
		array(
			'type' => 'select',
			'label' => esc_html_x('Extended visibility', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => '',
			'section' => $_PANEL,
			'priority' => $priority,
			'choices' => entex_customizer_cc_select_display_extended()
		)
	);
	} // END remove
	
	
	// -- END MAIN CONTROLLERS -- //
	
	// 90
	do_action('entex_theme_customize_register_panel_'. $_TARGET .'_priority_'.$priority, $wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority);
	
}

/* ******************** */
// END: CONTROLLER SET





/* -------------------- */
// TEMPATE HEADER OUTPUT

function entex_theme_output_data_panel_typo($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	$hide = false;
	$google = array();
	
	$_SELECTOR = $data['selector'];
	$unit = $data['unit'];
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	
	/* Dont generate stylesheet from this panel */
	$name = 'entex_theme_panel_'. $_TARGET .'_init_visibility';
	$value = get_theme_mod($name, 0);
	if($value) $visibility = 0;
		else $visibility = 1;
	if(!$visibility) return;

	
	/* TYPO font control */
	$name = 'entex_theme_'. $_TARGET .'_font_control';
	$value = get_theme_mod($name, 0);
	if($value){
		$arr = (array) json_decode($value);
		$value = $arr['font'];
		if($value && trim($value)){
			
			if(defined('ENTEX_THEME_CUSTOMIZER_GOOGLE_FONTS_FALLBACK')){
				if(ENTEX_THEME_CUSTOMIZER_GOOGLE_FONTS_FALLBACK) $value .= ', '.ENTEX_THEME_CUSTOMIZER_GOOGLE_FONTS_FALLBACK;
			}
			
			$replacement = array($_SELECTOR, 'font-family', $value, '');
			$style = str_replace($match, $replacement, $data['style']);
			entex_ECOUT($_TARGET, $name.'_font_family', $style);
			
			$google[$name] = $arr;
			entex_theme_customize_google($google);
			
			/* only move on if font-family provided */
			$value = $arr['regularweight'];
			
		} else $value = '';
		
		if($value){
			$fontWeight = '';
			$fontStyle = '';
			if($value == 'regular'){
				$fontWeight = '400';
				$fontStyle = 'normal';
			} else if($value == 'italic'){
				$fontWeight = '400';
				$fontStyle = 'italic';
			} else {
				if(strpos($value, 'italic') !== FALSE){
					$fontWeight = str_replace('italic', '', $value);
					$fontStyle = 'italic';
				} else {
					$fontWeight = $value;
					$fontStyle = 'normal';
				}
			}
			if($fontWeight){
				$replacement = array($_SELECTOR, 'font-weight', $fontWeight, '');
				$style = str_replace($match, $replacement, $data['style']);
				entex_ECOUT($_TARGET, $name.'_font_weight', $style);
			}
			if($fontStyle){
				$replacement = array($_SELECTOR, 'font-style', $fontStyle, '');
				$style = str_replace($match, $replacement, $data['style']);
				entex_ECOUT($_TARGET, $name.'_font_style', $style);
			}
		}
	}
	
	
	/* TARGET text-transform (value) */
	
	$name = 'entex_theme_typo_'. $_TARGET .'_text_transform_choices';
	$value = get_theme_mod($name, 0);
	if($value){
		$replacement = array($_SELECTOR, 'text-transform', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	/* TARGET text-align (value) */
	
	if(strpos($data['remove'], 'text_align') === FALSE){
	$name = 'entex_theme_typo_'. $_TARGET .'_text_align_choices';
	$value = get_theme_mod($name, 0);
	if($value){
		$replacement = array($_SELECTOR, 'text-align', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	}
	
	
	/* TARGET letter-spacing (value) */
	
	$name = 'entex_theme_typo_'. $_TARGET .'_letter_spacing_choices';
	$value = get_theme_mod($name, 0);
	if($value < -0.10) $value = null; 
	if($value != null){
		$replacement = array($_SELECTOR, 'letter-spacing', $value, 'em');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	if($data['unit'] == 'clamp'){
		
		// -- FONT SIZE CLAMP -- //

		/* TARGET font-size (units converted) */
		$name = 'entex_theme_typo_'. $_TARGET .'_font_size_clamp';
		$value = get_theme_mod($name, '');
		if($value){
			$replacement = array($_SELECTOR, 'font-size', $value, '');
			$style = str_replace($match, $replacement, $data['style']);
			entex_ECOUT($_TARGET, $name, $style);
		}
	
	} else {
	
		// -- FONT SIZE -- //

		/* TARGET font-size initial (unit converted) */
		if(strpos($data['remove'], 'font_size_initial') === FALSE){
			$name = 'entex_theme_typo_'. $_TARGET .'_font_size_initial';
			$value = get_theme_mod($name, 0);
			if($value < 0.1) $value = 0;
			if($value > 72) $value = 'inherit';
			if($value){
				if($value == 'inherit'){
					$replacement = array($_SELECTOR, 'font-size', $value, '');
				} else {
					/* convering */
					if($unit == 'rem') $value = ($value / 16);
					$replacement = array($_SELECTOR, 'font-size', $value, $unit);
				}
				if($data['initial']) $style = str_replace($match, $replacement, $data['initial']);
					else $style = str_replace($match, $replacement, $data['style']);
				entex_ECOUT($_TARGET, $name, $style);
			}
		}
	
	} // END else if clamp
	
	/* TARGET line-height initial (number) */
	
	if(strpos($data['remove'], 'line_height_initial') === FALSE){
		$name = 'entex_theme_typo_'. $_TARGET .'_line_height_initial_calculated';
		$value = get_theme_mod($name, 0);
		if($value < 0.1) $value = 0;
		if($value){
			$replacement = array($_SELECTOR, 'line-height', $value, '');
			if($data['initial']) $style = str_replace($match, $replacement, ($data['unit'] == 'clamp' ? $data['style'] : $data['initial']));
				else $style = str_replace($match, $replacement, $data['style']);
			entex_ECOUT($_TARGET, $name, $style);
		}
	}
	
	
	if($data['unit'] != 'clamp'){
	
		/* Only allow 'vw' on responsive devices */
		if($unit == 'vw') $unit = 'rem';
	
		/* TARGET font-size main (unit) */
	
		if(strpos($data['remove'], 'font_size_main') === FALSE){
			$name = 'entex_theme_typo_'. $_TARGET .'_font_size_main';
			$value = get_theme_mod($name, 0);
			if($value < 0.1) $value = 0;
			if($value > 120) $value = 'inherit';
			if($value){
				if($value == 'inherit'){
					$replacement = array($_SELECTOR, 'font-size', $value, '');
				} else {
					/* convering */
					if($unit == 'rem') $value = ($value / 16);
					$replacement = array($_SELECTOR, 'font-size', $value, $unit);
				}
				$style = '';
				/* might just merge them - as we do in javascript file */
				if($data['responsive']) $style .= str_replace($match, $replacement, $data['responsive']);
				if($data['desktop']) $style .= str_replace($match, $replacement, $data['desktop']);
				if(!$style) $style = str_replace($match, $replacement, $data['style']);
				entex_ECOUT($_TARGET, $name, $style);
			}
		}
	
	
		/* TARGET line-height main (number) */
	
		if(strpos($data['remove'], 'line_height_main') === FALSE){
			$name = 'entex_theme_typo_'. $_TARGET .'_line_height_main_calculated';
			$value = get_theme_mod($name, 0);
			if($value != 'inherit' && $value < 0.1) $value = 0;
			if($value){
				$replacement = array($_SELECTOR, 'line-height', $value, '');
				$style = '';
				/* might just merge them - as we do in javascript file */
				if($data['responsive']) $style .= str_replace($match, $replacement, $data['responsive']);
				if($data['desktop']) $style .= str_replace($match, $replacement, $data['desktop']);
				if(!$style) $style = str_replace($match, $replacement, $data['style']);
				entex_ECOUT($_TARGET, $name, $style);
			}
		} // END remove line_height_main
	
	} // END if NOT clamp
	
	
	if(strpos($data['remove'], '__padding__') === FALSE){
		
	/* TARGET padding-top (em) */
	
	if(strpos($data['remove'], 'padding_top') === FALSE){
	$name = 'entex_theme_typo_'. $_TARGET .'_padding_top';
	$value = get_theme_mod($name, -0.25);
	if($value < 0) $value = null;
	if($value != null){
		$replacement = array($_SELECTOR, 'padding-top', $value, 'em');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	}
	
	
	/* TARGET padding-bottom (em) */
	
	if(strpos($data['remove'], 'padding_bottom') === FALSE){
	$name = 'entex_theme_typo_'. $_TARGET .'_padding_bottom';
	$value = get_theme_mod($name, -0.25);
	if($value < 0) $value = null;
	if($value != null){
		$replacement = array($_SELECTOR, 'padding-bottom', $value, 'em');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	}

	} // END if remove
	
	
	if(strpos($data['remove'], '__color__') === FALSE){
	
		/* TARGET color (value) */
	
		if(strpos($data['remove'], 'foreground_color') === FALSE){
			$name = 'entex_theme_typo_'. $_TARGET .'_foreground_color';
			$value = get_theme_mod($name, 0);
			if($value){
				$replacement = array($_SELECTOR, 'color', $value, '');
				$style = str_replace($match, $replacement, $data['style']);
				entex_ECOUT($_TARGET, $name, $style);
			}
		}
	
	
		/* TARGET text-shadow (color) */
		// No color - no display
	
		if(strpos($data['remove'], 'foreground_text_shadow_color') === FALSE){
			$name = 'entex_theme_typo_'. $_TARGET .'_foreground_text_shadow_color';
			$value = get_theme_mod($name, 0);
			if($value){
				$replacement = array($_SELECTOR, 'text-shadow', $value, ' 0px 1px 1px');
				$style = str_replace($match, $replacement, $data['style']);
				entex_ECOUT($_TARGET, $name, $style);
			}
		}
	}
	
	
	
	if(strpos($data['remove'], 'extended_display') === FALSE){	
	
		/* TARGET extended display (value) */
	
		/* viewporter */
		$name = 'entex_theme_typo_'. $_TARGET .'_extended_display_viewport';
		$viewporter = get_theme_mod($name, 0);
		$name = 'entex_theme_typo_'. $_TARGET .'_extended_display_choices';
		$value = get_theme_mod($name, 0);
		if($value){
			$replacement = array($_SELECTOR, 'display', $value, '');
			$style = str_replace($match, $replacement, ($viewporter ? $data['initial'] : $data['style']));
			entex_ECOUT($_TARGET, $name, $style);
		}
	}
	
	/* action (global) */
	do_action('entex_theme_customize_intercept_wp_head_'.$data['visibility'], $_TARGET, $data);
	
	/* action */
	do_action('entex_theme_customize_wp_head_'.$_TARGET, $_TARGET, $data);
	
}

/* ******************** */
// END: TEMPATE OUTPUT

// -- END FILE -- //