<?php if(!defined('ABSPATH')) die();
/**
 * Entex theme customizer panel
 *
 * Panels are loaded as stylesheet url
 * Create your own customizer directory in your child theme
 * To override and modify the default panels
 *
 * @package Entex
 * @subpackage Entex
 * @updated 2.0190814
 * 
 * Documentation: http://entex.info
 * Contributor: Jonas Lundman
 *
 * IMPORTANT:
 * Labels are NOT translatable
 * As they are considered as CSS data labels
 *
 */

/* -------------------- */
// CONTROLLER SET

function entex_theme_customize_register_panel_options($wp_customize, $_TARGET, $data){
	
	/* NOTE: This panel is shared by many targets */
	/* Each set of controllers is conditional */

	if(!isset($wp_customize)) return;
	if(defined('ENTEX_THEME_CUSTOMIZER_PANELS_OFF')) return;

	if(!$_TARGET) return;
	if(!$data['label']) $_LABEL = $_TARGET;
		else $_LABEL = esc_attr($data['label']);
	$unit = $data['unit'];
	
	// CREATE SUB PANEL
	
	$_PANEL = 'entex_panel_'.$_TARGET;
	$wp_customize->add_section($_PANEL,
		array(
			'title' => $_LABEL,
			'description' => $data['description'],
			'priority' => $data['panel-priority'],
			'panel' => $data['in-master-panel']
		)
	);

	$priority = 10;
	
	
	// -- EARLY CONTROLLERS -- //

	/* panel visibility */
	$id = 'entex_theme_panel_'. $_TARGET .'_init_visibility';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Ignore this panel settings on save', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('This function is not in use', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);


	/* TARGET template */
	if($_TARGET == 'template'){
		/* translated in options array */
		foreach(entex_theme_customize_template_conditionals() as $index => $label){
			
			// HEADING
			$id = 'entex_theme_options_'. $_TARGET .'_space_'.$index;
			$wp_customize->add_setting($id, array('default' => '','sanitize_callback' => 'sanitize_text_field'));
			$wp_customize->add_control(
				new entex_customize_space_control(
					$wp_customize, 
					$id, array(
						'label' => $label,
						'description' => esc_html_x('Make shure you are visiting the corresponding archive before making changes, otherwise nothing happens here.', 'Customizer data: DO NOT TRANSLATE', 'entex'),
						'border' => 50,
						'break' => false,
						'height' => 0,
						'section' => $_PANEL,
						'priority' => $priority
					)
				)
			);
			
			$n = 0;
			$breakpoints = array(1, 2, 3);
			foreach($breakpoints as $breakpoint){
				$n ++;
				$id = 'entex_theme_options_'. $_TARGET .'_'.$n.'_'.$index;
				$wp_customize->add_setting($id, array('default' => '', 'transport' => 'refresh', 'sanitize_callback' => 'sanitize_text_field'));
				$wp_customize->add_control($id,
					array(
						'type' => 'select',
						/* translators: */
						'label' => sprintf(esc_html_x('Template %s', 'Customizer data: DO NOT TRANSLATE', 'entex'), $n),
						'description' => '',
						'section' => $_PANEL,
						'priority' => $priority,
						'choices' => entex_customizer_cc_select_template_examples(array('entries', 'contents', 'widgets'))
					)
				);
				
				if($breakpoint == 3) continue;
				
				$id = 'entex_theme_options_'. $_TARGET .'_'.$n.'_'.$index.'_breakpoint_'.$breakpoint;
				$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'refresh', 'sanitize_callback' => 'entex_theme_customize_sanitize_breakpoint'));
				$wp_customize->add_control($id,
					array(
						'type' => 'number',
						/* translators: */
						'label' => sprintf(esc_html_x('Breakpoint %s', 'Customizer data: DO NOT TRANSLATE', 'entex'), $breakpoint),
						/* translators: */
						'description' => sprintf(esc_html_x('Number of entries before changing into template %s', 'Customizer data: DO NOT TRANSLATE', 'entex'), ($n + 1)),
						'section' => $_PANEL,
						'priority' => $priority,
						'choices' => entex_customizer_cc_select_template_examples()
					)
				);
				if($breakpoint > 1){
					$id = 'entex_theme_options_'. $_TARGET .'_'.$n.'_'.$index.'_min_'.$breakpoint;
					$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'refresh', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
					$wp_customize->add_control($id,
						array(
							'type' => 'checkbox',
							'label' => esc_html_x('Ignore if less then 4 entries left', 'Customizer data: DO NOT TRANSLATE', 'entex'),
							'description' => '',
							'section' => $_PANEL,
							'priority' => $priority,
							'choices' => entex_customizer_cc_select_template_examples()
						)
					);
				}
			}
		}
	}
	

	$priority 	= 80;
	do_action('entex_theme_customize_register_panel_'. $_TARGET .'_priority_'.$priority, $wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority);

}

/* ******************** */
// END: CONTROLLER SET





/* -------------------- */
// TEMPATE HEADER OUTPUT - MIXED

function entex_theme_output_data_panel_options($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	return;
	
}

/* ******************** */
// END: TEMPATE OUTPUT

// -- END FILE -- //