<?php if(!defined('ABSPATH')) die();
/**
 * Entex theme customizer panel
 *
 * Panels are loaded as stylesheet url
 * Create your own customizer directory in your child theme
 * To override and modify the default panels
 *
 * @package Entex
 * @subpackage Entex
 * @updated 2.210510
 * 
 * Documentation: https://entex.info
 * Contributor: Jonas Lundman
 *
 * IMPORTANT:
 * Labels are NOT MENT TO BE translatable
 * As they are considered as CSS data labels
 * However, the GET TEXT call are made in the options array anayway
 *
**/

// START


/* -------------------- */
// CONTROLLER SET

function entex_theme_customize_register_panel_layout($wp_customize, $_TARGET, $data){

	if(!isset($wp_customize)) return;
	if(defined('ENTEX_THEME_CUSTOMIZER_PANELS_OFF')) return;

	if(!$_TARGET) return;
	if(!$data['label']) $_LABEL = $_TARGET;
		else $_LABEL = esc_attr($data['label']);
	$unit = $data['unit'];
	
	
	// CREATE SUB PANEL
	
	$_PANEL = 'entex_panel_'.$_TARGET;
	if($data['visibility'] == 'layout'){
		$wp_customize->add_section($_PANEL,
			array(
				'title' => $_LABEL,
				'description' => $data['description'],
				'priority' => $data['panel-priority'],
				'panel' => $data['in-master-panel']
			)
		);
	}
	
	$priority = 10;
	
	// -- EARLY CONTROLLERS -- //
	
	$id = 'entex_theme_panel_'. $_TARGET .'_init_visibility';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Ignore this panel settings on save', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	
	// -- EXTEND EARLY CONTROLLERS -- //

	$priority 	= 20;
	do_action('entex_theme_customize_register_panel_'. $_TARGET .'_priority_'.$priority, $wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority);
	$priority 	= 40;



	/* TARGET width (clamp) */
	
	if(strpos($data['remove'], 'width_clamp') === FALSE){
	
	// HEADING
	$id = 'entex_theme_layout_'. $_TARGET .'_space_width_clamp';
	$wp_customize->add_setting($id, array('default' => '', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				'label' => esc_html_x('Width', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => esc_html_x('This controller is using clamp value. Make shure to feed all values and validate deisired result in different media views.', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'border' => 30,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);

	/* GHOSTS */
	
	$id = 'entex_theme_layout_'. $_TARGET .'_width_clamp_1';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
	$wp_customize->add_control(new entex_customize_range_control( $wp_customize, $id, array('label'	=> esc_html_x('Minimum (px)', 'Customizer data: DO NOT TRANSLATE', 'entex'), 'description' => '', 'break' => false, 'ghost' => true, 'min' => 0, 'max' => 200, 'step' => 1, 'section' => $_PANEL, 'priority' => $priority)));
	
	$id = 'entex_theme_layout_'. $_TARGET .'_width_clamp_2';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
	$wp_customize->add_control(new entex_customize_range_control( $wp_customize, $id, array('label'	=> esc_html_x('Scale (Viewport width)', 'Customizer data: DO NOT TRANSLATE', 'entex'), 'description' => '', 'break' => false, 'ghost' => true, 'min' => 0, 'max' => 50, 'step' => 0.01, 'section' => $_PANEL, 'priority' => $priority)));
	
	$id = 'entex_theme_layout_'. $_TARGET .'_width_clamp_3';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
	$wp_customize->add_control(new entex_customize_range_control( $wp_customize, $id, array('label'	=> esc_html_x('Maximum (px)', 'Customizer data: DO NOT TRANSLATE', 'entex'), 'description' => '', 'break' => false, 'ghost' => true, 'min' => 0, 'max' => 600, 'step' => 1, 'section' => $_PANEL, 'priority' => $priority)));
	
	/* TARGET CLAMP */
	/* CALCULATED */ // This is the final value to read from theme options
	
	$id = 'entex_theme_layout_'. $_TARGET .'_width_clamp';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
	
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'calculated' => true,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	} // END if unit NOT removed
	
	
	// HEADING //
	$id = 'entex_theme_layout_'. $_TARGET .'_space_backgrounds';
	$wp_customize->add_setting($id, array('default' => '','sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				'label' => esc_html_x('Background', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'border' => 30,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET background color */
	
	$id = 'entex_theme_layout_'. $_TARGET .'_background_color_value';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability'  => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize,
			$id,
			array(
				'label' 		=> esc_html_x('Background color', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description'   => '',
				'section'       => $_PANEL,
				'settings'      => $id,
				'priority' 		=> $priority,
				'show_opacity'  => true, 
				'palette'	=> entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	
	
	/* TARGET background color transparent */
	
	$id = 'entex_theme_layout_'. $_TARGET .'_background_color_transparent';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Set background color as transparent', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	
	/* TARGET foreground color */
	if(strpos($data['remove'], 'foreground_layout_color') === FALSE){
		$id = 'entex_theme_layout_'. $_TARGET .'_foreground_color';
		$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability'  => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
		$wp_customize->add_control(
			new entex_customize_color_control(
				$wp_customize,
				$id,
				array(
					'label' 		=> esc_html_x('Foreground color', 'Customizer data: DO NOT TRANSLATE', 'entex'),
					'description'   => esc_html_x('Individual elements inside might override this and :hover and :active statements must be adjusted manually.', 'Customizer data: DO NOT TRANSLATE', 'entex'),
					'section'       => $_PANEL,
					'settings'      => $id,
					'priority' 		=> $priority,
					'show_opacity'  => true, 
					'palette'	=> entex_customizer_cc_color_palette_default()
				)
			)
		);
	}
	
	
	/* TARGET foreground text shadow color */
	if(strpos($data['remove'], 'foreground_layout_text_shadow_color') === FALSE){
		$id = 'entex_theme_layout_'. $_TARGET .'_foreground_text_shadow_color';
		$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability' => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
		$wp_customize->add_control(
			new entex_customize_color_control(
				$wp_customize, $id,
				array(
					/* translators: */
					'label' => sprintf(esc_html_x('Text shadow', 'Customizer data: DO NOT TRANSLATE', 'entex'), $_LABEL),
					'section' => $_PANEL,
					'priority' => $priority,
					'settings' => $id,
					'show_opacity' => true, 
					'palette' => entex_customizer_cc_background_color_palette_default()
				)
			)
		);
	}
	
	
	/* TARGET line height */
	if(strpos($data['remove'], 'line_height_layout') === FALSE){

		/* GHOST */
		$id = 'entex_theme_layout_'. $_TARGET .'_line_height';
		$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
		$wp_customize->add_control(
			new entex_customize_range_control(
				$wp_customize, 
				$id, array(
					'label'	=> esc_html_x('Line height (number)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
					'ghost' => true,
					'min' => 0,
					'max' => 73,
					'step' => 1,
					'section' => $_PANEL,
					'priority' => $priority
				)
			)
		);
	
		/* CALCULATED */
		$id = 'entex_theme_layout_'. $_TARGET .'_line_height_calculated';
		$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
		$wp_customize->add_control(
			new entex_customize_range_control(
				$wp_customize, 
				$id, array(
					'label'	=> esc_html_x('Line height', 'Customizer data: DO NOT TRANSLATE', 'entex'),
					'calculated' => true,
					'monitor' => true,
					'section' => $_PANEL,
					'priority' => $priority
				)
			)
		);
	}
	
	
	// -- BEFORE and AFTER -- //
	
	$priority = 50;
	do_action('entex_theme_customize_register_panel_'. $_TARGET .'_priority_'.$priority, $wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority);
	$priority = 60;
	
	
	// -- MISC -- //
	
	// HEADING
	$id = 'entex_theme_layout_'. $_TARGET .'_space_misc';
	$wp_customize->add_setting($id, array('default' => '','sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				'label' => esc_html_x('Miscellaneous', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'border' => 50,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	/* TARGET text-align center content */
	if(strpos($data['remove'], 'center_content') === FALSE){
	$id = 'entex_theme_layout_'. $_TARGET .'_center_content';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Center content', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => '',
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	}
	
	
	/* TARGET box-shadow visibility */
	if(strpos($data['remove'], 'box_shadow_visibility') === FALSE){
	$id = 'entex_theme_layout_'. $_TARGET .'_box_shadow_visibility';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Remove default box shadow', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => '',
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	}
	
	
	/* TARGET margin visibility (ALL) */
	if(strpos($data['remove'], 'margin_all_visibility') === FALSE){
	$id = 'entex_theme_layout_'. $_TARGET .'_margin_all_visibility';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Remove all margins', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('To be used in conjunction with padding and border settings', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	}
	
	
	/* TARGET margin visibility (mobile) */
	if(strpos($data['remove'], 'margin_mobile_visibility') === FALSE){
	$id = 'entex_theme_layout_'. $_TARGET .'_margin_mobile_visibility';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Remove margins on mobile view', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('To be used in conjunction with padding and border settings', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	}
	
	// 60
	do_action('entex_theme_customize_register_panel_'. $_TARGET .'_priority_'.$priority, $wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority);
	
	// --  BORDERS -- //
	
	if(strpos($data['remove'], '__border_layout__') === FALSE){
		
	// HEADING
	$id = 'entex_theme_layout_'. $_TARGET .'_space_borders';
	$wp_customize->add_setting($id, array('default' => '','sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				'label' => esc_html_x('Borders', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'border' => 50,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET border visibility (none) */
	
	$id = 'entex_theme_layout_'. $_TARGET .'_border_visibility';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Remove all borders', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => 'entex_panel_'.$_TARGET,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	/* TARGET border mobile visibility (none) */
	
	if(strpos($data['remove'], 'border_mobile_visibility') === FALSE){
	$id = 'entex_theme_layout_'. $_TARGET .'_border_mobile_visibility';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Do not apply border settings on mobile view', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => 'entex_panel_'.$_TARGET,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	}
	
	
	/* TARGET border (ALL) */
	
	if(strpos($data['remove'], 'border_all_width') === FALSE){
	$id = 'entex_theme_layout_'. $_TARGET .'_border_all_width';
	$wp_customize->add_setting($id, array('default' => -1, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Border All (px)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'monitor' => true,
				'min' => -1,
				'max' => 10,
				'step' => 1,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	}
	
	
	/* TARGET border all color */
	
	if(strpos($data['remove'], 'border_all_color') === FALSE){
	$id = 'entex_theme_layout_'. $_TARGET .'_border_all_color';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability'  => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize, $id,
			array(
				'label' => esc_html_x('Border color', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'section' => $_PANEL,
				'priority' => $priority,
				'settings' => $id,
				'show_opacity' => true, 
				'palette' => entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	}
	
	
	
	/* TARGET border-top-width */
	
	$id = 'entex_theme_layout_'. $_TARGET .'_border_top_width';
	$wp_customize->add_setting($id, array('default' => -1, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Border top width (px)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'monitor' => true,
				'min' => -1,
				'max' => 10,
				'step' => 1,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET border top color */
	
	$id = 'entex_theme_layout_'. $_TARGET .'_border_top_color';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability'  => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize, $id,
			array(
				'label' => esc_html_x('Border top color', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'section' => $_PANEL,
				'priority' => $priority,
				'settings' => $id,
				'show_opacity' => true, 
				'palette' => entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	
	
	/* TARGET border-bottom-width */
	
	$id = 'entex_theme_layout_'. $_TARGET .'_border_bottom_width';
	$wp_customize->add_setting($id, array('default' => -1, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Border bottom width (px)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'monitor' => true,
				'min' => -1,
				'max' => 10,
				'step' => 1,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET border bottom color */
	
	$id = 'entex_theme_layout_'. $_TARGET .'_border_bottom_color';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability'  => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize, $id,
			array(
				'label' => esc_html_x('Border bottom color', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'section' => $_PANEL,
				'priority' => $priority,
				'settings' => $id,
				'show_opacity' => true, 
				'palette' => entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	} // END if NOT __border_layout__
	
	
	// -- PADDING -- //
	
	if(strpos($data['remove'], '__padding_layout__') === FALSE){
	
	$id = 'entex_theme_layout_'. $_TARGET .'_space_padding';
	$wp_customize->add_setting($id, array('default' => '', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				'label' => esc_html_x('Padding', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'border' => 50,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	/* TARGET padding viewport */
	
	if(strpos($data['remove'], 'padding_viewport') === FALSE){
	$id = 'entex_theme_layout_'. $_TARGET .'_padding_viewport';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Do not apply padding settings on mobile view', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => 'entex_panel_'.$_TARGET,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	}
	
	
	/* TARGET padding (ALL) rem */
	if(strpos($data['remove'], 'padding_all') === FALSE){
	$id = 'entex_theme_layout_'. $_TARGET .'_padding_all';
	$wp_customize->add_setting($id, array('default' => -1, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Padding all (rem)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'break' => false,
				'min' => -1,
				'max' => 100,
				'step' => 1,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	}
	
	
	/* TARGET padding-top (em) */
	if(strpos($data['remove'], 'padding_top') === FALSE){
	$id = 'entex_theme_layout_'. $_TARGET .'_padding_top';
	$wp_customize->add_setting($id, array('default' => -0.25, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Padding top (em)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'break' => false,
				'monitor' => true,
				'min' => -0.25,
				'max' => 5,
				'step' => 0.25,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	}
	
	/* TARGET padding-bottom */
	if(strpos($data['remove'], 'padding_bottom') === FALSE){
	$id = 'entex_theme_layout_'. $_TARGET .'_padding_bottom';
	$wp_customize->add_setting($id, array('default' => -0.25, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Padding bottom (em)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'monitor' => true,
				'min' => -0.25,
				'max' => 5,
				'step' => 0.25,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	}
	} // END if padding NOT remove
	
	
	/* TARGET CLAMP */
	if(strpos($data['remove'], 'padding_clamp') === FALSE){
	
	// HEADING
	$id = 'entex_theme_layout_'. $_TARGET .'_space_padding_clamp';
	$wp_customize->add_setting($id, array('default' => '','sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				'label' => esc_html_x('Padding', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => esc_html_x('This controller is using clamp value. Make shure to feed all values and validate deisired result in different media views.', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'border' => 30,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);

	/* GHOSTS */
	
	$id = 'entex_theme_layout_'. $_TARGET .'_padding_clamp_1';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
	$wp_customize->add_control(new entex_customize_range_control( $wp_customize, $id, array('label'	=> esc_html_x('Minimum (px)', 'Customizer data: DO NOT TRANSLATE', 'entex'), 'description' => '', 'break' => false, 'ghost' => true, 'min' => 0, 'max' => 100, 'step' => 1, 'section' => $_PANEL, 'priority' => $priority)));
	
	$id = 'entex_theme_layout_'. $_TARGET .'_padding_clamp_2';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
	$wp_customize->add_control(new entex_customize_range_control( $wp_customize, $id, array('label'	=> esc_html_x('Scale (Viewport width)', 'Customizer data: DO NOT TRANSLATE', 'entex'), 'description' => '', 'break' => false, 'ghost' => true, 'min' => 0, 'max' => 20, 'step' => 0.01, 'section' => $_PANEL, 'priority' => $priority)));
	
	$id = 'entex_theme_layout_'. $_TARGET .'_padding_clamp_3';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
	$wp_customize->add_control(new entex_customize_range_control( $wp_customize, $id, array('label'	=> esc_html_x('Maximum (px)', 'Customizer data: DO NOT TRANSLATE', 'entex'), 'description' => '', 'break' => false, 'ghost' => true, 'min' => 0, 'max' => 300, 'step' => 1, 'section' => $_PANEL, 'priority' => $priority)));
	
	$id = 'entex_theme_layout_'. $_TARGET .'_padding_clamp';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default') );
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'calculated' => true,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	} // END if clamp NOT removed
	
	

	$priority = 80;
	do_action('entex_theme_customize_register_panel_'. $_TARGET .'_priority_'.$priority, $wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority);
	
}


/* ******************** */
// END: CONTROLLER SET


/* -------------------- */
// TEMPATE HEADER OUTPUT

function entex_theme_output_data_panel_layout($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	$_SELECTOR = $data['selector'];
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	
	/* Dont generate stylesheet from this panel */ 
	$name = 'entex_theme_panel_'. $_TARGET .'_init_visibility';
	$value = get_theme_mod($name, 0);
	if($value) $visibility = 0;
		else $visibility = 1;
		
	if(!$visibility) return;
	
	
	/* TARGET background color */
	$name = 'entex_theme_layout_'. $_TARGET .'_background_color_value';
	$value = get_theme_mod($name, '');
	if($value){
		$replacement = array($_SELECTOR, 'background-color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET background color transparent */
	$name = 'entex_theme_layout_'. $_TARGET .'_background_color_transparent';
	$value = get_theme_mod($name, 0);
	if($value){
		$value = 'transparent';
		$replacement = array($_SELECTOR, 'background-color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET foreground color */
	if(strpos($data['remove'], 'foreground_layout_color') === FALSE){
		$name = 'entex_theme_layout_'. $_TARGET .'_foreground_color';
		$value = get_theme_mod($name, '');
		if($value){
			$replacement = array($_SELECTOR, 'color', $value, '');
			$style = str_replace($match, $replacement, $data['style']);
			entex_ECOUT($_TARGET, $name, $style);
		}
	}
	
	
	/* TARGET text-shadow (color) */
	// No color - no display
	if(strpos($data['remove'], 'foreground_layout_text_shadow_color') === FALSE){
		$name = 'entex_theme_layout_'. $_TARGET .'_foreground_text_shadow_color';
		$value = get_theme_mod($name, 0);
		if($value){
			$replacement = array($_SELECTOR, 'text-shadow', $value, ' 0px 1px 1px');
			$style = str_replace($match, $replacement, $data['style']);
			entex_ECOUT($_TARGET, $name, $style);
		}
	}
	
	
	/* TARGET line-height (number) */
	if(strpos($data['remove'], 'line_height_layout') === FALSE){
		$name = 'entex_theme_layout_'. $_TARGET .'_line_height_calculated';
		$value = get_theme_mod($name, 0);
		if($value < 0.1) $value = 0;
		if($value){
			$replacement = array($_SELECTOR, 'line-height', $value, '');
			$style = str_replace($match, $replacement, $data['style']);
			entex_ECOUT($_TARGET, $name, $style);
		}
	}
	
	
	/* As controllers are identical we loop them through */
	do_action('entex_theme_customize_controllers_wp_head_'.$_TARGET, $_TARGET, $data);
	
	
	// -- Miscellaneous -- //
	
	/* TARGET Center content */
	if(strpos($data['remove'], 'center_content') === FALSE){
	$name = 'entex_theme_layout_'. $_TARGET .'_center_content';
	$value = get_theme_mod($name, 0);
	if($value){
		$value = 'center';
		$property = 'text-align';
		$unit = '';
		$additional = entex_customize_get_additional($_TARGET, $name, $data);
		$replacement = entex_customize_get_replacement($_SELECTOR, $property, $value, $unit, $data);

		$style = str_replace($match, $replacement, $data['style'].$additional);
		entex_ECOUT($_TARGET, $name, $style);
	}
	}
	
	/* TARGET box-shadow visibility */
	if(strpos($data['remove'], 'box_shadow_visibility') === FALSE){
	$name = 'entex_theme_layout_'. $_TARGET .'_box_shadow_visibility';
	$value = get_theme_mod($name, 0);
	if($value){
		$value = 'none';
		$replacement = array($_SELECTOR, 'box-shadow', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	}
	
	
	/* TARGET margin (ALL) */
	if(strpos($data['remove'], 'margin_all_visibility') === FALSE){
	$name = 'entex_theme_layout_'. $_TARGET .'_margin_all_visibility';
	$value = get_theme_mod($name, 0);
	if($value){
		$value = '0px';
		$additional = $additional = entex_customize_get_additional($_TARGET, $name, $data);
		$replacement = array($_SELECTOR, 'margin', $value, '');
		$style = str_replace($match, $replacement, $data['style'].$additional);
		entex_ECOUT($_TARGET, $name, $style);
	}
	}
	
	
	/* TARGET margin (ALL) */
	if(strpos($data['remove'], 'margin_mobile_visibility') === FALSE){
	$name = 'entex_theme_layout_'. $_TARGET .'_margin_mobile_visibility';
	$value = get_theme_mod($name, 0);
	if($value){
		$value = '0px';
		$additional = entex_customize_get_additional($_TARGET, $name, $data);
		$replacement = array($_SELECTOR, 'margin', $value, '');
		$style = str_replace($match, $replacement, $data['initial'].$additional);
		entex_ECOUT($_TARGET, $name, $style);
	}
	}
	
	
	// -- BORDERS -- //
	if(strpos($data['remove'], '__border_layout__') === FALSE){
		
	/* TARGET border visibility */
	$name = 'entex_theme_layout_'. $_TARGET .'_border_visibility';
	$value = get_theme_mod($name, 0);
	$value = $value ? 'none' : '';
	if($value){
		$replacement = array($_SELECTOR, 'border', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET border mobile visibility */
	if(strpos($data['remove'], 'border_mobile_visibility') === FALSE){
	$name = 'entex_theme_layout_'. $_TARGET .'_border_mobile_visibility';
	$value = get_theme_mod($name, 0);
	$value = $value ? 'none' : '';
	if($value){
		$replacement = array($_SELECTOR, 'border', $value, '');
		$style = str_replace($match, $replacement, $data['initial']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	}
	
	/* TARGET border all width */
	if(strpos($data['remove'], 'border_all_width') === FALSE){
	$name = 'entex_theme_layout_'. $_TARGET .'_border_all_width';
	$value = get_theme_mod($name, -1);
	if($value < 0) $value = null;
	if($value != null){
		$replacement = array($_SELECTOR, 'border-width', $value, 'px');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	}
	
	/* TARGET border all COLOR */
	if(strpos($data['remove'], 'border_all_color') === FALSE){
	$name = 'entex_theme_layout_'. $_TARGET .'_border_all_color';
	$value = get_theme_mod($name, '');
	if($value){
		$STYLE = ' { border-color: '. $value .'; }';
		$replacement = array($_SELECTOR, 'border-color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	}
	
	/* TARGET border top width */
	$name = 'entex_theme_layout_'. $_TARGET .'_border_top_width';
	$value = get_theme_mod($name, -1);
	if($value < 0) $value = null;
	if($value != null){
		$replacement = array($_SELECTOR, 'border-top-width', $value, 'px');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET border top COLOR */
	$name = 'entex_theme_layout_'. $_TARGET .'_border_top_color';
	$value = get_theme_mod($name, '');
	if($value){
		$STYLE = ' { border-top-color: '. $value .'; }';
		$replacement = array($_SELECTOR, 'border-top-color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET border bottom width */
	$name = 'entex_theme_layout_'. $_TARGET .'_border_bottom_width';
	$value = get_theme_mod($name, -1);
	if($value < 0) $value = null;
	if($value != null){
		$replacement = array($_SELECTOR, 'border-bottom-width', $value, 'px');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET border bottom COLOR */
	$name = 'entex_theme_layout_'. $_TARGET .'_border_bottom_color';
	$value = get_theme_mod($name, '');
	if($value){
		$replacement = array($_SELECTOR, 'border-bottom-color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	}
	
	
	// -- PADDING (ALL) (REM) -- //
	if(strpos($data['remove'], '__padding_layout__') === FALSE){
		
	/* viewporter */
	// (Can be hidden but we need the false value here )
	$name = 'entex_theme_layout_'. $_TARGET .'_padding_viewport';
	$viewporter = get_theme_mod($name, 0);
	
	/* TARGET padding (rem) */
	if(strpos($data['remove'], 'padding_all') === FALSE){
	$name = 'entex_theme_layout_'. $_TARGET .'_padding_all';
	$value = get_theme_mod($name, -1);
	if($value < 0) $value = null;
	if($value != null){
		/* converting */
		$value = ($value / 16);
		$replacement = array($_SELECTOR, 'padding', $value, 'rem');
		$style = str_replace($match, $replacement, ($viewporter ? $data['responsive'] : $data['style']));
		entex_ECOUT($_TARGET, $name, $style);
	}
	}
	
	// -- PADDING TOP BOTTOM (EM) -- //
	
	/* TARGET padding-top (em) */
	if(strpos($data['remove'], 'padding_top') === FALSE){
	$name = 'entex_theme_layout_'. $_TARGET .'_padding_top';
	$value = get_theme_mod($name, -0.1);
	if($value < 0) $value = null;
	if($value != null){
		$replacement = array($_SELECTOR, 'padding-top', $value, 'em');
		$style = str_replace($match, $replacement, ($viewporter ? $data['responsive'] : $data['style']));
		entex_ECOUT($_TARGET, $name, $style);
	}
	}
	
	/* TARGET padding-bottom */
	if(strpos($data['remove'], 'padding_bottom') === FALSE){
	$name = 'entex_theme_layout_'. $_TARGET .'_padding_bottom';
	$value = get_theme_mod($name, -0.1);
	if($value < 0) $value = null;
	if($value != null){
		$replacement = array($_SELECTOR, 'padding-bottom', $value, 'em');
		$style = str_replace($match, $replacement, ($viewporter ? $data['responsive'] : $data['style']));
		entex_ECOUT($_TARGET, $name, $style);
	}
	}
	} // END if padding NOT removed
	
	
	/* TARGET padding CLAMP */
	if(strpos($data['remove'], 'padding_clamp') === FALSE){
	$name = 'entex_theme_layout_'. $_TARGET .'_padding_clamp';
	$value = get_theme_mod($name, '');
	if($value){
		$replacement = array($_SELECTOR, 'padding', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	} 
	
	// -- WIDTH CLAMP -- //

	/* TARGET width CLAMP */
	if(strpos($data['remove'], 'width_clamp') === FALSE){
	$name = 'entex_theme_layout_'. $_TARGET .'_width_clamp';
	$value = get_theme_mod($name, '');
	if($value){
		$replacement = array($_SELECTOR, 'width', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	}
	
	
	
	/* action (global) */
	do_action('entex_theme_customize_intercept_wp_head_'.$data['visibility'], $_TARGET, $data);

	/* action */
	do_action('entex_theme_customize_wp_head_'.$_TARGET, $_TARGET, $data);
	
}

/* ******************** */
// END: TEMPATE OUTPUT

// -- END FILE -- //