<?php if(!defined('ABSPATH')) die();
/**
 * Entex theme customizer panel
 *
 * Panels are loaded as stylesheet url
 * Create your own customizer directory in your child theme
 * To override and modify the default panels
 *
 * @package Entex
 * @subpackage Entex
 * @updated 2.0190814
 * 
 * Documentation: http://entex.info
 * Contributor: Jonas Lundman
 *
 * IMPORTANT:
 * Labels are NOT MENT TO BE translatable
 * As they are considered as CSS data labels
 * However, the GET TEXT call are made in the options array anayway
 *
 */

/* -------------------- */
// CONTROLLER SET

function entex_theme_customize_register_panel_html($wp_customize, $_TARGET, $data){

	if(!isset($wp_customize)) return;
	if(defined('ENTEX_THEME_CUSTOMIZER_PANELS_OFF')) return;

	if(!$_TARGET) return;
	if(!$data['label']) $_LABEL = $_TARGET;
		else $_LABEL = esc_attr($data['label']);
	$unit = $data['unit'];
	
	// CREATE SUB PANEL
	
	$_PANEL = 'entex_panel_'.$_TARGET;
	$wp_customize->add_section($_PANEL,
		array(
			'title' => $_LABEL,
			'description' => $data['description'],
			'priority' => $data['panel-priority'],
			'panel' => $data['in-master-panel']
		)
	);

	$priority = 10;
	
	
	// -- EARLY CONTROLLERS -- //

	/* panel visibility */
	$id = 'entex_theme_panel_'. $_TARGET .'_init_visibility';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Ignore this panel settings on save', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('This function is not in use', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	
	// -- GLOBAL -- //
	
	/* force front end use inline styles instead of creating stylesheet */ 
	$id = 'entex_customizer_force_inline_styles';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Do not create stylesheet', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('This global option will force to load settings as embed styles instead of trying create stylesheet on save.', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	
	// -- BODY CLASS -- //
	
	/* section preview */ 
	$id = 'entex_theme_section_preview_visibility';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Show preview section', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('A hidden section is generated with all common elements included to make shure every controller has a target.', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	
	// -- BODY CLASS -- //
	
	/* wp-is-initial */ 
	$id = 'entex_theme_remove_wp_is_initial';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Disable all initital layout', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('This will unlink all initial typographic styles. Use this when building completely new layout for elements instead of override default styles.', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	
	// -- END EARLY CONTROLLERS -- //
	
	
	$priority 	= 20;
	do_action('entex_theme_customize_register_panel_'. $_TARGET .'_priority_'.$priority, $wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority);
	$priority 	= 40;

	
	// HEADING
	$id = 'entex_theme_typo_'. $_TARGET .'_space_font_control';
	$wp_customize->add_setting($id, array('default' => '', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				'label' => esc_html_x('HTML settings', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'border' => 50,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* html (root) font size */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_root_size';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Html font size (px)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => esc_html_x('Changing the values here will scale the complete website as all style properties are relative to the html root element.', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'break' => true,
				'min' => 10,
				'max' => 20,
				'step' => 1,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);

	
	/* html font control */
	
	$id = 'entex_theme_'. $_TARGET .'_font_control';
	$wp_customize->add_setting($id, array('default' => entex_theme_font_control_defaults(), 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_font'));
	$wp_customize->add_control(
		new entex_customize_font_control(
			$wp_customize, 
			$id, array(
				'label' => esc_html_x('Html font settings', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'master' => true,
				'section' => $_PANEL,
				'priority' => $priority,
				'input_attrs' => array(
					'font_count' => 0,
					'orderby' => 'alpha',
				),
			)
		)
	);
	/* memory */
	$id = 'entex_theme_'. $_TARGET . '_memory_control';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'sanitize_text_field'));
	$wp_customize->add_control(
		new entex_customize_memory_control(
			$wp_customize, 
			$id, array(
				/* translators: */
				'label' => sprintf(esc_html_x('%s memory settings', 'Customizer data: DO NOT TRANSLATE', 'entex'), $_LABEL),
				'description' => '',
				'section' => $_PANEL,
				'priority' => $priority,
				'master' => 'entex_theme_'. $_TARGET .'_font_control'
			)
		)
	);
	
	
	/* html color */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_root_color';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability' => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize, $id,
			array(
				'label' => esc_html_x('Html initial color', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'section' => $_PANEL,
				'priority' => $priority,
				'settings' => $id,
				'show_opacity' => true, 
				'palette' => entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	
	
	/* text color */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_paragraph_color';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability' => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize, $id,
			array(
				'label' => esc_html_x('Paragraph initial color', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'section' => $_PANEL,
				'priority' => $priority,
				'settings' => $id,
				'show_opacity' => true, 
				'palette' => entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	
	
	
	// HEADING
	$id = 'entex_theme_typo_'. $_TARGET .'_space_font_size';
	$wp_customize->add_setting($id, array('default' => '', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				'label' => esc_html_x('Body settings', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'border' => 50,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	

	/* body font size */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_font_size_initial';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Body initial font size (rem)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'break' => true,
				'min' => 0,
				'max' => 72,
				'step' => 1,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* body line height */
	/* GHOST */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_line_height_initial';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Line height', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'ghost' => true,
				'min' => 0,
				'max' => 72,
				'step' => 1,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	/* CALCULATED */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_line_height_initial_calculated';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Line height', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'calculated' => true,
				'monitor' => true,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	

	/* RESPONSIVE body font size / .ua-main */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_font_size_main';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Body main font size (rem)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'desc' => esc_html_x('Tablet and main desktop view', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'break' => true,
				'min' => 0,
				'max' => 72,
				'step' => 1,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* body line height main */
	/* GHOST */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_line_height_main';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Line height', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'desc' => '',
				'break' => false,
				'ghost' => true,
				'monitor' => true,
				'min' => 0,
				'max' => 72,
				'step' => 1,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	/* CALCULATED */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_line_height_main_calculated';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Line height', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'calculated' => true,
				'monitor' => true,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	// -- END MAIN CONTROLLERS -- //
	

	$priority 	= 80;
	do_action('entex_theme_customize_register_panel_'. $_TARGET .'_priority_'.$priority, $wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority);

}

/* ******************** */
// END: CONTROLLER SET





/* -------------------- */
// TEMPATE HEADER OUTPUT - MIXED

function entex_theme_output_data_panel_html($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	/* NOTE: MIXED TARGETS and IDS */
	$_SELECTOR = $data['selector']; // default 'html'
	$unit = $data['unit'];
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	$google = array();
	
	/* Dont generate stylesheet from this panel */
	$name = 'entex_theme_panel_'. $_TARGET .'_init_visibility';
	$value = get_theme_mod($name, 0);
	if($value) $visibility = 0;
		else $visibility = 1;
	if(!$visibility) return;
	
	
	/* html font-size (px) */
	$name = 'entex_theme_typo_'. $_TARGET .'_root_size';
	$value = get_theme_mod($name, 0);
	if($value == 16) $value = 0;
	if($value){
		$replacement = array('html', 'font-size', $value, 'px');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}

	
	/* html font control */
	$name = 'entex_theme_'. $_TARGET .'_font_control';
	$value = get_theme_mod($name, '');
	if($value){
		$arr = (array) json_decode($value);
		$value = $arr['font'];
		$weight = $arr['regularweight'];
		$bold = $arr['boldweight'];
		if($value){
			
			if(defined('ENTEX_THEME_CUSTOMIZER_GOOGLE_FONTS_FALLBACK')){
				if(ENTEX_THEME_CUSTOMIZER_GOOGLE_FONTS_FALLBACK) $value .= ', '.ENTEX_THEME_CUSTOMIZER_GOOGLE_FONTS_FALLBACK;
			}
			
			$replacement = array('html', 'font-family', $value, '');
			$style = str_replace($match, $replacement, $data['style']);
			entex_ECOUT($_TARGET, $name, $style);
			
			if($weight){
				$replacement = array('html', 'font-weight', $weight, '');
				$style = str_replace($match, $replacement, $data['style']);
				entex_ECOUT($_TARGET, $name.'_weight', $style);
			}
			
			if($bold){
				$replacement = array(entex_theme_customize_bold_selectors(), 'font-weight', $bold, '');
				$style = str_replace($match, $replacement, $data['style']);
				entex_ECOUT($_TARGET, $name.'_bold', $style);
			}
			
			$google[$name] = $arr;
			entex_theme_customize_google($google);
		}
	}
	
	/* html color */
	
	$name = 'entex_theme_typo_'. $_TARGET .'_root_color';
	$value = get_theme_mod($name, 0);
	if($value){
		$replacement = array('html', 'color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* text color */
	
	$name = 'entex_theme_typo_'. $_TARGET .'_paragraph_color';
	$value = get_theme_mod($name, 0);
	if($value){
		$replacement = array('p', 'color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	// -- ( BODY ) -- //

	
	/* body font-size (rem) */
	$name = 'entex_theme_typo_'. $_TARGET .'_font_size_initial';
	$value = get_theme_mod($name, 0);
	if($value < 0.1) $value = 0;
	if($value){
		/* converting */
		$value = ($value / 16);
		/* no selector - added in placeholder */
		$replacement = array('', 'font-size', $value, 'rem');
		$style = str_replace($match, $replacement, $data['initial']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* body line-height (number) */
	$name = 'entex_theme_typo_'. $_TARGET .'_line_height_initial_calculated';
	$value = get_theme_mod($name, 0);
	if($value < 0.1) $value = 0;
	if($value){
		/* no selector - added in placeholder */
		$replacement = array('', 'line-height', $value, '');
		$style = str_replace($match, $replacement, $data['initial']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* body font-size main (rem) */
	$name = 'entex_theme_typo_'. $_TARGET .'_font_size_main';
	$value = get_theme_mod($name, 0);
	if($value < 0.1) $value = 0;
	if($value){
		/* converting */
		$value = ($value / 16);
		/* no selector - added in placeholder */
		$replacement = array('', 'font-size', $value, 'rem');
		$style = str_replace($match, $replacement, $data['responsive'].$data['desktop']);
		entex_ECOUT($_TARGET, $name, $style);
	}

	/* body line-height main (number) */
	$name = 'entex_theme_typo_'. $_TARGET .'_line_height_main_calculated';
	$value = get_theme_mod($name, 0);
	if($value < 0.1) $value = 0;
	if($value){
		/* no selector - added in placeholder */
		$replacement = array('', 'line-height', $value, '');
		$style = str_replace($match, $replacement, $data['responsive'].$data['desktop']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	
	
	/* action (global) */
	do_action('entex_theme_customize_intercept_wp_head_'.$data['visibility'], $_TARGET, $data);
	
	/* action */
	do_action('entex_theme_customize_wp_head_'.$_TARGET, $_TARGET, $data);
	
}

/* ******************** */
// END: TEMPATE OUTPUT

// -- END FILE -- //