<?php if(!defined('ABSPATH')) die();
/**
 * Entex theme customizer panel
 *
 * Panels are loaded as stylesheet url
 * Create your own customizer directory in your child theme
 * To override and modify the default panels
 *
 * @package Entex
 * @subpackage Entex
 * @updated 2.211027
 * 
 * Documentation: http://entex.info
 * Contributor: Jonas Lundman
 *
 * IMPORTANT:
 * Labels are NOT MENT TO BE translatable
 * As they are considered as CSS data labels
 * However, the GET TEXT call are made in the options array anayway
 *
**/

/* -------------------- */
// CONTROLLER SET

function entex_theme_customize_register_panel_body($wp_customize, $_TARGET, $data){

	if(!isset($wp_customize)) return;
	if(defined('ENTEX_THEME_CUSTOMIZER_PANELS_OFF')) return;

	if(!$_TARGET) return;
	if(!$data['label']) $_LABEL = $_TARGET;
		else $_LABEL = esc_attr($data['label']);
	$unit = $data['unit'];
	
	
	// CREATE SUB PANEL
	
	$_PANEL = 'entex_panel_'.$_TARGET;
	$wp_customize->add_section($_PANEL,
		array(
			'title' => $_LABEL,
			'description' => $data['description'],
			'priority' => $data['panel-priority'],
			'panel' => $data['in-master-panel']
		)
	);

	$priority = 1;
	
	
	// -- EARLY CONTROLLERS -- //
	
	$id = 'entex_theme_panel_'. $_TARGET .'_init_visibility';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html(_x('Ignore this panel settings on save', 'Customizer data: DO NOT TRANSLATE', 'entex')),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	$priority = 2;
	do_action('entex_theme_customize_register_panel_'. $_TARGET .'_priority_'.$priority, $wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority);
	$priority = 3;

	// -- SECTIONS -- //

	// HEADING
	$id = 'entex_theme_layout_'. $_TARGET .'_space_elements_global';
	$wp_customize->add_setting($id, array('default' => '', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				'label' => esc_html(_x('Body sections', 'Customizer data: DO NOT TRANSLATE', 'entex')),
				'description' => '',
				'border' => 30,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* Sections (ua-grid-box) box shadow visibility */
	$id = 'entex_theme_layout_'. $_TARGET .'_gridbox_box_shadow_visibility';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html(_x('Remove sections default box shadow', 'Customizer data: DO NOT TRANSLATE', 'entex')),
			'description' => esc_html(_x('Desktop media view only', 'Customizer data: DO NOT TRANSLATE', 'entex')),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	
	/* Sections (ua-grid-box) background-color transparent */
	$id = 'entex_theme_layout_'. $_TARGET .'_gridbox_background_transparent';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html(_x('Remove sections default background color', 'Customizer data: DO NOT TRANSLATE', 'entex')),
			'description' => esc_html(_x('Desktop media view only', 'Customizer data: DO NOT TRANSLATE', 'entex')),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	/* Sections (ua-grid-box) background-color */
	$id = 'entex_theme_layout_'. $_TARGET .'_gridbox_background_color';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability'  => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize,
			$id,
			array(
				'label' 		=> esc_html(_x('Sections Background color', 'Customizer data: DO NOT TRANSLATE', 'entex')),
				'description'   => esc_html(_x('All media views', 'Customizer data: DO NOT TRANSLATE', 'entex')),
				'section'       => $_PANEL,
				'settings'      => $id,
				'priority' 		=> $priority,
				'show_opacity'  => true, 
				'palette'	=> entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	
	/* Sections (ua-root) background-color (filter) */
	$id = 'entex_theme_layout_'. $_TARGET .'_root_background_filter';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability'  => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize,
			$id,
			array(
				'label' 		=> esc_html(_x('Main area background filter', 'Customizer data: DO NOT TRANSLATE', 'entex')),
				'description'   => esc_html(_x('Allow to apply a thin layer of color', 'Customizer data: DO NOT TRANSLATE', 'entex')),
				'section'       => $_PANEL,
				'settings'      => $id,
				'priority' 		=> $priority,
				'show_opacity'  => true, 
				'palette'	=> entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	
	
	$priority 	= 3;
	do_action('entex_theme_customize_register_panel_'. $_TARGET .'_priority_'.$priority, $wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority);
	$priority 	= 4;
	
	// HERE WE USE DEFAULT WordPress CONTROLLERS

	// -- BACKGROUNDS -- //

	// HEADING //
	$id = 'entex_theme_layout_'. $_TARGET .'_space_backgrounds';
	$wp_customize->add_setting($id, array('default' => '','sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				'label' => esc_html(_x('Background', 'Customizer data: DO NOT TRANSLATE', 'entex')),
				'description' => '',
				'border' => 30,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	$priority = 5;
	
	/* Move built in background color control into the body layout panel */
	$wp_customize->get_control('background_color')->section = $_PANEL;
	$wp_customize->get_control('background_color')->priority = $priority;
	$wp_customize->get_control('background_color')->description = esc_html(_x('This is the WordPress built in background color without alpha channels.', 'Customizer data: DO NOT TRANSLATE', 'entex'));
	
	/* Move built in background image control into the body layout panel */
	$wp_customize->get_control('background_image')->priority = $priority;
	if(get_theme_support('custom-background')){
		foreach(array('image', 'preset', 'position', 'size', 'repeat', 'attachment') as $prop){
			$wp_customize->get_control('background_' .$prop)->section = $_PANEL;
		}
	}


	/* TARGET background image visibility */
	
	$id = 'entex_theme_layout_'. $_TARGET .'_background_image_visibility';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html(_x('Hide background image', 'Customizer data: DO NOT TRANSLATE', 'entex')),
			'description' => esc_html(_x('Allow you to keep but ignore image settings', 'Customizer data: DO NOT TRANSLATE', 'entex')),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	
	/* TARGET background color transparent */
	
	$id = 'entex_theme_layout_'. $_TARGET .'_background_color_transparent';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html(_x('Set background color as transparent', 'Customizer data: DO NOT TRANSLATE', 'entex')),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	

	
	
	// -- BEFORE and AFTER -- //
	/* As controllers are identical we loop them through */
	$priority 	= 50;
	do_action('entex_theme_customize_register_panel_'. $_TARGET .'_priority_'.$priority, $wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority);
	$priority 	= 60;
	
	
	// -- PADDING -- //
	if(strpos($data['remove'], '__padding__') === FALSE){
		
		// HEADING
		$id = 'entex_theme_layout_'. $_TARGET .'_space_padding';
		$wp_customize->add_setting($id, array('default' => '', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
		$wp_customize->add_control(
			new entex_customize_space_control(
				$wp_customize, 
				$id, array(
					'label' => esc_html(_x('Padding', 'Customizer data: DO NOT TRANSLATE', 'entex')),
					'description' => esc_html(_x('Activates site box mode', 'Customizer data: DO NOT TRANSLATE', 'entex')),
					'border' => 50,
					'break' => false,
					'height' => 0,
					'section' => $_PANEL,
					'priority' => $priority
				)
			)
		);
	
	
		/* TARGET padding-top (rem) */
		if(strpos($data['remove'], 'padding_top') === FALSE){
			$id = 'entex_theme_layout_'. $_TARGET .'_padding_top';
			$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
			$wp_customize->add_control(
				new entex_customize_range_control(
					$wp_customize, 
					$id, array(
						'label'	=> esc_html(_x('Padding top (px)', 'Customizer data: DO NOT TRANSLATE', 'entex')),
						'description' => esc_html(_x('Desktop view only', 'Customizer data: DO NOT TRANSLATE', 'entex')),
						'break' => false,
						'monitor' => true,
						'min' => 0,
						'max' => 300,
						'step' => 1,
						'section' => $_PANEL,
						'priority' => $priority
					)
				)
			);
		}
	
		/* TARGET padding-bottom (rem) */
		if(strpos($data['remove'], 'padding_bottom') === FALSE){
			$id = 'entex_theme_layout_'. $_TARGET .'_padding_bottom';
			$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
			$wp_customize->add_control(
				new entex_customize_range_control(
					$wp_customize, 
					$id, array(
						'label'	=> esc_html(_x('Padding bottom (px)', 'Customizer data: DO NOT TRANSLATE', 'entex')),
						'description' => esc_html(_x('Desktop view only', 'Customizer data: DO NOT TRANSLATE', 'entex')),
						'monitor' => true,
						'min' => 0,
						'max' => 300,
						'step' => 1,
						'section' => $_PANEL,
						'priority' => $priority
					)
				)
			);
		}
	} // END if NOT __padding__

	$priority 	= 80;
	do_action('entex_theme_customize_register_panel_'. $_TARGET .'_priority_'.$priority, $wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority);
	
}


/* ******************** */
// END: CONTROLLER SET


/* -------------------- */
// TEMPATE HEADER OUTPUT

function entex_theme_output_data_panel_body($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	$_SELECTOR = $data['selector'];
	$unit = $data['unit'];
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	
	/* Dont generate stylesheet from this panel */ 
	$name = 'entex_theme_panel_'. $_TARGET .'_init_visibility';
	$value = get_theme_mod($name, 0);
	if($value) $visibility = 0;
		else $visibility = 1;
		
	if(!$visibility) return;

	// -- SECTIONS -- //
	
	/* Sections (ua-grid-box) box shadow visibility */
	$name = 'entex_theme_layout_'. $_TARGET .'_gridbox_box_shadow_visibility';
	$value = get_theme_mod($name, 0);
	if($value){
		$value = 'none';
		$replacement = array('.ua-grid-box', 'box-shadow', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}

	/* Sections (ua-grid-box) background-color transparent */
	$name = 'entex_theme_layout_'. $_TARGET .'_gridbox_background_transparent';
	$value = get_theme_mod($name, 0);
	if($value){
		$value = 'transparent !important';
		$replacement = array('.ua-grid-box', 'background-color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* Sections (ua-grid-box) background-color */
	$name = 'entex_theme_layout_'. $_TARGET .'_gridbox_background_color';
	$value = get_theme_mod($name, '');
	if($value){
		$replacement = array('.ua-grid-box', 'background-color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* Sections (ua-root) background-color (filter) */
	$name = 'entex_theme_layout_'. $_TARGET .'_root_background_filter';
	$value = get_theme_mod($name, '');
	if($value){
		$replacement = array('.ua-root', 'background-color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}


	/* TARGET background image visibility */
	$name = 'entex_theme_layout_'. $_TARGET .'_background_image_visibility';
	$value = get_theme_mod($name, 0);
	if($value){
		$value = 'none !important';
		$replacement = array($_SELECTOR, 'background-image', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET background color transparent */
	$name = 'entex_theme_layout_'. $_TARGET .'_background_color_transparent';
	$value = get_theme_mod($name, 0);
	if($value){
		$value = 'transparent !important';
		$replacement = array($_SELECTOR, 'background-color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}

	/* As controllers are identical we loop them through */
	do_action('entex_theme_customize_controllers_wp_head_'.$_TARGET, $_TARGET, $data);
	
	
	// -- PADDING TOP BOTTOM (EM) -- //
	if(strpos($data['remove'], '__padding__') === FALSE){
	
		/* TARGET padding-top (rem) */
		if(strpos($data['remove'], 'padding_top') === FALSE){
			$name = 'entex_theme_layout_'. $_TARGET .'_padding_top';
			$value = get_theme_mod($name, 0);
			if($value < 1) $value = null;
			if($value != null){
				$value = ($value / 16);
				$replacement = array($_SELECTOR, 'padding-top', $value, 'rem');
				$style = str_replace($match, $replacement, $data['style']);
				entex_ECOUT($_TARGET, $name, $style);
			}
		}
	
		/* TARGET padding-bottom */
		if(strpos($data['remove'], 'padding_bottom') === FALSE){
			$name = 'entex_theme_layout_'. $_TARGET .'_padding_bottom';
			$value = get_theme_mod($name, 0);
			if($value < 1) $value = null;
			if($value != null){
				$value = ($value / 16);
				$replacement = array($_SELECTOR, 'padding-bottom', $value, 'rem');
				$style = str_replace($match, $replacement, $data['style']);
				entex_ECOUT($_TARGET, $name, $style);
			}
		}
	} // END if NOT __padding__
	
	/* action (global) */
	do_action('entex_theme_customize_intercept_wp_head_'.$data['visibility'], $_TARGET, $data);

	/* action */
	do_action('entex_theme_customize_wp_head_'.$_TARGET, $_TARGET, $data);
	
}

/* ******************** */
// END: TEMPATE OUTPUT

// -- END FILE -- //