
// UPDATED 2022 09 30

(function($){
	
	var api = wp.customize;
	var head = $('head');
	var parent_api = window.parent.wp.customize;
	var transported = '';
	var warnings = '';
	var bolds = '';
	var debug = false;
	var global_target = '';
	
	debug = ENTEX_CUSTOMIZE.debug;
	if(debug) console.log('Debug is on');
	
	transported = ENTEX_CUSTOMIZE.data.replace(/&quot;/g, '"');
	var ENTEX_Arr = $.parseJSON(transported);
	if(debug) console.log(ENTEX_Arr);
	
	warnings = ENTEX_CUSTOMIZE.warnings;
	if(warnings && debug) console.log(warnings); // alerted later
	
	bolds = ENTEX_CUSTOMIZE.bolds;
	if(bolds && debug) console.log(bolds);

	transported = ENTEX_CUSTOMIZE_FONTS.data.replace(/&quot;/g, '"');
	var ENTEX_fonts = $.parseJSON(transported);
	if(debug) console.log(ENTEX_fonts);
	
	var this_def_font_size_num = 12;
	var this_def_line_height_num = 16;
	
	
	
	
	// -- PARENT EVENT FUNCTIONS -- //
	
	/* not in use yet */
	function init_detachTypo(){
		return;
		var el = $('.entex-button-control-detach-typo', window.parent.document).get(0);
		if(el){
			var selectors = 'style[id*="entex-theme-typo-"], style[id*="entex-theme-font-control-"], link[id*="entex-theme-font-control-"]';
			var $elements = $(selectors);
			$(el).click(function(){
				if($(this).hasClass('entex-button-control-is-active')){
					$elements.detach();
					if($(this).data('current')) head.append($(this).data('current'));
				} else {
					var $current = head.find(selectors);
					if($current){
						$(this).data('current', $current);
						$current.remove();
					}
					head.append($elements);
				}
			}).data('current', null);
		}
	}
	

	
	// -- HELPER FUNCTIONS -- //
	
	function removeLoader(){
		var el = $('#customize-preview', window.parent.document).get(0);
		if(!el) return;
		$(el).css('background-image', 'none').children('iframe').css('background-image', 'none');
	}
	
	function getElementFontSize(context){
		if(debug) console.log(context);
		return parseFloat(
			getComputedStyle(context).fontSize
		);
	}
	
	function getElementLineHeight(context){
		return parseFloat(
			getComputedStyle(context).lineHeight
		);
	}
	
	$('body').data('remote', 0);
	$('body').data('timeout', null);
	
	function runController(id){
		
		var el = getController(id);
		if(!el) return false

		$('body').data('remote', 1);
		$(el).css('opacity', 0.35);
		
		/* prevent event on multiple remoted controllers */
		var dataTimeout = $('body').data('timeout');
		if(dataTimeout) clearTimeout(dataTimeout);
		dataTimeout = setTimeout(function(){ 
			$('body').data('remote', 0); 
			$(el).css('opacity', '').siblings().css('opacity', '');
		}, 3000);
		$('body').data('timeout', dataTimeout);
		
		var parent_control = parent_api.control.instance(id);
		var value = parent_control.setting.get();

		parent_control.setting.set('');
		parent_control.setting.set(value);
		
		$(el).find('.entex-customize-control-monitor-wr input').val(value);

	}
	
	
	
	
	$('body').data('preview', null);

	function runPreview(el){
		/* Pass el argument as clean this */
		var dataTimeout = $('body').data('preview');
		if(dataTimeout) clearTimeout(dataTimeout);
		dataTimeout = setTimeout(function(){ 
			$('.ua-customizer-preview-element').removeClass('ua-customizer-preview-element'); 
		}, 3000);
		$('body').data('preview', dataTimeout);
		$(el).addClass('ua-customizer-preview-element');
	}
	
	function getController(id){
		var el = $('#customize-control-' + id, window.parent.document).get(0);
		if(el) return el;
			else return false;
	}
	
	function getMonitor(id){
		var el = $('#customize-control-' + id, window.parent.document).find('.entex-customize-control-monitor').get(0);
		if(el) return el;
			else return false;
	}
	
	function getNotification(id){
		var el = $('#customize-control-' + id, window.parent.document).find('.customize-control-notifications-container').get(0);
		if(el) return el;
			else return false;
	}
	
	function setNotification(id, wr, message, type){
		var $wr = $(wr);
		if(!type) type = 'info';
		if($wr.find('#notice-' + id).get(0)) return;
		$wr.show().find('ul').append(
			'<li id="notice-' + id + '" class="notice notice-' + type + ' is-dismissible"><div class="notification-message">' + message + '</div><button type="button" data-parent="' + id + '" class="entex-dismiss notice-dismiss"><span class="screen-reader-text">Dismiss</span></button></li>'
		);
	}
	
	$(window.parent.document).on('click', '.entex-dismiss', function(){
		removeNotification($(this).attr('data-parent'), $(this).closest('.customize-control-notifications-container').get(0));
	});
	
	function removeNotification(id, wr){
		var $wr = $(wr);
		$wr.find('#notice-' + id).remove();
		if(!$wr.find('li').get(0)) $wr.slideUp('fast');
	}
	
	function getColorMonitor(id){
		var el = $('#customize-control-' + id, window.parent.document).find('.wp-color-result-value').get(0);
		if(el) return el;
			else return false;
	}
	
	function setColorInput(id, value){
		var el = $('#customize-control-' + id, window.parent.document).find('input.alpha-color-control').get(0);
		if(el){
			$('#customize-control-' + id, window.parent.document).find('button.wp-color-result').trigger('click');
			$(el).val(value + ' ').change();
		}
	}
	
	function clearColorInput(id){
		var el = $('#customize-control-' + id, window.parent.document).find('input.wp-picker-clear').get(0);
		if(el) $(el).trigger('click');
	}
	
	function disableInput(id){
		var el = $('#customize-control-' + id, window.parent.document).get(0);
		if(el) $(el).addClass('entex-element-not-generated').attr('title', 'Element is not generated on current page load');
	}
	
	function enableInput(id){
		var el = $('#customize-control-' + id, window.parent.document).get(0);
		if(el) $(el).removeClass('entex-element-not-generated').removeAttr('title');
	}
	
	/* interaction pseudo only */
	function isPseudo(selector){true;
		var pseudo = false;
		if(selector.match(':before')) pseudo = true;
		if(selector.match(':after')) pseudo = true;
		if(selector.match(':hover')) pseudo = true;
		if(selector.match(':active')) pseudo = true;
		if(selector.match(':focus')) pseudo = true;
		if(selector.match(':focus-within')) pseudo = true;
		if(selector.match(':blur')) pseudo = true;
		return pseudo;
	}
	
	function removePseudo(selector){
		
		var pseudo = isPseudo(selector);
		if(!pseudo) return selector;
		return selector.split(':')[0];
	}
	
	/* must be refined as main is not in use anymore */
	function disableController(id, selector, main){
		return true;
		enableInput(id);
		var pseudo = isPseudo(selector);
		if(!pseudo){
			var check = selector;
			if(main == 'main'){
				if(check != 'body'){
					check = '.ua-main ' + selector;
				}
			}
			if(check.match('.selected')) check = check.replace('.selected', '');
			if(check.match('-active')) check = false;
			if(check && !$(check).get(0)){
				disableInput(id);
				if(debug) console.log('Controller disabled: ' + check);
				return false;
			}
		} else {
			//if(debug) console.log('(Pseudo enabled ' + selector + ')');
		}
		return true;
	}
	
	/* returning Warning string */
	function validateViewportElement(selector, placeholder, data){
		
		/* no validation if called by runController */
		if($('body').data('remote')) return '';

		var browserView = $(window).width();
		if(debug) console.log('Validating Viewport element: BROWSER width: ' + browserView + ' | ' + selector + ' | Placeholder: ' + placeholder);
		
		var pseudo = isPseudo(selector);
		if(pseudo){
			var original = selector;
			selector = removePseudo(selector);
			if(debug) console.log('Pseudo removed: ' + original + ' -> ' + selector);
		}
		
		if(selector == '.ua-main' || selector == '.ua-not-main'){
			if($(selector).get(0)) return '';
				else return 'Element not found on current page';
		}
		
		
		if(!placeholder.match('@media')){
			if($(selector).get(0)) return '';
				else return 'Element not found on current page';
		}
		
		if(placeholder.match('.ua-not-main')){
			if($('.ua-not-main ' + selector).get(0)) return '';
			if(browserView < 640){
				if($(selector).get(0)) return '';
					else return 'Element not found on current page';
			} else return 'Element need settings in mobile view';
		}
		
		if(placeholder.match('.ua-main') && placeholder.match('min-width: 640px')){
			if(browserView > 639) return '';
				else return 'Element need settings in tablet or desktop view';
		}
		
		if(placeholder.match('.ua-main')){
			if(browserView > 979) return '';
				else return 'Element need settings in desktop view';
		}
		
		if(placeholder.match('min-width') && placeholder.match('max-width')){
			if(debug) console.log('ERR: Validate still min and max-width left : ' + selector);
		}
		
		if(placeholder.match('max-width')){
			var value = placeholder.match(/\d+/)[0];
			if(debug) console.log('Parsed max-width: ' + value);
			if(browserView > value) return 'Element need settings in viewport less than ' + (value++);
				else return '';
		}
		
		if(placeholder.match('min-width')){
			var value = placeholder.match(/\d+/)[0];
			if(debug) console.log('Parsed min-width: ' + value);
			if(browserView < value) return 'Element need settings in viewport at least ' + value;
				else return '';
		}

		if(debug) console.log('Validate element failed for: ' + selector);
		return '';
	}
	
	
	/* find an existsing element of the selector to get computed values from */
	function validateComputedSelector(target, id, selector, property, unit, placeholder, data){
		
		if(debug) console.log('Validate computed selector incoming values: ' + selector + ' | Placeholder: ' + placeholder);
		var browserView = $(window).width();

		/* body font-size reference objects */
		if(selector == '.ua-main' || selector == '.ua-not-main'){
			if(debug) console.log('Validated body selector as: ' + selector);
			return selector;
		}
		
		if(selector == 'body' || selector == 'html'){
			if(debug) console.log('Validated selector as: ' + selector);
			return selector;
		}
		
		if(placeholder.match('.ua-not-main')){
			if($('.ua-not-main ' + selector).get(0)) {
				if(debug) console.log('Found element inside .ua-not-main, selector is returned as child object');
				return $('.ua-not-main ' + selector).get(0);
			}
		}
		
		if(placeholder.match('.ua-main')){
			if($('.ua-main ' + selector).get(0)) {
				if(debug) console.log('Found element inside .ua-main, selector is returned as child object');
				return $('.ua-main ' + selector).get(0);
			}
		}
		
		if(debug) console.log('NO CHANGES: Validated selector as: ' + selector);
		return selector;
	}
	
	
	/* remove units and return identical controller value */
	function validateComputedValue(target, id, selector, property, value, unit, placeholder, data){
		
		if(unit && unit == '%'){
			value = parseFloat(value);
		}
		
		if(unit && unit == 'vw'){
			var browserView = $(window).width();
			value = ((parseFloat(value) / browserView) * 100);
		}
		
		/* should not occur */
		if(unit && unit == 'rem'){
			value = (parseFloat(value) / 10);
		}
		
		if(unit && unit == 'em'){
			if(property == 'font-size') var parent = $(selector).parent().get(0);
				else var parent = $(selector).get(0);
			var parentFontSize = getElementFontSize(parent);
			value = (parseFloat(value) / parentFontSize);
		}
		
		if(unit && unit == 'px'){
			value = (parseFloat(value));
		}
		
		if(property == 'line-height') value = (parseFloat(value));
		if(property == 'text-shadow'){
			if(value.match('#')){
				alert('Your Browser cant handle computed RGB values');
				return false;
			}
			var regExp = /\(([^)]+)\)/;
			var matches = regExp.exec(value);
			if(value.match('rgba')) value = 'rgba(' + matches[1] + ')';
				else value = 'rgb(' + matches[1] + ')';
		}
		
		if(debug) console.log('Element ' + selector + ' VALIDATED computed value: ' + value + unit);
		return value;
	}
	

	
	function bindTitleClick(target, id, selector, property, unit, placeholder, data){
		
		var pseudo = isPseudo(selector);
		if(property == 'text-align') pseudo = true;
		
		if(property == 'border-width') property = 'border-top-width'; 
		if(property == 'border-color') property = 'border-top-color';
		if(property == 'border-style') property = 'border-top-style';
		if(property == 'padding') property = 'padding-top'; 
		if(property == 'margin') property = 'margin-top'; 

		var el = $('#customize-control-' + id + ' .customize-control-title', window.parent.document).get(0);
		if(!el) return false;
		
		/* remove old if in case javascript reloaded */
		if($(el).find('a').get(0)) $(el).find('a').remove();
		
		if(!$(el).find('a').get(0)){
			if(!pseudo){
				
			/* GC - Get Computed button */
			$(el).prepend(
				$('<a />').addClass('entex-get-computed').attr('title', 'Get computed value').text('GC').bind('click', function(){
					
					/* if html paragraph */
					if(selector == 'p') selector = '.ua-main p';
					
					if(placeholder.match('.ua-main') && selector != '.ua-main') var main = 'YES';
						else var main = 'NO';
					
					if(debug) console.log('BEFORE validate: ID: ' + id + ' | TARGET: ' + target + ' | Selector: ' + selector + ' | AS MAIN: ' + main + ' | Property: ' + property + ' |  UNIT: ' + unit );

					/* circut if added in dom */
					if($('[data-' + property + '=' + id + ']').get(0)) { 
						var element = $('[data-' + property + '=' + id + ']').get(0); 
					} else var element = validateComputedSelector(target, id, selector, property, unit, placeholder, data);

					if(!element) {
						if(debug) console.log('Element for: ' + selector + ' NOT FOUND');
						return false;
					}

					var value = $(element).css(property);
					if(property == 'line-height' && value == 'normal'){
						/* remove this when occur fixed */
						alert('normal value found, trying parents ...');
						var found = false;
						$.each($(element).parents(), function(index, obj){
							if(!found){
								var find = $(obj).css(property);
								if(find.match('px')){
									value = parseFloat(find);
									var n = $(obj).get(0);
									if(debug) console.log('Converting line-height from parent (' + n.nodeName + ') : ' + value);
									found = true;
								}
							}
						});
					}
					if(debug) console.log('Incoming element value for ' + selector + ' | Computed value: ' + value);
			
					var set = validateComputedValue(target, id, selector, property, value, unit, placeholder, data);
					if(set || set === 0){
						var parent_control = parent_api.control.instance(id);
						parent_control.setting.set(set);

						var monitor = getMonitor(id);
						if(monitor){
							$(monitor).prev('input').val(set);
							setTimeout(function(){ $(monitor).text('Calculated'); }, 500);
						} else {
							var colorMonitor = getColorMonitor(id);
							if(colorMonitor) { 
								setColorInput(id, set);
								/* hack */
								setTimeout(function(){ 
									$(colorMonitor).text('Calculated'); 
									$(colorMonitor).closest('.wp-picker-container').find('button.wp-color-result').trigger('click');
									$obj = $(colorMonitor).closest('.wp-picker-container').find('.wp-picker-input-wrap').find('input.alpha-color-control');
									$obj.focus().trigger('keyup');
								}, 500);
							}
						}
					}
				}).addClass('binded')
			);
			}
			
			/* R - Reset button */
			$(el).prepend(
				$('<a />').addClass('entex-get-computed').attr('title', 'Reset control').text('R').bind('click', function(){

					var parent_control = parent_api.control.instance(id);
					var set = parent_control.setting.default;
					if(set == null){
						alert('NOTE: Customizer id not registered in options: ' + id);
						set = '';
					} else {
						if(debug) console.log('Customizer id from options: ' + id);
					}
					parent_control.setting.set(set);
					var monitor = getMonitor(id);
					if(monitor){
						$(monitor).prev('input').val(set);
						setTimeout(function(){ $(monitor).text('Reset'); }, 500);
					} else {
						var colorMonitor = getColorMonitor(id);
						if(colorMonitor) { 
							clearColorInput(id);
							setTimeout(function(){ $(colorMonitor).text('Reset'); }, 500); 
						}
					}
				})
			);
		}
	}

	// THIS IS WHERE THE MAGIC HAPPENS
	function add_style(target, styleId, selector, property, value, unit, placeholder, data){
		
		/* allow change selector by propery */
		if(typeof data.main[property] !== 'undefined'){
			if(debug) console.log('data.main = ' + data.main[property]);
			selector = data.main[property];
		}
		
		var prefix = '-inline-css';
		var add = '';
		if(value == 'zero') { value = '0'; }
		if(debug) console.log('STYLE replacement = ' + placeholder);
		if(debug && data.additional) console.log('CUSTOM DATA FOUND: ' + data.additional);
		
		/* find additional selectors */
		if(target == 'ToDo'){
			var find = hypenId(styleId);
			if(data.additional.match('|')) var items = data.additional.split('|');
				else items = new Array(data.additional);
			$.each(items, function(i, item){
				if(item.match(find)){
					var additional = $.trim(item.replace('[' + find + ']', ''));
					selector += ', ' + additional;
					if(debug) console.log('ADDITIONAL selector found: = ' + additional);
				}
			});
		}
		
		/* find additional declarations */
		var additional = '';
		if(data.additional){
			var find = hypenId(styleId);
			if(data.additional.match('|')) var items = data.additional.split('|');
				else items = new Array(data.additional);
			$.each(items, function(i, item){
				if(item.match(find)){
					additional += ' ' + $.trim(item.replace('[' + find + ']', ''));
					if(debug) console.log('ADDITIONAL found: = ' + additional);
				}
			});
		}
		
		/* kill selector if placeholder has it */
		if(!placeholder.match('[selector]')) selector = '';
		
		if(unit) unit += ';';
			else value += ';';
		
		D = placeholder;
		D = D.replace(/\[selector\]/g, selector);
		D = D.replace(/\[property\]/g, property);
		D = D.replace(/\[value\]/g, value);
		D = D.replace(/\[unit\]/g, unit);
		add = D;
		
		var style  = '<style id="' + styleId + prefix + '" type="text/css">';
		style += add + additional;
		style += '</style>' + "\r\n";
		
		if(debug) console.log(style);
		if($('#' + styleId + prefix).length !== 0) $('#' + styleId + prefix).replaceWith(style);
			else $(style).appendTo(head);
					
	}

	function remove_style(styleId){
		var prefix = '-inline-css';
		if($('#' + styleId + prefix).length !== 0) $('#' + styleId + prefix).remove();
		if(debug) console.log('Style removed');
	}
	
	function add_link(linkId, url){
		
		if(ENTEX_fonts['google-fonts-customize-disable']){
			alert('Google fonts for Customizer is disabled inside the Html panel.');
			return false;
		}
		
		var link = $('#' + linkId).get(0);
		/* always remove exsisting */
		if(link) $(link).remove();
		
		// Enqueue the google link
		if(url){
			url = 'https://fonts.googleapis.com/css' + url;
			$('<link id="'  + linkId + '" href="' + url + '" type="text/css" media="all" rel="stylesheet">').appendTo(head);
			if(debug) console.log('<link id="'  + linkId + '" href="' + url + '" type="text/css" media="all" rel="stylesheet">');
		}
	}
	
	function add_layout(linkId, url, to){
		if(to){
			var link = $('#' + linkId).get(0);
			if(link) $(link).remove();
		} else if(url){
			$('<link id="'  + linkId + '" href="' + url + '" type="text/css" media="all" rel="stylesheet">').prependTo(head);
		}
	}
	
	function camelCase(str){
		expr = /-([a-z])/;
		for(var exp = expr; exp.test(str); str = str.replace(exp, RegExp.$1.toUpperCase()));
		return str;
	}
	
	function parseTo(to){
		var transported = to.replace(/&quot;/g, '"');
		var Arr = $.parseJSON(transported);
		return Arr;
	}
	
	function parseUrl(Arr){
		
		var family = Arr['font'];
		var subset = Arr['subset'];
		if(!subset) subset = 'all';
				
		var weight = Arr['regularweight'];
		if(!weight) weight = 'regular';
		//if(weight == 'regular') weight = '400';
		//if(weight == 'italic') weight = '400i';
				
		var collection = new Array();
		collection.push(weight);
		var italic = Arr['italicweight'];
		if(italic) collection.push(italic);
		var bolder = Arr['boldweight'];
		if(bolder) collection.push(bolder);
				
		family = family.replace(/\s/g, '+');
		/*
		weight = weight.replace('talic', '');
		italic = italic.replace('talic', '');
		bolder = bolder.replace('talic', '');
		*/
		collection = collection.filter((v, i, a) => a.indexOf(v) === i);
		weight = collection.join();
		var url = '?family=' + family + ':' + weight + '&subset=' + subset;
		return url;
	}
	
	function underscoreId(id){
		var underscore = id.replace(/_/g, '-');
		return underscore;
	}
	
	function hypenId(id){
		var hypen = id.replace(/-/g, '_');
		return hypen;
	}
	
	// -- END HELPER FUNCTIONS -- //

	
	
	
	
	
	// -- WORDPRESS default -- //
	
	
	// Site title.
	api('blogname', function(value){
		value.bind(function(to){
			$('.site-title a').text(to);
		});
	});

	// Site tagline.
	api('blogdescription', function(value){
		value.bind(function(to){
			$('.site-description').text(to);
		});
	});	

	// Custom background
	api('background_image', function(value){
		value.bind(function(to){
			$('body').toggleClass('custom-background-image', '' !== to);
		});
	});
	
	// -- END WORDPRESS default -- //
	
	
	// Section preview visibility
	api('entex_theme_section_preview_visibility', function(value){
		value.bind(function(to){
			var cl = 'wp-is-section-preview';
			if(!to){
				$('body').removeClass(cl);
				if(debug) console.log('body class removed: ' + cl);
			} else {
				$('body').addClass(cl);
				if(debug) console.log('body class added: ' + cl);
			}
		});
	});
	
	function onLoadPreview(){
		var cl = 'wp-is-section-preview';
		var id = 'entex_theme_section_preview_visibility';
		var parent_control = parent_api.control.instance(id);
		var value = parent_control.setting.get();
		if(value){
			$('body').addClass(cl);
			if(debug) console.log('body class added: ' + cl);
		}
	}
	
	// Remove theme initial presentation CSS
	api('entex_theme_remove_wp_is_initial', function(value){
		value.bind(function(to){
			var cl = 'wp-is-initial';
			if(to){
				$('body').removeClass(cl);
				if(debug) console.log('body class removed: ' + cl);
			} else {
				$('body').addClass(cl);
				if(debug) console.log('body class added: ' + cl);
			}
		});
	});
	
	

	function extractTransport(A){
		var transport = {};
		transport.target = A['target'];
		transport.selector = A['selector'];
		transport.unit = A['unit'];
		transport.main = A['main'];
		transport.before = A['before'];
		transport.after = A['after'];
		transport.additional = A['additional'];
		transport.remove = A['remove'];
		transport.description = A['description'];
		transport.visibility = A['visibility'];
		transport.style = A['style'];
		transport.initial = A['initial'];
		transport.responsive = A['responsive'];
		transport.desktop = A['desktop'];
		return transport;
	}

	
	// -- PANELS ARRAY -- //

	if(ENTEX_Arr.length){
		for(i = 0; i < ENTEX_Arr.length; i++){
			
			console.log(ENTEX_Arr[i]['target']);
			if(ENTEX_Arr[i]['master'] == 'html'){
				entex_controllers_html(extractTransport(ENTEX_Arr[i]));
			}
			if(ENTEX_Arr[i]['master'] == 'body'){
				entex_controllers_body(extractTransport(ENTEX_Arr[i]));
			}
			if(ENTEX_Arr[i]['master'] == 'typo'){
				entex_controllers_typo(extractTransport(ENTEX_Arr[i]));			
			}
			if(ENTEX_Arr[i]['master'] == 'layout'){
				entex_controllers_layout(extractTransport(ENTEX_Arr[i]));
			}
		}
		removeLoader();
		onLoadPreview();
		init_detachTypo();
	}
	
	// -- BY FILTER OR ACTIONS -- //
	
	function entex_actions_layout(data){
		
		// NOTE: Those can only be executed from layout panel action hook
		// All targets are visiting here, make shure you use conditionals (if...)
		if(debug) console.log('Loading controllers for: ' + data.target + ' | FUNCTION: entex_actions_layout()');
		
		var target = data.target;
		var selector = data.selector;
		var this_selector = '';
		
		/* margin-top */ // - might use 'main' array - temporary use another selector for spcific property
		//if(!data.remove.match('margin_top')) entex_controller(target, 'entex_theme_layout_' + target + '_margin_top', selector, 'margin-top', 'em', '', '', data.style, data);
		
		/* margin-bottom */ 
		/* margin (DESKTOP) visibility */
		// DESKTOP ONLY
		if(!data.remove.match('margin_bottom_desktop')){
			entex_controller(target, 'entex_theme_layout_' + target + '_margin_bottom_desktop', selector, 'margin-bottom', 'em', '', '', data.desktop, data);
		}
		
		if(target == 'socle'){ 
			/* toggle classname .ua-set-invert */
			entex_controller_classname(target, 'entex_theme_layout_' + target + '_set_invert', selector, '', '', 'ua-set-invert', '', data.style, data);
		}

		if(target == 'navigation'){
			/* link deviders all margin-top */ // - might use 'main' array
			entex_controller(target, 'entex_theme_layout_' + target + '_margin_deviders_all_top', selector, 'margin-top', 'px', '', '', data.style, data);
		
			/* link all deviders color */
			// Special case, the color property is occupied by the selector, we cant use the main array to temporary change selector by property
			// As this controller is ment for link parent containers (navigations)
			// We force this target to always add the child selector hard-coded
			// However, if target is the global navigation, we must manually remove the right seconday manually
		
			if(target == 'navigation') this_selector = selector.replaceAll(',', ' .ua-menu-mix:not(.ua-grid-item-2 .ua-menu-mix) > ul > li:before,') + ' .ua-menu-mix:not(.ua-grid-item-2 .ua-menu-mix) > ul > li:before';
				else this_selector = selector.replaceAll(',', ' .ua-menu-mix > ul > li:before,') + ' .ua-menu-mix > ul > li:before';
			entex_controller(target, 'entex_theme_layout_' + target + '_foreground_deviders_all_color', this_selector, 'color', '', '', '', data.style, data);
		
			/* link deviders all display */ // - might use 'main' array
			entex_controller(target, 'entex_theme_layout_' + target + '_margin_deviders_all_display', selector, 'display', '', 'none', '', data.style, data);
		}
		
		data.device = '@media screen and (max-width: 979px) { [selector] { [property] : [value][unit] } } ';
		
		if(target == 'header_column'){
			/* min-height */ 
			entex_controller(target, 'entex_theme_layout_' + target + '_min_height', selector, 'min-height', 'em', '', '', data.device, data);
		
			/* viewporter */
			/*
			entex_controller_viewport(target, 'entex_theme_layout_' + target + '_min_height_viewport', new Array(
				'entex_theme_layout_' + target + '_min_height'
			), data.device, data);
			*/
		}
		
		if(target == 'branding'){
			/* TARGET Header settings: grid-column / grid-row  */
			/* grid-column */ // - using additional ('#ua-id-header-content > div { grid-row: 1; }') and main ('grid-column' => '#ua-id-header-content > div')
			entex_controller(target, 'entex_theme_layout_' + target + '_header_settings_column', selector, 'grid-column', '', '1/4', '', data.style, data);
			
			/* viewporter */
			entex_controller_viewport(target, 'entex_theme_layout_' + target + '_header_settings_column_viewport', new Array(
				'entex_theme_layout_' + target + '_header_settings_column'
			), data.device, data);
			
			/* filter: invert() */ 
			this_selector = '#ua-nav-expander';
			if(!data.remove.match('filter_invert')) entex_controller(target, 'entex_theme_layout_' + target + '_filter_invert', this_selector, 'filter', '', 'invert()', '', data.style, data);
			
			/* opacity */ 
			this_selector = '#ua-nav-expander';
			entex_controller(target, 'entex_theme_layout_' + target + '_opacity', this_selector, 'opacity', '', '', '', data.style, data);
			
			/* opacity */ // - special case when column appear as layer above backgrounds on none desktop screens
			this_selector = '#ua-id-header-column';
			entex_controller(target, 'entex_theme_layout_' + target + '_device_opacity', this_selector, 'opacity', '', '', '', data.device, data);
		}
	}
	
	function entex_actions_typo(data){
		
		// NOTE: Those can only be executed from typo panel action hook
		if(debug) console.log('Loading controllers for: ' + data.target + ' | FUNCTION: entex_actions_typo()');
		
		var target = data.target;
		var selector = data.selector;
		var this_selector = '';
		var add = '';
		
		if(target.match('nav_link') || target == 'h4_layout'){
			/* padding-right padding-left */
			entex_controller(target, 'entex_theme_typo_' + target + '_padding_right', selector, 'padding-right', 'em', '', '', data.style, data);
			entex_controller(target, 'entex_theme_typo_' + target + '_padding_left', selector, 'padding-left', 'em', '', '', data.style, data);
		}
		
		if(!target.match('nav_link')) return;
		
		/* background color */ // - typo - 
		entex_controller(target, 'entex_theme_typo_' + target + '_background_color_value', selector, 'background-color', '', '', '', data.style, data);
		
		/* border-top border-bottom */ // - typo - 
		entex_controller(target, 'entex_theme_typo_' + target + '_border_top_width', selector, 'border-top-width', 'px', '', '', data.style, data);
		entex_controller(target, 'entex_theme_typo_' + target + '_border_bottom_width', selector, 'border-bottom-width', 'px', '', '', data.style, data);
		
		/* border color */ // - typo - 
		entex_controller(target, 'entex_theme_typo_' + target + '_border_color_value', selector, 'border-color', '', '', '', data.style, data);
		
		/* devider visibility */ // - typo - 
		this_selector = selector.replaceAll(' > a', ':before');
		if(!data.remove.match('devider_visibility')) entex_controller(target, 'entex_theme_typo_' + target + '_devider_visibility', this_selector, 'visibility', '', 'hidden', '', data.style, data);
		
		/* devider display */ // - typo - 
		this_selector = selector.replaceAll(' > a', ':before');
		if(!data.remove.match('devider_display')) entex_controller(target, 'entex_theme_typo_' + target + '_devider_display', this_selector, 'display', '', 'none', '', data.style, data);
		
		/* filter: invert() */ 
		this_selector = selector.replaceAll('ul > li > a', 'ul > li > a:before');
		if(!data.remove.match('filter_invert')) entex_controller(target, 'entex_theme_typo_' + target + '_filter_invert', this_selector, 'filter', '', 'invert()', '', data.style, data);
		
		
		// HOVER
		
		/* color hover */
		this_selector = create_this_selector(selector, ':hover');
		entex_controller(target, 'entex_theme_typo_' + target + '_foreground_hover_color', this_selector, 'color', '', '', '', data.style, data);
		
		/* background color hover */ // - typo - 
		this_selector = create_this_selector(selector, ':hover');
		entex_controller(target, 'entex_theme_typo_' + target + '_background_hover_color_value', this_selector, 'background-color', '', '', '', data.style, data);
		
		/* border color hover */ // - typo - 
		this_selector = create_this_selector(selector, ':hover');
		entex_controller(target, 'entex_theme_typo_' + target + '_border_hover_color_value', this_selector, 'border-color', '', '', '', data.style, data);
		
		/* text-shadow hover display */ 
		this_selector = create_this_selector(selector, ':hover');
		entex_controller(target, 'entex_theme_typo_' + target + '_text_shadow_hover_display', this_selector, 'text-shadow', '', 'none', '', data.style, data);
		
		/* devider hover visibility */ // - typo - 
		this_selector = create_this_selector(selector, ':hover:before');
		add = create_this_selector(selector, ':hover + li:before');
		this_selector = this_selector + ', ' + add;
		this_selector = this_selector.replaceAll(' > a', '');
		if(!data.remove.match('devider_hover_visibility')) entex_controller(target, 'entex_theme_typo_' + target + '_devider_hover_visibility', this_selector, 'visibility', '', 'hidden', '', data.style, data);
		
		/* filter: invert() */ 
		this_selector = selector.replaceAll('ul > li > a', 'ul > li:hover > a:before');
		if(!data.remove.match('filter_hover_invert')) entex_controller(target, 'entex_theme_typo_' + target + '_filter_hover_invert', this_selector, 'filter', '', 'invert()', '', data.style, data);
		
		
		// ACTIVE / SELECTED
		
		/* color active */ // using classname
		this_selector = create_this_selector(selector, '.selected');
		entex_controller(target, 'entex_theme_typo_' + target + '_foreground_active_color', this_selector, 'color', '', '', '', data.style, data);
		
		/* background color active */ // - typo - 
		this_selector = create_this_selector(selector, '.selected');
		entex_controller(target, 'entex_theme_typo_' + target + '_background_active_color_value', this_selector, 'background-color', '', '', '', data.style, data);
		
		/* border color active */ // - typo - 
		this_selector = create_this_selector(selector, '.selected');
		entex_controller(target, 'entex_theme_typo_' + target + '_border_active_color_value', this_selector, 'border-color', '', '', '', data.style, data);
		
		/* font-weight active */ 
		this_selector = create_this_selector(selector, '.selected');
		entex_controller(target, 'entex_theme_typo_' + target + '_font_weight_choices', this_selector, 'font-weight', '', '', '', data.style, data);
		
		/* text-shadow active display */ 
		this_selector = create_this_selector(selector, '.selected');
		entex_controller(target, 'entex_theme_typo_' + target + '_text_shadow_active_display', this_selector, 'text-shadow', '', 'none', '', data.style, data);
		
		/* devider active visibility */ // - typo - 
		this_selector = create_this_selector(selector, '.selected:before');
		add = create_this_selector(selector, '.selected + li:before');
		this_selector = this_selector + ', ' + add;
		this_selector = this_selector.replaceAll(' > a', '');
		if(!data.remove.match('devider_active_visibility')) entex_controller(target, 'entex_theme_typo_' + target + '_devider_active_visibility', this_selector, 'visibility', '', 'hidden', '', data.style, data);
		
		/* filter: invert() */ 
		this_selector = selector.replaceAll('ul > li > a', 'ul > li.selected > a:before');
		if(!data.remove.match('filter_active_invert')) entex_controller(target, 'entex_theme_typo_' + target + '_filter_active_invert', this_selector, 'filter', '', 'invert()', '', data.style, data);
		
		/* padding removal right left */
		if(!data.remove.match('_padding_removal_')) entex_controller(target, 'entex_theme_typo_' + target + '_padding_removal_right', selector.replaceAll('li > a', 'li:last-child > a'), 'padding-right', '', '0px', '', data.style, data);
		if(!data.remove.match('_padding_removal_')) entex_controller(target, 'entex_theme_typo_' + target + '_padding_removal_left', selector.replaceAll('li > a', 'li:first-child > a'), 'padding-left', '', '0px', '', data.style, data);
		
		/* min-width */ // - layout -
		if(!data.remove.match('min_width')) entex_controller(target, 'entex_theme_layout_' + target + '_min_width', selector, 'min-width', 'em', '', '', data.style, data);
		
		
		
		
	}
	
	/* helper */
	function create_this_selector(selector, intercept){
		var menulink = false;
		if(selector.match('ul > li > a')) menulink = true;
		var multiple = false;
		if(selector.match(',')) multiple = true;

		if(menulink) selector = selector.replaceAll('ul > li > a', 'ul > li');
		if(multiple) selector = selector.replaceAll(',', intercept + ',') + intercept;
			else selector = selector.replaceAll(',', intercept + ',') + intercept;
		if(menulink) selector = selector.replaceAll(intercept, intercept + ' > a');
		return selector;
	}
	
	
	
	// -- BACKGROUNDS -- //
	
	function entex_backgrounds(data){
		
		if(debug) console.log('Loading controllers for: ' + data.target + ' | FUNCTION: entex_backgrounds()');
		
		var target = data.target;
		var selector = data.selector;
		var multiple = '';
		if(selector.match(',')){
			multiple = selector;
		}
		
		var controllers = new Array();

		if(data.before) controllers.push('_before');
		if(data.after) controllers.push('_after');
		if(!controllers.length) return;

		for(n = 0; n < controllers.length; n++){
			
			add_id = controllers[n];
			if(controllers[n] == '_before') pseudo = ':before';
			if(controllers[n] == '_after') pseudo = ':after';
			
			if(multiple) selector = multiple.replaceAll(',', pseudo + ',');
			
			if(debug) console.log('Loop: ' + n + ' | ADD ID = ' + add_id + ' | PSEUDO = ' + pseudo);
			if(n >= 10) break;
			
		
			/* (pseudo) Adding z-index removes transparent background order - if exists in stylesheet */
			if(!data.remove.match('_z_index_background')) entex_controller(target, 'entex_theme_layout_' + target +  add_id + '_z_index_background', selector + pseudo, 'z-index', '', 'auto', '', data.style, data);
			
			/* (pseudo) background color */
			entex_controller(target, 'entex_theme_layout_' + target +  add_id + '_background_color_pseudo', selector + pseudo, 'background-color', '', '', '', data.style, data);
		
			/* (pseudo) background image */
			entex_controller(target, 'entex_theme_layout_' + target +  add_id + '_background_image_pseudo', selector + pseudo, 'background-image', '', '', '', data.style, data);
		
			/* (pseudo) background image visibility */
			entex_controller(target, 'entex_theme_layout_' + target +  add_id + '_background_image_visibility', selector + pseudo, 'background-image', '', 'none !important', '', data.style, data);

			/* (pseudo) background image position */
			entex_controller(target, 'entex_theme_layout_' + target +  add_id + '_background_image_position_choices', selector + pseudo, 'background-position', '', '', '', data.style, data);
		
			/* (pseudo) background image position pixels - UNIT ADDED IN VALIDATION */
			entex_controller(target, 'entex_theme_layout_' + target +  add_id + '_background_image_position_value_pixels', selector + pseudo, 'background-position', '', '', '', data.style, data);
		
			/* (pseudo) background image position top percent */
			entex_controller(target, 'entex_theme_layout_' + target +  add_id + '_background_image_position_value_percent_top', selector + pseudo, 'background-position', '', '', '', data.style, data);
		
			/* (pseudo) background image position left percent - UNIT ADDED IN VALIDATION */
			entex_controller(target, 'entex_theme_layout_' + target +  add_id + '_background_image_position_value_percent_left', selector + pseudo, 'background-position', '', '', '', data.style, data);
			
			/* (pseudo) background image size */
			entex_controller(target, 'entex_theme_layout_' + target +  add_id + '_background_image_size', selector + pseudo, 'background-size', '', '', '', data.style, data);
		
			/* (pseudo) background image repeat */
			entex_controller(target, 'entex_theme_layout_' + target +  add_id + '_background_image_repeat', selector + pseudo, 'background-repeat', '', '', '', data.style, data);
			
			/* (pseudo) background image opacity */
			entex_controller(target, 'entex_theme_layout_' + target +  add_id + '_background_opacity', selector + pseudo, 'opacity', '', '', '', data.style, data);
		
			/* (pseudo) background image filter grayscale */
			entex_controller(target, 'entex_theme_layout_' + target +  add_id + '_background_filter_grayscale', selector + pseudo, 'filter', 'grayscale([to])', '', '', data.style, data);
		
			/* viewporter */
			if(!data.remove.match('background_viewport')){
			entex_controller_viewport(target, 'entex_theme_layout_' + target + add_id + '_background_viewport', new Array(
				'entex_theme_layout_' + target +  add_id + '_z_index_background',
				'entex_theme_layout_' + target +  add_id + '_background_color_pseudo', 
				'entex_theme_layout_' + target +  add_id + '_background_image_pseudo',
				'entex_theme_layout_' + target +  add_id + '_background_image_visibility',
				'entex_theme_layout_' + target +  add_id + '_background_image_position',
				'entex_theme_layout_' + target +  add_id + '_background_image_position_value_pixels',
				'entex_theme_layout_' + target +  add_id + '_background_image_position_value_percent_top',
				'entex_theme_layout_' + target +  add_id + '_background_image_position_value_percent_left',
				'entex_theme_layout_' + target +  add_id + '_background_image_size',
				'entex_theme_layout_' + target +  add_id + '_background_image_repeat',
				'entex_theme_layout_' + target +  add_id + '_background_opacity',
				'entex_theme_layout_' + target +  add_id + '_background_filter_grayscale'
			
			), (controllers[n] == '_after' ? data.desktop : data.responsive), data);
			}
		
		}
		
	}
	
	
	
	
	
	// -- PANEL HTML -- //
	
	function entex_controllers_html(data){
		
		if(debug) console.log('Loading controllers for: ' + data.target + ' | FUNCTION: entex_controllers_html()');
		
		/* cant handle rem with range controllers */
		/* Use px and convert to rem on PHP save, as customizer doesnt need rem anyway */
		if(data.unit == 'rem') data.unit = 'px';
		var target = data.target;
		
		/* html root font-size (px) */
		entex_controller(target, 'entex_theme_typo_' + target + '_root_size', 'html', 'font-size', 'px', '', '', data.style, data);
	
		/* html font-family (font control) */
	
		api('entex_theme_' + target + '_font_control', function(value){
			var id = 'entex_theme_' + target + '_font_control';
			value.bind(function(to){
				var target = 'html';
				var selector = 'html';
				var selector_bold = bolds; 
				var property = 'font-family';
				var styleId = underscoreId(id);
				var placeholder = data.style;
				var linkId = 'LINK-' + styleId;
				var url = '';
				var weight = '';
				var bold = '';
				if(to){
					var Arr = parseTo(to);
					if(debug) console.log(Arr);
					var family = Arr['font'];
					weight = Arr['regularweight'];
					bold = Arr['boldweight'];
					to = family;
					if(to){
						url = parseUrl(Arr);
					}
				}
				add_link(linkId, url);
				if(to) add_style(target, styleId, selector, property, to, '', placeholder, data);
					else remove_style(styleId);
				if(weight) add_style(target, styleId + '-weight', selector, 'font-weight', weight, '', placeholder, data);
					else remove_style(styleId + '-weight');
				if(bold) add_style(target, styleId + '-bold', selector_bold, 'font-weight', bold, '', placeholder, data);
					else remove_style(styleId + '-bold');
			});
		});
		
		/* html color */
		entex_controller(target, 'entex_theme_typo_' + target + '_root_color', 'html', 'color', '', '', '', data.style, data);
	
		/* text color */
		entex_controller(target, 'entex_theme_typo_' + target + '_paragraph_color', 'p', 'color', '', '', '', data.style, data);
	
	
		// -- BODY -- //
		
		/* (body) font-size (rem -> px) */ // Selector is only a reference object here, true selectors added in placeholder
		entex_controller(target, 'entex_theme_typo_' + target + '_font_size_initial', '.ua-not-main', 'font-size', 'px', '', '', data.initial, data);

		/* (body) line-height (number) */ 
		entex_controller_calculated(target, 'entex_theme_typo_' + target + '_line_height_initial', '.ua-not-main', 'line-height', '', '', '', data.initial, data);
		
		/* (body) font-size (rem -> px) */
		entex_controller(target, 'entex_theme_typo_' + target + '_font_size_main', '.ua-main', 'font-size', 'px', '', '', data.responsive + data.desktop, data);
	
		/* (body) line-height (number) */
		entex_controller_calculated(target, 'entex_theme_typo_' + target + '_line_height_main', '.ua-main', 'line-height', '', '', '', data.responsive + data.desktop, data);
	

	}

	// -- TYPO -- //
	
	function entex_controllers_typo(data){
		
		if(debug) console.log('Loading controllers for: ' + data.target + ' | FUNCTION: entex_controllers_typo()');
		
		/* cant handle rem with range controllers */
		/* Use px and convert to rem on PHP save, as customizer doesnt need rem anyway */
		if(data.unit == 'rem') data.unit = 'px';
		
		var clamp = false;
		if(data.unit == 'clamp') clamp = true;
		if(clamp) data.unit = '';
		var target = data.target;
		var selector = data.selector;
		var unit = data.unit;
		
		entex_actions_typo(data);

		/* font-family (font control) */
		entex_controller_font(target, 'entex_theme_' + target + '_font_control', selector, '', '', '', '', data.style, data);

		/* text-transform */
		entex_controller(target, 'entex_theme_typo_' + target + '_text_transform_choices', selector, 'text-transform', '', '', '', data.style, data);
		
		/* text-align */
		if(!data.remove.match('text_align')) entex_controller(target, 'entex_theme_typo_' + target + '_text_align_choices', selector, 'text-align', '', '', '', data.style, data);
		
		/* letter-spacing */
		entex_controller(target, 'entex_theme_typo_' + target + '_letter_spacing_choices', selector, 'letter-spacing', 'em', '', '', data.style, data);
		
		if(clamp){
			
			/* font-size clamp (clamp control) */
			entex_controller_clamp(target, 'entex_theme_typo_' + target + '_font_size_clamp', selector, 'font-size', 'px', 'vw', 'px', data.style, data);
			
		} else {
		
			/* font-size initial (mobile) */
			if(!data.remove.match('font_size_initial')) entex_controller(target, 'entex_theme_typo_' + target + '_font_size_initial', selector, 'font-size', data.unit, '', '', data.initial, data);
			
		}
		
		/* line-height initial */
		if(!data.remove.match('line_height_initial')) entex_controller_calculated(target, 'entex_theme_typo_' + target + '_line_height_initial', selector, 'line-height', data.unit, '', '', (clamp ? data.style : data.initial), data);
		
		if(!clamp){
			
			/* font-size main */
			if(!data.remove.match('font_size_main')) entex_controller(target, 'entex_theme_typo_' + target + '_font_size_main', selector, 'font-size', data.unit, '', '', data.responsive + data.desktop, data);
		
			/* line-height main */
			if(!data.remove.match('line_height_main')) entex_controller_calculated(target, 'entex_theme_typo_' + target + '_line_height_main', selector, 'line-height', data.unit, '', '', data.responsive + data.desktop, data);
		
		}
		
		/* padding-top padding-bottom */
		if(!data.remove.match('padding_top')) entex_controller(target, 'entex_theme_typo_' + target + '_padding_top', selector, 'padding-top', 'em', '', '', data.style, data);
		if(!data.remove.match('padding_bottom')) entex_controller(target, 'entex_theme_typo_' + target + '_padding_bottom', selector, 'padding-bottom', 'em', '', '', data.style, data);
		
		if(!data.remove.match('__color__')){
			
			/* color */
			entex_controller(target, 'entex_theme_typo_' + target + '_foreground_color', selector, 'color', '', '', '', data.style, data);
		
			/* text-shadow */
			entex_controller(target, 'entex_theme_typo_' + target + '_foreground_text_shadow_color', selector, 'text-shadow', ' 0px 1px 1px', '', '', data.style, data);
		}
		
		
		/* Extended display */
		if(!data.remove.match('extended_display')){
			entex_controller(target, 'entex_theme_typo_' + target + '_extended_display_choices', selector, 'display', '', '', '', data.style, data);
		
			/* viewporter */
			entex_controller_viewport(target, 'entex_theme_typo_' + target + '_extended_display_viewport', new Array(
				'entex_theme_typo_' + target + '_extended_display_choices'
			), data.initial, data);
		}

	}
	

	
	// -- PANEL LAYOUT -- //

	function entex_controllers_layout(data){

		if(debug) console.log('Loading controllers for: ' + data.target + ' | FUNCTION: entex_controllers_layout()');
		
		/* cant handle rem with range controllers */
		/* Use px and convert to rem on PHP save, as customizer doesnt need rem anyway */
		if(data.unit == 'rem') data.unit = 'px';
		
		var target = data.target;
		var selector = data.selector;
		
		entex_actions_layout(data);
		
		// START
		
		/* width clamp (clamp control) */
		if(!data.remove.match('width_clamp')) entex_controller_clamp(target, 'entex_theme_layout_' + target + '_width_clamp', selector, 'width', 'px', 'vw', 'px', data.style, data);
		
		/* background color */
		entex_controller(target, 'entex_theme_layout_' + target + '_background_color_value', selector, 'background-color', '', '', '', data.style, data);
		
		/* background color transparent */
		entex_controller(target, 'entex_theme_layout_' + target + '_background_color_transparent', selector, 'background-color', '', 'transparent', '', data.style, data);
		
		/* foreground color */
		if(!data.remove.match('foreground_layout_color')) entex_controller(target, 'entex_theme_layout_' + target + '_foreground_color', selector, 'color', '', '', '', data.style, data);
		
		/* foreground text-shadow color */
		if(!data.remove.match('foreground_layout_text_shadow_color')) entex_controller(target, 'entex_theme_layout_' + target + '_foreground_text_shadow_color', selector, 'text-shadow', ' 0px 1px 1px', '', '', data.style, data);
		
		/* line-height */
		if(!data.remove.match('line_height_layout')) entex_controller_calculated(target, 'entex_theme_layout_' + target + '_line_height', selector, 'line-height', '', '', '', data.style, data);
		
		entex_backgrounds(data);
		
		/* Miscellaneous */
		
		/* center content - text-align */
		if(!data.remove.match('center_content')) entex_controller(target, 'entex_theme_layout_' + target + '_center_content', selector, 'text-align', '', 'center', '', data.style, data);
		
		/* box-shadow visibility */
		if(!data.remove.match('box_shadow_visibility')) entex_controller(target, 'entex_theme_layout_' + target + '_box_shadow_visibility', selector, 'box-shadow', '', 'none', '', data.style, data);
		
		/* margin (ALL) visibility */ 
		if(!data.remove.match('margin_all_visibility')) entex_controller(target, 'entex_theme_layout_' + target + '_margin_all_visibility', selector, 'margin', '', '0px', '', data.style, data);
		
		/* margin (MOBILE) visibility */ // (mobile only)
		if(!data.remove.match('margin_mobile_visibility')) entex_controller(target, 'entex_theme_layout_' + target + '_margin_mobile_visibility', selector, 'margin', '', '0px', '', data.initial, data);
		
		if(!data.remove.match('__border_layout__')){
			/* border visibility */
			entex_controller(target, 'entex_theme_layout_' + target + '_border_visibility', selector, 'border', '', 'none', '', data.style, data);
			
			/* border mobile visibility */
			if(!data.remove.match('border_mobile_visibility')) entex_controller(target, 'entex_theme_layout_' + target + '_border_mobile_visibility', selector, 'border', '', 'none', '', data.initial, data);
		
			/* border (ALL) */
			if(!data.remove.match('border_all_width')) entex_controller(target, 'entex_theme_layout_' + target + '_border_all_width', selector, 'border-width', 'px', '', '', data.style, data);
			if(!data.remove.match('border_all_color')) entex_controller(target, 'entex_theme_layout_' + target + '_border_all_color', selector, 'border-color', '', '', '', data.style, data);
		
			/* border-top border-bottom */
			entex_controller(target, 'entex_theme_layout_' + target + '_border_top_width', selector, 'border-top-width', 'px', '', '', data.style, data);
			entex_controller(target, 'entex_theme_layout_' + target + '_border_top_color', selector, 'border-top-color', '', '', '', data.style, data);
			entex_controller(target, 'entex_theme_layout_' + target + '_border_bottom_width', selector, 'border-bottom-width', 'px', '', '', data.style, data);
			entex_controller(target, 'entex_theme_layout_' + target + '_border_bottom_color', selector, 'border-bottom-color', '', '', '', data.style, data);
		}
		
		// PADDING
		if(!data.remove.match('__padding_layout__')){
			/* viewporter */
			if(!data.remove.match('padding_viewport')){
			entex_controller_viewport(target, 'entex_theme_layout_' + target + '_padding_viewport', new Array(
				'entex_theme_layout_' + target + '_padding_all',
				'entex_theme_layout_' + target + '_padding_top', 
				'entex_theme_layout_' + target + '_padding_bottom'
			), data.responsive, data);
			}
			
			/* Padding (ALL) */ // PX
			if(!data.remove.match('padding_all')) entex_controller(target, 'entex_theme_layout_' + target + '_padding_all', selector, 'padding', 'px', '', '', data.style, data);
		
			/* Padding TOP | BOTTOM */ // EM
			if(!data.remove.match('padding_top')) entex_controller(target, 'entex_theme_layout_' + target + '_padding_top', selector, 'padding-top', 'em', '', '', data.style, data);
			if(!data.remove.match('padding_bottom')) entex_controller(target, 'entex_theme_layout_' + target + '_padding_bottom', selector, 'padding-bottom', 'em', '', '', data.style, data);
		
		} // END if NOT padding
		
		/* padding clamp (clamp control) */
		if(!data.remove.match('padding_clamp')) entex_controller_clamp(target, 'entex_theme_layout_' + target + '_padding_clamp', selector, 'padding', 'px', 'vw', 'px', data.style, data);

	}

	// -- PANEL BODY -- //

	function entex_controllers_body(data){

		if(debug) console.log('Loading controllers for: ' + data.target  + ' | FUNCTION: entex_controllers_body()');
		
		if(data.unit == 'rem') data.unit = 'px';
		var target = data.target;
		var selector = data.selector;

	
		/* Sections box shadow visibility */
		entex_controller(target, 'entex_theme_layout_' + target + '_gridbox_box_shadow_visibility', '.ua-grid-box', 'box-shadow', '', 'none', '', data.desktop, data);
	
		/* Sections box background-color transparent */
		entex_controller(target, 'entex_theme_layout_' + target + '_gridbox_background_transparent', '.ua-grid-box', 'background-color', '', 'transparent', '', data.desktop, data);
	
		/* Sections box background-color */
		entex_controller(target, 'entex_theme_layout_' + target + '_gridbox_background_color', '.ua-grid-box', 'background-color', '', '', '', data.desktop, data);
		
		/* Sections root background-color (filter) */
		entex_controller(target, 'entex_theme_layout_' + target + '_root_background_filter', '.ua-root', 'background-color', '', '', '', data.style, data);
		
		
		/* background image visibility - WP default controller */ // Using !important
		entex_controller(target, 'entex_theme_layout_' + target + '_background_image_visibility', selector, 'background-image', '', 'none !important', '', data.style, data);
		
		/* background color transparent */ // Using !important
		entex_controller(target, 'entex_theme_layout_' + target + '_background_color_transparent', selector, 'background-color', '', 'transparent !important', '', data.style, data);

		entex_backgrounds(data);
	
		/* Padding TOP | BOTTOM */
		if(!data.remove.match('__padding__')){
			if(!data.remove.match('padding_top')) entex_controller(target, 'entex_theme_layout_' + target + '_padding_top', selector, 'padding-top', 'px', '', '', data.desktop, data);
			if(!data.remove.match('padding_bottom')) entex_controller(target, 'entex_theme_layout_' + target + '_padding_bottom', selector, 'padding-bottom', 'px', '', '', data.desktop, data);
		}
	}
	

	
	
	// -- CONTROLLER FUNCTIONS -- //
	
	function entex_controller_classname(target, id, selector, property, value_unit, value_true, value_false, placeholder, data){
		
		api(id, function(value){
			value.bind(function(to){
				if(to){
					$(selector).addClass(value_true);
					if(debug) console.log('Classname: ' + value_true + ' ADDED TO : ' + selector);
				} else {
					$(selector).removeClass(value_true);
					if(debug) console.log('Classname: ' + value_true + ' REMOVED FROM : ' + selector);
				}
			});
		});
	}
	
	function entex_controller_viewport(target, id, ids, placeholder, data){
		
		/* initiate body data onload */
		var parent_control = parent_api.control.instance(id);
		var init = parent_control.setting.get();
		if(init){
			$.each(ids, function(i, cid){
				$('body').data(cid + '-placeholder', placeholder);
			});
		}
		
		api(id, function(value){
			value.bind(function(to){
				if(to){
					$.each(ids, function(i, cid){
						$('body').data(cid + '-placeholder', placeholder);
						runController(cid);
					});
				} else {
					$.each(ids, function(i, cid){
						$('body').data(cid + '-placeholder', '');
						runController(cid);
					});
				}
			});
		});
	}
	
	
	function entex_controller(target, id, selector, property, value_unit, value_true, value_false, value_placeholder, data){
		
		if(debug) console.log('T: ' + target + ' | ID: ' + id + ' | SEL: ' + selector + ' | PROP: ' + property + ' | UNIT: ' + value_unit + ' | VTRUE: ' + value_true + ' | VFALSE: ' + value_false);
		if(debug) console.log('Placeholder: ' + value_placeholder);

		bindTitleClick(target, id, selector, property, value_unit, value_placeholder, data);
		//var check = disableController(id, selector, main);
		var wr = getNotification(id);
		
		api(id, function(value){
			var monitor = getMonitor(id);
			value.bind(function(to){
				
				var unit = value_unit;
				var placeholder = value_placeholder;
				if($('body').data(id + '-placeholder')) placeholder = $('body').data(id + '-placeholder');
				
				var error = validateViewportElement(selector, placeholder, data);
				if(error) setNotification(id, wr, error, 'warning');
					else removeNotification(id, wr);

				var def = '';
				if(monitor){
					if(to < 0) def = 'Theme default';
					$(monitor).text(def);
				}
				to = validate_controller(to, target, id, selector, property, unit);
				if(to == 'inherit') unit = '';
				if(to && unit.match('[to]')){
					to = unit.replace(/\[to\]/g, to);
					unit = '';
				}
				
				if(to != 'inherit'){
					if(to){
						if(to != 'zero'){
							if(value_true){
								to = value_true;
								unit = '';
							}
						}
					} else {
						if(value_false){
							to = value_false;
							unit = '';
						}
					}
				}
				
				var styleId = underscoreId(id);
				if(to) add_style(target, styleId, selector, property, to, unit, placeholder, data);
					else remove_style(styleId);
				
			});
		});
	}
	
	
	
	function entex_controller_clamp(target, id, selector, property, min, scale, max, placeholder, data){

		if(debug) console.log('T: ' + target + ' | ID: ' + id + ' | SEL: ' + selector + ' | PROP: ' + property + ' | UNITS: ' + min + ' | ' + scale + ' |  ' + max);
		if(debug) console.log('Placeholder: ' + placeholder);

		var clamp = id;
		var clamp_1 = id + '_1';
		var clamp_2 = id + '_2';
		var clamp_3 = id + '_3';
		
		bindTitleClick(target, clamp_1, selector, property, min, placeholder, data);
		bindTitleClick(target, clamp_2, selector, property, scale, placeholder, data);
		bindTitleClick(target, clamp_3, selector, property, max, placeholder, data);

		api(clamp_1, function(value){
			var parent_control = parent_api.control.instance(clamp);
			var parent_control_1 = parent_api.control.instance(clamp_1);
			var parent_control_2 = parent_api.control.instance(clamp_2);
			var parent_control_3 = parent_api.control.instance(clamp_3);
			value.bind(function(to){
				
				var value_1 = to;
				var value_2 = parent_control_2.setting.get();
				var value_3 = parent_control_3.setting.get();

				var calculated = 'clamp(' + value_1 + min + ', ' + value_2 + scale + ', ' + value_3 + max + ')';
				if(!value_1 && !value_2 && !value_3) calculated = '';

				parent_control.setting.set('');
				if(calculated) parent_control.setting.set(calculated);
				
			});
		});
		api(clamp_2, function(value){
			var parent_control = parent_api.control.instance(clamp);
			var parent_control_1 = parent_api.control.instance(clamp_1);
			var parent_control_2 = parent_api.control.instance(clamp_2);
			var parent_control_3 = parent_api.control.instance(clamp_3);
			value.bind(function(to){
				
				var value_1 = parent_control_1.setting.get();
				var value_2 = to;
				var value_3 = parent_control_3.setting.get();

				var calculated = 'clamp(' + value_1 + min + ', ' + value_2 + scale + ', ' + value_3 + max + ')';
				if(!value_1 && !value_2 && !value_3) calculated = '';

				parent_control.setting.set('');
				if(calculated) parent_control.setting.set(calculated);
				
			});
		});
		api(clamp_3, function(value){
			var parent_control = parent_api.control.instance(clamp);
			var parent_control_1 = parent_api.control.instance(clamp_1);
			var parent_control_2 = parent_api.control.instance(clamp_2);
			var parent_control_3 = parent_api.control.instance(clamp_3);
			value.bind(function(to){

				var value_1 = parent_control_1.setting.get();
				var value_2 = parent_control_2.setting.get();
				var value_3 = to;
				
				var calculated = 'clamp(' + value_1 + min + ', ' + value_2 + scale + ', ' + value_3 + max + ')';
				if(!value_1 && !value_2 && !value_3) calculated = '';

				parent_control.setting.set('');
				if(calculated) parent_control.setting.set(calculated);
				
			});
		});

		api(id, function(value){
			var monitor = getMonitor(id);
			value.bind(function(to){
				
				if(debug) console.log('Controller clamp in use, NO VAILIDATION IS USED for speed and performance');
				var styleId = underscoreId(id);
				
				if(to) add_style(target, styleId, selector, property, to, '', placeholder, data);
					else remove_style(styleId);
			});
		});
	}
	
	
	function entex_controller_calculated(target, id, selector, property, value_unit, value_true, value_false, placeholder, data){

		if(debug) console.log('T: ' + target + ' | ID: ' + id + ' | SEL: ' + selector + ' | PROP: ' + property + ' | UNIT: ' + value_unit + ' | VTRUE: ' + value_true + ' | VFALSE: ' + value_false);
		if(debug) console.log('Placeholder: ' + placeholder);
		
		

		bindTitleClick(target, id, selector, property, value_unit, placeholder, data);
		//var check = disableController(id, selector, main);
		var wr = getNotification(id);
		
		/* special case for html panel */
		//if(main && selector == 'html > body') selector = '.ua-main';
		
		var calculated_id = id + '_calculated';

		api(id, function(value){
			var parent_control = parent_api.control.instance(calculated_id);
			value.bind(function(to){
				
				if(placeholder.match('.ua-main') && selector != '.ua-main') var main = true;
					else var main = false;
			
				if(debug) console.log('Controller GHOST calculated in use');
				var error = validateViewportElement(selector, placeholder, data);
				if(error) setNotification(id, wr, error, 'warning');
					else removeNotification(id, wr);

				if(to > 72) {
					parent_control.setting.set('inherit');
					return;
				}
				
				if(to < 0.1) to = 0;
				var calculated = 0;
				var el = null;
				
				if(to){
					
					if(debug){
						if(!main) console.log('Selector is main: NO');
							else console.log('Selector is main: YES');
					}
					
					/* hack */
					if(selector.match(':first-letter')){
						
						var sel = removePseudo(selector);
						if(!main) el = $(sel + ':not(.ua-main ' + sel + ')').get(0);
							else el = $('.ua-main ' + sel).get(0);
						if(el) var size = parseFloat(window.getComputedStyle(el, ':first-letter').getPropertyValue('font-size'));

					} else {
						if(!main) var size = getElementFontSize($(selector + ':not(.ua-main ' + selector + ')').get(0));
							else var size = getElementFontSize($('.ua-main ' + selector).get(0));
					}
					
					if(debug){
						console.log('Parsed element ' + selector + ' font-size as: ' + size);
						if(size && !el){
							console.log('Preview added');
							if(!main) runPreview($(selector + ':not(.ua-main ' + selector + ')').get(0));
								else runPreview($('.ua-main ' + selector).get(0));
						} else console.log('Size not found in calculated context');
					}
					
					if(!size){
						size = this_def_font_size_num;
						alert('Element not found on current page, calculation failed and default value will be used. Add the value manually inside text field below the range controller.');
					}
					if(debug){
						console.log('Controller value (to): ' + to + ' | calculated: ' + (to / size));
					}
					var calculated = (to / size);
				}
				parent_control.setting.set(calculated);
			});
		});
	
	
		/* calculated */
		// NOTE: This is a plain input text field - whatever value placed here will be used, no matter unit
		var calculated_wr = getNotification(calculated_id);
		
		api(calculated_id, function(value){
			var monitor_calculated = getMonitor(calculated_id);
			value.bind(function(to){
				
				if(placeholder.match('.ua-main') && selector != '.ua-main') var main = true;
					else var main = false;
				
				if(debug) console.log('Controller FINAL calculated in use');
				var error = validateViewportElement(selector, placeholder, data);
				if(error) setNotification(calculated_id, calculated_wr, error, 'error');
					else removeNotification(calculated_id, calculated_wr);
				if(error) return false;

				var inherit = '';
				if(to == 'inherit') inherit = 'inherit';
					else if(to < 0.1) to = 0;
				var styleId = underscoreId(calculated_id);
				var el;
				
				if(to){
					
					/* send RAW, no units */
					add_style(target, styleId, selector, property, to, '', placeholder, data);
					
					/* circut */
					if(!monitor_calculated) return;

					/* monitor only */
					/* we need the value (back) in pixels as the Ghost range controller */
					
					/* hack */
					if(selector.match(':first-letter')){
						var sel = removePseudo(selector);
						if(!main) el = $(sel + ':not(.ua-main ' + sel + ')').get(0);
							else el = $('.ua-main ' + sel).get(0);
						if(el) var size = parseFloat(window.getComputedStyle(el, ':first-letter').getPropertyValue('font-size'));

					} else {
						if(!main || selector == 'html > body') var size = getElementFontSize($(selector + ':not(.ua-main ' + selector + ')').get(0));
							else var size = getElementFontSize($('.ua-main ' + selector).get(0));
					}
					
					if(!size){
						console.log('Controller FINAL calculated NO SIZE FOUND - returning no monitor');
						return;
					} else {
						console.log('Controller FINAL calculated font-size: ' + size);
					}
						
					if(!inherit){
						$(monitor_calculated).text((Math.round(size * to)) + 'px');
						if(debug) console.log('Controller FINAL calculated target font-size: ' + size + ' | line-height monitored as (not rounded): ' + (size * to) + 'px');
					} else {
						/* hack */
						if(el){
							var pixels = parseFloat(window.getComputedStyle(el, ':first-letter').getPropertyValue('line-height'));
						} else {
							if(!main || selector == 'html > body') var pixels = getElementLineHeight($(selector + ':not(.ua-main ' + selector + ')').get(0));
								else var pixels = getElementLineHeight($('.ua-main ' + selector).get(0));
						}
						inherit = inherit + ' = ';
						$(monitor_calculated).text('inherit = ' + Math.round(pixels) + 'px');
						if(debug) console.log('Controller FINAL calculated target font-size: ' + size + ' | line-height monitored as (not rounded): ' + pixels + 'px');
					}
					
				} else {
					if(monitor_calculated) $(monitor_calculated).text('');
					remove_style(styleId);
				}
			});
		});
	}
	
	
	function entex_controller_font(target, id, selector, property, value_unit, value_true, value_false, placeholder, data){

		if(debug) console.log('T: ' + target + ' | ID: ' + id + ' | SEL: ' + selector + ' | PROP: ' + property + ' | UNIT: ' + value_unit + ' | VTRUE: ' + value_true + ' | VFALSE: ' + value_false);
		if(debug) console.log('Placeholder: ' + placeholder);
			
		//var check = disableController(id, selector, main);
		var wr = getNotification(id);
		
		api(id, function(value){
			var controller = getController(id);
			if(controller && $(controller).find('.entex-font-control-is-master').get(0)) var master = true;
				else var master = false;
			value.bind(function(to){
				
				var error = validateViewportElement(selector, placeholder, data);
				if(error) setNotification(id, wr, error, 'error');
					else removeNotification(id, wr);
			
				var styleId = underscoreId(id);
			
				var toFontFamily = '';
				var propertyFontFamily = 'font-family';
				var styleIdFontFamily = styleId + '-font-family';
			
				var toFontWeight = '';
				var propertyFontWeight = 'font-weight';
				var styleIdFontWeight = styleId + '-font-weight';
			
				var toFontStyle = '';
				var propertyFontStyle = 'font-style';
				var styleIdFontStyle = styleId + '-font-style';
			
				var linkId = 'LINK-' + styleId;
				var url = '';
			
				if(to){
					var Arr = parseTo(to);
					toFontFamily = Arr['font'];
					toFontWeight = Arr['regularweight'];
				
					if(toFontFamily) url = parseUrl(Arr);
						else toFontWeight = '';

					if(toFontWeight) {
						if(toFontWeight == 'regular'){
							toFontWeight = '400';
							toFontStyle = 'normal';
						} else if(toFontWeight == 'italic'){
							toFontWeight = '400';
							toFontStyle = 'italic';
						} else {
							if(toFontWeight.match('italic')){
								toFontWeight = toFontWeight.replace('italic', '');
								toFontStyle = 'italic';
							} else {
								toFontWeight = toFontWeight;
								toFontStyle = 'normal';
							}
						}
					}
				}

				add_link(linkId, url);
				if(toFontFamily) add_style(target, styleIdFontFamily, selector, propertyFontFamily, toFontFamily, '', placeholder, data);
					else remove_style(styleIdFontFamily);
				if(toFontWeight) add_style(target, styleIdFontWeight, selector, propertyFontWeight, toFontWeight, '', placeholder, data);
					else remove_style(styleIdFontWeight);
				if(toFontStyle) add_style(target, styleIdFontStyle, selector, propertyFontStyle, toFontStyle, '', placeholder, data);
					else remove_style(styleIdFontStyle);
			});
		});
	}
	
	
	function validate_controller(to, target, id, selector, property, unit){
		
		if(debug) console.log('validate controller value (to) : ' + to);
		
		if(property == 'filter'){
			if(to < 0){
				to = '';
			}
		}
		
		if(property == 'background-image'){
			if(to && to !== true) to = 'url(' + to + ')';
		}
		
		/* to = color value */
		// dep - use the unit 'variable'
		/*
		if(property == 'text-shadow'){
			if(to) to = to + ' 0px 1px 1px';
		}
		*/
		
		if(property == 'opacity'){
			if(target == 'branding'){
				if(to < 0.01) to = 0;
			} else {
				/* ToDo: maybe keep 1 (full opacity) as option */
				if(to == 1 || to < 0.01) to = 0;
			}
		}
		
		if(property == 'font-size'){
			if(selector == 'html'){
				/* remove if default browser size */
				if(to == 16) to = 0;
			} else {
				if(to > 120) to = 'inherit';
					else if(to < 0.1) to = 0;
			}
		}
		
		if(property == 'top' || property == 'right'){
			if(to == 0) to = 'zero';
				else if(to < 0 && target != 'logotext') to = 0;
		}
		
		if(property == 'line-height'){
			if(to < 0.1) to = 0;
		}
		
		if(property == 'letter-spacing'){
			if(to == 0) to = 'zero';
				else if(to < -0.10) to = 0;
		}
		
		if(property == 'width'){
			if(to < 0.1) to = 0;
		}
		
		if(property.match('padding')){
			if(id.match('_padding_removal_')){
				if(to) to = '0px';
			} else {
				if(to == 0) to = 'zero';
					else if(to < 0) to = 0;
			}
		}
		
		if(property == 'border-radius'){
			if(to == 0) to = 'zero';
				else if(to < 0) to = 0;
		}
		
		if(property == 'border-width'){
			if(to == 0) to = 'zero';
				else if(to < 0) to = 0;
		}
		
		if(property == 'border-top-width'){
			if(to == 0) to = 'zero';
				else if(to < 0) to = 0;
		}
		
		if(property == 'border-bottom-width'){
			if(to == 0) to = 'zero';
				else if(to < 0) to = 0;
		}
		
		if(property == 'margin'){
			if(to < 0.1) to = 0;
		}
		
		if(property == 'margin-top' || property == 'margin-bottom'){
			if(to == 0) to = 'zero';
				else if(to < 0) to = 0;
		}
		
		if(property == 'margin'){
			if(to && id.match('_devider_')){
				to = '0 ' + to + 'rem 0 ' + to + 'rem';
			}
		}
		
		if(property == 'background-position'){
			if(id.match('_value_pixels')){
				if(to < 1) to = 0;
					else to = to + 'px 0px';
			}
			if(id.match('value_percent_top')){
				if(to < 1) to = 0;
					else to = 'center ' + to +'%';
			}
			if(id.match('value_percent_left')){
				if(to < 1) to = 0;
					else to = to + '% 0%';
			}
		}
		
		if(debug) console.log('Passing validated value (to) : ' + to);
			
		return to;
	}
	
	if(warnings) alert(warnings);


})( jQuery );
