<?php if(!defined('ABSPATH')) die();
/**
 * ENTEX SPACE CONTROL
 * Entex customizer UI
 * Extended class WP_Customize_Control
 *
 * @package Entex
 * @subpackage Entex
 * @updated 2.0180629
 * 
 * Documentation: http://entex.info
 * Author: Jonas Lundman
 *
 */
 
/**
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
**/

if(class_exists('WP_Customize_Control')){
	class entex_customize_space_control extends WP_Customize_Control{
		
		public $type = 'space';

		public function __construct($manager, $id, $args = array()){
			parent::__construct( $manager, $id, $args );
			$defaults = array(
				'label' => '',
				'description' => '',
				'break' => false,
				'border' => 30,
				'height' => 0
			);
			
			$args = wp_parse_args($args, $defaults);
			
			$this->label = $args['label'];
			$this->description = $args['description'];
			$this->break = $args['break'];
			$this->border = absint($args['border']);
			$this->height = absint($args['height']);
		}

		public function render_content(){
			if($this->height) $_STYLE = ' style="line-height: '. esc_attr($this->height) .'px;"';
			if($this->break) echo wp_kses_post('<br'. $_STYLE .'>');
			if($this->border) echo '<div style="border-width: 0px 0px 1px 0px; border-style: dashed; height: '. esc_attr($this->border) .'px; margin-bottom: 0px;"></div>';
			if($this->label) echo '<label class="customize-control-title" style="font-size: 18px; margin-top: 6px;">'. esc_html($this->label) .'</label>';
			if($this->description) echo '<span class="customize-control-description" style="display: block;">'. esc_html($this->description) .'</span>';
		}
	}
}

// -- END FILE -- //