<?php if(!defined('ABSPATH')) die();
/**
 * ENTEX RANGE CONTROL
 * Entex customizer UI
 * Extended class WP_Customize_Control
 *
 * @package Entex
 * @subpackage Entex
 * @updated 2.0180629
 * 
 * Documentation: http://entex.info
 * Author: Jonas Lundman
 *
 */
 
/**
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
**/

if(class_exists('WP_Customize_Control')){
	class entex_customize_range_control extends WP_Customize_Control{
		
		public $type = 'range';

		public function __construct($manager, $id, $args = array()){
			parent::__construct( $manager, $id, $args );
			$defaults = array(
				'min' => 0,
				'max' => 1,
				'step' => 0.05,
				'description' => '',
				'break' => false,
				'ghost' => '',
				'calculated' => false,
				'monitor' => false
			);
			$args = wp_parse_args($args, $defaults);

			$this->min = $args['min'];
			$this->max = $args['max'];
			$this->step = $args['step'];
			$this->description = $args['description'];
			$this->break = $args['break'];
			$this->ghost = $args['ghost'];
			$this->calculated = $args['calculated'];
			$this->monitor = true;//$args['monitor'];
		}

		public function render_content(){
			if($this->break) echo '<br>';
			$calculated = '';
			if($this->monitor) $hidden = '';
				else $hidden = ' display: none;';  
			//$onchange = "jQuery(this).next().find('input').val((jQuery(this).val()) / 12).trigger('change');";
			?>
			<label>
				<?php if($this->calculated) : ?>
					<?php if($this->monitor) : ?>
						<span class="entex-customize-control-monitor-wr" style="display: block; position: relative;">
							<input type="text" <?php $this->link(); ?> value="<?php echo esc_attr( $this->value() ); ?>">
							<span class="entex-customize-control-monitor" style="position: absolute; bottom: 4px; right: 10px; color: #999;"></span>
						</span>
					<?php else : ?>
						<input type="text" <?php $this->link(); ?> value="<?php echo esc_attr( $this->value() ); ?>">
					<?php endif; ?>
				<?php else : ?>
					<span class="customize-control-title"><?php echo esc_html( $this->label ); ?><span style="float: right; font-weight: 400; font-size: 13px;">Saved: <?php echo esc_attr( $this->value() ); ?></span></span>
					<?php if($this->description) : ?>
						<span class="customize-control-description" style="display: block;"><?php echo esc_html( $this->description ); ?></span>
					<?php endif; ?>
					<?php if($this->ghost) : ?>
						<input class="range-slider entex-range-slider" min="<?php echo esc_attr($this->min) ?>" max="<?php echo esc_attr($this->max) ?>" step="<?php echo esc_attr($this->step) ?>" type="range" <?php $this->link(); ?> value="<?php echo esc_attr( $this->value() ); ?>">
					<?php else: ?>
						<input class="range-slider entex-range-slider" min="<?php echo esc_attr($this->min) ?>" max="<?php echo esc_attr($this->max) ?>" step="<?php echo esc_attr($this->step) ?>" type="range" <?php $this->link(); ?> value="<?php echo esc_attr( $this->value() ); ?>" oninput="jQuery(this).next().find('input').val( jQuery(this).val() )">
						<span class="entex-customize-control-monitor-wr" style="display: block; position: relative; margin-top: 5px;">
							<input onpaste="jQuery(this).parent().prev('input').val(jQuery(this).val()).trigger('change')" onkeyup="jQuery(this).parent().prev('input').val(jQuery(this).val()).trigger('change')" type="text" value="<?php echo esc_attr( $this->value() ); ?>">
							<?php if($this->monitor) : ?>
								<span class="entex-customize-control-monitor" style="position: absolute; bottom: 4px; right: 10px; color: #999;"></span>
							<?php endif; ?>
						</span>
					<?php endif; ?>
				<?php endif; ?>
			</label>
			<?php
		}
	}
}
 

 
// -- END FILE -- //