<?php if(!defined('ABSPATH')) die();
/**
 * ENTEX MEMORY CONTROL
 * Entex customizer UI
 * Extended class WP_Customize_Control
 *
 * @package Entex
 * @subpackage Entex
 * @updated 2.0191121
 * 
 * Documentation: https://entex.info
 * Author: Jonas Lundman
 *
 */
 
/**
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
**/

if(class_exists('WP_Customize_Control')){
	class entex_customize_memory_control extends WP_Customize_Control{
		
		public $type = 'memory';

		public function __construct($manager, $id, $args = array()){
			parent::__construct( $manager, $id, $args );
			$defaults = array(
				'label' => '',
				'description' => '',
				'import' => true,
				'master' => ''
			);
			
			$args = wp_parse_args($args, $defaults);
			
			$this->label = $args['label'];
			$this->description = $args['description'];
			$this->import = $args['import'];
			$this->master = $args['master'];
			if(!$this->master) $this->master = 'none';
		}

		public function render_content(){
			if($this->label) echo '<label class="customize-control-title entex-font-control-expandable">'. esc_html($this->label) .'</label>';
			if($this->description) echo '<span class="description customize-control-description entex-font-control-expandable">'. esc_html($this->description) .'</span>';
			?>
			<input type="text" class="entex-memory-control-data entex-memory-control-<?php echo esc_attr($this->master); ?> entex-font-control-expandable" data-memory-master="<?php echo esc_attr($this->master); ?>" id="<?php echo esc_attr($this->id); ?>" name="<?php echo esc_attr($this->id); ?>" value="<?php echo esc_attr($this->value()); ?>" <?php $this->link(); ?> />
			<?php
			echo '<div style="border-width: 0px 0px 1px 0px; border-style: dashed; height: 10px; margin-bottom: 20px;"></div>';
		}
	}
}

// -- END FILE -- //