<?php if(!defined('ABSPATH')) die();
/**
 * ENTEX FONT CONTROL
 * Entex customizer UI
 *
 * Extends WP_Customize_Control
 *
 * @package Entex
 * @subpackage Entex
 * @updated 2.0210511
 * 
 * Documentation: https://entex.info
 *
**/
 
/**
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
**/

if(class_exists('WP_Customize_Control')){
	class entex_customize_font_control extends WP_Customize_Control {

		public $type = 'google_fonts';
		private $fontMaster = true;
		private $fontMasterId = '';
		private $fontParentSelector = null;
		private $fontList = false;
		private $fontValues = [];
		private $fontListIndex = 0;
		private $fontCount = 0;
		private $fontOrderBy = 'alpha';
		
		public function __construct($manager, $id, $args = array(), $options = array()){
			
			parent::__construct( $manager, $id, $args );
			
			if(isset($args['master']) && $args['master'] === FALSE) $this->fontMaster = false;
			if(isset($args['master_id']) && $args['master_id']) $this->fontMasterId = $args['master_id'];
				else $this->fontMasterId = 'entex_theme_font_control_html';
				
			/* not in use for now */
			if(isset($args['parent_selector']) && !$args['parent_selector']) $this->fontParentSelector = '';
				else if(!isset($args['parent_selector'])) $this->fontParentSelector = '';
				
			if(isset($this->input_attrs['orderby']) && strtolower($this->input_attrs['orderby']) === 'popular') $this->fontOrderBy = 'popular';
				else if(!isset($this->input_attrs['orderby'])) $this->fontOrderBy = 'alpha';
				
			if(isset($this->input_attrs['font_count'])){
				if($this->input_attrs['font_count']){
					$this->fontCount = (abs((int) $this->input_attrs['font_count']) > 0 ? abs((int) $this->input_attrs['font_count'] ) : 0);
				}
			}
			$this->fontList = $this->getGoogleFonts('all');
			$this->fontValues = json_decode($this->value());
			$this->fontListIndex = $this->getFontIndex($this->fontList, $this->fontValues->font);

		}
		
		public function getSubsets(){
			$arr['all'] = 'All Subsets';
			foreach($this->fontList as $key => $value){
				foreach($value->subsets as $index => $name){
					$arr[$name] = str_replace('-', ' ', $name);
				}
			}
			asort($arr);
			return $arr;
		}
		
		public function getVariants(){
			$arr['all'] = 'All Variants';
			foreach($this->fontList as $key => $value){
				foreach($value->variants as $index => $name){
					
					if($name == 'regular'){
						$arr[$name] = '400 (regular)';
					} else if($name == 'italic'){
						$arr[$name] = '400 italic (regular italic)';
					} else {
						$arr[$name] = str_replace('italic', ' italic', $name);
					}
				}
			}
			asort($arr);
			return $arr;
		}
		
		public function control_wp_kses(){
	
			/* default */
			$allowed_tags = wp_kses_allowed_html('post');
			
			/* form elements */
			$allowed_tags['option'] = $allowed_tags['span'];
			$allowed_tags['option']['type'] = true;
			$allowed_tags['option']['name'] = true;
			$allowed_tags['option']['value'] = true;
			$allowed_tags['option']['checked'] = true;
			$allowed_tags['option']['disabled'] = true;
			$allowed_tags['option']['selected'] = true;
			$allowed_tags['option']['required'] = true;
			$allowed_tags['option']['placeholder'] = true;

			return $allowed_tags;
		}
		
		public function getCategories(){
			$arr['all'] = 'All Categories';
			foreach($this->fontList as $key => $value){
				$arr[$value->category] = $value->category;
			}
			return $arr;
		}
		
		public function getFilters(){
			$arr['1-all-'] = 'All Categories';
			$arr = array_merge($arr, $this->getCategories());
			$arr['3-all-'] = 'All Variants';
			$arr = $arr + $this->getVariants();
			unset($arr['all']);
			return $arr;
		}

		public function enqueue(){
			if(!function_exists('entex_ECROOT')) return;
			$path = 'extended/entex-control-font/assets/';
			wp_enqueue_script('entex-control-font', entex_ECROOT($path.'entex-control-font.js', true), array('jquery'), '', true);
			wp_enqueue_style('entex-control-font', entex_ECROOT($path.'entex-control-font.css', true));
		}

		public function to_json(){
			parent::to_json();
			$this->json['entexfontslist'] = $this->fontList;
		}

		public function render_content(){
			$fontCounter = 0;
			$isFontInList = false;
			$fontListStr = '';
			
			if(!function_exists('entex_ECROOT')){
				echo '<span class="customize-control-title">'. esc_html($this->label) .'</span>';
				echo '<p>Controller not implemented by Entex customizer UI. Files not found. Please read the documentation.</p>';
				return;
			}

			if(!empty($this->fontList)){
				?>
				<div class="google_fonts_select_control entex-font-control<?php echo esc_attr(($this->fontMaster ? ' entex-font-control-is-master' : '')); ?>">
					<?php if( !empty( $this->label ) ) { ?>
						<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
					<?php } ?>
					<?php if( !empty( $this->description ) ) { ?>
						<span class="customize-control-description entex-font-control-expanded-hide"><?php echo esc_html( $this->description ); ?></span>
					<?php } ?>
					<input type="hidden" id="<?php echo esc_attr( $this->id ); ?>" name="<?php echo esc_attr( $this->id ); ?>" value="<?php echo esc_attr( $this->value() ); ?>" class="customize-control-google-font-selection" <?php $this->link(); ?> />
					
					<div class="entex-font-control-description customize-control-description entex-font-control-expandable"><?php echo ($this->fontMaster ? 'Select subset' : 'Subset decided by HTML controller'); ?></div>
					<div class="subset-style entex-font-control-expandable">
						<select<?php echo ($this->fontMaster ? '' : ' disabled="disabled"'); ?> class="google-fonts-subset-style">
							<?php
								foreach( $this->getSubsets() as $value => $label) {
									echo '<option value="' . esc_attr($value) . '" ' . selected( $this->fontValues->subset, $value, false ) . '>' . esc_html($label) . '</option>';
								}
							?>
						</select>
					</div>
					
					<div class="entex-font-control-description customize-control-description entex-font-control-expandable">Filter</div>
					<div class="filter-style entex-font-control-expandable">
						<select class="google-fonts-filter-style">
							<?php
								echo '<option value="">- No filter -</option>'; 
								foreach( $this->getFilters() as $value => $label) {
									if(strpos($value, '-all-') !== FALSE){
										echo '<option value="">&nbsp;</option>'; 
										$value = '';
									}
									echo '<option value="' . esc_attr($value) . '">' . esc_html($label) . '</option>';
								}
							?>
						</select>
					</div>
					
					<div class="entex-font-control-description customize-control-description entex-font-control-expandable"><a title="Reset" class="entex-font-control-reset-link">R</a><span>Select font</span><a title="Current value to Memory" class="entex-font-control-label-link entex-font-control-memory">M</a><a data-saved-1="<?php echo esc_attr($this->fontValues->font); ?>" data-saved-2="<?php echo esc_attr($this->fontValues->regularweight); ?>" title="Compare current with original saved" class="entex-font-control-label-link entex-font-control-compare">Compare</a><span class="entex-font-control-monitor-wr"><span class="entex-font-control-monitor"><?php echo esc_html(count($this->fontList)); ?></span><span> of <?php echo esc_html(count($this->fontList)); ?></span></div>
					<div class="google-fonts">
						<select class="google-fonts-list" control-name="<?php echo esc_attr( $this->id ); ?>">
							<option value=''>- Theme default -</option>
							<?php
								foreach( $this->fontList as $key => $value ) {
									$fontCounter++;
									/* leave the first , as marker */
									$data = 'entex,'.$value->category.','.implode(',', $value->variants).','.implode(',', $value->subsets).',all,entex';
									$fontListStr .= '<option data-all="'. $data .'" data-category="'. $value->category .'" data-variants="'. implode(',', $value->variants) .'" data-subsets="'. implode(',', $value->subsets) .'" value="' . $value->family . '" ' . selected( $this->fontValues->font, $value->family, false ) . '>' . $value->family . '</option>';
									if ( $this->fontValues->font === $value->family ) {
										$isFontInList = true;
									}
									if ( $this->fontCount && is_int( $this->fontCount ) && $fontCounter === $this->fontCount ) {
										break;
									}
								}
								if ( !$isFontInList && $this->fontListIndex ) {
									// If the default or saved font value isn't in the list of displayed fonts, add it to the top of the list as the default font
									$fontListStr = '<option value="' . esc_attr($this->fontList[$this->fontListIndex]->family) . '" ' . selected( $this->fontValues->font, $this->fontList[$this->fontListIndex]->family, false ) . '>' . $this->fontList[$this->fontListIndex]->family . ' (default)</option>' . $fontListStr;
								}
								// Display our list of font options
								echo wp_kses($fontListStr, $this->control_wp_kses());
							?>
						</select>
						<?php if(!$this->fontMaster): ?>
							<label class="entex-font-control-checkbox-label" style="margin-top: 5px;">
							<input type="checkbox" class="entex-font-control-checkbox entex-font-control-checkbox-html" name="checkbox-html-<?php echo esc_attr( $this->id ); ?>" data-saved="<?php echo esc_attr($this->fontValues->font); ?>" id="checkbox-html-<?php echo esc_attr( $this->id ); ?>" data-control-master="<?php echo esc_attr( $this->fontMasterId ); ?>" data-control-set="<?php echo esc_attr( $this->id ); ?>" value="html"/>
							<span>Inherit from html</span>
							</label>
							<?php if($this->fontParentSelector): ?>
								<label class="entex-font-control-checkbox-label" style="margin-bottom: 5px;">
								<input type="checkbox" class="entex-font-control-checkbox entex-font-control-checkbox-parent" name="checkbox-parent-<?php echo esc_attr( $this->id ); ?>" data-saved="<?php echo esc_attr($this->fontValues->font); ?>" id="checkbox-parent-<?php echo esc_attr( $this->id ); ?>" data-control-parent="<?php echo esc_attr( $this->fontParentSelector ); ?>" data-control-set="<?php echo esc_attr( $this->id ); ?>" value="parent"/>
								<span>Inherit from parent</span>
								</label>
							<?php endif; ?>
						<?php endif; ?>
					</div>
					
						
					
					<?php if($this->fontMaster) :?>
					<div class="entex-font-control-description customize-control-description entex-font-control-expandable">Select weight and style for regular text</div>
					<?php else: ?>
					<div class="entex-font-control-description customize-control-description entex-font-control-expandable">Select weight and style</div>
					<?php endif; ?>
					
					<div class="weight-style entex-font-control-expandable">
						<select class="google-fonts-regularweight-style">
							<?php
								foreach( $this->fontList[$this->fontListIndex]->variants as $key => $value ) {
									echo '<option value="' . esc_attr($value) . '" ' . selected( $this->fontValues->regularweight, $value, false ) . '>' . esc_html(str_replace('italic', ' italic', $value)) . '</option>';
								}
							?>
						</select>
						<?php if(!$this->fontMaster): ?>
							<label class="entex-font-control-checkbox-label" style="margin-top: 5px; margin-bottom: 15px;">
							<input type="checkbox" class="entex-font-control-checkbox entex-font-control-checkbox-important" name="checkbox-important-<?php echo esc_attr( $this->id ); ?>" data-saved="<?php echo esc_attr($this->fontValues->regularweight); ?>" id="checkbox-important-<?php echo esc_attr( $this->id ); ?>" data-set="" value="important"/>
							<span>Lock weight</span>
							</label>
						<?php endif; ?>
					</div>
					<div class="entex-font-control-memory-wr entex-font-control-expandable"><div class="entex-font-memory-wr"></div><div class="entex-font-memory-print-wr"><a class="entex-font-memory-import" title="Import from last exported collection (data will be merged with current)" href="#">Import</a> &nbsp;|&nbsp; <a title="Current selection will be exported as theme option" class="entex-font-memory-export" href="#">Export</a> &nbsp;|&nbsp; <a class="entex-font-memory-print" href="#">Print</a></div></div>
					<div class="entex-font-control-description customize-control-description entex-font-control-<?php echo ($this->fontMaster ? 'expandable' : 'hidden'); ?>">Select weight for italic text</div>
					<div class="weight-style entex-font-control-<?php echo ($this->fontMaster ? 'expandable' : 'hidden'); ?>">
						<select class="google-fonts-italicweight-style" <?php disabled( in_array( 'italic', $this->fontList[$this->fontListIndex]->variants ), false ); ?>>
							<?php
								$optionCount = 0;
								foreach( $this->fontList[$this->fontListIndex]->variants as $key => $value ) {
									// Only add options that are italic
									if( strpos( $value, 'italic' ) !== false ) {
										echo '<option value="' . esc_attr($value) . '" ' . selected( $this->fontValues->italicweight, $value, false ) . '>' . esc_html(str_replace('italic', ' italic', $value)) . '</option>';
										$optionCount++;
									}
								}
								if( $optionCount == 0 ) {
									echo '<option value="">Not Available for this font</option>';
								}
							?>
						</select>
					</div>
					
					<div class="entex-font-control-description customize-control-description entex-font-control-<?php echo ($this->fontMaster ? 'expandable' : 'hidden'); ?>">Select weight for bold text</div>
					<div class="weight-style entex-font-control-<?php echo esc_attr(($this->fontMaster ? 'expandable' : 'hidden')); ?>">
						<select class="google-fonts-boldweight-style">
							<?php
								$optionCount = 0;
								foreach( $this->fontList[$this->fontListIndex]->variants as $key => $value ) {
									// Only add options that aren't italic
									if( strpos( $value, 'italic' ) === false ) {
										echo '<option value="' . esc_attr($value) . '" ' . selected( $this->fontValues->boldweight, $value, false ) . '>' . esc_html($value) . '</option>';
										$optionCount++;
									}
								}
								// This should never evaluate as there'll always be at least a 'regular' weight
								if( $optionCount == 0 ) {
									echo '<option value="">Not Available for this font</option>';
								}
							?>
						</select>
					</div>
					<input type="hidden" class="google-fonts-category" value="<?php echo esc_attr($this->fontValues->category); ?>">
					<div class="entex-font-control-font-monitor entex-font-control-expandable">
						<table>
							<tr><td>Name</td><td>:</td><td class="name">No font selected</td></tr>
							<tr><td>Category</td><td>:</td><td class="category">No font selected</td></tr>
							<tr><td>Variants</td><td>:</td><td class="variants">No font selected</td></tr>
							<tr><td>Subsets</td><td>:</td><td class="subsets">No font selected</td></tr>
						</table>
					</div>
					<input type="button" class="entex-font-control-expander button" data-active="Hide extended font settings" data-inactive="Show extended font settings" value="Show extended font settings"/>
				</div>
				<?php
			}
		}

		/* Find the index of the saved font in our multidimensional array of Google Fonts */
		
		public function getFontIndex($haystack, $needle){
			if(empty($haystack)) return false;
			foreach($haystack as $key => $value){
				if($value->family == $needle){
					return $key;
				}
			}
			return false;
		}

		/* Return the list of Google Fonts from our json file. Unless otherwise specfied, list will be limited to 30 fonts. */
		// Google Fonts json generated from https://www.googleapis.com/webfonts/v1/webfonts?sort=popularity&key=YOUR-API-KEY 
		
		public function getGoogleFonts($count = 30){
			
			$count = 'all';
			if(defined('ENTEX_API_KEY_GOOGLE_WEBFONTS')){
				$key = ENTEX_API_KEY_GOOGLE_WEBFONTS;
				$fontFile = 'https://www.googleapis.com/webfonts/v1/webfonts?key='.$key;
			} else {
				if(!function_exists('entex_ECROOT')) return '';
				$path = 'extended/entex-control-font/assets/';
				$fontFile = entex_ECROOT($path.'google-fonts-alphabetical.json', true);
				if($this->fontOrderBy === 'popular') $fontFile = entex_ECROOT($path.'google-fonts-popularity.json', true);
			}
			
			$request = wp_remote_get($fontFile);
			if(is_wp_error($request)) return "";

			$body = wp_remote_retrieve_body($request);
			$content = json_decode($body);

			if($count == 'all') return $content->items;
				else return array_slice( $content->items, 0, $count );
		}
	}
}
 

 
// -- END FILE -- //