
/* ENTEX FONT CONTROL JAVASCRIPT */
/* UPDATED 2020 08 19 */

jQuery( document ).ready(function($){
	
	"use strict";

	/**
	 * Googe Font Select Custom Control
	 * Entex theme font control
	 *
	 * Inspired by
	 * @link https://github.com/maddisondesigns
	 */ 
	 
	$('.customize-control-google-font-selection').each(function(){
		var str = $(this).val();
		if(str){
			
			var transported = str.replace(/&quot;/g, '"');
			var Arr = $.parseJSON(transported);
			
			var root = $(this).closest('.google_fonts_select_control.entex-font-control');
			var font_selector = root.find('.google-fonts-list');
			var regularweight = root.find('.google-fonts-regularweight-style');
			var italicweight = root.find('.google-fonts-italicweight-style');
			var boldweight = root.find('.google-fonts-boldweight-style');
			var subset = root.find('.google-fonts-subset-style');
			var changed = 0;
			
			if(Arr['font']) {
				if(font_selector.val() != Arr['font']) {
					font_selector.val(Arr['font']); 
					changed = 1;
				}
			}
			if(Arr['regularweight']){
				if(regularweight.val() != Arr['regularweight']) {
					regularweight.val(Arr['regularweight']); 
					changed = 1;
				}
			}
			if(Arr['italicweight']){
				if(italicweight.val() != Arr['italicweight']) {
					italicweight.val(Arr['italicweight']); 
					changed = 1;
				}
			}
			if(Arr['boldweight']){
				if(boldweight.val() != Arr['boldweight']) {
					boldweight.val(Arr['boldweight']); 
					changed = 1;
				}
			}
			if(Arr['subset']){
				if(subset.val() != Arr['subset']) {
					subset.val(Arr['subset']); 
					changed = 1;
				}
			}
			if(changed) console.log('changed: '  + str);
		}
	});
	
	function valueToArray(str){
		var transported = str.replace(/&quot;/g, '"');
		var Arr = $.parseJSON(transported);
		return Arr;
	}
	
	function valueToLabel(value){
		var Arr = valueToArray(value);
		var label = Arr['font'] + ' | ' + Arr['regularweight'] + ' | ' + Arr['italicweight'] + ' | ' + Arr['boldweight'];
		return label;
	}

	$(document).on('click', 'a.entex-font-memory', function(){
		
		var $root = $(this).closest('.google_fonts_select_control.entex-font-control');
		$root.find('.google-fonts-filter-style').val('').trigger('change');
		
		var $selector_1 = $root.find('.google-fonts-list');
		var $selector_2 = $root.find('.google-fonts-regularweight-style');
		$selector_1.val($(this).data('font-1')).trigger('change');
		$selector_2.val($(this).data('font-2')).trigger('change');
	
		var control = '';
		var control_attribute = '';
		
		/* additiional siblings */
		control = 'text_transform';
		control_attribute = 'text-transform';
		if($root.parent().siblings('[id*="' + control + '"]').get(0)){
			$root.parent().siblings('[id*="' + control + '"]').find('select').val($(this).data(control_attribute)).trigger('change');
		}
		
		control = 'letter_spacing';
		control_attribute = 'letter-spacing';
		if($root.parent().siblings('[id*="' + control + '"]').get(0)){
			$root.parent().siblings('[id*="' + control + '"]').find('[type="range"]').val($(this).data(control_attribute)).trigger('change');
		}
		
		control = 'font_size_';
		control_attribute = 'font-size';
		if($root.parent().siblings('[id*="' + control + '"]').get(0)){
			$root.parent().siblings('[id*="' + control + '"]').find('.entex-customize-control-monitor-wr input').val($(this).data(control_attribute)).trigger('keyup');
		}

		return false;
	});
	
	$(document).on('click', 'a.entex-font-memory-remove', function(){
		$(this).addClass('ua-tmp-remove').next().addClass('ua-tmp-remove');
		$(this).parent().find('.ua-tmp-remove').remove();
		return false;
	});
	
	$(document).on('click', '.entex-font-memory-print-wr a.entex-font-memory-import', function(){

		var $root = $(this).closest('.google_fonts_select_control.entex-font-control');
		var master = $root.find('.customize-control-google-font-selection').attr('id');
		var obj = $('[data-memory-master="' + master + '"]').get(0);
		if(obj){
			var str = $(obj).val();

			if(!str){
				alert('No saved data found to import');
				return false;
			}
			if(!str.match('|')){
				alert('Data not valid. Should be like: "verdana|700,Roboto condensed|500" etc etc');
				return false;
			}
			
			var $container = $(this).closest('.entex-font-control-memory-wr').find('.entex-font-memory-wr');
			if(str.match(',')){
				var collection = str.split(',');
				var n;
				for(n = 0; n < collection.length; n++){
					var data = collection[n];
					var values = data.split('|');
					values = values.map(s => s.trim());
					var $element = '<div><a class="entex-font-memory-remove" title="Remove this line"> X </a><a class="entex-font-memory" data-font-1="' + values[0] + '" data-font-2="' + values[1] + '" data-text-transform="">' + values[0] + ' | ' + values[1] + '</a></div>';
					$container.append($element);
				};
			} else {
				var data = str;
				var values = data.split('|');
				values = values.map(s => s.trim());
				var $element = '<div><a class="entex-font-memory-remove" title="Remove this line"> X </a><a class="entex-font-memory" data-font-1="' + values[0] + '" data-font-2="' + values[1] + '" data-text-transform="">' + values[0] + ' | ' + values[1] + '</a></div>';
				$container.append($element);
			}
		}
		return false;
	});
	
	$(document).on('click', '.entex-font-memory-print-wr a.entex-font-memory-export', function(){

		var $print = $(this).closest('.entex-font-control-memory-wr').clone(false);
		$print.find('.entex-font-memory-print-wr').remove();
		$print.find('.entex-font-memory-remove').remove();
		if(!$print.find('a').get(0)) return;
		var content = $print.html();
		
		var $root = $(this).closest('.google_fonts_select_control.entex-font-control');
		var master = $root.find('.customize-control-google-font-selection').attr('id');
		var obj = $('[data-memory-master="' + master + '"]').get(0);
		if(obj){
			var collect = new Array();
			$print.find('a').each(function(){
				var str = $(this).data('font-1') + '|' + $(this).data('font-2');
				collect.push(str);
			});
			var value = collect.join(',');
			if(value){
				$(obj).val(value).trigger('change');
				var txt = $(this).text();
				$(this).text('Success');
				var $el = $(this);
				var timeout = setTimeout(function(){
					$el.text(txt);
				}, 2000);
			}
		}
		return false;
	});
	
	$(document).on('click', '.entex-font-memory-print-wr a.entex-font-memory-print', function(){

		var $print = $(this).closest('.entex-font-control-memory-wr').clone(false);
		$print.find('.entex-font-memory-print-wr').remove();
		$print.find('.entex-font-memory-remove').remove();
		if(!$print.find('a').get(0)) return;
		if($print.find('a').get(1)){
			$print.find('a').parent().each(function(){
				if($(this).next().get(0)){
					$(this).find('a').text($(this).find('a').text() + ',');
				}
			});
		}
		var content = $print.html();
		var WinPrint = window.open('', '', 'left=0,top=0,width=800,height=900,toolbar=0,scrollbars=0,status=0');
		WinPrint.document.write(content);
		WinPrint.document.close();
		WinPrint.focus();
		WinPrint.print();
		WinPrint.close();
		return false;
	});
	
	$('a.entex-font-control-memory').on('click', function(){
		
		var $remove = $('<a />');
		$remove.addClass('entex-font-memory-remove').attr('title', 'Remove this line').text(' X ');
			
		var data = '';
		var data_initial = '';
		var control = '';
		var control_attribute = '';
		
		var $root = $(this).closest('.google_fonts_select_control.entex-font-control');
		var current_1 = $root.find('.google-fonts-list').val();
		var current_2 = $root.find('.google-fonts-regularweight-style').val();
		var text_1 = $root.find('.google-fonts-list :selected').text();
		var text_2 = current_2;
		
		var $link = $('<a />');
		$link.addClass('entex-font-memory').attr('data-font-1', current_1).attr('data-font-2', current_2).text(text_1 + ' | ' + text_2);
		
		
		/* additiional siblings */
		control = 'text_transform';
		control_attribute = 'text-transform';
		$link.attr('data-' + control_attribute, data_initial);
		if($root.parent().siblings('[id*="' + control + '"]').get(0)){
			data = $root.parent().siblings('[id*="' + control + '"]').find('select').val();
			$link.attr('data-' + control_attribute, data);
			if(data) $link.text($link.text() + ' | ' + $root.parent().siblings('[id*="' + control + '"]').find('option:selected').text());
		}
		
		control = 'letter_spacing';
		control_attribute = 'letter-spacing';
		$link.attr('data-' + control_attribute, data_initial);
		if($root.parent().siblings('[id*="' + control + '"]').get(0)){
			data = $root.parent().siblings('[id*="' + control + '"]').find('[type="range"]').val();
			$link.attr('data-' + control_attribute, data);
			if(data && data != '-0.11') $link.text($link.text() + ' | L');
		}
		
		control = 'font_size_';
		control_attribute = 'font-size';
		$link.attr('data-' + control_attribute, data_initial);
		if($root.parent().siblings('[id*="' + control + '"]').get(0)){
			data = $root.parent().siblings('[id*="' + control + '"]').find('[type="range"]').val();
			$link.attr('data-' + control_attribute, data);
			if(data && data != '0') $link.text($link.text() + ' | ' + data);
		}
		
		var $wr = $root.find('.entex-font-control-memory-wr');
		$wr.show().find('.entex-font-memory-wr').append(
			$('<div />').append(
				$remove,
				$link
			)
		);
		return false;
	});
	
	$('a.entex-font-control-compare').on('click', function(){
		
		$(this).toggleClass('ua-compare-saved');
		
		var $root = $(this).closest('.google_fonts_select_control.entex-font-control');
		$root.find('.google-fonts-filter-style').val('').trigger('change');
		
		var current_1 = $root.find('.google-fonts-list').val();
		var current_2 = $root.find('.google-fonts-regularweight-style').val();

		if($(this).hasClass('ua-compare-saved')){
			$(this).data('compare-1', current_1).data('compare-2', current_2);
			$root.find('.google-fonts-list').val($(this).data('saved-1')).trigger('change');
			$root.find('.google-fonts-regularweight-style').val($(this).data('saved-2')).trigger('change');
		} else {
			$root.find('.google-fonts-list').val($(this).data('compare-1')).trigger('change');
			$root.find('.google-fonts-regularweight-style').val($(this).data('compare-2')).trigger('change');
		}
		return false;
	});
	
	$('a.entex-font-control-reset-link').on('click', function(){
		var $root = $(this).closest('.google_fonts_select_control.entex-font-control');
		$root.find('.google-fonts-list').val('').trigger('change');
		return false;
	});
	
	// ToDo: cleanup varaible policy of '$' element variables (root should be $root)
	
	
	$('.entex-font-control-checkbox').on('click', function(){
		
		/* reset filter */
		var $root = $(this).closest('.google_fonts_select_control.entex-font-control');
		
		
		if($(this).val() == 'html'){
			var master = $(this).attr('data-control-master');
			if(!master) return false;
			var master_select = $('[name="' + master + '"]').get(0);
			if(master_select){
				var set = $(this).attr('data-control-set');
				var saved = $(this).attr('data-saved');
				var str = $(master_select).val();
				var transported = str.replace(/&quot;/g, '"');
				var Arr = $.parseJSON(transported);
				
				/* reset filter selector */
				$root.find('.google-fonts-filter-style').val('').trigger('change');
				
				if($(this).is(':checked')) $('[control-name="' + set + '"]').addClass('ua-tmp-checked').val(Arr['font']).trigger('change');
					else $('[control-name="' + set + '"]').removeClass('ua-tmp-checked').val(saved).trigger('change');
			} else return false;
		}
		
		if($(this).val() == 'important'){
			if($(this).is(':checked')){
				var set = $root.find('.google-fonts-regularweight-style').val();
				$(this).attr('data-set', set);
			} else {
				$(this).attr('data-set', '');
				$root.find('.google-fonts-regularweight-style').trigger('change');
			}
		}
		
		/* not in use yet */
		if($(this).val() == 'parent'){
			var parent = $(this).attr('data-control-parent');
			if(!parent) return false;
			var parent_select = $('[name="' + parent + '"]').get(0);
			if(parent_select){
				var set = $(this).attr('data-control-set');
				var saved = $(this).attr('data-saved');
				var str = $(parent_select).val();
				var transported = str.replace(/&quot;/g, '"');
				var Arr = $.parseJSON(transported);
				
				/* reset filter selector */
				$root.find('.google-fonts-filter-style').val('').trigger('change');

				if($(this).is(':checked')) $('[control-name="' + set + '"]').val(Arr['font']).trigger('change');
					else $('[control-name="' + set + '"]').val(saved).trigger('change');
			} else return false;
		}

	});
	
	$('.entex-font-control-expander').on('click', function(){
		/* synced with memory controller when direct next controller */
		$(this).closest('.google_fonts_select_control.entex-font-control').toggleClass('entex-font-control-is-expanded').parent().next().toggleClass('entex-font-control-is-expanded');
		if($(this).val() == $(this).attr('data-inactive')) $(this).val($(this).attr('data-active'));
			else $(this).val($(this).attr('data-inactive'));
		return false;
	});
	
	$('.google-fonts-filter-style').on('change', function() {
		var root = $(this).closest('.google_fonts_select_control.entex-font-control');
		var font_selector = root.find('.google-fonts-list');
		
		var filter = $(this).val();
		font_selector.data('filter', filter);
		var class_name = 'entex-font-control-hidden-option';
		var all_options = font_selector.find('option');
		all_options.removeClass(class_name).prop('disabled', false);
		if(filter) all_options.addClass(class_name).filter('[data-all*=",' + filter + ',"]').removeClass(class_name);
		if(filter) all_options.not('[data-all*=",' + filter + ',"]').not('[value=""]').prop('disabled', true);
		
		var font_monitor = root.find('.entex-font-control-monitor');
		var count = all_options.filter('[class=""]');
		if(count.length) font_monitor.text(count.length);
			else font_monitor.text('0');
			
		all_options.filter('[value=""]').removeAttr('class');
		return true;
		
	});
	
	$('.google-fonts-subset-style').on('change', function() {
		var root = $(this).closest('.google_fonts_select_control.entex-font-control');
		var font_selector = root.find('.google-fonts-list');
		var filter = $(this).val();
		var class_name = 'entex-font-control-hidden-subset';
		var all_options = font_selector.find('option');
		all_options.removeClass(class_name).prop('disabled', false);
		if(filter) all_options.addClass(class_name).filter('[data-all*=",' + filter + ',"]').removeClass(class_name);
		if(filter) all_options.not('[data-all*=",' + filter + ',"]').not('[value=""]').prop('disabled', true);
		
		var font_monitor = root.find('.entex-font-control-monitor');
		var count = all_options.filter('[class=""]');
		if(count.length) font_monitor.text(count.length);
			else font_monitor.text('0');
			
		all_options.filter('[value=""]').removeAttr('class');
		return true;
	});
	
	$('.google-fonts-list').on('change', function() {
		var root = $(this).closest('.google_fonts_select_control.entex-font-control');
		var elementRegularWeight = root.find('.google-fonts-regularweight-style');
		var elementItalicWeight = root.find('.google-fonts-italicweight-style');
		var elementBoldWeight = root.find('.google-fonts-boldweight-style');
		var elementSubset = root.find('.google-fonts-subset-style');
		var elementFilter = root.find('.google-fonts-filter-style');
		var elementCheckHtml = root.find('.entex-font-control-checkbox-html');
		var elementCheckImportant = root.find('.entex-font-control-checkbox-important');
		var selectedFont = $(this).val();
		var customizerControlName = $(this).attr('control-name');
		var elementItalicWeightCount = 0;
		var elementBoldWeightCount = 0;
		var filter = $(this).data('filter');
		var filter_match = false;
		
		var regularSelected = elementRegularWeight.val();

		// Clear Weight/Style dropdowns
		elementRegularWeight.empty();
		elementItalicWeight.empty();
		elementBoldWeight.empty();
		
		// Make sure Italic & Bold dropdowns are enabled
		elementRegularWeight.prop('disabled', false);
		elementItalicWeight.prop('disabled', false);
		elementBoldWeight.prop('disabled', false);
		
		if($(this).hasClass('ua-tmp-check')) $(this).removeClass('ua-tmp-check');
			else elementCheckHtml.prop('checked', false);
		

		// Get the Google Fonts control object
		var bodyfontcontrol = _wpCustomizeSettings.controls[customizerControlName];

		// Find the index of the selected font
		var indexes = $.map(bodyfontcontrol.entexfontslist, function(obj, index) {
			if(obj.family === selectedFont) {
				return index;
			}
		});
		
		//QQ
		if(indexes[0] == null) var exists = 0;
			else var exists = 1;

		if(exists){
			
			var index = indexes[0];
			var select_me_regular = null;
			var select_me_italic = null;
			var select_me_bold = null;
			var trigger_me = null;
		
			// For the selected Google font show the available weight/style variants
			$.each(bodyfontcontrol.entexfontslist[index].variants, function(val, text) {
				
				var label = text;
				var $option = $('<option />');
				var $option_extended = $('<option />');
				if(filter && text == filter) filter_match = true;

				if(label == 'regular'){
					label = '400 (regular)';
					select_me_regular = $option;
				} else if(label == 'italic'){
					label = '400 italic (regular italic)';
					select_me_italic = $option_extended;
				} else {
					label = label.replace('italic', ' italic');
				}
				elementRegularWeight.append(
					$option.val(text).html(label)
				);
				if (text.indexOf("italic") >= 0) {
					elementItalicWeight.append(
						$option_extended.val(text).html(label)
					);
					elementItalicWeightCount++;
				} else {
					if(text == '500') select_me_bold = $option_extended;
					elementBoldWeight.append(
						$option_extended.val(text).html(label)
					);
					elementBoldWeightCount++;
				}
			});

			
			if(select_me_regular) select_me_regular.prop('selected', true);
			if(select_me_italic) select_me_italic.prop('selected', true);
			if(select_me_bold) select_me_bold.prop('selected', true);

			var $o = $(this).find(':selected');
			var $monitor = root.find('.entex-font-control-font-monitor');
			$monitor.find('.name').text($o.text());
			$monitor.find('.category').text($o.attr('data-category'));
			$monitor.find('.variants').html($o.attr('data-variants').replace(/italic/g, ' italic').split(',').join('<br>'));
			$monitor.find('.subsets').html($o.attr('data-subsets').split(',').join('<br>'));
		
		} else {
			elementRegularWeight.append(
				$('<option></option>').val('').html('inherit'),
				$('<option></option>').val('400').html('400 (regular)'),
				$('<option></option>').val('400italic').html('400 italic (regular italic)'),
				$('<option></option>').val('700').html('700'),
				$('<option></option>').val('700italic').html('700 italic')
			);

			var txt = 'No font selected';
			root.find('.entex-font-control-font-monitor td[class]').html(txt);
			elementFilter.val('').trigger('change');
		}

		if(elementItalicWeightCount == 0) {
			elementItalicWeight.append(
				$('<option></option>').val('').html('Not Available for this font')
			);
			elementItalicWeight.prop('disabled', 'disabled');
		}
		if(elementBoldWeightCount == 0) {
			elementBoldWeight.append(
				$('<option></option>').val('').html('Not Available for this font')
			);
			elementBoldWeight.prop('disabled', 'disabled');
		}
		
		if(exists && regularSelected){
			if(elementRegularWeight.find('option[value="' + regularSelected  + '"]').get(0)) elementRegularWeight.val(regularSelected);
		}

		// Update the font category based on the selected font
		if(exists) root.find('.google-fonts-category').val(bodyfontcontrol.entexfontslist[index].category);
			else root.find('.google-fonts-category').val('');

		entexGetAllSelects(root);
		
		/* override if filter matches available option */
		if(!root.hasClass('entex-font-control-is-master')){
			if(!elementCheckImportant.is(':checked')){
				if(filter_match) root.find('.google-fonts-regularweight-style').val(filter).trigger('change');
			}
		}
	});

	$('.google_fonts_select_control select').on('change', function() {
		var root = $(this).closest('.google_fonts_select_control.entex-font-control');
		entexGetAllSelects(root);
	});

	function entexGetAllSelects($element) {
		if($element.hasClass('entex-font-control-is-master')) var master = true;
			else var master = false;
			
		var elementCheckImportant = $element.find('.entex-font-control-checkbox-important').get(0);
		if(elementCheckImportant && $(elementCheckImportant).is(':checked') && $(elementCheckImportant).attr('data-set')){
			var regularWeight = $(elementCheckImportant).attr('data-set');
		} else {
			var regularWeight = $element.find('.google-fonts-regularweight-style').val();
		}
		
		if(master){
			var selectedFont = {
				font: $element.find('.google-fonts-list').val(),
				regularweight: $element.find('.google-fonts-regularweight-style').val(),
				italicweight: $element.find('.google-fonts-italicweight-style').val(),
				boldweight: $element.find('.google-fonts-boldweight-style').val(),
				category: $element.find('.google-fonts-category').val(),
				subset: $element.find('.google-fonts-subset-style').val(),
			};
		} else {
			var selectedFont = {
				font: $element.find('.google-fonts-list').val(),
				regularweight: regularWeight,
				italicweight: '',
				boldweight: '',
				category: '',
				subset: '',
			};
		}

		// Important! Make sure to trigger change event so Customizer knows it has to save the field
		$element.find('.customize-control-google-font-selection').val(JSON.stringify(selectedFont)).trigger('change');
	}


});
