<?php if(!defined('ABSPATH')) die();
/**
 * ENTEX CUSTOMIZE COLOR CONTROL
 * Entex customizer UI
 *
 * Extends WP_Customize_Control
 * Extends wp.colorpicker
 *
 * @package Entex
 * @subpackage Entex
 * @version 2.10604
 * 
 * Documentation: https://entex.info 
 *
 */
 
/**
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
**/

if(class_exists('WP_Customize_Control')){
	class entex_customize_color_control extends WP_Customize_Control{

		public $type = 'alpha-color';
		public $palette;
		public $show_opacity;

		public function enqueue(){
			$path = 'extended/entex-control-color/assets/';
			wp_enqueue_script('entex-color-control', entex_ECROOT($path.'entex-color-control.js', true), array('jquery', 'wp-color-picker'), '2.1.0', true);
			wp_enqueue_style('entex-color-control', entex_ECROOT($path.'entex-color-control.css', true), array('wp-color-picker'), '2.1.0');
		}

		public function render_content() {

			if(is_array($this->palette)) $palette = implode('|', $this->palette);
				else $palette = (false === $this->palette || 'false' === $this->palette) ? 'false' : 'true';
			$show_opacity = (false === $this->show_opacity || 'false' === $this->show_opacity) ? 'false' : 'true';
			
			?>
			<label>
				<?php 
				if(isset($this->label) && '' !== $this->label) echo '<span class="customize-control-title">'. esc_html(sanitize_text_field( $this->label )) .'</span>';
				if(isset($this->description) && '' !== $this->description) echo '<span class="description customize-control-description">'. esc_html(sanitize_text_field( $this->description )) .'</span>';
				?>
				<input class="alpha-color-control" type="text" data-show-opacity="<?php echo esc_attr($show_opacity); ?>" data-palette="<?php echo esc_attr( $palette ); ?>" data-default-color="<?php echo esc_attr( $this->settings['default']->default ); ?>" <?php $this->link(); ?>  />
			</label>
			<?php
		}
	}
}
 
// -- END FILE -- //