
/* Modified Entex customizer UI */
/* UPDATED 2018 07 01 */

/**
 * Override the stock color.js toString() method to add support for
 * outputting RGBa or Hex.
 */
 
Color.prototype.toString = function(flag){

	if('no-alpha' == flag) return this.toCSS('rgba', '1').replace( /\s+/g, '' );
	if(1 > this._alpha) return this.toCSS('rgba', this._alpha).replace( /\s+/g, '' );

	var hex = parseInt(this._color, 10).toString(16);
	if(this.error) { return ''; }
	if(hex.length < 6){
		for(var i = 6 - hex.length - 1; i >= 0; i--){
			hex = '0' + hex;
		}
	}
	return '#' + hex;
};


function entex_eca_get_alpha(value){
	
	var alphaVal;
	value = value.replace( / /g, '' );

	if(value.match( /rgba\(\d+\,\d+\,\d+\,([^\)]+)\)/ )){
		alphaVal = parseFloat( value.match( /rgba\(\d+\,\d+\,\d+\,([^\)]+)\)/ )[1] ).toFixed(2) * 100;
		alphaVal = parseInt( alphaVal );
	} else {
		alphaVal = 100;
	}
	return alphaVal;
}


function entex_eca_update_alpha(alpha, $control, $alphaSlider, update_slider){
	
	var iris, colorPicker, color;

	iris = $control.data('a8cIris');
	colorPicker = $control.data('wpWpColorPicker');
	iris._color._alpha = alpha;
	color = iris._color.toString();
	$control.val( color );
	colorPicker.toggler.css({
		'background-color': color
	});

	if(update_slider){
		entex_eca_update_alpha_slider( alpha, $alphaSlider );
	}
	$control.wpColorPicker( 'color', color );
}

function entex_eca_update_alpha_slider( alpha, $alphaSlider ) {
	$alphaSlider.slider( 'value', alpha );
	$alphaSlider.find( '.ui-slider-handle' ).text( alpha.toString() );
}

// INIT
jQuery(document).ready( function( $ ){

	$( '.alpha-color-control' ).each( function() {
		
		var $parent = $(this).closest('li.customize-control-alpha-color');
		$parent.find('div.customize-control-notifications-container').prependTo($parent);
		$parent.find('span.customize-control-title').prependTo($parent);

		var $control, startingColor, paletteInput, showOpacity, defaultColor, palette,
			colorPickerOptions, $container, $alphaSlider, alphaVal, sliderOptions;

		$control = $( this );
		startingColor = $control.val().replace( /\s+/g, '' );
		paletteInput = $control.attr( 'data-palette' );
		showOpacity  = $control.attr( 'data-show-opacity' );
		defaultColor = $control.attr( 'data-default-color' );

		if ( paletteInput.indexOf( '|' ) !== -1 ) {
			palette = paletteInput.split( '|' );
		} else if ( 'false' == paletteInput ) {
			palette = false;
		} else {
			palette = true;
		}

		colorPickerOptions = {
			change: function( event, ui ) {
				var key, value, alpha, $transparency;

				key = $control.attr( 'data-customize-setting-link' );
				value = $control.wpColorPicker( 'color' );

				if ( defaultColor == value ) {
					alpha = entex_eca_get_alpha( value );
					$alphaSlider.find( '.ui-slider-handle' ).text( alpha );
				}
				// QQ
				$container.find('.wp-color-result-value').text(value.replace('rgba', ''));

				wp.customize( key, function( obj ) {
					obj.set( value );
				});

				$transparency = $container.find( '.transparency' );
				$transparency.css( 'background-color', ui.color.toString( 'no-alpha' ) );
			},
			palettes: palette // Use the passed in palette.
		};

		$control.wpColorPicker( colorPickerOptions );
		$container = $control.parents( '.wp-picker-container:first' );
		
		//QQ
		$container.find('.wp-color-result-text').append(
			$('<span/>').addClass('wp-color-result-value').text($control.val().replace('rgba', ''))
		);

		$( '<div class="alpha-color-picker-container">' +
				'<div class="min-click-zone click-zone"></div>' +
				'<div class="max-click-zone click-zone"></div>' +
				'<div class="alpha-slider"></div>' +
				'<div class="transparency"></div>' +
			'</div>' ).appendTo( $container.find( '.wp-picker-holder' ) );

		$alphaSlider = $container.find( '.alpha-slider' );
		alphaVal = entex_eca_get_alpha( startingColor );
		sliderOptions = {
			create: function( event, ui ) {
				var value = $( this ).slider( 'value' );
				$( this ).find( '.ui-slider-handle' ).text( value );
				$( this ).siblings( '.transparency ').css( 'background-color', startingColor );
			},
			value: alphaVal,
			range: 'max',
			step: 1,
			min: 0,
			max: 100,
			animate: 300
		};

		$alphaSlider.slider( sliderOptions );
		if ( 'true' == showOpacity ) {
			$alphaSlider.find( '.ui-slider-handle' ).addClass( 'show-opacity' );
		}

		$container.find( '.min-click-zone' ).on( 'click', function() {
			entex_eca_update_alpha( 0, $control, $alphaSlider, true );
		});
		$container.find( '.max-click-zone' ).on( 'click', function() {
			entex_eca_update_alpha( 100, $control, $alphaSlider, true );
		});
		
		$container.find('.iris-palette-container').toggleClass('iris-palette-container entex-iris-palette-container').appendTo($container.find('.wp-picker-holder'));
		if($container.find('.iris-palette[style^="height"]').get(0)){
			var $marker = $container.find('.iris-palette[style^="height"]');
			$marker.nextAll().appendTo($('<div />').addClass('entex-iris-palette-container entex-palette-stylesheet').appendTo($container.find('.wp-picker-holder')));
			$marker.hide();
			$container.find('.entex-palette-stylesheet').hide().before($('<input />').prop('type', 'button').addClass('entex-button-control button').val('View stylesheet palette').click(function(){
					$(this).next().toggle().parent().toggleClass('entex-button-control-is-active');
				}).css('margin-top', '3px')
			);
		}

		$container.find( '.iris-palette' ).on( 'click', function() {
			
			if($container.find('.iris-picker').is(':hidden')) $container.find('button.wp-color-result').trigger('click');
			var color, alpha;

			color = $( this ).css( 'background-color' );
			alpha = entex_eca_get_alpha( color );

			entex_eca_update_alpha_slider( alpha, $alphaSlider );
			if ( alpha != 100 ) {
				color = color.replace( /[^,]+(?=\))/, ( alpha / 100 ).toFixed( 2 ) );
			}
			$control.wpColorPicker( 'color', color );
		});

		$container.find( '.button.wp-picker-clear' ).on( 'click', function() {
			var key = $control.attr( 'data-customize-setting-link' );
			$control.wpColorPicker( 'color', '#ffffff' );
			wp.customize( key, function( obj ) {
				obj.set( '' );
			});
			entex_eca_update_alpha_slider( 100, $alphaSlider );
		});

		$container.find( '.button.wp-picker-default' ).on( 'click', function() {
			var alpha = entex_eca_get_alpha( defaultColor );
			entex_eca_update_alpha_slider( alpha, $alphaSlider );
		});

		$control.on( 'input', function() {
			var value = $( this ).val();
			var alpha = entex_eca_get_alpha( value );

			entex_eca_update_alpha_slider( alpha, $alphaSlider );
		});

		$alphaSlider.slider().on( 'slide', function( event, ui ) {
			var alpha = parseFloat( ui.value ) / 100.0;
			entex_eca_update_alpha( alpha, $control, $alphaSlider, false );
			$( this ).find( '.ui-slider-handle' ).text( ui.value );
		});

	});
});
