<?php if(!defined('ABSPATH')) die();
/**
 * ENTEX BUTTON CONTROL
 * Entex customizer UI
 * Extended class WP_Customize_Control
 *
 * @package Entex
 * @subpackage Entex
 * @updated 2.0180629
 * 
 * Documentation: http://entex.info
 * Author: Jonas Lundman
 *
 */
 
if(class_exists('WP_Customize_Control')){
	class entex_customize_button_control extends WP_Customize_Control{
		
		public $type = 'button';

		public function __construct($manager, $id, $args = array()){
			parent::__construct( $manager, $id, $args );
			$defaults = array(
				'label' => 'Show all settings',
				'description' => 'Show or hide settings',
				'label_passive' => 'Show all settings',
				'label_active' => 'Hide all settings',
				'classname' => '',
				'key' => '',
				'onclick' => '',
				'break' => false
			);
			
			$args = wp_parse_args($args, $defaults);
			
			$this->label = $args['label'];
			$this->description = $args['description'];
			$this->label_passive = $args['label_passive'];
			$this->label_active = $args['label_active'];
			$this->classname = $args['classname'];
			$this->onclick = $args['onclick'];
			$this->key = $args['key'];
			$this->break = $args['break'];
		}
		
		public function control_wp_kses(){
	
			/* default */
			$allowed_tags = wp_kses_allowed_html('post');
			
			/* form elements */
			$allowed_tags['input'] = $allowed_tags['span'];
			$allowed_tags['input']['type'] = true;
			$allowed_tags['input']['name'] = true;
			$allowed_tags['input']['value'] = true;
			$allowed_tags['input']['checked'] = true;
			$allowed_tags['input']['disabled'] = true;
			$allowed_tags['input']['required'] = true;
			$allowed_tags['input']['placeholder'] = true;
			$allowed_tags['input']['min'] = true;
			$allowed_tags['input']['max'] = true;
			$allowed_tags['input']['onclick'] = true;

			return $allowed_tags;
		}
		

		public function enqueue() {
			wp_enqueue_script(
				'entex-control-button',
				entex_ECROOT('extended/entex-control-button/assets/entex-control-button.js', true),
				array('jquery'),
				'null',
				true
			);
		}

		public function render_content(){
			if($this->break) echo '<br>';
			$C[] = 'entex-button-control';
			$C[] = 'button';
			$C[] = $this->classname;
			$onclick = '';
			if($this->onclick) $onclick = ' onclick="'. esc_js($this->onclick) .'"';
			echo wp_kses('<input'. $onclick .' data-key="'. esc_attr($this->key) .'" title="'. esc_attr($this->description) .'" type="button" class="'. esc_attr(implode(' ', $C)) .'" data-active="'. esc_attr($this->label_active) .'" data-inactive="'. esc_attr($this->label_passive) .'" value="'. esc_attr($this->label) .'"/>', $this->control_wp_kses());
		}
	}
}

// -- END FILE -- //