<?php if(!defined('ABSPATH')) die();
/**
 * Entex theme customize options
 *
 * @package Entex
 * @subpackage Entex
 * @updated 2.30325
 *
 * 
**/


/* -------------------- */
// HTML BOLD SELECTORS

function entex_theme_customize_bold_selectors_default(){
	$arr[] = '.ua-init th';
	$arr[] = '.ua-init strong';
	$arr[] = 'p.ua-preamble:not(:only-child)';
	$arr[] = '.ua-comment-list div[class*=-meta] [rel=nofollow]';
	$arr[] = '.ua-comment-list p.moderate';
	return $arr;
}

function entex_theme_customize_bold_selectors(){
	$arr = entex_theme_customize_bold_selectors_default();
	/* filter */
	$arr = apply_filters('entex_theme_customize_controls_bold_selectors', $arr);
	$selectors = implode(', ', $arr);
	return $selectors;
}

/* -------------------- */
// TEMPLATE LOCATIONS
function entex_theme_customize_templates(){

	static $cache;
	if(!empty($cache)) return $cache;

	$types = array('entries', 'events', 'widgets', 'contents', 'sections', 'parts', 'custom');
	/* filter */
	$add = apply_filters('entex_theme_template_types', $types);
	if(is_array($add) && !empty($add)) $types = $add;
	
	foreach($types as $type){
		$TYPE = 'template-'. $type;
		/* cached */
		$templates = wp_get_theme()->get_page_templates(null, $TYPE);
		if(!empty($templates)){
			foreach($templates as $file => $name) {
				$populate = true;
				if(defined('ENTEX_TEMPLATE_USE_CHILD_THEME_ONLY')){
					if(is_child_theme()){
						if(file_exists(get_stylesheet_directory().'/'.$file)) $populate = true;
							else $populate = false;
					}
				} 
				if($populate) $arr[$type][esc_attr($file)] = esc_attr($name);
			}
		}
	}
	$cache = $arr;
	return $arr;
}

/* Building array of conditional hierarchy */
function entex_theme_customize_template_conditionals(){
	
	$is = array();
	
	$is['is_home'] = esc_html_x('Home', 'Customizer', 'entex');
	$is['is_category'] = esc_html_x('Category', 'Customizer', 'entex');
	$is['is_tag'] = esc_html_x('Tag', 'Customizer', 'entex');
	$is['is_author'] = esc_html_x('Author', 'Customizer', 'entex');
	$is['is_date'] = esc_html_x('Date', 'Customizer', 'entex');
	$is['is_tax'] = esc_html_x('Taxonomy', 'Customizer', 'entex');
	$is['is_search'] = esc_html_x('Search', 'Customizer', 'entex');
	
	$post_formats = get_theme_support('post-formats');
	if(!empty($post_formats[0])){
		foreach($post_formats[0] as $name){
			/* translators: */
			$is['is_post_format_'.$name] = sprintf(esc_html_x('Post format %s', 'Customizer', 'entex'), $name);
		}
	}
	
	$post_types = get_post_types(array('public' => true), 'objects');
	unset($post_types['post']);
	unset($post_types['page']);
	if(!empty($post_types)){
		foreach($post_types as $post_type){
			$taxonomies = get_object_taxonomies(array('post_type' => $post_type->name), 'object');
			if(!empty($taxonomies)){
				foreach($taxonomies as $taxonomy){
					$is['is_'. $taxonomy->name] = esc_attr($taxonomy->label) .' ( '. esc_attr($post_type->name) .' )';
				}
			}
		}
	}
	return $is;
}




/* -------------------- */
// SECTION PREVIEW CONTENT
/* sanitized by wp_kses */

function entex_template_output_preview_drop_cap(){
	return '<p class="has-drop-cap">'. _x('No cumundo promta eripuit ea doroeminum menandri electram facilisis no nedranisa fugit invidunt. Errem doming eu cum cu eos nonumy corpora scribentur. Etiam decore iracundia eum no vis et dolor graecis sententiae.', 'DO NOT TRANSLATE', 'entex'). '</p>';
}

function entex_template_output_preview_main_p(){
	return wpautop(_x('No cumundo promta eripuit ea doroeminum menandri electram facilisis no nedranisa fugit invidunt. Errem doming eu cum cu eos nonumy corpora scribentur. Etiam decore iracundia eum no vis et dolor graecis sententiae.', 'DO NOT TRANSLATE', 'entex'));
}

function entex_template_output_preview_not_main_p(){
	return wpautop(_x('No cumendo promta eripuit ea doroeminum menandri electram facilisis no nedranisa fugit invidunt.', 'DO NOT TRANSLATE', 'entex'));
}

function entex_template_output_preview_preamble(){
	return _x('No cumundo promta eripuit ea doroeminum menandri electram facilisis no nedranisa fugit invidunt, errem decore iracundia eum no viset dolor.', 'DO NOT TRANSLATE', 'entex');
}

function entex_template_output_preview_meta(){
	$meta = _x('Cumendo promta doroeminum elram', 'DO NOT TRANSLATE', 'entex');
	return '<div class="entry-meta" style="margin-top: 0.5em">'. $meta .'</div>';
}


function entex_template_output_preview_not_main(){
	
	/* in case */
	if(!is_customize_preview()) return '';
	
	$html = '';
	$text = _x('Entex customizer preview not main', 'DO NOT TRANSLATE', 'entex');
	$target = 'h4';
	$idfs = 'entex_theme_typo_'. $target .'_font_size';
	$idlh = 'entex_theme_typo_'. $target .'_line_height';
	$html .=  '<h4 data-font-size="'. $idfs .'" data-line-height="'. $idlh .'">'. $text .'</h4>';
	$html .=  entex_template_output_preview_drop_cap();
	
	$target = 'preamble';
	$text = entex_template_output_preview_preamble();
	$idfs = 'entex_theme_typo_'. $target .'_font_size';
	$idlh = 'entex_theme_typo_'. $target .'_line_height';
	$html .=  '<p class="is-style-ua-preamble" data-font-size="'. $idfs .'" data-line-height="'. $idlh .'">'. $text .'</p>'; 
	
	$text = _x('Entex customizer preview paragraph heading not main', 'DO NOT TRANSLATE', 'entex');
	$target = 'h3';
	$idfs = 'entex_theme_typo_'. $target .'_font_size';
	$idlh = 'entex_theme_typo_'. $target .'_line_height';
	$html .=  '<h3 data-font-size="'. $idfs .'" data-line-height="'. $idlh .'">'. $text .'</h3>';
	$html .=  entex_template_output_preview_not_main_p();
	
	$text = _x('Entex customizer preview document heading not main', 'DO NOT TRANSLATE', 'entex');
	$target = 'h2';
	$idfs = 'entex_theme_typo_'. $target .'_font_size';
	$idlh = 'entex_theme_typo_'. $target .'_line_height';
	$html .=  '<h2 data-font-size="'. $idfs .'" data-line-height="'. $idlh .'">'. $text .'</h2>';
	$html .=  entex_template_output_preview_not_main_p();
	
	if(entex_theme_customize_has_extended_titles()){
	$text = _x('Entex customizer extended title preview', 'DO NOT TRANSLATE', 'entex');
	$target = 'h2_em';
	$idfs = 'entex_theme_typo_'. $target .'_font_size';
	$idlh = 'entex_theme_typo_'. $target .'_line_height';
	$extended = '<em data-font-size="'. $idfs .'" data-line-height="'. $idlh .'">'. $text .'</em>';
	
	$text = _x('Entex customizer extended title preview below', 'DO NOT TRANSLATE', 'entex');
	$extended_end = '<em>'. $text .'</em>';
	}
	
	$text = _x('Entex customizer preview entry heading not main', 'DO NOT TRANSLATE', 'entex');
	$target = 'h2_span';
	$idfs = 'entex_theme_typo_'. $target .'_font_size';
	$idlh = 'entex_theme_typo_'. $target .'_line_height';
	$html .=  '<h2 class="entry-heading" data-font-size="'. $idfs .'" data-line-height="'. $idlh .'"><a href="#">'. $extended .'<span>'. $text .'</span></a></h2>';
	$html .=  entex_template_output_preview_meta();
	$html .=  entex_template_output_preview_not_main_p();
	
	echo wp_kses_post($html);
	
}
add_action('entex_template_preview_not_main', 'entex_template_output_preview_not_main');

function entex_template_output_preview_main(){
	
	/* in case */
	if(!is_customize_preview()) return '';
	
	$text = _x('Entex customizer preview main', 'DO NOT TRANSLATE', 'entex');
	$target = 'h4';
	$idfs = 'entex_theme_typo_'. $target .'_font_size_main';
	$idlh = 'entex_theme_typo_'. $target .'_line_height_main';
	$html .=  '<h4 data-font-size="'. $idfs .'" data-line-height="'. $idlh .'">'. $text .'</h4>';
	$html .=  entex_template_output_preview_drop_cap();
	
	$target = 'preamble';
	$text = entex_template_output_preview_preamble();
	$idfs = 'entex_theme_typo_'. $target .'_font_size';
	$idlh = 'entex_theme_typo_'. $target .'_line_height';
	$html .=  '<p class="is-style-ua-preamble" data-font-size="'. $idfs .'" data-line-height="'. $idlh .'">'. $text .'</p>';
	
	$text = _x('Entex customizer preview paragraph heading main', 'DO NOT TRANSLATE', 'entex');
	$target = 'h3';
	$idfs = 'entex_theme_typo_'. $target .'_font_size_main';
	$idlh = 'entex_theme_typo_'. $target .'_line_height_main';
	$html .=  '<h3 data-font-size="'. $idfs .'" data-line-height="'. $idlh .'">'. $text .'</h3>';
	$html .=  entex_template_output_preview_main_p();
	
	$text = _x('Entex customizer preview document heading main', 'DO NOT TRANSLATE', 'entex');
	$target = 'h2';
	$idfs = 'entex_theme_typo_'. $target .'_font_size_main';
	$idlh = 'entex_theme_typo_'. $target .'_line_height_main';
	$html .=  '<h2 data-font-size="'. $idfs .'" data-line-height="'. $idlh .'">'. $text .'</h2>';
	$html .=  entex_template_output_preview_main_p();
	
	$text = _x('Entex customizer preview document heading containge extra content to compare linebreaks and latin characters', 'DO NOT TRANSLATE', 'entex');
	$html .=  '<h2>'. $text .'</h2>';
	$html .=  entex_template_output_preview_main_p();
	
	
	if(entex_theme_customize_has_extended_titles()){
	$text = _x('Entex customizer extended title preview', 'DO NOT TRANSLATE', 'entex');
	$target = 'h2_em';
	$idfs = 'entex_theme_typo_'. $target .'_font_size_main';
	$idlh = 'entex_theme_typo_'. $target .'_line_height_main';
	$extended = '<em data-font-size="'. $idfs .'" data-line-height="'. $idlh .'">'. $text .'</em>';
	
	$text = _x('Entex customizer extended title preview below', 'DO NOT TRANSLATE', 'entex');
	$extended_end = '<em>'. $text .'</em>';
	}
	
	$text = _x('Entex customizer preview entry heading main', 'DO NOT TRANSLATE', 'entex');
	$target = 'h2_span';
	$idfs = 'entex_theme_typo_'. $target .'_font_size_main';
	$idlh = 'entex_theme_typo_'. $target .'_line_height_main';
	$html .= '<h2 class="entry-heading" data-font-size="'. $idfs .'" data-line-height="'. $idlh .'"><a href="#">'. $extended .'<span>'. $text .'</span>'. $extended_end .'</a></h2>';
	$html .=  entex_template_output_preview_meta();
	$html .= entex_template_output_preview_main_p();
	
	echo wp_kses_post($html);
	
}
add_action('entex_template_preview_main', 'entex_template_output_preview_main');





/* -------------------- */
// CONTROLLER ARRAY SETTINGS

/**
 * TYPO is focused on the font settings
 * Units are mostly ment for font properties
 * Such as 'unit', that mainly ment to font-size 
 *
 * ALL ID prefix 'controller' added 
 * EX: 'controller_typo_h3_letter_spacing'
 *
**/

/**
IMPORTANT: Multiple selectors MUST keep the comma at the end of character LIKE: '#example-1 > p, #example-2 > p'
**/

function entex_theme_customize_register_data(){
	
	// -- OPTIONS -- //
	
	$panel = 'entex_panel_options';
	$priority = 10;
	
	$arr['options']['template']['label'] = esc_html_x('Template settings', 'Customizer', 'entex');
	$arr['options']['template']['selector'] = '';
	$arr['options']['template']['unit'] = '';
	$arr['options']['template']['panel-priority'] = $priority;
	$arr['options']['template']['in-master-panel'] = $panel;
	$arr['options']['template']['main'] = '';
	$arr['options']['template']['before'] = '';
	$arr['options']['template']['after'] = '';
	$arr['options']['template']['additional'] = '';
	$arr['options']['template']['remove'] = '';
	$arr['options']['template']['description'] = esc_html_x('Options are saved as Theme modifications and is unique for each child theme.', 'Customizer', 'entex');
	$arr['options']['template']['visibility'] = 'options';
	$arr['options']['template']['style'] = '';
	$arr['options']['template']['initial'] = '';
	$arr['options']['template']['responsive'] = '';
	$arr['options']['template']['desktop'] = '';
	
	
	
	
	// -- DESIGN -- //
	
	/* TYPO panels */
	/* ('entex_panel_master_typo') is auto-assigned if not overritten by 'in-master-panel' etc etc */
	
	$panel = 'entex_panel_master';
	$priority = 8;
	
	/* NOTE: using mixed targets */
	$arr['html']['html']['label'] = esc_html_x('Html settings', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['html']['html']['selector'] = 'html';
	$arr['html']['html']['unit'] = 'rem';
	$arr['html']['html']['panel-priority'] = $priority;
	$arr['html']['html']['in-master-panel'] = $panel;
	$arr['html']['html']['main'] = '';
	$arr['html']['html']['before'] = '';
	$arr['html']['html']['after'] = '';
	$arr['html']['html']['additional'] = '';
	$arr['html']['html']['remove'] = 'extended_display';
	$arr['html']['html']['description'] = esc_html_x('This is the main typographic font settings for the current theme.', 'Customizer', 'entex');
	$arr['html']['html']['visibility'] = 'typo';
	$arr['html']['html']['style'] = '[selector] { [property] : [value][unit] } ';
	$arr['html']['html']['initial'] = 'body, .ua-nav li li, figcaption, html > body .ua-not-main { [property] : [value][unit] } ';
	$arr['html']['html']['responsive'] = '@media screen and (min-width: 640px) and (max-width: 979px) { body, .ua-nav li li { [property] : [value][unit] } } ';
	$arr['html']['html']['desktop'] = '@media screen and (min-width: 980px) { .ua-main, .ua-main .ua-nav li li { [property] : [value][unit] } } ';
	
	$arr['body']['body']['label'] = esc_html_x('Body layout', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['body']['body']['selector'] = 'body';
	$arr['body']['body']['unit'] = '';
	$arr['body']['body']['panel-priority'] = $priority;
	$arr['body']['body']['in-master-panel'] = $panel;
	$arr['body']['body']['main'] = '';
	$arr['body']['body']['before'] = true;
	$arr['body']['body']['after'] = true;
	$arr['body']['body']['additional'] = '';
	$arr['body']['body']['remove'] = '__padding__';
	$arr['body']['body']['description'] = '';
	$arr['body']['body']['visibility'] = 'layout';
	$arr['body']['body']['style'] = '[selector] { [property] : [value][unit] } ';
	$arr['body']['body']['initial'] = '@media screen and (max-width: 639px) { [selector] { [property] : [value][unit] } } ';
	$arr['body']['body']['responsive'] = '@media screen and (min-width: 640px) { [selector] { [property] : [value][unit] } } ';
	$arr['body']['body']['desktop'] = '@media screen and (min-width: 980px) { [selector] { [property] : [value][unit] } } ';
	
	
	
	/* foreground_color tmp remove */
	$arr['typo']['drop_cap']['label'] = esc_html_x('Drop cap', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['typo']['drop_cap']['selector'] = '.has-drop-cap:not(:focus)::first-letter';
	$arr['typo']['drop_cap']['unit'] = 'rem';
	$arr['typo']['drop_cap']['panel-priority'] = $priority;
	$arr['typo']['drop_cap']['in-master-panel'] = $panel;
	$arr['typo']['drop_cap']['main'] = '';
	$arr['typo']['drop_cap']['before'] = '';
	$arr['typo']['drop_cap']['after'] = '';
	$arr['typo']['drop_cap']['additional'] = '';
	$arr['typo']['drop_cap']['remove'] = 'extended_display | text_align | foreground_color';
	$arr['typo']['drop_cap']['description'] = 'Drop caps should not be adjusted in Firefox browser, as the baseline adjustment is made by line-heigh, thats ignored by mozilla.';
	$arr['typo']['drop_cap']['visibility'] = 'typo';
	$arr['typo']['drop_cap']['style'] = '.entex-theme [selector] { [property] : [value][unit] } ';
	$arr['typo']['drop_cap']['initial'] = '.entex-theme [selector] { [property] : [value][unit] } html > body.entex-theme .ua-not-main [selector] { [property] : [value][unit] } ';
	$arr['typo']['drop_cap']['responsive'] = '@media screen and (min-width: 640px) and (max-width: 979px) { .entex-theme [selector] { [property] : [value][unit] } } ';
	$arr['typo']['drop_cap']['desktop'] = '@media screen and (min-width: 980px) { .entex-theme .ua-main [selector] { [property] : [value][unit] } } ';

	$priority = 10;
	
	$arr['layout']['header']['label'] = esc_html_x('Header', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['layout']['header']['selector'] = '#ua-id-header';
	$arr['layout']['header']['unit'] = '';
	$arr['layout']['header']['panel-priority'] = $priority;
	$arr['layout']['header']['in-master-panel'] = $panel;
	$arr['layout']['header']['main'] = '';
	$arr['layout']['header']['before'] = true;
	$arr['layout']['header']['after'] = false;
	$arr['layout']['header']['additional'] = '';
	$arr['layout']['header']['remove'] = 'width_clamp | padding_clamp | margin_all_visibility | margin_mobile_visibility';
	$arr['layout']['header']['description'] = '';
	$arr['layout']['header']['visibility'] = 'layout';
	$arr['layout']['header']['style'] = '[selector] { [property] : [value][unit] } ';
	$arr['layout']['header']['initial'] = '@media screen and (max-width: 639px) { [selector] { [property] : [value][unit] } } ';
	$arr['layout']['header']['responsive'] = '@media screen and (min-width: 640px) { [selector] { [property] : [value][unit] } } ';
	$arr['layout']['header']['desktop'] = '@media screen and (min-width: 980px) { [selector] { [property] : [value][unit] } } ';
	
	$arr['layout']['branding']['label'] = esc_html_x('Header branding', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['layout']['branding']['selector'] = '#ua-id-branding';
	$arr['layout']['branding']['unit'] = '';
	$arr['layout']['branding']['panel-priority'] = $priority;
	$arr['layout']['branding']['in-master-panel'] = $panel;
	$arr['layout']['branding']['main'] = array('grid-column' => '#ua-id-header-content > div');
	$arr['layout']['branding']['before'] = true;
	$arr['layout']['branding']['after'] = true;
	$arr['layout']['branding']['additional'] = '[entex_theme_layout_branding_header_settings_column] #ua-id-header-content > div { grid-row: 1; } @media screen and (max-width: 979px) { #ua-id-header-column { margin: 0.625rem; min-height: auto; } } @media (max-width: 410px) { #ua-id-header-column { margin: 0.313rem; } } | [entex_theme_layout_branding_center_content] #ua-branding-inner-wr { display: block; } | [entex_theme_layout_branding_margin_mobile_visibility] @media screen and (max-width: 639px) { html #ua-id-header-column { margin: 0px; } } | [entex_theme_layout_branding_margin_all_visibility] #ua-id-header-content { margin-top: 0px; margin-bottom: 0px; } .ua-branding-wr { margin: 0px; } html #ua-id-header-column { margin: 0px; } | [entex_theme_layout_branding_background_color_transparent] .ua-branding-wr { background: none; }';
	$arr['layout']['branding']['remove'] = 'width_clamp | padding_clamp | box_shadow_visibility';
	$arr['layout']['branding']['description'] = '';
	$arr['layout']['branding']['visibility'] = 'layout';
	$arr['layout']['branding']['style'] = '[selector] { [property] : [value][unit] } ';
	$arr['layout']['branding']['initial'] = '@media screen and (max-width: 639px) { [selector] { [property] : [value][unit] } } ';
	$arr['layout']['branding']['responsive'] = '@media screen and (min-width: 640px) { [selector] { [property] : [value][unit] } } ';
	$arr['layout']['branding']['desktop'] = '@media screen and (min-width: 980px) { [selector] { [property] : [value][unit] } } ';
	
	$arr['layout']['header_column']['label'] = esc_html_x('Header column', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['layout']['header_column']['selector'] = '.entex-theme #ua-id-header-column';
	$arr['layout']['header_column']['unit'] = '';
	$arr['layout']['header_column']['panel-priority'] = $priority;
	$arr['layout']['header_column']['in-master-panel'] = $panel;
	$arr['layout']['header_column']['main'] = '';
	$arr['layout']['header_column']['before'] = true;
	$arr['layout']['header_column']['after'] = false;
	$arr['layout']['header_column']['additional'] = '';
	$arr['layout']['header_column']['remove'] = 'width_clamp | padding_clamp | foreground_layout_text_shadow_color | line_height_layout | box_shadow_visibility';
	$arr['layout']['header_column']['description'] = 'This area is invisible as default but will always cover full height';
	$arr['layout']['header_column']['visibility'] = 'layout';
	$arr['layout']['header_column']['style'] = '[selector] { [property] : [value][unit] } ';
	$arr['layout']['header_column']['initial'] = '@media screen and (max-width: 639px) { [selector] { [property] : [value][unit] } } ';
	$arr['layout']['header_column']['responsive'] = '@media screen and (min-width: 640px) { [selector] { [property] : [value][unit] } } ';
	$arr['layout']['header_column']['desktop'] = '@media screen and (min-width: 980px) { [selector] { [property] : [value][unit] } } ';
	
	$arr['layout']['article_header']['label'] = esc_html_x('Article Header', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['layout']['article_header']['selector'] = '.wp-doc-article-header .ua-main #main-header-inner';
	$arr['layout']['article_header']['unit'] = '';
	$arr['layout']['article_header']['panel-priority'] = $priority;
	$arr['layout']['article_header']['in-master-panel'] = $panel;
	$arr['layout']['article_header']['main'] = '';
	$arr['layout']['article_header']['before'] = '';
	$arr['layout']['article_header']['after'] = '';
	$arr['layout']['article_header']['additional'] = '';
	$arr['layout']['article_header']['remove'] = 'width_clamp | padding_clamp | __border_layout__ | box_shadow_visibility | line_height_layout';
	$arr['layout']['article_header']['description'] = '';
	$arr['layout']['article_header']['visibility'] = 'layout';
	$arr['layout']['article_header']['style'] = '[selector] { [property] : [value][unit] } ';
	$arr['layout']['article_header']['initial'] = '@media screen and (max-width: 639px) { [selector] { [property] : [value][unit] } } ';
	$arr['layout']['article_header']['responsive'] = '@media screen and (min-width: 640px) { [selector] { [property] : [value][unit] } } ';
	$arr['layout']['article_header']['desktop'] = '@media screen and (min-width: 980px) { [selector] { [property] : [value][unit] } } ';
	

	$arr['layout']['footer']['label'] = esc_html_x('Footer', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['layout']['footer']['selector'] = '#ua-id-footer';
	$arr['layout']['footer']['unit'] = '';
	$arr['layout']['footer']['panel-priority'] = $priority;
	$arr['layout']['footer']['in-master-panel'] = $panel;
	$arr['layout']['footer']['main'] = '';
	$arr['layout']['footer']['before'] = true;
	$arr['layout']['footer']['after'] = true;
	$arr['layout']['footer']['additional'] = '';
	$arr['layout']['footer']['remove'] = 'width_clamp | padding_clamp | __padding_layout__ ';
	$arr['layout']['footer']['description'] = '';
	$arr['layout']['footer']['visibility'] = 'layout';
	$arr['layout']['footer']['style'] = '[selector] { [property] : [value][unit] } ';
	$arr['layout']['footer']['initial'] = '@media screen and (max-width: 639px) { [selector] { [property] : [value][unit] } } ';
	$arr['layout']['footer']['responsive'] = '@media screen and (min-width: 640px) { [selector] { [property] : [value][unit] } } ';
	$arr['layout']['footer']['desktop'] = '@media screen and (min-width: 980px) { [selector] { [property] : [value][unit] } } ';
	
	
	$arr['layout']['socle']['label'] = esc_html_x('Socle', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['layout']['socle']['selector'] = '#ua-id-socle';
	$arr['layout']['socle']['unit'] = '';
	$arr['layout']['socle']['panel-priority'] = $priority;
	$arr['layout']['socle']['in-master-panel'] = $panel;
	$arr['layout']['socle']['main'] = '';
	$arr['layout']['socle']['before'] = true;
	$arr['layout']['socle']['after'] = true;
	$arr['layout']['socle']['additional'] = '';
	$arr['layout']['socle']['remove'] = 'width_clamp | padding_clamp | __padding_layout__ | border_all_width | border_all_color | center_content | box_shadow_visibility | margin_all_visibility | margin_mobile_visibility  ';
	$arr['layout']['socle']['description'] = '';
	$arr['layout']['socle']['visibility'] = 'layout';
	$arr['layout']['socle']['style'] = '[selector] { [property] : [value][unit] } ';
	$arr['layout']['socle']['initial'] = '@media screen and (max-width: 639px) { [selector] { [property] : [value][unit] } } ';
	$arr['layout']['socle']['responsive'] = '@media screen and (min-width: 640px) { [selector] { [property] : [value][unit] } } ';
	$arr['layout']['socle']['desktop'] = '@media screen and (min-width: 980px) { [selector] { [property] : [value][unit] } } ';
	
	
	/* note: has initial, needs parent */
	$arr['layout']['site_logo']['label'] = esc_html_x('Site logo', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['layout']['site_logo']['selector'] = '.site-logo';
	$arr['layout']['site_logo']['unit'] = 'clamp';
	$arr['layout']['site_logo']['panel-priority'] = 10;
	$arr['layout']['site_logo']['in-master-panel'] = $panel;
	$arr['layout']['site_logo']['main'] = '';
	$arr['layout']['site_logo']['before'] = false;
	$arr['layout']['site_logo']['after'] = false;
	$arr['layout']['site_logo']['additional'] = '';
	$arr['layout']['site_logo']['remove'] = 'padding_all';
	$arr['layout']['site_logo']['description'] = '';
	$arr['layout']['site_logo']['visibility'] = 'layout';
	$arr['layout']['site_logo']['style'] = '.entex-theme [selector] { [property] : [value][unit] } ';
	$arr['layout']['site_logo']['initial'] = '@media screen and (max-width: 639px) { .entex-theme [selector] { [property] : [value][unit] } } ';
	$arr['layout']['site_logo']['responsive'] = '@media screen and (min-width: 640px) { .entex-theme [selector] { [property] : [value][unit] } } ';
	$arr['layout']['site_logo']['desktop'] = '@media screen and (min-width: 980px) { .entex-theme [selector] { [property] : [value][unit] } } ';
	
	
	$arr['typo']['site_title']['label'] = esc_html_x('Site title', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['typo']['site_title']['selector'] = '#ua-id-header .site-title';
	$arr['typo']['site_title']['unit'] = 'clamp';
	$arr['typo']['site_title']['panel-priority'] = $priority;
	$arr['typo']['site_title']['in-master-panel'] = $panel;
	$arr['typo']['site_title']['main'] = '';
	$arr['typo']['site_title']['before'] = '';
	$arr['typo']['site_title']['after'] = '';
	$arr['typo']['site_title']['additional'] = '';
	$arr['typo']['site_title']['remove'] = ''; // All 4 font controllers always removed on unit clamp
	$arr['typo']['site_title']['description'] = '';
	$arr['typo']['site_title']['visibility'] = 'typo';
	$arr['typo']['site_title']['style'] = '[selector] { [property] : [value][unit] } ';
	$arr['typo']['site_title']['initial'] = '@media screen and (max-width: 639px) { [selector] { [property] : [value][unit] } } ';
	$arr['typo']['site_title']['responsive'] = '';
	$arr['typo']['site_title']['desktop'] = '';
	
	$arr['typo']['site_description']['label'] = esc_html_x('Site description', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['typo']['site_description']['selector'] = '#ua-id-header .site-description';
	$arr['typo']['site_description']['unit'] = 'clamp';
	$arr['typo']['site_description']['panel-priority'] = $priority;
	$arr['typo']['site_description']['in-master-panel'] = $panel;
	$arr['typo']['site_description']['main'] = '';
	$arr['typo']['site_description']['before'] = '';
	$arr['typo']['site_description']['after'] = '';
	$arr['typo']['site_description']['additional'] = '';
	$arr['typo']['site_description']['remove'] = '__padding__'; // All 4 font controllers always removed on unit clamp
	$arr['typo']['site_description']['description'] = '';
	$arr['typo']['site_description']['visibility'] = 'typo';
	$arr['typo']['site_description']['style'] = '[selector] { [property] : [value][unit] } ';
	$arr['typo']['site_description']['initial'] = '@media screen and (max-width: 639px) { [selector] { [property] : [value][unit] } } ';
	$arr['typo']['site_description']['responsive'] = '';
	$arr['typo']['site_description']['desktop'] = '';
	
	
	$priority = 12;
	
	$arr['layout']['navigation']['label'] = esc_html_x('Navigation', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['layout']['navigation']['selector'] = '#ua-id-navigation, #ua-id-navigation-top';
	$arr['layout']['navigation']['unit'] = '';
	$arr['layout']['navigation']['panel-priority'] = $priority;
	$arr['layout']['navigation']['in-master-panel'] = $panel;
	$arr['layout']['navigation']['main'] = array('text-align' => '#ua-id-navigation .ua-grid-item-1 .ua-menu-mix', 'margin-top' => '#ua-id-navigation .ua-grid-item-2 .ua-menu-mix > ul > li > a, #ua-id-navigation .ua-menu-mix > ul > li:before, #ua-id-navigation-top .ua-menu-mix > ul > li:before', 'display' => '#ua-id-navigation .ua-grid-item-1 .ua-menu-mix > ul > li:before, #ua-id-navigation-top .ua-menu-mix > ul > li:before');
	$arr['layout']['navigation']['before'] = false; 
	$arr['layout']['navigation']['after'] = true;
	$arr['layout']['navigation']['additional'] = '';
	$arr['layout']['navigation']['remove'] = 'width_clamp | padding_clamp | margin_all_visibility | margin_mobile_visibility | border_mobile_visibility | border_all_width | border_all_color | padding_viewport | background_viewport';
	$arr['layout']['navigation']['description'] = 'Basic settings only for desktop view and applies on both main and top navigation. Read the documentation how to tune each navigation section and menues.';
	$arr['layout']['navigation']['visibility'] = 'layout';
	$arr['layout']['navigation']['style'] = '@media screen and (min-width: 980px) { [selector] { [property] : [value][unit] } } ';
	$arr['layout']['navigation']['initial'] = '';
	$arr['layout']['navigation']['responsive'] = '';
	$arr['layout']['navigation']['desktop'] = '';
	
	$priority = 13;
	
	$arr['typo']['nav_link_all']['label'] = esc_html_x('Navigation links', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['typo']['nav_link_all']['selector'] = '#ua-id-navigation .ua-grid-item-1 .ua-menu-mix > ul > li > a, #ua-id-navigation-top .ua-menu-mix > ul > li > a';
	$arr['typo']['nav_link_all']['unit'] = 'rem';
	$arr['typo']['nav_link_all']['panel-priority'] = $priority;
	$arr['typo']['nav_link_all']['in-master-panel'] = $panel;
	$arr['typo']['nav_link_all']['main'] = '';
	$arr['typo']['nav_link_all']['before'] = false; 
	$arr['typo']['nav_link_all']['after'] = false;
	$arr['typo']['nav_link_all']['additional'] = '';
	$arr['typo']['nav_link_all']['remove'] = 'font_size_initial | line_height_initial | extended_display';
	$arr['typo']['nav_link_all']['description'] = '';
	$arr['typo']['nav_link_all']['visibility'] = 'typo';
	$arr['typo']['nav_link_all']['style'] = '@media screen and (min-width: 980px) { [selector] { [property] : [value][unit] } } ';
	$arr['typo']['nav_link_all']['initial'] = '@media screen and (min-width: 980px) { [selector] { [property] : [value][unit] } } ';
	$arr['typo']['nav_link_all']['responsive'] = '';
	$arr['typo']['nav_link_all']['desktop'] = '@media screen and (min-width: 980px) { [selector] { [property] : [value][unit] } } ';
	
	$priority = 14;
	/*
	$arr['layout']['navigation_mobile']['label'] = esc_html_x('Navigation mobile', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['layout']['navigation_mobile']['selector'] = '#ua-id-navigation, #ua-id-navigation-top';
	$arr['layout']['navigation_mobile']['unit'] = '';
	$arr['layout']['navigation_mobile']['panel-priority'] = $priority;
	$arr['layout']['navigation_mobile']['in-master-panel'] = $panel;
	$arr['layout']['navigation_mobile']['main'] = '';
	$arr['layout']['navigation_mobile']['before'] = true;
	$arr['layout']['navigation_mobile']['after'] = false;
	$arr['layout']['navigation_mobile']['additional'] = '';
	$arr['layout']['navigation_mobile']['remove'] = 'width_clamp | padding_clamp | margin_all_visibility | margin_mobile_visibility | border_mobile_visibility | border_all_width | border_all_color | padding_viewport | padding_all ';
	$arr['layout']['navigation_mobile']['description'] = 'Basic settings only for mobile or tablet view and applies on both main and top navigation. Read the documentation how to tune each navigation section and menues.';
	$arr['layout']['navigation_mobile']['visibility'] = 'layout';
	$arr['layout']['navigation_mobile']['style'] = '@media screen and (max-width: 979px) { [selector] { [property] : [value][unit] } } ';
	$arr['layout']['navigation_mobile']['initial'] = '';
	$arr['layout']['navigation_mobile']['responsive'] = '';
	$arr['layout']['navigation_mobile']['desktop'] = '';
	*/
	
	$priority = 15;
	
	$arr['typo']['nav_link_all_mobile']['label'] = esc_html_x('Navigation links mobile', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['typo']['nav_link_all_mobile']['selector'] = '#ua-id-navigation .ua-grid-item-1 .ua-menu-mix > ul > li > a, #ua-id-navigation-top .ua-menu-mix > ul > li > a';
	$arr['typo']['nav_link_all_mobile']['unit'] = 'rem';
	$arr['typo']['nav_link_all_mobile']['panel-priority'] = $priority;
	$arr['typo']['nav_link_all_mobile']['in-master-panel'] = $panel;
	$arr['typo']['nav_link_all_mobile']['main'] = '';
	$arr['typo']['nav_link_all_mobile']['before'] = true; 
	$arr['typo']['nav_link_all_mobile']['after'] = true;
	$arr['typo']['nav_link_all_mobile']['additional'] = '';
	$arr['typo']['nav_link_all_mobile']['remove'] = 'min-width | font_size_initial | line_height_initial | extended_display | devider_visibility | devider_display | devider_hover_visibility | devider_active_visibility | _padding_removal_ ';
	$arr['typo']['nav_link_all_mobile']['description'] = '';
	$arr['typo']['nav_link_all_mobile']['visibility'] = 'typo';
	$arr['typo']['nav_link_all_mobile']['style'] = '@media screen and (max-width: 979px) { [selector] { [property] : [value][unit] } } ';
	$arr['typo']['nav_link_all_mobile']['initial'] = '@media screen and (max-width: 979px) { [selector] { [property] : [value][unit] } } ';
	$arr['typo']['nav_link_all_mobile']['responsive'] = '';
	$arr['typo']['nav_link_all_mobile']['desktop'] = '@media screen and (max-width: 979px) { [selector] { [property] : [value][unit] } } ';

	$priority = 20;
	
	/* note: has initial, needs parent */
	$arr['typo']['h1']['label'] = esc_html_x('Heading h1', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['typo']['h1']['selector'] = '.ua-main h1';
	$arr['typo']['h1']['unit'] = 'rem';
	$arr['typo']['h1']['panel-priority'] = $priority;
	$arr['typo']['h1']['in-master-panel'] = $panel;
	$arr['typo']['h1']['main'] = '';
	$arr['typo']['h1']['before'] = '';
	$arr['typo']['h1']['after'] = '';
	$arr['typo']['h1']['additional'] = '';
	$arr['typo']['h1']['remove'] = 'extended_display';
	$arr['typo']['h1']['description'] = esc_html_x('This is the global main heading for all pages, make the default settings here and make variations for extended headings.', 'Customizer', 'entex');
	$arr['typo']['h1']['visibility'] = 'typo';
	$arr['typo']['h1']['style'] = '.entex-theme [selector] { [property] : [value][unit] } ';
	$arr['typo']['h1']['initial'] = '@media screen and (max-width: 639px) { .entex-theme [selector] { [property] : [value][unit] } } ';
	$arr['typo']['h1']['responsive'] = '@media screen and (min-width: 640px) { .entex-theme [selector] { [property] : [value][unit] } } ';
	$arr['typo']['h1']['desktop'] = '';

	/* note: has initial, needs parent */
	$arr['typo']['h1_em']['label'] = esc_html_x('Heading h1 extended', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['typo']['h1_em']['selector'] = '.ua-main h1 > em';
	$arr['typo']['h1_em']['unit'] = 'rem';
	$arr['typo']['h1_em']['panel-priority'] = $priority;
	$arr['typo']['h1_em']['in-master-panel'] = $panel;
	$arr['typo']['h1_em']['main'] = '';
	$arr['typo']['h1_em']['before'] = '';
	$arr['typo']['h1_em']['after'] = '';
	$arr['typo']['h1_em']['additional'] = '';
	$arr['typo']['h1_em']['remove'] = '';
	$arr['typo']['h1_em']['description'] = esc_html_x('This is the global main extended heading for all pages and should be treated as independent. However, as it remains inside the main heading, it inherits all that parent properites as default. Make shure you override them all if necessary.', 'Customizer', 'entex');
	$arr['typo']['h1_em']['visibility'] = 'typo';
	$arr['typo']['h1_em']['style'] = '.entex-theme [selector] { [property] : [value][unit] } ';
	$arr['typo']['h1_em']['initial'] = '@media screen and (max-width: 639px) { .entex-theme [selector] { [property] : [value][unit] } } ';
	$arr['typo']['h1_em']['responsive'] = '@media screen and (min-width: 640px) { .entex-theme [selector] { [property] : [value][unit] } } ';
	$arr['typo']['h1_em']['desktop'] = '';
	
	/* note: has initial, needs parent */
	$arr['typo']['h2']['label'] = esc_html_x('Heading h2', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['typo']['h2']['selector'] = 'h2';
	$arr['typo']['h2']['unit'] = 'rem';
	$arr['typo']['h2']['panel-priority'] = $priority;
	$arr['typo']['h2']['in-master-panel'] = $panel;
	$arr['typo']['h2']['main'] = '';
	$arr['typo']['h2']['before'] = '';
	$arr['typo']['h2']['after'] = '';
	$arr['typo']['h2']['additional'] = '';
	$arr['typo']['h2']['remove'] = 'extended_display';
	$arr['typo']['h2']['description'] = esc_html_x('This is the main document content heading. This settings are inherited by Entry headings and Layered headlines. When editing, make shure you are monitoring the h2 heading in the document flow inside a singular page, not entry headings.', 'Customizer', 'entex');
	$arr['typo']['h2']['visibility'] = 'typo';
	$arr['typo']['h2']['style'] = '.entex-theme [selector] { [property] : [value][unit] } ';
	$arr['typo']['h2']['initial'] = '.entex-theme [selector] { [property] : [value][unit] } html > body.entex-theme .ua-not-main [selector] { [property] : [value][unit] } ';
	$arr['typo']['h2']['responsive'] = '@media screen and (min-width: 640px) and (max-width: 979px) { .entex-theme [selector] { [property] : [value][unit] } } ';
	$arr['typo']['h2']['desktop'] = '@media screen and (min-width: 980px) { .entex-theme .ua-main [selector] { [property] : [value][unit] } } ';
	
	/* note: has initial, needs parent */
	$arr['typo']['h2_span']['label'] = esc_html_x('Heading h2 Entries', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['typo']['h2_span']['selector'] = '.entry-heading';
	$arr['typo']['h2_span']['unit'] = 'rem';
	$arr['typo']['h2_span']['panel-priority'] = $priority;
	$arr['typo']['h2_span']['in-master-panel'] = $panel;
	$arr['typo']['h2_span']['main'] = '';
	$arr['typo']['h2_span']['before'] = '';
	$arr['typo']['h2_span']['after'] = '';
	$arr['typo']['h2_span']['additional'] = '';
	$arr['typo']['h2_span']['remove'] = '';
	$arr['typo']['h2_span']['description'] = esc_html_x('This is the entry heading font properties and overrides the parent h2 settings. It is recommended to customize the original document heading first, and apply the final values for this element later.', 'Customizer', 'entex');
	$arr['typo']['h2_span']['visibility'] = 'typo';
	$arr['typo']['h2_span']['style'] = '.entex-theme [selector] { [property] : [value][unit] } ';
	$arr['typo']['h2_span']['initial'] = '@media screen and (max-width: 639px) { .entex-theme [selector] { [property] : [value][unit] } } html > body.entex-theme .ua-not-main [selector] { [property] : [value][unit] } ';
	$arr['typo']['h2_span']['responsive'] = '@media screen and (min-width: 640px) and (max-width: 979px) { .entex-theme [selector] { [property] : [value][unit] } } ';
	$arr['typo']['h2_span']['desktop'] = '@media screen and (min-width: 980px) { .entex-theme .ua-main [selector] { [property] : [value][unit] } } ';
	
	if(entex_theme_customize_has_extended_titles()){
		/* note: has initial, needs parent */
		$arr['typo']['h2_em']['label'] = esc_html_x('Heading h2 Entries extended', 'Panel heading: DO NOT TRANSLATE', 'entex');
		$arr['typo']['h2_em']['selector'] = '.entry-heading em';
		$arr['typo']['h2_em']['unit'] = 'rem';
		$arr['typo']['h2_em']['panel-priority'] = $priority;
		$arr['typo']['h2_em']['in-master-panel'] = $panel;
		$arr['typo']['h2_em']['main'] = '';
		$arr['typo']['h2_em']['before'] = '';
		$arr['typo']['h2_em']['after'] = '';
		$arr['typo']['h2_em']['additional'] = '';
		$arr['typo']['h2_em']['remove'] = '';
		$arr['typo']['h2_em']['description'] = esc_html_x('This is the extended entry heading font properties and overrides the parent h2 settings', 'Customizer', 'entex');
		$arr['typo']['h2_em']['visibility'] = 'typo';
		$arr['typo']['h2_em']['style'] = '.entex-theme [selector] { [property] : [value][unit] } ';
		$arr['typo']['h2_em']['initial'] = '@media screen and (max-width: 639px) { .entex-theme [selector] { [property] : [value][unit] } } html > body.entex-theme .ua-not-main [selector] { [property] : [value][unit] } ';
		$arr['typo']['h2_em']['responsive'] = '@media screen and (min-width: 640px) and (max-width: 979px) { .entex-theme [selector] { [property] : [value][unit] } } ';
		$arr['typo']['h2_em']['desktop'] = '@media screen and (min-width: 980px) { .entex-theme .ua-main [selector] { [property] : [value][unit] } } ';
	}
	
	/* note: has initial, needs parent */
	$arr['typo']['h3']['label'] = esc_html_x('Heading h3', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['typo']['h3']['selector'] = 'h3';
	$arr['typo']['h3']['unit'] = 'rem';
	$arr['typo']['h3']['panel-priority'] = $priority;
	$arr['typo']['h3']['in-master-panel'] = $panel;
	$arr['typo']['h3']['main'] = '';
	$arr['typo']['h3']['before'] = '';
	$arr['typo']['h3']['after'] = '';
	$arr['typo']['h3']['additional'] = '';
	$arr['typo']['h3']['remove'] = 'extended_display';
	$arr['typo']['h3']['description'] = '';
	$arr['typo']['h3']['visibility'] = 'typo';
	$arr['typo']['h3']['style'] = '.entex-theme [selector] { [property] : [value][unit] } ';
	$arr['typo']['h3']['initial'] = '.entex-theme [selector] { [property] : [value][unit] } html > body.entex-theme .ua-not-main [selector] { [property] : [value][unit] } ';
	$arr['typo']['h3']['responsive'] = '@media screen and (min-width: 640px) and (max-width: 979px) { .entex-theme [selector] { [property] : [value][unit] } } ';
	$arr['typo']['h3']['desktop'] = '@media screen and (min-width: 980px) { .entex-theme .ua-main [selector] { [property] : [value][unit] } } ';
	
	$priority = 30;
	
	/* note: has initial, needs parent */
	$arr['typo']['h4']['label'] = esc_html_x('Devider h4', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['typo']['h4']['selector'] = 'h4';
	$arr['typo']['h4']['unit'] = 'rem';
	$arr['typo']['h4']['panel-priority'] = $priority;
	$arr['typo']['h4']['in-master-panel'] = $panel;
	$arr['typo']['h4']['main'] = '';
	$arr['typo']['h4']['before'] = '';
	$arr['typo']['h4']['after'] = '';
	$arr['typo']['h4']['additional'] = '';
	$arr['typo']['h4']['remove'] = 'font_size_main | line_height_main | extended_display | __color__ | __padding__ ';
	$arr['typo']['h4']['description'] = '';
	$arr['typo']['h4']['visibility'] = 'typo';
	$arr['typo']['h4']['style'] = '.entex-theme [selector] { [property] : [value][unit] } ';
	$arr['typo']['h4']['initial'] = '.entex-theme [selector] { [property] : [value][unit] } ';
	$arr['typo']['h4']['responsive'] = '.entex-theme [selector] { [property] : [value][unit] } ';
	
	$priority = 32;
	
	$arr['typo']['h4']['desktop'] = '';
	
	$arr['layout']['h4_layout']['label'] = esc_html_x('Devider h4 layout', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['layout']['h4_layout']['selector'] = 'h4';
	$arr['layout']['h4_layout']['unit'] = '';
	$arr['layout']['h4_layout']['panel-priority'] = $priority;
	$arr['layout']['h4_layout']['in-master-panel'] = $panel;
	$arr['layout']['h4_layout']['main'] = '';
	$arr['layout']['h4_layout']['before'] = true;
	$arr['layout']['h4_layout']['after'] = true;
	$arr['layout']['h4_layout']['additional'] = '';
	$arr['layout']['h4_layout']['remove'] = 'width_clamp | padding_clamp | box_shadow_visibility | margin_all_visibility | margin_mobile_visibility';
	$arr['layout']['h4_layout']['description'] = '';
	$arr['layout']['h4_layout']['visibility'] = 'layout';
	$arr['layout']['h4_layout']['style'] = '.entex-theme [selector] { [property] : [value][unit] } ';
	$arr['layout']['h4_layout']['initial'] = '.entex-theme [selector] { [property] : [value][unit] } ';
	$arr['layout']['h4_layout']['responsive'] = '.entex-theme [selector] { [property] : [value][unit] } ';
	$arr['layout']['h4_layout']['desktop'] = '';
	
	$priority = 40;
	
	/* note: has initial, needs parent */
	$arr['typo']['preamble']['label'] = esc_html_x('Preamble', 'Panel heading: DO NOT TRANSLATE', 'entex');
	$arr['typo']['preamble']['selector'] = 'p.is-style-ua-preamble';
	$arr['typo']['preamble']['unit'] = 'rem';
	$arr['typo']['preamble']['panel-priority'] = $priority;
	$arr['typo']['preamble']['in-master-panel'] = $panel;
	$arr['typo']['preamble']['main'] = '';
	$arr['typo']['preamble']['before'] = '';
	$arr['typo']['preamble']['after'] = '';
	$arr['typo']['preamble']['additional'] = '';
	$arr['typo']['preamble']['remove'] = 'extended_display';
	$arr['typo']['preamble']['description'] = '';
	$arr['typo']['preamble']['visibility'] = 'typo';
	$arr['typo']['preamble']['style'] = '.entex-theme [selector] { [property] : [value][unit] } ';
	$arr['typo']['preamble']['initial'] = '.entex-theme [selector] { [property] : [value][unit] } html > body.entex-theme .ua-not-main [selector] { [property] : [value][unit] } ';
	$arr['typo']['preamble']['responsive'] = '@media screen and (min-width: 640px) and (max-width: 979px) { .entex-theme [selector] { [property] : [value][unit] } } ';
	$arr['typo']['preamble']['desktop'] = '@media screen and (min-width: 980px) { .entex-theme .ua-main [selector] { [property] : [value][unit] } } ';
	
	/* filter */
	$arr = apply_filters('entex_theme_customize_controls', $arr);
	
	return $arr;
}





/* -------------------- */
// COLLECT SAVED COLORS
/* This collects colors from this theme stylesheet */
/* And store them as Theme mod to be presented in the customizer color control palette */
/* Each time a new custom color is added in the customizer */
/* The collection merge them into the Theme mod */

function entex_fn_init_collect_theme_customizer_colors(){

	$colors = entex_fn_collect_theme_customizer_colors();
	$colors_customizer = apply_filters('entex_collected_customizer_colors', $colors);
	
	if(defined('ENTEX_THEME_CUSTOMIZER_READ_DEFAULT_STYLESHEET')){
		
		$colors = entex_fn_collect_theme_stylesheet_colors();
		$colors_stylesheet = apply_filters('entex_collected_stylesheet_colors', $colors);
		if($colors_stylesheet){
			$remove = array_merge(preg_grep("/0,0,0,/", $colors_stylesheet), preg_grep("/255,255,255,/", $colors_stylesheet));
			$remove = apply_filters('entex_remove_collected_stylesheet_colors', $remove, $colors_stylesheet);
			if(!empty($remove)) $colors_stylesheet = array_diff($colors_stylesheet, $remove);
		}
		$name = 'entex_theme_colors_stylesheet';
		if(!empty($colors_stylesheet)) set_theme_mod($name, implode(',', $colors_stylesheet));
		
	} else {
		
		if(!defined('ENTEX_THEME_CUSTOMIZER_HIDE_DEFAULT_STYLESHEET')){
			$name = 'entex_theme_colors_stylesheet';
			$value = get_theme_mod($name, '');
			if($value){
				$colors_stylesheet = explode(',', $value);
			}
		}
	}
	
	if(!empty($colors_stylesheet)){
		
		/* add marker to alpha controller javascript */
		/* reads the palette without background-color inline style applied */
		/* In that case we can split into separate palettes */
		
		if(!empty($colors_customizer)){
			$colors_customizer[] = ''; 
			$GLOBALS['ENTEX-CUSTOMIZER-ALL-COLORS'] = array_unique(array_merge($colors_customizer, $colors_stylesheet));
		} else {
			$GLOBALS['ENTEX-CUSTOMIZER-ALL-COLORS'] = array_unique($colors_stylesheet);
		}
		
	} else if(!empty($colors_customizer)){
		$GLOBALS['ENTEX-CUSTOMIZER-ALL-COLORS'] = array_unique($colors_customizer);
	}
	//$GLOBALS['ENTEX-CUSTOMIZER-ALL-COLORS'] = apply_filters('entex_customizer_cc_color_palette', $GLOBALS['ENTEX-CUSTOMIZER-ALL-COLORS']);
}
add_action('customize_register', 'entex_fn_init_collect_theme_customizer_colors', -5);


function entex_fn_collect_theme_customizer_colors(){
	
	$colors = array();
	$mods = get_theme_mods();
	if(empty($mods)) return $colors;
	
	$value_matches = array('#', 'rgb');
	
	foreach($mods as $key => $value){

		if(!$value || is_array($value)) continue;
		$check = false;
		foreach($value_matches as $match){
			if(strpos($value, $match) !== FALSE) $check = true;
		}
		if(!$check) continue;
		if(strpos($value, '#') !== FALSE && strlen($value) < 5) $value .= substr($value, -3);
		
		if(strpos($key, 'background_color') !== FALSE){
			$colors[] = $value;
			$GLOBALS['ENTEX-CUSTOMIZER-COLORS'][] = $value;
		} else if(strpos($key, '_color') !== FALSE){
			$colors[] = $value;
			$GLOBALS['ENTEX-CUSTOMIZER-BACKGROUND-COLORS'][] = $value;
		}
	}
	return $colors;
}

function entex_fn_collect_theme_stylesheet_colors($drop = false){
	
	$file = get_template_directory_uri() .'/assets/ua-css/ua-default-stylesheet.css';
	$stylesheet_content = file_get_contents($file);
	if(!$stylesheet_content) return;
	
	$property = 'color';
	$value_matches = array('#', 'rgb');
	
	$colors = entex_fn_values_from_stylesheet($stylesheet_content, $property, $value_matches);
	return $colors;
}

function entex_fn_values_from_stylesheet($stylesheet_content, $property, $value_matches = false, $return_result = false){

	$css = preg_match_all('/(?ims)([a-z0-9\s\,\.\:#_\-@]+)\{([^\}]*)\}/', $stylesheet_content, $arr);

	$result = array();
	$property_values = array();
	
	foreach($arr[0] as $i => $x){
		$selector = trim($arr[1][$i]);
		$rules = explode(';', trim($arr[2][$i]));
		$result[$selector] = array();
		foreach($rules as $strRule){
			if(!empty($strRule)){
				$rule = explode(':', $strRule);
				if(!$rule[0] || !trim($rule[0])) continue;
				if(!$rule[1] || !trim($rule[1])) continue;
				$result[$selector][][trim($rule[0])] = trim($rule[1]);
				
				$value = trim($rule[1]);
				/* shorthand hex-color adjustment */
				if(strpos($value, '#') !== FALSE && strlen($value) < 5) $value .= substr($value, -3);
				
				if(strpos($rule[0], $property) !== FALSE){
					if(!empty($value_matches)){
						foreach($value_matches as $match){
							if(strpos($value, $match) !== FALSE) $property_values[] = trim(str_replace(' !important', '', $value));
						}
					} else {
						$property_values[] = trim(str_replace(' !important', '', $value));
					}
				}
			}
		}
	}
	
	if(!empty($value_matches) && !empty($property_values)){
		$property_values = array_unique($property_values);
	}

	if($return_result) return $result;
		else return $property_values;
}

/* ******************** */
// END COLLECT COLORS



// -- END FILE -- //