<?php if(!defined('ABSPATH')) die();
/**
 * Entex theme customize actions
 *
 * @package Entex
 * @subpackage Entex
 * @version 2.11122
 *
 * 
**/
/**
 * Actions are filtered in by the panels 
 * Most by _layout_ and _typo_ panels
 * as they act as base controller set for most selectors
 * Bevare to keep the targets apart from each other
 * Like:
 * $id = 'entex_theme_typo_'. $_TARGET ...
 * $id = 'entex_theme_layout_'. $_TARGET ...
 * Specially when copy and paste
**/

/* -------------------- */
// CONTROLLER SET

function entex_theme_customize_controllers_background_button($wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority){

	if($data['before'] || $data['after']){
		
	/* Button show / hide options */
	/* Button example: */
	// TARGET CSS: ul.entex-button-control-toggle-typo-is-active > li[id*="entex_theme_typo"] { display: none; }
	// TARGET CSS: ul.entex-button-control-toggle-typo-is-active > li[id*="entex_theme_layout"] { display: block; }
	// NOTE: make shure the button controller id NOT match the CSS rules for hide och show 
	
	/* note: [] */
	/* we only need this once */
	if($_TARGET == 'body') $GLOBALS['ENTEX-CUSTOMIZER-ADD-INLINE-STYLE'][] = 'ul[id*=panel_body].entex-button-control-hide-background-is-active > li[id*=_root_background_filter] ~ li[id*=background] { display: none !important; }';
		else $GLOBALS['ENTEX-CUSTOMIZER-ADD-INLINE-STYLE'][] = 'ul[id*=panel_'. $_TARGET .'].entex-button-control-hide-background-is-active > li[id*=background] { display: none !important; }';
	
	/* setting not doing anything */
	$id = 'entex_theme_button_'. $_TARGET .'_devider';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'sanitize_text_field'));
	
	/* we just wanna render a button */
	$wp_customize->add_control(
		new entex_customize_button_control(
			$wp_customize, 
			$id, array(
				'label' => esc_html_x('Hide background options', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'label_passive' => esc_html_x('Hide background options', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'label_active' => esc_html_x('Show background options', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'key' => 'hide-background',
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	} // END if has before or after
	
}
add_action('entex_theme_customize_register_panel_body_priority_2', 'entex_theme_customize_controllers_background_button', 10, 6);
add_action('entex_theme_customize_register_panel_header_priority_20', 'entex_theme_customize_controllers_background_button', 10, 6);
add_action('entex_theme_customize_register_panel_footer_priority_20', 'entex_theme_customize_controllers_background_button', 10, 6);
add_action('entex_theme_customize_register_panel_socle_priority_20', 'entex_theme_customize_controllers_background_button', 10, 6);
add_action('entex_theme_customize_register_panel_branding_priority_20', 'entex_theme_customize_controllers_background_button', 10, 6);
add_action('entex_theme_customize_register_panel_navigation_priority_20', 'entex_theme_customize_controllers_background_button', 10, 6);
add_action('entex_theme_customize_register_panel_header_column_priority_20', 'entex_theme_customize_controllers_background_button', 10, 6);
add_action('entex_theme_customize_register_panel_h4_layout_priority_20', 'entex_theme_customize_controllers_background_button', 10, 6);
add_action('entex_theme_customize_register_panel_nav_link_all_mobile_priority_20', 'entex_theme_customize_controllers_background_button', 10, 6);

function entex_theme_customize_controllers_background($wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority){
	
	/* As controllers are identical we loop them through */

	if($data['before']) $loop['_before'] = ' before';
	if($data['after']) $loop['_after'] = ' after';
	if(empty($loop)) $loop['element'] = '';

	foreach($loop as $_pseudo => $text){
	
		/* maybe skip all instead */
		if($_pseudo == 'element') continue;
	
		if($_pseudo == 'element') $_pseudo = '';
		if(!$text) $text = '';
	
	
	// HEADING
	$id = 'entex_theme_layout_'. $_TARGET .'_space_backgrounds'.$_pseudo;
	$wp_customize->add_setting($id, array('default' => '','sanitize_callback' => 'sanitize_text_field'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				/* translators: */
				'label' => sprintf(esc_html_x('Background %s', 'Customizer data: DO NOT TRANSLATE', 'entex'), $text),
				'description' => '',
				'border' => 30,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET viewport */
	
	if(strpos($data['remove'], 'background_viewport') === FALSE){
	if($_pseudo == '_after') $label = _X('Only apply background settings on desktop view', 'Customizer data: DO NOT TRANSLATE', 'entex');
		else $label = esc_html_x('Do not apply background settings on mobile view', 'Customizer data: DO NOT TRANSLATE', 'entex');
	$id = 'entex_theme_layout_'. $_TARGET . $_pseudo .'_background_viewport';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => $label,
			'section' => 'entex_panel_'.$_TARGET,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	}
	
	
	/* TARGET z-index */
	
	if(strpos($data['remove'], 'z_index_background') === FALSE){
	$id = 'entex_theme_layout_'. $_TARGET . $_pseudo .'_z_index_background';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Remove layer index if exsist', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('Layer is behind background color as default, to shine throgh if background is alpha. Use this checkbox to bring in front.', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	}
	
	/* TARGET background color */

	$id = 'entex_theme_layout_'. $_TARGET . $_pseudo .'_background_color_pseudo';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability'  => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize,
			$id,
			array(
				/* translators: */
				'label' 		=> sprintf(esc_html_x('Background color %s', 'Customizer data: DO NOT TRANSLATE', 'entex'), $text),
				'description'   => '',
				'section'       => $_PANEL,
				'settings'      => $id,
				'priority' 		=> $priority,
				'show_opacity'  => true, 
				'palette'	=> entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	

	/* TARGET background image */
	
	$id = 'entex_theme_layout_'. $_TARGET . $_pseudo .'_background_image_pseudo';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'esc_url_raw'));
	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize, 
			$id,
			array(
				/* translators: */
				'label' => sprintf(esc_html_x('Background image %s', 'Customizer data: DO NOT TRANSLATE', 'entex'), $text),
				'description' => '',
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET background image visibility */
	
	$id = 'entex_theme_layout_'. $_TARGET . $_pseudo .'_background_image_visibility';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'type' => 'checkbox',
			'label' => esc_html_x('Hide background image', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('Allow you to keep but ignore image settings', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority
		)
	);
	
	
	/* TARGET background image size */
	
	$id = 'entex_theme_layout_'. $_TARGET . $_pseudo .'_background_image_size';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'sanitize_text_field'));
	$wp_customize->add_control($id,
		array(
			'type' => 'select',
			/* translators: */
			'label' => sprintf(esc_html_x('Background image size %s', 'Customizer data: DO NOT TRANSLATE', 'entex'), $text),
			'description' => '',
			'section' => $_PANEL,
			'priority' => $priority,
			'choices' => entex_customizer_cc_select_background_size()
		)
	);
	
	
	/* TARGET background image repeat */
	
	$id = 'entex_theme_layout_'. $_TARGET . $_pseudo .'_background_image_repeat';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'sanitize_text_field'));
	$wp_customize->add_control($id,
		array(
			'type' => 'select',
			/* translators: */
			'label' => sprintf(esc_html_x('Background image repeat %s', 'Customizer data: DO NOT TRANSLATE', 'entex'), $text),
			'description' => '',
			'section' => $_PANEL,
			'priority' => $priority,
			'choices' => entex_customizer_cc_select_background_repeat()
		)
	);
	

	/* TARGET background image position */
	
	$id = 'entex_theme_layout_'. $_TARGET . $_pseudo .'_background_image_position_choices';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'sanitize_text_field'));
	$wp_customize->add_control($id,
		array(
			'type' => 'select',
			/* translators: */
			'label' => sprintf(esc_html_x('Background image position %s', 'Customizer data: DO NOT TRANSLATE', 'entex'), $text),
			'description' => esc_html_x('If background size is set to cover, positions are limited', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'choices' => entex_customizer_cc_select_background_position()
		)
	);
	
	
	/* TARGET background image position pixels */
		
	$id = 'entex_theme_layout_'. $_TARGET . $_pseudo .'_background_image_position_value_pixels';
	$wp_customize->add_setting($id, array('default' => -1, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				/* translators: */
				'label'	=> sprintf(esc_html_x('BG side position (px) %s', 'Customizer data: DO NOT TRANSLATE', 'entex'), $text),
				'description' => esc_html_x('Suitable for no repeated backgrounds, position forced from left', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'min' => -1,
				'max' => 300,
				'step' => 1,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET background image position top percent */
		
	$id = 'entex_theme_layout_'. $_TARGET . $_pseudo .'_background_image_position_value_percent_top';
	$wp_customize->add_setting($id, array('default' => -1, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				/* translators: */
				'label'	=> sprintf(esc_html_x('BG top posistion (percent) %s', 'Customizer data: DO NOT TRANSLATE', 'entex'), $text),
				'description' => esc_html_x('Suitable for adjust covered background vertically, position forced from center', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'min' => -1,
				'max' => 100,
				'step' => 0.5,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET background image position left percent */
		
	$id = 'entex_theme_layout_'. $_TARGET . $_pseudo .'_background_image_position_value_percent_left';
	$wp_customize->add_setting($id, array('default' => -1, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				/* translators: */
				'label'	=> sprintf(esc_html_x('BG side position (percent) %s', 'Customizer data: DO NOT TRANSLATE', 'entex'), $text),
				'description' => esc_html_x('Suitable for adjust start positions on large backgrounds, position forced from left', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'min' => -1,
				'max' => 100,
				'step' => 0.5,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET background image opacity */

	$id = 'entex_theme_layout_'. $_TARGET . $_pseudo .'_background_opacity';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				/* translators: */
				'label'	=> sprintf(esc_html_x('Background opacity %s', 'Customizer data: DO NOT TRANSLATE', 'entex'), $text),
				'break' => false,
				'min' => 0,
				'max' => 1,
				'step' => 0.05,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	/* TARGET background image filter grayscale */

	$id = 'entex_theme_layout_'. $_TARGET . $_pseudo .'_background_filter_grayscale';
	$wp_customize->add_setting($id, array('default' => -0.05, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				/* translators: */
				'label'	=> sprintf(esc_html_x('Background Grayscale %s', 'Customizer data: DO NOT TRANSLATE', 'entex'), $text),
				'break' => false,
				'min' => -0.05,
				'max' => 1,
				'step' => 0.05,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	} // END $loop
	
}
add_action('entex_theme_customize_register_panel_body_priority_50', 'entex_theme_customize_controllers_background', 10, 6);
add_action('entex_theme_customize_register_panel_header_priority_50', 'entex_theme_customize_controllers_background', 10, 6);
add_action('entex_theme_customize_register_panel_footer_priority_50', 'entex_theme_customize_controllers_background', 10, 6);
add_action('entex_theme_customize_register_panel_socle_priority_50', 'entex_theme_customize_controllers_background', 10, 6);
add_action('entex_theme_customize_register_panel_branding_priority_50', 'entex_theme_customize_controllers_background', 10, 6);
add_action('entex_theme_customize_register_panel_navigation_priority_50', 'entex_theme_customize_controllers_background', 10, 6);
add_action('entex_theme_customize_register_panel_navigation_mobile_priority_50', 'entex_theme_customize_controllers_background', 10, 6);
add_action('entex_theme_customize_register_panel_header_column_priority_50', 'entex_theme_customize_controllers_background', 10, 6);
add_action('entex_theme_customize_register_panel_h4_layout_priority_50', 'entex_theme_customize_controllers_background', 10, 6);
add_action('entex_theme_customize_register_panel_nav_link_all_mobile_priority_50', 'entex_theme_customize_controllers_background', 10, 6);

/* ******************** */
// END: CONTROLLER SET





/* -------------------- */
// TEMPATE HEADER OUTPUT
// NOTE: Those are using action inside 'entex_theme_customize_wp_head_' action
// Compare to those using: 'entex_theme_customize_controllers_wp_head_'
// We want them to render in correct context and order on front end

function entex_theme_output_data_controllers_background($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	$_SELECTOR = $data['selector'];
	$_MULTIPLE = '';
	if(strpos($_SELECTOR, ',') !== FALSE) $_MULTIPLE = $_SELECTOR;
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	
	/* As controllers are identical we loop them through */

	if($data['before']) $loop['_before'] = ':before';
	if($data['after']) $loop['_after'] = ':after';
	if(empty($loop)) return;

	foreach($loop as $add_id => $pseudo){
	
	if($_MULTIPLE) $_SELECTOR = str_replace(',', $pseudo .',', $_MULTIPLE);

	/* viewporter */
	$add_query = '';
	$name = 'entex_theme_layout_'. $_TARGET . $add_id .'_background_viewport';
	$viewporter = get_theme_mod($name, 0);
	if($viewporter) $add_query = ($add_id == '_after' ? $data['desktop'] : $data['responsive']);
	
	/* TARGET z-index removes transparent background order */
	if(strpos($data['remove'], 'z_index_background') === FALSE){
	$name = 'entex_theme_layout_'. $_TARGET . $add_id .'_z_index_background';
	$value = get_theme_mod($name, 0);
	$value = $value ? 'auto' : '';
	if($value){
		$replacement = array($_SELECTOR . $pseudo, 'z-index', $value, '');
		$style = str_replace($match, $replacement, ($viewporter ? $add_query : $data['style']));
		entex_ECOUT($_TARGET, $name, $style);
	}
	}
	
	/* TARGET background color */
	$name = 'entex_theme_layout_'. $_TARGET . $add_id .'_background_color_pseudo';
	$value = get_theme_mod($name, '');
	if($value){
		$replacement = array($_SELECTOR . $pseudo, 'background-color', $value, '');
		$style = str_replace($match, $replacement, ($viewporter ? $add_query : $data['style']));
		entex_ECOUT($_TARGET, $name, $style);
	}

	/* TARGET background image */
	$name = 'entex_theme_layout_'. $_TARGET . $add_id .'_background_image_pseudo';
	$image = get_theme_mod($name, 0);
	$value = $image ? 'url('.$image.')' : '';
	if($value){
		$replacement = array($_SELECTOR . $pseudo, 'background-image', $value, '');
		$style = str_replace($match, $replacement, ($viewporter ? $add_query : $data['style']));
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET background image visibility */
	$name = 'entex_theme_layout_'. $_TARGET . $add_id .'_background_image_visibility';
	$value = get_theme_mod($name, 0);
	if($value){
		$value = 'none';
		$replacement = array($_SELECTOR . $pseudo, 'background-image', $value, ' !important');
		$style = str_replace($match, $replacement, ($viewporter ? $add_query : $data['style']));
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET background image position */
	$name = 'entex_theme_layout_'. $_TARGET . $add_id .'_background_image_position_choices';
	$value = get_theme_mod($name, '');
	if($value){
		$replacement = array($_SELECTOR . $pseudo, 'background-position', $value, '');
		$style = str_replace($match, $replacement, ($viewporter ? $add_query : $data['style']));
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET background image position pixels */
	$name = 'entex_theme_layout_'. $_TARGET . $add_id .'_background_image_position_value_pixels';
	$value = get_theme_mod($name, -1);
	if($value < 0) $value = 0;
	if($value){
		$value = $value .'px 0px';
		$replacement = array($_SELECTOR . $pseudo, 'background-position', $value, '');
		$style = str_replace($match, $replacement, ($viewporter ? $add_query : $data['style']));
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET background image position left percent */
	$name = 'entex_theme_layout_'. $_TARGET . $add_id .'_background_image_position_value_percent_top';
	$value = get_theme_mod($name, -1);
	if($value < 0) $value = 0;
	if($value){
		$value = 'center '. $value .'%';
		$replacement = array($_SELECTOR . $pseudo, 'background-position', $value, '');
		$style = str_replace($match, $replacement, ($viewporter ? $add_query : $data['style']));
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET background image position left percent */
	$name = 'entex_theme_layout_'. $_TARGET . $add_id .'_background_image_position_value_percent_left';
	$value = get_theme_mod($name, -1);
	if($value < 0) $value = 0;
	if($value){
		$value = $value .'% 0%';
		$replacement = array($_SELECTOR . $pseudo, 'background-position', $value, '');
		$style = str_replace($match, $replacement, ($viewporter ? $add_query : $data['style']));
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET background image size */
	$name = 'entex_theme_layout_'. $_TARGET . $add_id .'_background_image_size';
	$value = get_theme_mod($name, '');
	if($value){
		$replacement = array($_SELECTOR . $pseudo, 'background-size', $value, '');
		$style = str_replace($match, $replacement, ($viewporter ? $add_query : $data['style']));
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET background image repeat */
	$name = 'entex_theme_layout_'. $_TARGET . $add_id .'_background_image_repeat';
	$value = get_theme_mod($name, '');
	if($value){
		$replacement = array($_SELECTOR . $pseudo, 'background-repeat', $value, '');
		$style = str_replace($match, $replacement, ($viewporter ? $add_query : $data['style']));
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET background opacity */
	$name = 'entex_theme_layout_'. $_TARGET . $add_id .'_background_opacity';
	$value = get_theme_mod($name, 0);
	if($value == 1 || $value < 0.01) $value = 0;
	if($value){
		$replacement = array($_SELECTOR . $pseudo, 'opacity', $value, '');
		$style = str_replace($match, $replacement, ($viewporter ? $add_query : $data['style']));
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET background filter */
	$name = 'entex_theme_layout_'. $_TARGET . $add_id .'_background_filter_grayscale';
	$value = get_theme_mod($name, 0);
	if($value < 0.05) $value = 0;
	if($value){
		$replacement = array($_SELECTOR . $pseudo, 'filter', 'grayscale('. $value .')', '');
		$style = str_replace($match, $replacement, ($viewporter ? $add_query : $data['style']));
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	} // END LOOP
	
	
}
// NOTE: THOSE ARE FILTERED IN BY WP_HEAD PANEL ACTION, not as everything else in this document...
add_action('entex_theme_customize_controllers_wp_head_body', 'entex_theme_output_data_controllers_background', 10, 2);
add_action('entex_theme_customize_controllers_wp_head_header', 'entex_theme_output_data_controllers_background', 10, 2);
add_action('entex_theme_customize_controllers_wp_head_footer', 'entex_theme_output_data_controllers_background', 10, 2);
add_action('entex_theme_customize_controllers_wp_head_socle', 'entex_theme_output_data_controllers_background', 10, 2);
add_action('entex_theme_customize_controllers_wp_head_branding', 'entex_theme_output_data_controllers_background', 10, 2);
add_action('entex_theme_customize_controllers_wp_head_navigation', 'entex_theme_output_data_controllers_background', 10, 2);
add_action('entex_theme_customize_controllers_wp_head_header_column', 'entex_theme_output_data_controllers_background', 10, 2);
add_action('entex_theme_customize_controllers_wp_head_h4_layout', 'entex_theme_output_data_controllers_background', 10, 2);
add_action('entex_theme_customize_controllers_wp_head_nav_link_all_mobile', 'entex_theme_output_data_controllers_background', 10, 2);



// -- END FILE -- //