<?php if(!defined('ABSPATH')) die();
/**
 * Entex theme customize actions
 *
 * @package Entex
 * @subpackage Entex
 * @updated 2.20930
 *
 * 
**/
/**
 * Actions are filtered in by the panels 
 * Most by _layout_ and _typo_ panels
 * as they act as base controller set for most selectors
 * Bevare to keep the targets apart from each other
 * Like:
 * $id = 'entex_theme_typo_'. $_TARGET ...
 * $id = 'entex_theme_layout_'. $_TARGET ...
 * Specially when copy and paste
**/


function entex_theme_customize_controllers_class_ua_set_invert($wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority){
	
	/* TARGET classname us-set-invert */ // inverted as default
	
	if(strpos($data['remove'], 'set_invert') === FALSE){
		$id = 'entex_theme_layout_'. $_TARGET .'_set_invert';
		$wp_customize->add_setting($id, array('default' => 1, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
		$wp_customize->add_control($id,
			array(
				'label' => esc_html_x('Invert colors', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => esc_html_x('This will add the classname ua-set-invert to the socle root element. Manual style adjustments might be needed depending on current widget settings inside the socle.', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'section' => $_PANEL,
				'priority' => $priority,
				'type' => 'checkbox'
			)
		);
	}
}
add_action('entex_theme_customize_register_panel_socle_priority_20', 'entex_theme_customize_controllers_class_ua_set_invert', 20, 6);



	
function entex_theme_customize_controllers_menu_expander($wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority){
	
	
	// HEADING
	$id = 'entex_theme_layout_'. $_TARGET .'_space_menu_expander';
	$wp_customize->add_setting($id, array('default' => '','sanitize_callback' => 'sanitize_text_field'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				/* translators: */
				'label' => sprintf(esc_html_x('Menu expander', 'Customizer data: DO NOT TRANSLATE', 'entex'), $_LABEL),
				'description' => esc_html_x('Never visible on desktop screen', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'border' => 30,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);

	/* TARGET filter: invert() */
	
	if(strpos($data['remove'], 'filter_invert') === FALSE){
		$id = 'entex_theme_layout_'. $_TARGET .'_filter_invert';
		$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
		$wp_customize->add_control($id,
			array(
				'label' => esc_html_x('Invert button colors', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'section' => $_PANEL,
				'priority' => $priority,
				'type' => 'checkbox'
			)
		);
	}
	
	
	/* TARGET opacity */

	$id = 'entex_theme_layout_'. $_TARGET .'_opacity';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				/* translators: */
				'label'	=> esc_html_x('Opacity', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => esc_html_x('Has always full opacity on active', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'break' => false,
				'min' => 0,
				'max' => 1,
				'step' => 0.05,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
}
add_action('entex_theme_customize_register_panel_branding_priority_80', 'entex_theme_customize_controllers_menu_expander', 20, 6);



function entex_theme_output_data_controllers_menu_expander($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	$_SELECTOR = $data['selector'];
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	
	
	/* TARGET filter invert (em) */
	
	if(strpos($data['remove'], 'filter_invert') === FALSE){
		$_THIS_SELECTOR = '#ua-nav-expander';
		$name = 'entex_theme_layout_'. $_TARGET .'_filter_invert';
		$value = get_theme_mod($name, 0);
		if($value){
			
			$value = 'invert()';
			$property = 'filter';
			$unit = '';
			$additional = entex_customize_get_additional($_TARGET, $name, $data);
			$replacement = entex_customize_get_replacement($_THIS_SELECTOR, $property, $value, $unit, $data);
			
			$style = str_replace($match, $replacement, $data['style'].$additional);
			entex_ECOUT($_TARGET, $name, $style);
		}
	}
	
	/* TARGET opacity */
	$_THIS_SELECTOR = '#ua-nav-expander';
	$name = 'entex_theme_layout_'. $_TARGET .'_opacity';
	$value = get_theme_mod($name, 0);
	if($value < 0.01) $value = 0;
	if($value){

		$property = 'opacity';
		$unit = '';
		$additional = entex_customize_get_additional($_TARGET, $name, $data);
		$replacement = entex_customize_get_replacement($_THIS_SELECTOR, $property, $value, $unit, $data);
			
		$style = str_replace($match, $replacement, $data['style'].$additional);
		entex_ECOUT($_TARGET, $name, $style);
	}
}
add_action('entex_theme_customize_wp_head_branding', 'entex_theme_output_data_controllers_menu_expander', 20, 2);


add_filter('entex_layout_controller_label_filter_invert_branding', function($label){
	return esc_html_x('Invert navigation expander', 'Customizer label: DO NOT TRANSLATE', 'entex');
}, 10, 1);


function entex_theme_customize_controllers_filter_invert($wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority){
	

	/* TARGET filter: invert() */
	
	if(strpos($data['remove'], 'filter_invert') === FALSE){
		$id = 'entex_theme_layout_'. $_TARGET .'_filter_invert';
		$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
		$wp_customize->add_control($id,
			array(
				'label' => apply_filters('entex_layout_controller_label_filter_invert_'. $_TARGET, esc_html_x('Invert', 'Customizer data: DO NOT TRANSLATE', 'entex')),
				'description' => apply_filters('entex_layout_controller_description_filter_invert_'. $_TARGET, ''),
				'section' => $_PANEL,
				'priority' => $priority,
				'type' => 'checkbox'
			)
		);
	}
	
}


function entex_theme_output_data_controllers_filter_invert($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	$_SELECTOR = $data['selector'];
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	
	
	/* TARGET filter invert (em) */
	
	if(strpos($data['remove'], 'filter_invert') === FALSE){
		$name = 'entex_theme_layout_'. $_TARGET .'_filter_invert';
		$value = get_theme_mod($name, 0);
		if($value){
			$value = 'invert()';
			$property = 'filter';
			$unit = '';
			$additional = entex_customize_get_additional($_TARGET, $name, $data);
			$replacement = entex_customize_get_replacement($_SELECTOR, $property, $value, $unit, $data);
			
			$style = str_replace($match, $replacement, $data['style'].$additional);
			entex_ECOUT($_TARGET, $name, $style);
		}
	}
}



// SPECIAL CASE
/* The branding layout panel has Theme based column settings */

function entex_theme_customize_controllers_header_settings($wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority){
	

	/* TARGET Header settings: grid-column / grid-row  */
	
	$id = 'entex_theme_layout_'. $_TARGET .'_header_settings_column';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Set branding full width', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('This will also set the header column as layer on branding area', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	/* viewporter */
	$id = 'entex_theme_layout_'. $_TARGET .'_header_settings_column_viewport';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Set branding full width on mobile view only', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('Set branding full width above must be active', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => 'entex_panel_'.$_TARGET,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	
	/* TARGET opacity */

	$id = 'entex_theme_layout_'. $_TARGET .'_device_opacity';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				/* translators: */
				'label'	=> esc_html_x('Header column opacity', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => esc_html_x('Mobile and Tablet screen sizes only. Use Header column panel to adjust this layer on all sizes.', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'break' => false,
				'min' => 0,
				'max' => 1,
				'step' => 0.05,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
}
add_action('entex_theme_customize_register_panel_branding_priority_20', 'entex_theme_customize_controllers_header_settings', 5, 6);


function entex_theme_output_data_controllers_header_settings($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	$_SELECTOR = $data['selector'];
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	$data['device'] = '@media screen and (max-width: 979px) { [selector] { [property] : [value][unit] } } ';
	
	/* TARGET Header settings: grid-column / grid-row  */

	$name = 'entex_theme_layout_'. $_TARGET .'_header_settings_column';
	$viewporter = get_theme_mod($name.'_viewport', 0);
	$value = get_theme_mod($name, 0);
	if($value){
		$value = '1/4';
		$property = 'grid-column';
		$unit = '';
		$additional = entex_customize_get_additional($_TARGET, $name, $data);
		$replacement = entex_customize_get_replacement($_SELECTOR, $property, $value, $unit, $data);

		$style = str_replace($match, $replacement, ($viewporter ? $data['device'] : $data['style']).$additional);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET desktop opacity */
	$name = 'entex_theme_layout_'. $_TARGET .'_device_opacity';
	$value = get_theme_mod($name, 0);
	if($value < 0.01) $value = 0;
	if($value){

		$property = 'opacity';
		$unit = '';
		$additional = entex_customize_get_additional($_TARGET, $name, $data);
		$replacement = entex_customize_get_replacement('.entex-theme #ua-id-header-column', $property, $value, $unit, $data);
			
		$style = str_replace($match, $replacement, $data['device'].$additional);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
}
add_action('entex_theme_customize_wp_head_branding', 'entex_theme_output_data_controllers_header_settings', 10, 2);




// MIN-HEIGHT

function entex_theme_customize_controllers_min_height($wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority){
	

	/* TARGET min-height (em) */
	
	$id = 'entex_theme_layout_'. $_TARGET .'_min_height';
	$wp_customize->add_setting($id, array('default' => '-0.1', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Min height (em)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => esc_html_x('The column has no height as default in mobile view', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'break' => false,
				'monitor' => true,
				'min' => -0.1,
				'max' => 20,
				'step' => 0.1,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	/* viewporter */
	/*
	$id = 'entex_theme_layout_'. $_TARGET .'_min_height_viewport';
	$wp_customize->add_setting($id, array('default' => 0, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Apply on mobile view only', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => 'entex_panel_'.$_TARGET,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	*/
	
}
add_action('entex_theme_customize_register_panel_header_column_priority_20', 'entex_theme_customize_controllers_min_height', 10, 6);


function entex_theme_output_data_controllers_min_height($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	$_SELECTOR = $data['selector'];
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	$data['device'] = '@media screen and (max-width: 979px) { [selector] { [property] : [value][unit] } } ';
	
	
	/* TARGET min-height */

	$name = 'entex_theme_layout_'. $_TARGET .'_min_height';
	$viewporter = true; //get_theme_mod($name.'_viewport', 0);
	$value = get_theme_mod($name, -0.1);
	if($value < 0) $value = null;
	if($value != null){
		$replacement = array($_SELECTOR, 'min-height', $value, 'em');
		$style = str_replace($match, $replacement, ($viewporter ? $data['device'] : $data['style']));
		entex_ECOUT($_TARGET, $name, $style);
	}

}
add_action('entex_theme_customize_wp_head_header_column', 'entex_theme_output_data_controllers_min_height', 10, 2);



// MIN-WIDTH
/* not on mobile links panel */

function entex_theme_customize_controllers_min_width($wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority){
	

	/* TARGET min-width (em) */
	
	$id = 'entex_theme_layout_'. $_TARGET .'_min_width';
	$wp_customize->add_setting($id, array('default' => '-0.1', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Link min-width (em)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => esc_html_x('Bevare of small screen on large menues', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'break' => false,
				'monitor' => true,
				'min' => -0.1,
				'max' => 20,
				'step' => 0.1,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
}
add_action('entex_theme_customize_register_panel_nav_link_all_priority_50', 'entex_theme_customize_controllers_min_width', 5, 6);


function entex_theme_output_data_controllers_min_width($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	$_SELECTOR = $data['selector'];
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	
	/* TARGET min-width */

	$name = 'entex_theme_layout_'. $_TARGET .'_min_width';
	$value = get_theme_mod($name, -0.1);
	if($value < 0) $value = null;
	if($value != null){
		$replacement = array($_SELECTOR, 'min-width', $value, 'em');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}

}
add_action('entex_theme_customize_wp_head_nav_link_all', 'entex_theme_output_data_controllers_min_width', 5, 2);





// MARGIN-TOP

function entex_theme_customize_controllers_margin_top($wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority){
	

	/* TARGET margin-top (em) */
	
	if(strpos($data['remove'], 'margin_top') === FALSE){
		$id = 'entex_theme_layout_'. $_TARGET .'_margin_top';
		$wp_customize->add_setting($id, array('default' => -0.25, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
		$wp_customize->add_control(
			new entex_customize_range_control(
				$wp_customize, 
				$id, array(
					'label'	=> esc_html_x('Margin top (em)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
					'description' => '',
					'break' => false,
					'monitor' => true,
					'min' => -0.25,
					'max' => 5,
					'step' => 0.25,
					'section' => $_PANEL,
					'priority' => $priority
				)
			)
		);
	}
	
}
//add_action('entex_theme_customize_register_panel_article_header_priority_60', 'entex_theme_customize_controllers_margin_top', 5, 6);


function entex_theme_output_data_controllers_margin_top($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	$_SELECTOR = $data['selector'];
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	
	
	/* TARGET margin_top (em) */
	
	if(strpos($data['remove'], 'margin_top') === FALSE){
		$name = 'entex_theme_layout_'. $_TARGET .'_margin_top';
		$value = get_theme_mod($name, -0.1);
		if($value < 0) $value = null;
		if($value != null){
			
			$property = 'margin-top';
			$unit = 'em';
			$additional = entex_customize_get_additional($_TARGET, $name, $data);
			$replacement = entex_customize_get_replacement($_SELECTOR, $property, $value, $unit, $data);
			
			$style = str_replace($match, $replacement, $data['style'].$additional);
			entex_ECOUT($_TARGET, $name, $style);
		}
	}
}
//add_action('entex_theme_customize_wp_head_article_header', 'entex_theme_output_data_controllers_margin_top', 5, 2);


// MARGIN-BOTTOM (DESKTOP)

function entex_theme_customize_controllers_margin_bottom_desktop($wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority){
	

	/* TARGET margin_bottom_desktop (em) */

	if(strpos($data['remove'], 'margin_bottom_desktop') === FALSE){
		$id = 'entex_theme_layout_'. $_TARGET .'_margin_bottom_desktop';
		$wp_customize->add_setting($id, array('default' => -0.25, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
		$wp_customize->add_control(
			new entex_customize_range_control(
				$wp_customize, 
				$id, array(
					'label'	=> esc_html_x('Margin bottom Desktop (em)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
					'description' => '',
					'break' => false,
					'monitor' => true,
					'min' => -0.25,
					'max' => 5,
					'step' => 0.25,
					'section' => $_PANEL,
					'priority' => $priority
				)
			)
		);
	}
	
}
add_action('entex_theme_customize_register_panel_article_header_priority_60', 'entex_theme_customize_controllers_margin_bottom_desktop', 5, 6);


function entex_theme_output_data_controllers_margin_bottom_desktop($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	$_SELECTOR = $data['selector'];
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	
	
	/* TARGET margin_bottom_desktop (em) */

	if(strpos($data['remove'], 'margin_bottom_desktop') === FALSE){

		$name = 'entex_theme_layout_'. $_TARGET .'_margin_bottom_desktop';
		$value = get_theme_mod($name, -0.1);
		if($value < 0) $value = null;
		if($value != null){
			
			$property = 'margin-bottom';
			$unit = 'em';
			$additional = entex_customize_get_additional($_TARGET, $name, $data);
			$replacement = entex_customize_get_replacement($_SELECTOR, $property, $value, $unit, $data);
			
			$style = str_replace($match, $replacement, $data['desktop'].$additional);
			entex_ECOUT($_TARGET, $name, $style);
		}
	}

}
add_action('entex_theme_customize_wp_head_article_header', 'entex_theme_output_data_controllers_margin_bottom_desktop', 5, 2);


// NOT IN USE YET
// EXTENDED PSEUDO COLORS

function entex_theme_customize_controllers_pseudo_colors($wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority){
	
	/* TARGET color:hover */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_foreground_hover_color';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability' => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize, $id,
			array(
				/* translators: */
				'label' => sprintf(esc_html_x('Link color hover', 'Customizer data: DO NOT TRANSLATE', 'entex'), $_LABEL),
				'section' => $_PANEL,
				'priority' => $priority,
				'settings' => $id,
				'show_opacity' => true, 
				'palette' => entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	
	
	/* TARGET color:active */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_foreground_active_color';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability' => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize, $id,
			array(
				/* translators: */
				'label' => sprintf(esc_html_x('Link color active', 'Customizer data: DO NOT TRANSLATE', 'entex'), $_LABEL),
				'section' => $_PANEL,
				'priority' => $priority,
				'settings' => $id,
				'show_opacity' => true, 
				'palette' => entex_customizer_cc_background_color_palette_default()
			)
		)
	);

	
	
}


function entex_theme_output_data_controllers_pseudo_colors($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	$_SELECTOR = $data['selector'];
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	
	
	/* TARGET hover color (value) */
	
	$name = 'entex_theme_typo_'. $_TARGET .'_foreground_hover_color';
	$value = get_theme_mod($name, 0);
	if($value){
		$replacement = array($_SELECTOR, 'color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	/* TARGET active color (value) */
	
	$name = 'entex_theme_typo_'. $_TARGET .'_foreground_active_color';
	$value = get_theme_mod($name, 0);
	if($value){
		$replacement = array($_SELECTOR, 'color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
}






// PADDING RIGHT LEFT (typo)

function entex_theme_customize_controllers_padding_right_left($wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority){
	

	/* TARGET padding-right */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_padding_right';
	$wp_customize->add_setting($id, array('default' => -0.25, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Padding right (em)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'break' => false,
				'monitor' => true,
				'min' => -0.25,
				'max' => 3,
				'step' => 0.25,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET padding-left */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_padding_left';
	$wp_customize->add_setting($id, array('default' => -0.25, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Padding left (em)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'monitor' => true,
				'min' => -0.25,
				'max' => 3,
				'step' => 0.25,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
}
add_action('entex_theme_customize_register_panel_nav_link_all_priority_80', 'entex_theme_customize_controllers_padding_right_left', 10, 6);
add_action('entex_theme_customize_register_panel_nav_link_all_mobile_priority_80', 'entex_theme_customize_controllers_padding_right_left', 10, 6);
add_action('entex_theme_customize_register_panel_h4_layout_priority_80', 'entex_theme_customize_controllers_padding_right_left', 10, 6);

function entex_theme_output_data_controllers_padding_right_left($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	$_SELECTOR = $data['selector'];
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	

	/* TARGET padding-right (em) */

	$name = 'entex_theme_typo_'. $_TARGET .'_padding_right';
	$value = get_theme_mod($name, -0.25);
	if($value < 0) $value = null;
	if($value != null){
		$replacement = array($_SELECTOR, 'padding-right', $value, 'em');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}

	
	/* TARGET padding-left (em) */

	$name = 'entex_theme_typo_'. $_TARGET .'_padding_left';
	$value = get_theme_mod($name, -0.25);
	if($value < 0) $value = null;
	if($value != null){
		$replacement = array($_SELECTOR, 'padding-left', $value, 'em');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
}
add_action('entex_theme_customize_wp_head_nav_link_all', 'entex_theme_output_data_controllers_padding_right_left', 10, 2);
add_action('entex_theme_customize_wp_head_nav_link_all_mobile', 'entex_theme_output_data_controllers_padding_right_left', 10, 2);
add_action('entex_theme_customize_wp_head_h4_layout', 'entex_theme_output_data_controllers_padding_right_left', 10, 2);


// PADDING REMOVAL RIGHT LEFT (typo)
/* Not in mobile panel */

function entex_theme_customize_controllers_padding_removal_right_left($wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority){
	

	// HEADING
	$id = 'entex_theme_typo_'. $_TARGET .'_space_padding_removal_right_left';
	$wp_customize->add_setting($id, array('default' => '','sanitize_callback' => 'sanitize_text_field'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				/* translators: */
				'label' => sprintf(esc_html_x('Padding removal', 'Customizer data: DO NOT TRANSLATE', 'entex'), $_LABEL),
				'description' => esc_html_x('Padding removal is active by default. Use this if padding is applied from customizer controllers.', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'border' => 30,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	/* TARGET padding removal left */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_padding_removal_left';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('First link padding left removal', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	
	/* TARGET padding removal right */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_padding_removal_right';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Last link padding right removal', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
}
add_action('entex_theme_customize_register_panel_nav_link_all_priority_80', 'entex_theme_customize_controllers_padding_removal_right_left', 11, 6);



function entex_theme_output_data_controllers_padding_removal_right_left($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	$_SELECTOR = $data['selector'];
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	

	/* TARGET padding removal right */

	$name = 'entex_theme_typo_'. $_TARGET .'_padding_removal_right';
	$value = get_theme_mod($name, 0);
	if($value){
		$value = '0';
		$selector = str_replace('li > a', 'li:last-child > a', $_SELECTOR);
		$replacement = array($selector, 'padding-right', $value, 'px');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}

	
	/* TARGET padding removal left */

	$name = 'entex_theme_typo_'. $_TARGET .'_padding_removal_left';
	$value = get_theme_mod($name, 0);
	if($value){
		$value = '0';
		$selector = str_replace('li > a', 'li:first-child > a', $_SELECTOR);
		$replacement = array($selector, 'padding-left', $value, 'px');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
}
add_action('entex_theme_customize_wp_head_nav_link_all', 'entex_theme_output_data_controllers_padding_removal_right_left', 11, 2);



// LINK DEVIDERS

function entex_theme_customize_controllers_link_deviders($wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority){
	
	// HEADING
	$id = 'entex_theme_layout_'. $_TARGET .'_space_all_deviders';
	$wp_customize->add_setting($id, array('default' => '','sanitize_callback' => 'sanitize_text_field'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				/* translators: */
				'label' => sprintf(esc_html_x('Deviders %s', 'Customizer data: DO NOT TRANSLATE', 'entex'), $_LABEL),
				'description' => '',
				'border' => 30,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET Link ALL deviders margin-top (px) */

	$id = 'entex_theme_layout_'. $_TARGET .'_margin_deviders_all_top';
	$wp_customize->add_setting($id, array('default' => -1, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Devider adjustment (px)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'break' => false,
				'monitor' => true,
				'min' => -1,
				'max' => 30,
				'step' => 1,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET Link ALL deviders color */
	// Special case, the color property is occupied by the selector, we cant use the main array to temporary change selector by property
	// As this action is ment for link parent containers (navigations)
	// We force this target to always add the selector hard coded
	
	$id = 'entex_theme_layout_'. $_TARGET .'_foreground_deviders_all_color';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability' => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize, $id,
			array(
				/* translators: */
				'label' => sprintf(esc_html_x('Devider color', 'Customizer data: DO NOT TRANSLATE', 'entex'), $_LABEL),
				'section' => $_PANEL,
				'priority' => $priority,
				'settings' => $id,
				'show_opacity' => true, 
				'palette' => entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	
	/* TARGET Link ALL deviders display */
	
	$id = 'entex_theme_layout_'. $_TARGET .'_margin_deviders_all_display';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Remove all deviders', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
}
add_action('entex_theme_customize_register_panel_navigation_priority_50', 'entex_theme_customize_controllers_link_deviders', 5, 6);


function entex_theme_output_data_controllers_link_deviders($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	$_SELECTOR = $data['selector'];
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	
	
	/* TARGET Link ALL deviders margin-top (px) */

	$name = 'entex_theme_layout_'. $_TARGET .'_margin_deviders_all_top';
	$value = get_theme_mod($name, -0.1);
	if($value < 0) $value = null;
	if($value != null){
		if(isset($data['main']['margin-top'])) $replacement = array($data['main']['margin-top'], 'margin-top', $value, 'px');
			else $replacement = array($_SELECTOR, 'margin-top', $value, 'px');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	

	/* TARGET Link ALL deviders color */
	// Special case, the color property is occupied by the selector, we cant use the main array to temporary change selector by property
	// As this action is ment for link parent containers (navigations)
	// We force this target to always add the selector hard coded
	// However, if target is the global navigation, we must manually remove the right seconday manually
	
	$name = 'entex_theme_layout_'. $_TARGET .'_foreground_deviders_all_color';
	$value = get_theme_mod($name, 0);
	if($value){
		if($_TARGET == 'navigation') $_THIS_SELECTOR = str_replace(',', ' .ua-menu-mix:not(.ua-grid-item-2 .ua-menu-mix) > ul > li:before,', $_SELECTOR). ' .ua-menu-mix:not(.ua-grid-item-2 .ua-menu-mix) > ul > li:before';
			else $_THIS_SELECTOR = str_replace(',', ' .ua-menu-mix > ul > li:before,', $_SELECTOR). ' .ua-menu-mix > ul > li:before';
		$replacement = array($_THIS_SELECTOR, 'color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	/* TARGET Link ALL deviders display */
	
	$name = 'entex_theme_layout_'. $_TARGET .'_margin_deviders_all_display';
	$value = get_theme_mod($name, 0);
	if($value){
		$value = 'none';
		if(isset($data['main']['display'])) $replacement = array($data['main']['display'], 'display', $value, '');
			else $replacement = array($_SELECTOR, 'display', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}

}
add_action('entex_theme_customize_wp_head_navigation', 'entex_theme_output_data_controllers_link_deviders', 10, 2);




// -- EXTENDED LINK CONTROLLERS -- //
/* Keep Late priority (30) */

function entex_theme_customize_controllers_links($wp_customize, $_TARGET, $data, $_LABEL, $_PANEL, $priority){
	
	
	// NOTE foreground color already in typo panel 
	
	/* TARGET background color */ // - typo -
	
	$id = 'entex_theme_typo_'. $_TARGET .'_background_color_value';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability'  => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize,
			$id,
			array(
				'label' 		=> esc_html_x('Background color', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description'   => '',
				'section'       => $_PANEL,
				'settings'      => $id,
				'priority' 		=> $priority,
				'show_opacity'  => true, 
				'palette'	=> entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	
	
	/* TARGET border-top-width */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_border_top_width';
	$wp_customize->add_setting($id, array('default' => -1, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Border top width (px)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'monitor' => true,
				'min' => -1,
				'max' => 10,
				'step' => 1,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET border-bottom-width */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_border_bottom_width';
	$wp_customize->add_setting($id, array('default' => -1, 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_default'));
	$wp_customize->add_control(
		new entex_customize_range_control(
			$wp_customize, 
			$id, array(
				'label'	=> esc_html_x('Border bottom width (px)', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'monitor' => true,
				'min' => -1,
				'max' => 10,
				'step' => 1,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	/* TARGET border color */ // - typo -
	
	$id = 'entex_theme_typo_'. $_TARGET .'_border_color_value';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability'  => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize,
			$id,
			array(
				'label' 		=> esc_html_x('Border color', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description'   => '',
				'section'       => $_PANEL,
				'settings'      => $id,
				'priority' 		=> $priority,
				'show_opacity'  => true, 
				'palette'	=> entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	
	
	/* TARGET devider visibility */
	
	if(strpos($data['remove'], 'devider_visibility') === FALSE){
		$id = 'entex_theme_typo_'. $_TARGET .'_devider_visibility';
		$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
		$wp_customize->add_control($id,
			array(
				'label' => esc_html_x('Hide all deviders', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'section' => $_PANEL,
				'priority' => $priority,
				'type' => 'checkbox'
			)
		);
	}
	
	
	/* TARGET devider display */
	
	if(strpos($data['remove'], 'devider_display') === FALSE){
		$id = 'entex_theme_typo_'. $_TARGET .'_devider_display';
		$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
		$wp_customize->add_control($id,
			array(
				'label' => esc_html_x('Remove all deviders', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'section' => $_PANEL,
				'priority' => $priority,
				'type' => 'checkbox'
			)
		);
	}
	
	
	/* TARGET filter: invert() */
	
	if(strpos($data['remove'], 'filter_invert') === FALSE){
		$id = 'entex_theme_typo_'. $_TARGET .'_filter_invert';
		$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
		$wp_customize->add_control($id,
			array(
				'label' => esc_html_x('Invert link icon', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'section' => $_PANEL,
				'priority' => $priority,
				'type' => 'checkbox'
			)
		);
	}
	
	
	
	
	// HOVER
	
	// HEADING HOVER
	$id = 'entex_theme_typo_'. $_TARGET .'_space_hover_links';
	$wp_customize->add_setting($id, array('default' => '','sanitize_callback' => 'sanitize_text_field'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				/* translators: */
				'label' => sprintf(esc_html_x('Hover settings', 'Customizer data: DO NOT TRANSLATE', 'entex'), $_LABEL),
				'description' => '',
				'border' => 30,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	/* TARGET color:hover */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_foreground_hover_color';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability' => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize, $id,
			array(
				/* translators: */
				'label' => sprintf(esc_html_x('Link color hover', 'Customizer data: DO NOT TRANSLATE', 'entex'), $_LABEL),
				'section' => $_PANEL,
				'priority' => $priority,
				'settings' => $id,
				'show_opacity' => true, 
				'palette' => entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	
	
	/* TARGET background color:hover  */ // - typo -
	
	$id = 'entex_theme_typo_'. $_TARGET .'_background_hover_color_value';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability'  => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize,
			$id,
			array(
				'label' 		=> esc_html_x('Background color hover', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description'   => '',
				'section'       => $_PANEL,
				'settings'      => $id,
				'priority' 		=> $priority,
				'show_opacity'  => true, 
				'palette'	=> entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	
	
	/* TARGET border color:hover  */ // - typo -
	
	$id = 'entex_theme_typo_'. $_TARGET .'_border_hover_color_value';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability'  => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize,
			$id,
			array(
				'label' 		=> esc_html_x('Border color hover', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description'   => '',
				'section'       => $_PANEL,
				'settings'      => $id,
				'priority' 		=> $priority,
				'show_opacity'  => true, 
				'palette'	=> entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	
	
	
	/* TARGET text-shadow hover display */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_text_shadow_hover_display';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Remove text shadow on hover', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	
	/* TARGET devider hover visibility */
	
	if(strpos($data['remove'], 'devider_hover_visibility') === FALSE){
		$id = 'entex_theme_typo_'. $_TARGET .'_devider_hover_visibility';
		$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
		$wp_customize->add_control($id,
			array(
				'label' => esc_html_x('Hide surrounded deviders on hover', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'section' => $_PANEL,
				'priority' => $priority,
				'type' => 'checkbox'
			)
		);
	}
	
	
	/* TARGET filter hover: invert() */
	
	if(strpos($data['remove'], 'filter_hover_invert') === FALSE){
		$id = 'entex_theme_typo_'. $_TARGET .'_filter_hover_invert';
		$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
		$wp_customize->add_control($id,
			array(
				'label' => esc_html_x('Invert link icon on hover', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'section' => $_PANEL,
				'priority' => $priority,
				'type' => 'checkbox'
			)
		);
	}
		
	
	
	// HEADING ACTIVE
	$id = 'entex_theme_typo_'. $_TARGET .'_space_active_links';
	$wp_customize->add_setting($id, array('default' => '','sanitize_callback' => 'sanitize_text_field'));
	$wp_customize->add_control(
		new entex_customize_space_control(
			$wp_customize, 
			$id, array(
				/* translators: */
				'label' => sprintf(esc_html_x('Active settings', 'Customizer data: DO NOT TRANSLATE', 'entex'), $_LABEL),
				'description' => '',
				'border' => 30,
				'break' => false,
				'height' => 0,
				'section' => $_PANEL,
				'priority' => $priority
			)
		)
	);
	
	
	
	/* TARGET color:active */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_foreground_active_color';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability' => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize, $id,
			array(
				/* translators: */
				'label' => sprintf(esc_html_x('Link color active', 'Customizer data: DO NOT TRANSLATE', 'entex'), $_LABEL),
				'section' => $_PANEL,
				'priority' => $priority,
				'settings' => $id,
				'show_opacity' => true, 
				'palette' => entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	
	
	/* TARGET background color:active  */ // - typo -
	
	$id = 'entex_theme_typo_'. $_TARGET .'_background_active_color_value';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability'  => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize,
			$id,
			array(
				'label' 		=> esc_html_x('Background color active', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description'   => '',
				'section'       => $_PANEL,
				'settings'      => $id,
				'priority' 		=> $priority,
				'show_opacity'  => true, 
				'palette'	=> entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	
	
	/* TARGET border color:active  */ // - typo -
	
	$id = 'entex_theme_typo_'. $_TARGET .'_border_active_color_value';
	$wp_customize->add_setting($id, array('default' => '', 'type' => 'theme_mod', 'capability'  => 'edit_theme_options', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_color'));
	$wp_customize->add_control(
		new entex_customize_color_control(
			$wp_customize,
			$id,
			array(
				'label' 		=> esc_html_x('Border color active', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description'   => '',
				'section'       => $_PANEL,
				'settings'      => $id,
				'priority' 		=> $priority,
				'show_opacity'  => true, 
				'palette'	=> entex_customizer_cc_background_color_palette_default()
			)
		)
	);
	
	
	/* TARGET font-weight active */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_font_weight_choices';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'sanitize_text_field'));
	$wp_customize->add_control($id,
		array(
			'type' => 'select',
			'label' => esc_html_x('Font weight active', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => esc_html_x('Make shure selected Google font weight exists', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'choices' => entex_customizer_cc_select_font_weight()
		)
	);
	
	
	/* TARGET text-shadow active display */
	
	$id = 'entex_theme_typo_'. $_TARGET .'_text_shadow_active_display';
	$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
	$wp_customize->add_control($id,
		array(
			'label' => esc_html_x('Remove text shadow on active', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'section' => $_PANEL,
			'priority' => $priority,
			'type' => 'checkbox'
		)
	);
	
	
	/* TARGET devider active visibility */
	
	if(strpos($data['remove'], 'devider_active_visibility') === FALSE){
		$id = 'entex_theme_typo_'. $_TARGET .'_devider_active_visibility';
		$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
		$wp_customize->add_control($id,
			array(
				'label' => esc_html_x('Hide surrounded deviders on active', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'section' => $_PANEL,
				'priority' => $priority,
				'type' => 'checkbox'
			)
		);
	}
	
	
	/* TARGET filter active: invert() */
	
	if(strpos($data['remove'], 'filter_active_invert') === FALSE){
		$id = 'entex_theme_typo_'. $_TARGET .'_filter_active_invert';
		$wp_customize->add_setting($id, array('default' => '', 'transport' => 'postMessage', 'sanitize_callback' => 'entex_theme_customize_sanitize_checkbox'));
		$wp_customize->add_control($id,
			array(
				'label' => esc_html_x('Invert link icon on active', 'Customizer data: DO NOT TRANSLATE', 'entex'),
				'description' => '',
				'section' => $_PANEL,
				'priority' => $priority,
				'type' => 'checkbox'
			)
		);
	}
	
}
add_action('entex_theme_customize_register_panel_nav_link_all_priority_70', 'entex_theme_customize_controllers_links', 30, 6);
add_action('entex_theme_customize_register_panel_nav_link_all_mobile_priority_70', 'entex_theme_customize_controllers_links', 30, 6);



function entex_theme_output_data_controllers_links($_TARGET = null, $data = null){
	
	if(!$_TARGET || empty($data)) return;
	
	$_SELECTOR = $data['selector'];
	$match = array('[selector]', '[property]', '[value]', '[unit]');
	
	
	/* TARGET background color */ // - typo -
	
	$name = 'entex_theme_typo_'. $_TARGET .'_background_color_value';
	$value = get_theme_mod($name, '');
	if($value){
		$replacement = array($_SELECTOR, 'background-color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	/* TARGET border top width */
	
	$name = 'entex_theme_typo_'. $_TARGET .'_border_top_width';
	$value = get_theme_mod($name, -1);
	if($value < 0) $value = null;
	if($value != null){
		$replacement = array($_SELECTOR, 'border-top-width', $value, 'px');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	/* TARGET border bottom width */
	
	$name = 'entex_theme_typo_'. $_TARGET .'_border_bottom_width';
	$value = get_theme_mod($name, -1);
	if($value < 0) $value = null;
	if($value != null){
		$replacement = array($_SELECTOR, 'border-bottom-width', $value, 'px');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	/* TARGET border color */ // - typo -
	
	$name = 'entex_theme_typo_'. $_TARGET .'_border_color_value';
	$value = get_theme_mod($name, '');
	if($value){
		$replacement = array($_SELECTOR, 'border-color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	/* TARGET devider visibility */ // - typo -
	
	if(strpos($data['remove'], 'devider_visibility') === FALSE){
		$name = 'entex_theme_typo_'. $_TARGET .'_devider_visibility';
		$value = get_theme_mod($name, 0);
		if($value){
			$value = 'hidden';
			if(strpos($_SELECTOR, 'ul > li > a') !== FALSE) $_THIS_SELECTOR = str_replace('ul > li > a', 'ul > li:before', $_SELECTOR);
				else $_THIS_SELECTOR = $_SELECTOR;
			$replacement = array($_THIS_SELECTOR, 'visibility', $value, '');
			$style = str_replace($match, $replacement, $data['style']);
			entex_ECOUT($_TARGET, $name, $style);
		}
	}
	
	
	/* TARGET devider display */ // - typo -
	
	if(strpos($data['remove'], 'devider_display') === FALSE){
		$name = 'entex_theme_typo_'. $_TARGET .'_devider_display';
		$value = get_theme_mod($name, 0);
		if($value){
			$value = 'none';
			if(strpos($_SELECTOR, 'ul > li > a') !== FALSE) $_THIS_SELECTOR = str_replace('ul > li > a', 'ul > li:before', $_SELECTOR);
				else $_THIS_SELECTOR = $_SELECTOR;
			$replacement = array($_THIS_SELECTOR, 'display', $value, '');
			$style = str_replace($match, $replacement, $data['style']);
			entex_ECOUT($_TARGET, $name, $style);
		}
	}
	
	
	/* TARGET filter invert (em) */
	
	if(strpos($data['remove'], 'filter_invert') === FALSE){
		$name = 'entex_theme_typo_'. $_TARGET .'_filter_invert';
		$value = get_theme_mod($name, 0);
		if($value){
			$value = 'invert()';
			$property = 'filter';
			$unit = '';
			$additional = entex_customize_get_additional($_TARGET, $name, $data);
			$replacement = entex_customize_get_replacement(str_replace('ul > li > a', 'ul > li > a:before', $_SELECTOR), $property, $value, $unit, $data);
			
			$style = str_replace($match, $replacement, $data['style'].$additional);
			entex_ECOUT($_TARGET, $name, $style);
		}
	}
	
	
	
	// -- HOVER -- //
	
	/* TARGET hover color (value) */
	
	$name = 'entex_theme_typo_'. $_TARGET .'_foreground_hover_color';
	$value = get_theme_mod($name, 0);
	if($value){
		if(strpos($_SELECTOR, 'ul > li > a') !== FALSE) $_THIS_SELECTOR = str_replace('ul > li > a', 'ul > li:hover > a', $_SELECTOR);
			else $_THIS_SELECTOR = $_SELECTOR;
		$replacement = array($_THIS_SELECTOR, 'color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET background color hover */ // - typo -
	$name = 'entex_theme_typo_'. $_TARGET .'_background_hover_color_value';
	$value = get_theme_mod($name, '');
	if($value){
		if(strpos($_SELECTOR, 'ul > li > a') !== FALSE) $_THIS_SELECTOR = str_replace('ul > li > a', 'ul > li:hover > a', $_SELECTOR);
			else $_THIS_SELECTOR = $_SELECTOR;
		$replacement = array($_THIS_SELECTOR, 'background-color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	/* TARGET border color hover */ // - typo -
	$name = 'entex_theme_typo_'. $_TARGET .'_border_hover_color_value';
	$value = get_theme_mod($name, '');
	if($value){
		if(strpos($_SELECTOR, 'ul > li > a') !== FALSE) $_THIS_SELECTOR = str_replace('ul > li > a', 'ul > li:hover > a', $_SELECTOR);
			else $_THIS_SELECTOR = $_SELECTOR;
		$replacement = array($_THIS_SELECTOR, 'border-color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	/* TARGET text-shadow hover display */ 
	
	$name = 'entex_theme_typo_'. $_TARGET .'_text_shadow_hover_display';
	$value = get_theme_mod($name, 0);
	if($value){
		$value = 'none';
		if(strpos($_SELECTOR, 'ul > li > a') !== FALSE) $_THIS_SELECTOR = str_replace('ul > li > a', 'ul > li:hover > a', $_SELECTOR);
			else $_THIS_SELECTOR = $_SELECTOR;
		$replacement = array($_THIS_SELECTOR, 'text-shadow', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	/* TARGET devider hover visibility */ // - typo -
	
	if(strpos($data['remove'], 'devider_hover_visibility') === FALSE){
		$name = 'entex_theme_typo_'. $_TARGET .'_devider_hover_visibility';
		$value = get_theme_mod($name, 0);
		if($value){
			$value = 'hidden';
			if(strpos($_SELECTOR, 'ul > li > a') !== FALSE){
				$_THIS_SELECTOR = str_replace('ul > li > a', 'ul > li:hover:before', $_SELECTOR);
				$_ADD = str_replace('ul > li > a', 'ul > li:hover + li:before', $_SELECTOR);
				$_THIS_SELECTOR = $_THIS_SELECTOR .', '. $_ADD;
			} else $_THIS_SELECTOR = $_SELECTOR;
			$replacement = array($_THIS_SELECTOR, 'visibility', $value, '');
			$style = str_replace($match, $replacement, $data['style']);
			entex_ECOUT($_TARGET, $name, $style);
		}
	}
	
	
	/* TARGET filter hover invert (em) */
	
	if(strpos($data['remove'], 'filter_hover_invert') === FALSE){
		$name = 'entex_theme_typo_'. $_TARGET .'_filter_hover_invert';
		$value = get_theme_mod($name, 0);
		if($value){
			$value = 'invert()';
			$property = 'filter';
			$unit = '';
			$additional = entex_customize_get_additional($_TARGET, $name, $data);
			$replacement = entex_customize_get_replacement(str_replace('ul > li > a', 'ul > li:hover > a:before', $_SELECTOR), $property, $value, $unit, $data);
			
			$style = str_replace($match, $replacement, $data['style'].$additional);
			entex_ECOUT($_TARGET, $name, $style);
		}
	}
	
	
	
	// -- ACTIVE -- // 
	
	/* TARGET active color (value) */
	
	$name = 'entex_theme_typo_'. $_TARGET .'_foreground_active_color';
	$value = get_theme_mod($name, 0);
	if($value){
		if(strpos($_SELECTOR, 'ul > li > a') !== FALSE) $_THIS_SELECTOR = str_replace('ul > li > a', 'ul > li.selected > a', $_SELECTOR);
			else $_THIS_SELECTOR = $_SELECTOR;
		$replacement = array($_THIS_SELECTOR, 'color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	/* TARGET background color active */ // - typo -
	
	$name = 'entex_theme_typo_'. $_TARGET .'_background_active_color_value';
	$value = get_theme_mod($name, '');
	if($value){
		if(strpos($_SELECTOR, 'ul > li > a') !== FALSE) $_THIS_SELECTOR = str_replace('ul > li > a', 'ul > li.selected > a', $_SELECTOR);
			else $_THIS_SELECTOR = $_SELECTOR;
		$replacement = array($_THIS_SELECTOR, 'background-color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	/* TARGET border color active */ // - typo -
	
	$name = 'entex_theme_typo_'. $_TARGET .'_border_active_color_value';
	$value = get_theme_mod($name, '');
	if($value){
		if(strpos($_SELECTOR, 'ul > li > a') !== FALSE) $_THIS_SELECTOR = str_replace('ul > li > a', 'ul > li.selected > a', $_SELECTOR);
			else $_THIS_SELECTOR = $_SELECTOR;
		$replacement = array($_THIS_SELECTOR, 'border-color', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	/* TARGET font-weight active */ 
	$name = 'entex_theme_typo_'. $_TARGET .'_font_weight_choices';
	$value = get_theme_mod($name, '');
	if($value){
		if(strpos($_SELECTOR, 'ul > li > a') !== FALSE) $_THIS_SELECTOR = str_replace('ul > li > a', 'ul > li.selected > a', $_SELECTOR);
			else $_THIS_SELECTOR = $_SELECTOR;
		$replacement = array($_THIS_SELECTOR, 'font-weight', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	/* TARGET text-shadow active display */ // - typo -
	
	$name = 'entex_theme_typo_'. $_TARGET .'_text_shadow_active_display';
	$value = get_theme_mod($name, 0);
	if($value){
		$value = 'none';
		if(strpos($_SELECTOR, 'ul > li > a') !== FALSE) $_THIS_SELECTOR = str_replace('ul > li > a', 'ul > li.selected > a', $_SELECTOR);
			else $_THIS_SELECTOR = $_SELECTOR;
		$replacement = array($_THIS_SELECTOR, 'text-shadow', $value, '');
		$style = str_replace($match, $replacement, $data['style']);
		entex_ECOUT($_TARGET, $name, $style);
	}
	
	
	/* TARGET devider active visibility */ // - typo -
	
	if(strpos($data['remove'], 'devider_active_visibility') === FALSE){
		$name = 'entex_theme_typo_'. $_TARGET .'_devider_active_visibility';
		$value = get_theme_mod($name, 0);
		if($value){
			$value = 'hidden';
			if(strpos($_SELECTOR, 'ul > li > a') !== FALSE){
				$_THIS_SELECTOR = str_replace('ul > li > a', 'ul > li.selected:before', $_SELECTOR);
				$_ADD = str_replace('ul > li > a', 'ul > li.selected + li:before', $_SELECTOR);
				$_THIS_SELECTOR = $_THIS_SELECTOR .', '. $_ADD;
			} else $_THIS_SELECTOR = $_SELECTOR;
			$replacement = array($_THIS_SELECTOR, 'visibility', $value, '');
			$style = str_replace($match, $replacement, $data['style']);
			entex_ECOUT($_TARGET, $name, $style);
		}
	}
	
	/* TARGET filter invert (em) */
	
	if(strpos($data['remove'], 'filter_active_invert') === FALSE){
		$name = 'entex_theme_typo_'. $_TARGET .'_filter_active_invert';
		$value = get_theme_mod($name, 0);
		if($value){
			$value = 'invert()';
			$property = 'filter';
			$unit = '';
			$additional = entex_customize_get_additional($_TARGET, $name, $data);
			$replacement = entex_customize_get_replacement(str_replace('ul > li > a', 'ul > li.selected > a:before', $_SELECTOR), $property, $value, $unit, $data);
			
			$style = str_replace($match, $replacement, $data['style'].$additional);
			entex_ECOUT($_TARGET, $name, $style);
		}
	}
	
}
add_action('entex_theme_customize_wp_head_nav_link_all', 'entex_theme_output_data_controllers_links', 30, 2);
add_action('entex_theme_customize_wp_head_nav_link_all_mobile', 'entex_theme_output_data_controllers_links', 30, 2);


// -- END FILE -- //