<?php if(!defined('ABSPATH')) die();
/**
 * Entex theme customizer
 *
 * @package Entex
 * @subpackage Entex
 * @version 2.11027
 *
 * This is the master customize entex API file
 *
 * You can override any file used by this protocol in your child theme
 * Or use available hooks to extend the customizer to your needs
 * The same goes for javascript or controller files
 * 
 * Copy the whole 'customizer' folder into your child theme
 * Or create individual cloned paths with folder structure to single files you need to modify
 * 
**/

/**
 * NOTE: DO NOT BREAK THE SANITIZED CHAIN
 *
 * ALL INPUT THEME MOD DATA
 * IS SANTITIZED BY THE CONTROLLERS
 * DO NOT ADD DATA MANUALLY
 * ONLY MOVE THEM AROUND IF NEEDED
 * INTO OPTIONS OR ANOTHER THEME MOD
 *
**/


/* -------------------- */
// LOAD RESET CONTROLLER FUNCTION
/* Thanks to Jonas Ludman */

function entex_customize_transport_controls_default(){
	
    global $wp_customize;
	foreach($wp_customize->controls() as $id => $settings){
		$data[] = $id;
	}
	
	/* trigger */
	$script = 'var jonas = 0'."\r\n";

	foreach($data as $index => $name){
		if(!empty($wp_customize->get_setting($name))){
			$default = wp_json_encode($wp_customize->get_setting($name)->default);
		} else {
			$default = '""';
		}
		$script .= sprintf(
			'wp.customize("'.$name.'", function(setting){setting.default = %s;});'."\r\n", 
			$default
		);
	}
    if($script) wp_add_inline_script('customize-controls', $script);
}
add_action('customize_controls_enqueue_scripts', 'entex_customize_transport_controls_default');






/* -------------------- */
// REMOVE ALL EDIT BUTTONS DISTRACTING VIEWS

if(defined('ENTEX_THEME_CUSTOMIZER_REMOVE_EDIT_BUTTONS')){
	add_action('wp_enqueue_scripts', function(){
		$js = 'wp.customize.selectiveRefresh.Partial.prototype.createEditShortcutForPlacement = function() {};';
		wp_add_inline_script('customize-selective-refresh', $js);
	});
}



/* -------------------- */
// SUPERGLOBALS

$GLOBALS['ENTEX-CUSTOMIZER-CSS'] = array();
$GLOBALS['ENTEX-CUSTOMIZER-LINKS'] = array();
$GLOBALS['ENTEX-CUSTOMIZER-COLORS'] = array();
$GLOBALS['ENTEX-CUSTOMIZER-BACKGROUND-COLORS'] = array();
$GLOBALS['ENTEX-CUSTOMIZER-ALL-COLORS'] = array();





/* -------------------- */
// CORE FUNCTIONS 

function entex_ECROOT($path, $uri = false){
	
	/* Entex Customizer Root directory file finder */
	$dirfile = str_replace('//', '/', '/customizer/'. $path);
	
	if($uri){
		if(is_child_theme() && file_exists(get_stylesheet_directory_uri().$dirfile)) return get_stylesheet_directory_uri().$dirfile;
			else return get_template_directory_uri().$dirfile;
	} else {
		if(is_child_theme() && file_exists(get_stylesheet_directory().$dirfile)) return get_stylesheet_directory().$dirfile;
			else return get_template_directory().$dirfile;
	}
}

function entex_ECOUT($_TARGET, $name, $style){
	
	/* note: prefix '-inline-css' will be added by WordPress core */
	/* prefix is added in javascript function in preview */
	$name = entex_theme_customize_generate_id($name);
	
	wp_register_style($name, true);
	wp_enqueue_style($name);
	wp_add_inline_style($name, $style);
	
	/* not working with any valid esc function */
	$GLOBALS['ENTEX-CUSTOMIZER-CSS'][$_TARGET][] = $style;
}

function entex_customize_get_additional($_TARGET, $name, $data){
	
	$additional = '';
	if(isset($data['additional']) && $data['additional']){
		$items = explode('|', $data['additional']);
		foreach($items as $item){
			if(strpos($item, $name) !== FALSE){
				$additional .= ' '. trim(str_replace('['. $name .']', '', $item));
			}
		}
	}
	return $additional;
}

function entex_customize_get_replacement($_SELECTOR, $property, $value, $unit, $data){
	
	if(isset($data['main'][$property])) $replacement = array($data['main'][$property], $property, $value, $unit);
		else $replacement = array($_SELECTOR, $property, $value, $unit);
	return $replacement;
}





/* -------------------- */
// INIT CUSTOMIZER

/* early include */
require_once entex_ECROOT('entex-customize-options.php'); // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound





/* -------------------- */
// LOAD ASSETS

function entex_theme_customize_preview_init(){
	
	/* preview iframe scope */
	if(current_user_can('edit_published_posts')) $cache = date('Ymdhi');
		else $cache = date('Ym');
	wp_enqueue_script('entex-theme-customizer', entex_ECROOT('js/entex-customizer-preview.js', true), array('jquery', 'customize-preview'), $cache, true);

	/* pass settings to javascript */
	$arr = entex_theme_customize_register_data();
	if(empty($arr)) return;
	
	/* extract what we need */
	foreach($arr as $master => $settings){
		
		if(empty($settings)) break;
		foreach($settings as $_TARGET => $data){
			$_SELECTOR = $data['selector'];
			$A[] = array(
				'target' => $_TARGET,
				'selector' => $_SELECTOR,
				'master' => $master,
				'unit' => $data['unit'],
				'main' => $data['main'], 
				'before' => $data['before'], 
				'after' => $data['after'], 
				'additional' => $data['additional'], 
				'remove' => $data['remove'], 
				'description' => $data['description'], 
				'visibility' => $data['visibility'], 
				'style' => $data['style'], 
				'initial' => $data['initial'], 
				'responsive' => $data['responsive'], 
				'desktop' => $data['desktop']
			);
		}
	}
	
	$str = json_encode($A);
	$warnings = '';
	if(defined('ENTEX_THEME_CUSTOMIZER_READ_DEFAULT_STYLESHEET')) $warnings .= 'ENTEX THEME CUSTOMIZER READ DEFAULT STYLESHEET is defined and done. Please remove defined variable in functions.php';
	
	$debug = '';
	if(defined('ENTEX_THEME_CUSTOMIZER_DEBUG_PREVIEW')) $debug = 'on';
	
	$file = get_template_directory_uri() .'/assets/ua-css/ua-default-layout.css';
	$id = 'entex-theme-layout-css';
	
	wp_localize_script('entex-theme-customizer', 'ENTEX_CUSTOMIZE', array(
		'data' => $str,
		'warnings' => $warnings,
		'bolds' => entex_theme_customize_bold_selectors(),
		'debug' => $debug,
		'file' => $file,
		'id' => $id
	));
	
	$F['google-fonts-disable'] = get_theme_mod('entex_theme_google_fonts_disable', 0);
	$F['google-fonts-customize-disable'] = get_theme_mod('entex_theme_customize_google_fonts_disable', 0);
	$str = json_encode($F);
	wp_localize_script('entex-theme-customizer', 'ENTEX_CUSTOMIZE_FONTS', array(
		'data' => $str
	));
	
	
}
add_action('customize_preview_init', 'entex_theme_customize_preview_init');





/* -------------------- */
// PANEL(S) INLINE STYLE API

$GLOBALS['ENTEX-CUSTOMIZER-ADD-INLINE-STYLE'] = array();
$GLOBALS['ENTEX-CUSTOMIZER-ADD-INLINE-SCRIPT'] = array();
function entex_theme_customize_controls_enqueue_scripts(){
	
	/* customize scope */
    wp_enqueue_style('entex-theme-customizer', entex_ECROOT('css/entex-customizer-styles.css', true), array(), mt_rand());
	wp_enqueue_style('entex-theme-admin-backend', get_template_directory_uri() .'/assets/css/entex-theme-admin-backend.css');
	
	wp_add_inline_style('entex-theme-customizer', trim(implode(' ', $GLOBALS['ENTEX-CUSTOMIZER-ADD-INLINE-STYLE'])));
	wp_add_inline_script('customize-controls', trim(implode(' ', $GLOBALS['ENTEX-CUSTOMIZER-ADD-INLINE-SCRIPT'])));
}
add_action('customize_controls_enqueue_scripts', 'entex_theme_customize_controls_enqueue_scripts');







/* -------------------- */
// DEFAULT INCLUDES

require_once entex_ECROOT('entex-customize-actions.php'); 									// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require_once entex_ECROOT('entex-customize-filters.php'); 									// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require_once entex_ECROOT('extended/entex-control-range/class-entex-control-range.php'); 	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require_once entex_ECROOT('extended/entex-control-color/class-entex-control-color.php'); 	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require_once entex_ECROOT('extended/entex-control-font/class-entex-control-font.php'); 		// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require_once entex_ECROOT('extended/entex-control-button/class-entex-control-button.php'); 	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require_once entex_ECROOT('extended/entex-control-space/class-entex-control-space.php'); 	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require_once entex_ECROOT('extended/entex-control-memory/class-entex-control-memory.php'); 	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound

/* ******************** */
// END: INCLUDES





/* -------------------- */
// REGISTER MASTER PANELS

function entex_theme_customize_register_master_panels($wp_customize){

	if(!isset($wp_customize)) return;
	
	$wp_customize->add_panel('entex_panel_master', 
		array(
			'priority' => 10,
			'capability' => 'edit_theme_options',
			'theme_supports' => '',
			'title' => esc_html_x('Entex layout', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => ''
		) 
	);
	
	$wp_customize->add_panel('entex_panel_options', 
		array(
			'priority' => 10,
			'capability' => 'edit_theme_options',
			'theme_supports' => '',
			'title' => esc_html_x('Entex options', 'Customizer data: DO NOT TRANSLATE', 'entex'),
			'description' => ''
		) 
	);
	
}
add_action('customize_register', 'entex_theme_customize_register_master_panels', 10, 1);

// END: REGISTER MASTER PANELS
/* ******************** */








/* -------------------- */
// REGISTER SUB PANELS AND CONTROLS
/* Remember to keep priority levels intact */

require_once entex_ECROOT('panels/customize-register-panel-wordpress.php');	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require_once entex_ECROOT('panels/customize-register-panel-body.php');		// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require_once entex_ECROOT('panels/customize-register-panel-html.php');		// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require_once entex_ECROOT('panels/customize-register-panel-typo.php');		// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require_once entex_ECROOT('panels/customize-register-panel-layout.php');	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require_once entex_ECROOT('panels/customize-register-panel-options.php');	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound


/* All output sanitized by options array */
function entex_theme_customize_register($wp_customize){
	
	if(!isset($wp_customize)) return;
	$arr = entex_theme_customize_register_data();
	if(empty($arr)) return;

	foreach($arr as $master => $settings){
		
		if(empty($settings)) break;
		
		foreach($settings as $_TARGET => $data){
			$_LABEL = $data['label'];
			$_SELECTOR = $data['selector'];
			$unit = $data['unit'];
			$panel_priority = $data['panel-priority'];
			if(!$data['in-master-panel']) $data['in-master-panel'] = 'entex_panel_master_'. entex_fn_undercase($master);
			call_user_func('entex_theme_customize_register_panel_'.entex_fn_undercase($master), $wp_customize, $_TARGET, $data);
		}
	}
}
add_action('customize_register', 'entex_theme_customize_register', 10, 1);

/* ******************** */
// END






/* -------------------- */
// TEMPATE HEADER OUTPUT

function entex_theme_customize_wp_head(){
	
	$arr = entex_theme_customize_register_data();
	if(empty($arr)) return;
	
	foreach($arr as $master => $settings){
		if(empty($settings)) break;
		foreach($settings as $_TARGET => $data){
			call_user_func('entex_theme_output_data_panel_'.entex_fn_undercase($master), $_TARGET, $data);
		}
	}	
}
add_action('wp_head', 'entex_theme_customize_wp_head', 10);






/* -------------------- */
// SANITIZE DATA
/* helper functions */
/* Resource: https://divpusher.com/blog/wordpress-customizer-sanitization-examples */

function entex_theme_customize_sanitize_checkbox($input){
	if(true === $input) return 1;
		else return 0;
}


function entex_theme_customize_sanitize_default($input){
	return sanitize_text_field($input);
}

function entex_theme_customize_sanitize_color($input){
	return wp_filter_nohtml_kses($input);
}

function entex_theme_customize_sanitize_breakpoint($input){
	$input = absint($input);
	if($input < 1) $input = 0;
	return $input;
}

/* moving out to controller settings */
function entex_theme_customize_sanitize_images($src){
	return esc_url_raw($src);
}


function entex_theme_customize_sanitize_footer_logo($src){
	if($src){ 
		$attachment_id = attachment_url_to_postid($src);
		set_theme_mod('entex_theme_footer_logo_image_id', $attachment_id);
	} else {
		remove_theme_mod('entex_theme_footer_logo_image_id');
	}
	return $src;
	return esc_url_raw($src);
}


function entex_theme_customize_generate_id($option_name){
	return str_replace('_', '-', trim($option_name));
}


function entex_theme_customize_sanitize_font($input){
	$val = json_decode($input, true);
	if(is_array($val)){
		foreach($val as $key => $value){
			$val[$key] = sanitize_text_field($value);
		}
		$input = json_encode($val);
	} else {
		$input = json_encode(sanitize_text_field($val));
	}
	return $input;
}


function entex_theme_customize_sanitize_logo_display($input){
	if($input < 300) $input = '';
	return $input;
}

function entex_theme_customize_sanitize_query_value($input){
	if($input < 300) $input = '';
	return absint($input);
}

/* ******************** */
// END: SANITIZE DATA






/* -------------------- */
// DEFAULTS

function entex_customize_default_header_logo_display(){
	return apply_filters('entex_customize_filter_default_header_logo_display', 560);
}


function entex_theme_font_control_defaults(){
	return json_encode(
		array(
			'font' => '',
			'regularweight' => '',
			'italicweight' => '',
			'boldweight' => '',
			'category' => '',
			'subset' => ''
		)
	);
}

/* not in use yet */
function entex_theme_font_control_html_default(){
	/* xml values */
	return '{"font":"Alegreya Sans","regularweight":"regular","italicweight":"italic","boldweight":"500","category":"sans-serif","subset":"latin"}';
}


/* ******************** */
// END: DEFAULTS






/* -------------------- */
// POPULATE CONTROLS
/* helper functions */
/* translators: DO NOT TRANSLATE option labels that are style values */

function entex_customizer_cc_select_background_position(){
	return array(
		'' => esc_html(_x('— Theme Default —', 'Customizer data: DO NOT TRANSLATE', 'entex')),
		'left top' => 'left top',
		'left center' => 'left center',
		'left bottom' => 'left bottom',
		'right top' => 'right top',
		'right center' => 'right center',
		'right bottom' => 'right bottom',
		'center top' => 'center top',
		'center center' => 'center center',
		'center bottom' => 'center bottom'
	);
}

function entex_customizer_cc_select_background_position_limited(){
	return array(
		'' => esc_html(_x('— Theme Default —', 'Customizer data: DO NOT TRANSLATE', 'entex')),
		'center top' => 'top',
		'center center' => 'center',
		'center bottom' => 'bottom'
	);
}

function entex_customizer_cc_select_background_repeat(){
	return array(
		'' => esc_html(_x('— Theme Default —', 'Customizer data: DO NOT TRANSLATE', 'entex')),
		'no-repeat' => esc_html_x('No repeat', 'Customizer data: DO NOT TRANSLATE', 'entex'),
		'repeat' => esc_html_x('Repeat', 'Customizer data: DO NOT TRANSLATE', 'entex'),
		'repeat-x' => esc_html_x('Repeat X', 'Customizer data: DO NOT TRANSLATE', 'entex'),
		'repeat-y' => esc_html_x('Repeat Y', 'Customizer data: DO NOT TRANSLATE', 'entex')
	);
}

function entex_customizer_cc_select_background_size(){
	return array(
		'' => esc_html(_x('— Theme Default —', 'Customizer data: DO NOT TRANSLATE', 'entex')),
		'auto' => 'auto',
		'cover' => 'cover',
		'100% auto' => esc_html_x('Fill width', 'Customizer data: DO NOT TRANSLATE', 'entex'),
		'auto 100%' => esc_html_x('Fill height', 'Customizer data: DO NOT TRANSLATE', 'entex')
	);
}

function entex_customizer_cc_select_vertical_align(){
	return array(
		'' => esc_html(_x('— Theme Default —', 'Customizer data: DO NOT TRANSLATE', 'entex')),
		'top' => 'top',
		'middle' => 'middle',
		'bottom' => 'bottom',
		'baseline' => 'baseline'
	);
}

function entex_customizer_cc_select_text_transform(){
	return array(
		'' => esc_html(_x('— Theme Default —', 'Customizer data: DO NOT TRANSLATE', 'entex')),
		'capitalize' => 'capitalize',
		'uppercase' => 'uppercase',
		'lowercase' => 'lowercase',
		'none' => 'none'
	);
}

function entex_customizer_cc_select_text_align(){
	return array(
		'' => esc_html(_x('— Theme Default —', 'Customizer data: DO NOT TRANSLATE', 'entex')),
		'left' => 'left',
		'right' => 'right',
		'center' => 'center',
		'justify' => 'justify',
		'initial' => 'initial',
		'inherit' => 'inherit'
	);
}

function entex_customizer_cc_select_font_weight(){
	return array(
		'' => esc_html(_x('— Theme Default —', 'Customizer data: DO NOT TRANSLATE', 'entex')),
		'regular' => '400 (regular)',
		'500' => '500',
		'600' => '600',
		'700' => '700 (bold)',
		'800' => '800',
		'900' => '900'
	);
}

function entex_customizer_cc_select_display_extended(){
	return array(
		'' => esc_html(_x('— Theme Default —', 'Customizer data: DO NOT TRANSLATE', 'entex')),
		'inline' => esc_html_x('Display inline', 'Customizer data: DO NOT TRANSLATE', 'entex'),
		'block' => esc_html_x('Display block', 'Customizer data: DO NOT TRANSLATE', 'entex'),
		'inline-block' => esc_html_x('Display inline-block', 'Customizer data: DO NOT TRANSLATE', 'entex'),
		'none' => esc_html_x('Display none', 'Customizer data: DO NOT TRANSLATE', 'entex')
	);
}

function entex_customizer_cc_color_palette_default(){ 

	return apply_filters('entex_customizer_cc_color_palette', array(
		'rgba(37,114,104,0.8)',
		'#4c5e37',
		'#5d6f48',
		'#777667',
		'#b3b3b3',
		'#dcdcdc',
		'#8088a8',
		'rgba(127,43,0,0.6)',
		'rgba(84,74,0,0.5)',
		'rgba(84,74,0,0.5)',
		'rgba(0,44,68,0.5)',
		'rgba(195,162,72,0.75)',
		'rgba(255,255,255,0.5)',
		'rgba(0,0,0,0.5)'
	));
}

function entex_customizer_cc_background_color_palette_default(){ 
	if(!empty($GLOBALS['ENTEX-CUSTOMIZER-ALL-COLORS'])){
		return apply_filters('entex_customizer_cc_color_palette', array_slice($GLOBALS['ENTEX-CUSTOMIZER-ALL-COLORS'], 0, -1, false));
	} else return entex_customizer_cc_color_palette_default();
}

// -- OPTIONS -- //
/* uses refresh - no javascript */

function entex_customizer_cc_select_template_examples($types = null){
	
	if($types === null) $types = array('entries');
	if(!is_array($types)) $types = array($types);
	
	// NOTE:
	/* $templates content Should be sanitized by get_page_templates() */
	/* All template controllers also uses sanitize_text_field */ 

	$added = array();
	$default = array('' => esc_html(_x('— Theme Default —', 'Customizer data: DO NOT TRANSLATE', 'entex')));
	$templates = entex_theme_customize_templates();
	foreach($types as $type){
		if(isset($templates[$type])){
			$added = array_merge($added, $templates[$type]);
		}
	}
	if(!empty($added)){
		foreach($added as $key => $name){
			$arr[str_replace('.php', '', $key)] = $name;
		}
		ksort($arr, SORT_NATURAL);
		foreach($arr as $key => $name){
			$result[$key .'.php'] = $name;
		}
	} else $result = $added;
	$results = array_merge($default, $result);
	return $results;
}




// END: POPULATE CONTROLS
/* ******************** */






/* -------------------- */
// ALPHA DYNAMIC PALETTE - not in use

function entex_theme_dynamic_palette_color(){

	return array(
		'#444334',
		'#8088a8',
		'rgba(105,40,40,.8)',
		'#00CC99',
		'#dbdbdb',
		'#33cc33'
	);
}

function entex_theme_dynamic_palette_background_color(){

	return array(
		'#444334',
		'#8088a8',
		'rgba(105,40,40,.8)',
		'#00CC99',
		'#dbdbdb',
		'#33cc33'
	);
}

/* ******************** */
// END: PALETTE







/* -------------------- */
// GOOGLE FONTS PREVIEW OUTPUT
// Only called if font url is provided by panel API

function entex_theme_customize_google($google){
	
	if(!is_customize_preview()) return;
	if(get_theme_mod('entex_theme_customize_google_fonts_disable', 0)) return '';
	if(empty($google)) return;

	/* collected as multi array */
	/* but uses only one level anyway */
	
	foreach($google as $name => $arr){
		$subsets[] = 'all';
		$font = str_replace(' ', '+', $arr['font']);
		if($arr['regularweight']) $fonts[$font][] = $arr['regularweight'];
		if($arr['italicweight']) $fonts[$font][] = $arr['italicweight'];
		if($arr['boldweight']) $fonts[$font][] = $arr['boldweight'];
		if(!isset($fonts[$font])) $fonts[$font][] = '';
	}
	foreach($fonts as $font => $variants){
		$families[] = $font.':'.implode(',', $variants);
	}

	$fonts_url = add_query_arg(array(
		'family' => implode('|', $families),
		'subset' => implode(',', $subsets),
	), 'https://fonts.googleapis.com/css');
	
	wp_enqueue_style('LINK-'. entex_theme_customize_generate_id($name), $fonts_url, array(), null);

}

/* ******************** */
// END: GOOGLE FONTS OUTPUT






/* -------------------- */
// CUSTOMIZER CACHE

function entex_customize_save_after($manager){
	remove_theme_mod('entex_customizer_saved');
}
add_action('customize_save_after', 'entex_customize_save_after');

/* hooked from functions.php */
function entex_customize_populate_customizer_styles(){
	
	/* If we are here */
	/* means that we just arrived from the customizer */
	/* or we are not allowed to write to file */
	/* if this file is called, all customizer files and panels are loaded */
	/* but never use them, except the wp_head call in each panel */
	
	// NOTE:
	// All data is already sanitized by the controller
	
	$css = '';
	$GUTENBERG_TARGETS = apply_filters('entex_customize_populate_gutenberg_targets', array('html', 'h1', 'h1_em', 'h2', 'h2_span', 'h2_em', 'h3', 'h4', 'preamble')); 
	$GUTENBERG_CSS = array();
	
	/* Create a string with linebreak marker separator */
	/* Also collect the GUTENBERG back-end content editor values */
	/* The SUPERGLOBAL is populated by the panel head output function */
	/* And this function is called later in priority */
	
	if(!empty($GLOBALS['ENTEX-CUSTOMIZER-CSS'])){
		foreach($GLOBALS['ENTEX-CUSTOMIZER-CSS'] as $_TARGET => $styles){
			foreach($styles as $style){
				if($style && trim($style)) $css .= trim($style) .'¤';
				if(in_array($_TARGET, $GUTENBERG_TARGETS)){
					if($style && trim($style)) $GUTENBERG_CSS[$_TARGET][] = trim($style);
				}
			}
		}
	} else {
		$css = entex_customize_get_content_none();
	}
	
	$force_inline = get_theme_mod('entex_customizer_force_inline_styles', 0);
	if($force_inline){
		
		/* sanitized */
		set_theme_mod('entex_gutenberg_styles', $GUTENBERG_CSS);
		set_theme_mod('entex_customizer_saved', 1);
		set_theme_mod('entex_customizer_inline_styles', $css);
		set_theme_mod('entex_customizer_use_inline_styles', 1);
		add_action('entex_template_before_main_content', 'entex_customize_page_message_mk_file_customizer_applied', 5);
		
	} else {
		
		/* Customized content related selectors must be converted when used in Gutenberg */
		/* We store the data in a separate theme mod for this objective */
		/* The $GUTENBERG_TARGETS is the filtered selectors we need */
		/* The $GUTENBERG_CSS is collected above and stored as an array */
		/* The data is converted in entex-setup-gutenberg.php */
		
		/* sanitized */
		set_theme_mod('entex_gutenberg_styles', $GUTENBERG_CSS);
			
		/* This is the main 'marker' for knowing to be here or not */
		/* We populate this single mod with all styles we need AS STRING */
		/* If we are not using / allowed creating stylesheet */
		/* We pull everything out from this one */
		/* instead of loading every customizer controller settings on every pageload */
		
		set_theme_mod('entex_customizer_saved', 1);
		
		/* empty the file failure / force inline marker */
		remove_theme_mod('entex_customizer_inline_styles');
		remove_theme_mod('entex_customizer_use_inline_styles');
		
		/* Choose file and prepare */
		/* We populate the string '$css' from above */
		/* And pull linebreaks replaceing the '¤' character */
		/* We are for now only populating one file */
		/* In the future, different 'versions' might be considered */
		
		$stylesheet = entex_customize_get_stylesheet_name();
		$dir = trailingslashit(get_stylesheet_directory());
		$file = '/'. $stylesheet .'.css';
		$content = '';
		$content .= '/* Created '. date('Y-m-d H:i') .' BY WordPress customizer */'."\r\n\r\n";
		$content .= str_replace('¤', "\r\n", $css);
		
		/* Child theme might using WordPress own file system */
		if(function_exists('entex_fn_mk_file')){
			$success = entex_fn_mk_file($dir, $file, $content);
		} else $success = false;
		
		if(!$success){
			
			/* FAILURE or make file function not in use */
			/* Tell we couldnt create a stylesheet */
			/* Create a marker to force using inline styles instead */
			/* Until next time Custmomizer is running and saving */
			/* Or stimulate do set option to never try using created stylesheet(s) */
			/* Then this process will never run again */
			
			/* sanitized */
			set_theme_mod('entex_customizer_inline_styles', $css);
			set_theme_mod('entex_customizer_use_inline_styles', 1);
			set_theme_mod('entex_customizer_force_inline_styles', 1);
			add_action('entex_template_before_main_content', 'entex_customize_page_message_mk_file_customizer_failed', 5);
		} else {
			/* Stimulate to reload the page as we not using the stylesheet yet */
			/* Feels better to end the process like this, but not needed */
			add_action('entex_template_before_main_content', 'entex_customize_page_message_mk_file_customizer_success', 5);
		}
	}
}


 
function entex_customize_page_message_mk_file_customizer_applied(){
	$message = esc_html_x('New customizer settings applied.', 'Customizer', 'entex');
	entex_template_output_page_message($indent = 0, $message, '');
}

function entex_customize_page_message_mk_file_customizer_success(){
	$message = esc_html_x('New customizer settings saved into cache and will be in use on next page load.', 'Customizer', 'entex');
	entex_template_output_page_message($indent = 0, $message, 'ua-message-attention');
}

function entex_customize_page_message_mk_file_customizer_failed(){
	$message = esc_html_x('Failed to create customizer.css into theme directory. Default WordPress embed method will be in use for Customizer settings. No future attempt will be made until you manually uncheck the option inside html customizer panel section.', 'Customizer', 'entex');
	$message = esc_html_x('Customizer settings is applied by WordPress.', 'Customizer', 'entex');
	entex_template_output_page_message($indent = 0, $message, 'ua-message-attention');
}



// -- END FILE -- //