<?php
/**
 * The template for displaying comments
 *
 * The area of the page that contains both current comments
 * and the comment form.
 * 
 * Note: This template can only be included once.
 *
 * @package Entex
 * @subpackage Entex theme
 * @subpackage Buddypress
 * @subpackage Woocommerce comments
 * @version 2.10610
 */

$have_comments = false;
if(have_comments()) $have_comments = true;
$comments_number = get_comments_number();

$indent = 0;
$html = '';
$subtitle = '';

$subtitle .= '<h5>';
$subtitle = apply_filters('entex_template_comments_subtitle_start', $subtitle, $have_comments);

if($comments_number){
	/* translators: */
	if($comments_number > 1) $CT = sprintf(_x('%1$s comments', 'Comments', 'entex'), number_format_i18n($comments_number));
		else $CT = _x('One comment', 'Comments', 'entex');
} else $CT = _x('No comments', 'Comments', 'entex');

$subtitle .= '<span>'. esc_html($CT) .'</span>';
$subtitle .= entex_template_get_meta_comment_last();
$subtitle = apply_filters('entex_template_comments_subtitle_end', $subtitle, $have_comments);
$subtitle .= '</h5>';

do_action('entex_template_before_template', $indent, '', __FILE__, entex_backtrace(2));
echo '<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- SECTION COMMENTS -->'."\r\n";
if(post_password_required()){
	$html = entex_IND($indent, 0).'<p class="ua-box ua-notice" id="comments">'. esc_html(_x( 'This page is protected. Enter the password to view Comments section.', 'Comments', 'entex' )) .'</p>'.entex_LBR();
	echo wp_kses_post($html);
	return;
}
if(is_page() && !$have_comments && !comments_open() && !pings_open()) return;

$links = paginate_comments_links(
	array(
		'echo' => false, 
		'before_page_number' => '<span class="meta-nav screen-reader-text">'. esc_html(_x('Page', 'Pagination: Before page number', 'entex')) .' </span>', 
		'prev_text' => esc_html(_x('Previous comments', 'Pagination', 'entex')), 
		'next_text' => esc_html(_x('Next comments', 'Pagination', 'entex'))
	)
);

if($links) $links = str_replace("\n", "\n".entex_IND(2), $links).entex_LBR();
	else $links = '<a class="page-numbers ua-fn-loading-false" href="#comments"><span class="meta-nav screen-reader-text">'._x('Page', 'Comments: LIKE Page 1', 'entex') .' </span>1</a>';

?>
<section id="comments" class="ua-comment-list ua-not-main">
<?php if($have_comments): ?>
 <h2><?php echo esc_html(_x( 'Comments', 'Comments', 'entex' )); ?></h2>
 <?php echo wp_kses_post($subtitle); ?>
<?php 
/* previous and next simple navigation */

if(defined('ENTEX_COMMENTS_NAVIGATION_ENABLE')){
$navlinks = get_the_comments_navigation(
	array(
		'prev_text' => '<span class="page-number prev"></span><span class="page-title">'. esc_html(_x('Older comments', 'Comments', 'entex')) .'</span>', 
		'next_text' => '<span class="page-title">'. esc_html(_x('Newer comments', 'Comments', 'entex')) .'</span><span class="page-number next"></span>',
		'screen_reader_text' => esc_html(_x('Comments navigation', 'Comments (screen reader text)', 'entex'))
	)
);

$navlinks = str_replace("\t", '', str_replace("\n", '', $navlinks));
entex_OUT(entex_CMD('the_comments_navigation').$navlinks.entex_LBR().entex_CMD());
}
?>
<?php if(!defined('ENTEX_COMMENTS_NAVIGATION_ENABLE') && $have_comments && $comments_number > (get_option('comments_per_page') * 2)) : ?>
<?php entex_OUT(entex_CMD('paginate_comments_links')); ?>
<nav class="navigation pagination pagination-top" role="navigation">
 <h2 class="screen-reader-text"><?php esc_html_e('Comments navigation', 'entex'); ?></h2>
 <div class="nav-links">
  <p><?php esc_html_e('Viewing comment page', 'entex'); ?></p>
  <?php echo wp_kses_post($links); ?>
  <button onclick="location.href='#respond'; return false;"><?php esc_html_e('Add new comment', 'entex'); ?></button>
 </div>
</nav>
<?php entex_OUT(entex_CMD()); ?>
<?php endif; ?>

 <!-- comments list start -->
 <ol>
<?php wp_list_comments(
	array(
		'callback' => 'bp_dtheme_blog_comments', 
		'type' => 'all', 
		'style' => 'ol', 
		'reply_text' => esc_html(_x('Reply to this comment', 'Comments', 'entex')), 
		'avatar_size' => 50
	)
); ?>
<?php entex_OUT(entex_CML()); ?>
 </ol>
 <!-- comments list end -->
<?php if($have_comments && $comments_number > (get_option('comments_per_page') * 1)) : ?>
<?php entex_OUT(entex_CMD('paginate_comments_links')); ?>
<nav class="navigation pagination pagination-bottom" role="navigation">
 <h2 class="screen-reader-text"><?php esc_html_e('Comments navigation', 'entex'); ?></h2>
 <div class="nav-links">
  <p><?php esc_html_e('Viewing comment page', 'entex'); ?></p>
  <?php echo wp_kses_post($links); ?>
  <button onclick="location.href='#respond'; return false;"><?php esc_html_e('Add new comment', 'entex'); ?></button>
 </div>
</nav>
<?php entex_OUT(entex_CMD()); ?>
<?php endif; ?>
<?php endif; ?>
<?php if(!comments_open() && $comments_number && post_type_supports(get_post_type(), 'comments')): ?>
 <p class="ua-box ua-notice"><?php esc_html_e('Comments are closed.', 'entex'); ?></p>
<?php endif; ?>
<?php

$logged_in_as = '';
$logged_in_as .= '<h5>';
$logged_in_as = apply_filters('entex_template_comments_form_meta_start', $logged_in_as);
/* translators: */
$logged_in_as .= '<span>'. wp_kses_post( sprintf(_x('Logged in as <a href="%1$s">%2$s</a>', 'Comments', 'entex'), admin_url('profile.php'), $user_identity) ) .'</span>';
$logged_in_as .= '<span><a href="'. esc_url( wp_logout_url(apply_filters('the_permalink', get_permalink()))) .'">'. esc_html(_x('Logout', 'Comments', 'entex')) .'</a></span>';
$logged_in_as = apply_filters('entex_template_comments_form_meta_end', $logged_in_as);
$logged_in_as .= '</h5>';

$comment_notes_before = _x('Your email address will not be published. Required fields are marked with a dot.', 'Comments', 'entex');
/* translators: */
$must_log_in = sprintf(_x('You must be <a href="%s">logged in</a> to post a comment.', 'Comments', 'entex'), esc_url(wp_login_url(apply_filters('the_permalink', get_permalink()))));

entex_OUT(entex_CMD('COMMENT FORM'));
comment_form(
	array(
		'title_reply' => esc_html(_x('Submit a comment', 'Comments', 'entex')),
		'cancel_reply_link' => esc_html(_x('Cancel', 'Comments', 'entex')),
		'title_reply_before' => '<h2 id="reply-title" class="comment-reply-title">',
		'title_reply_after'  => '</h2>'."\r\n",
		'cancel_reply_before' => ' ',
		'cancel_reply_after' => '',
		'class_form' => 'comment-form ua-content ua-form',
		'comment_notes_before' => '<p class="comment-notes"><span class="required">*</span><span id="email-notes">'. esc_html($comment_notes_before) .' </span></p>',
		'must_log_in' => '<h5><span>'. wp_kses_post($must_log_in) .'</span></h5>',
		'logged_in_as' => wp_kses_post($logged_in_as)
	)
);
entex_OUT(entex_CMD('END COMMENT FORM'));
?>
</section>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- SECTION COMMENTS END -->
<?php do_action('entex_template_after_template', 5, '', __FILE__, entex_backtrace(2)); ?>