
/* 
* PLUGIN: Entex extended block attributes
*
* Version: 2.20925
* Applies to Wordpress back-end
* Author: Jonas Lundman
* More information and documentation at
* http://entex.info
*
*/

// Updated 2022 09 25

wp.domReady(function(){ 

	wp.blocks.unregisterBlockStyle('core/image', 'rounded');
	wp.blocks.unregisterBlockStyle('core/image', 'default');
	
});

;(function($){
	$(document).ready(function(){
		
		var transported_1 = ENTEX_THEME_GUTENBERG_BACKEND.locations;
		var locations = $.parseJSON(transported_1);
		
		var transported_2 = ENTEX_THEME_GUTENBERG_BACKEND.positions;
		var positions = $.parseJSON(transported_2);
		
		var data = ENTEX_THEME_GUTENBERG_BACKEND.data;
		var Arr = $.parseJSON(data);
		
		/* Additional CSS */
		var txt_1 = ENTEX_THEME_GUTENBERG_BACKEND.txt_1;
		/* Theme Locations */
		var txt_2 = ENTEX_THEME_GUTENBERG_BACKEND.txt_2;
		/* Remove current widgets */
		var txt_3 = ENTEX_THEME_GUTENBERG_BACKEND.txt_3;
		/* Sections cant handle more then 4 columns. Create groups or use another location. */
		var txt_4 = ENTEX_THEME_GUTENBERG_BACKEND.txt_4;
		/* Not supported by Entex Theme */
		var txt_5 = ENTEX_THEME_GUTENBERG_BACKEND.txt_5;
		
		// NOTE: json, transported bool (0) will be true ('0')
		// Pass empty string to transport 0 as bool
		var def_cleanup = ENTEX_THEME_GUTENBERG_BACKEND.def_cleanup;
		var def_open = ENTEX_THEME_GUTENBERG_BACKEND.def_open;
		
		var set_initial_styles = ENTEX_THEME_GUTENBERG_BACKEND.set_initial_styles;

		let blockLoaded = false;
		let blockLoadedInterval = setInterval(function(){
			if($('.editor-styles-wrapper').get(0)){
				blockLoaded = true;
				this_init();
			}
			if(blockLoaded){
				clearInterval(blockLoadedInterval);
			}
		}, 500);
		
		function this_init(){
			
			/* init Entex CSS classnames */
			$('.is-root-container').addClass('ua-main ua-content').parent().addClass('ua-root ua-init');
			if(set_initial_styles) $('.edit-post-visual-editor').addClass(set_initial_styles);
			
			/* void front-end template events and links */
			/* this might be moved into the plugin */
			$(document).on('click', '.entex-block-content a', function(event){ return false; });

			/* init Entex CSS classnames Classic editor */
			$('.block-library-rich-text__tinymce').addClass('ua-content');
			/* dynamic */
			$(document).on('focus', '.block-library-rich-text__tinymce', function(){
				$('.block-library-rich-text__tinymce').addClass('ua-content');
			});
			
			/* version 5.9 changed script priority within iframes */
			/* we cant reach the frame yet */
			$(document).on('click', '.block-editor-post-preview__button-resize', function(event){
				alert(txt_5);
				if($(this).index() == 2){
					$('.is-root-container').addClass('ua-not-main ua-content').removeClass('ua-main');
				} else { 
					$('.is-root-container').addClass('ua-main ua-content').removeClass('ua-not-main');
				}
			});
			
			/* set border if checked in entex theme metabox */
			if($('.editor-post-featured-image__container').get(0)){
				if($('#entex_post_thumbnail_border').is(':checked')) $('.editor-post-featured-image__container').addClass('ua-admin-set-border');
				if($('#entex_post_thumbnail_hide').is(':checked')) $('.editor-post-featured-image__container').addClass('ua-admin-set-hidden');
			}
			
			/* toggle border when checked in entex theme metabox */
			$(document).on('click', '#entex_post_thumbnail_border', function(){
				if($('#entex_post_thumbnail_border').is(':checked')){
					$('.editor-post-featured-image__container').addClass('ua-admin-set-border');
				} else { 
					$('.editor-post-featured-image__container').removeClass('ua-admin-set-border');
				}
			});
			
			/* toggle opacity when checked in entex theme metabox */
			$(document).on('click', '#entex_post_thumbnail_hide', function(){
				if($('#entex_post_thumbnail_hide').is(':checked')){
					$('.editor-post-featured-image__container').addClass('ua-admin-set-hidden');
				} else { 
					$('.editor-post-featured-image__container').removeClass('ua-admin-set-hidden');
				}
			});


			if(def_open) $('#entex-gutenberg-metabox.closed:visible').find('.postbox-header h2').trigger('click');
			
			/* default boxes */
			$(document).on('click', '.components-panel__body:not(.ua-tmp-false) .components-panel__body-toggle', function(){
				
				var $panel = $(this).closest('.components-panel__body');
				$panel.addClass('ua-tmp-filter-me-out');
				var $siblings = $('.components-panel__body:visible, #side-sortables:visible > .postbox');
				$siblings.addClass('ua-tmp-false');

				/* note, since 5.9 some panels are outside the siblings */
				/* we need to parse all the panels - except this (current) one */
				$siblings.not('.ua-tmp-filter-me-out').not('.ua-tmp-protected').filter('.is-opened').find('.components-panel__body-toggle').trigger('click');
				/* metaboxes */
				$('#side-sortables:visible > .postbox').not('.closed').not('.ua-tmp-protected').find('.postbox-header h2').trigger('click');
				
				$siblings.removeClass('ua-tmp-false');
				$panel.removeClass('ua-tmp-filter-me-out');
				$('.interface-interface-skeleton__sidebar').stop().animate({ scrollTop: ($panel.position().top) - ($('.interface-complementary-area-header').outerHeight()) }, 300);
			});
			
			/* metaboxes */
			$(document).on('click', '#side-sortables > .postbox:not(.ua-tmp-false) .postbox-header h2', function(){
				
				var $panel = $(this).closest('.postbox');
				var $siblings = $('.components-panel__body:visible, #side-sortables:visible > .postbox');
				$siblings.addClass('ua-tmp-false');

				$panel.siblings('.postbox').not('.closed').not('.ua-tmp-protected').find('.postbox-header h2').trigger('click');
				$('.components-panel__body:visible').not('.ua-tmp-protected').filter('.is-opened').find('.components-panel__body-toggle').trigger('click');

				$siblings.removeClass('ua-tmp-false');
				$('.interface-interface-skeleton__sidebar').stop().animate({ scrollTop: ($panel.offset().top) - ($('.interface-complementary-area-header').outerHeight()) }, 300);

			});
			
			
			/* metaboxes below editor */
			$(document).on('click', '#normal-sortables > .postbox:not(.closed) .postbox-header h2', function(){
				var $el = $(this).closest('.postbox');
				$el.siblings('.postbox').not('.closed').find('.postbox-header h2').trigger('click');
				$('.interface-interface-skeleton__content').stop().animate({ scrollTop: ($el.offset().top) + ($('.edit-post-visual-editor').outerHeight() - 50) }, 300);
			});
			
			/* parse add classnames to loacted blocks */
			

			
			
			function setCookie(key, value, expiry) {
				var expires = new Date();
				expires.setTime(expires.getTime() + (expiry * 24 * 60 * 60 * 1000));
				document.cookie = key + '=' + value + ';expires=' + expires.toUTCString();
			}

			function getCookie(key) {
				var keyValue = document.cookie.match('(^|;) ?' + key + '=([^;]*)(;|$)');
				return keyValue ? keyValue[2] : null;
			}
			/*
			$(document).on('change', '.components-input-control__container select', function(event){ 
				var cookie = getCookie('entex_editor_image');
				if($(this).find('option[value="medium_large"]').get(0)){
					setCookie('entex_editor_image', $(this).val(), 10);
				}
			});
			*/
			function findSelect(){
				var end = 0;
				let selectLoaded = false;
				let selectLoadedInterval = setInterval(function(){
					end++;
					var option = $('.components-input-control__container option[value=full]').get(0);
					if(option){
						selectLoaded = true;
						var sel = $(option).parent().get(0);
						var native = Object.getOwnPropertyDescriptor(window.HTMLSelectElement.prototype, 'value').set;
						native.call(sel, 'medium_large');
						sel.dispatchEvent(new Event('change', {'bubbles': true}));
						
						link = $(option).closest('.components-panel__body').find('option[value=media]').get(0);
						if(link){
							sel = $(link).parent().get(0);
							var native = Object.getOwnPropertyDescriptor(window.HTMLSelectElement.prototype, 'value').set;
							native.call(sel, 'media');
							sel.dispatchEvent(new Event('change', {'bubbles': true}));
						}
					}
					if(end > 10 || selectLoaded){
						clearInterval(selectLoadedInterval);
					}
				}, 500);
			}
			/*
			$(document).on('focus', 'figcaption:not(.ua-tmp-focused)', function(event){ 
				$(this).addClass('ua-tmp-focused');
				if($(this).closest('.wp-block-image').get(0)){
					findSelect();
				}
			});
			*/
			
			
			/* THE MAIN TRIGGER FUNCTION */
			$(document).on('focus', '.editor-styles-wrapper .is-root-container', function(event){
				
				let blockInspectorLoaded = false;
				let blockInspectorLoadedInterval = setInterval(function(){
					var button = $('.block-editor-block-inspector__advanced').find('.components-panel__body-toggle').get(0);
					if(button){
						createLocatedInfo();
						blockInspectorLoaded = true;
						/* prevent panel toggle events */
						$(button).closest('.components-panel__body').addClass('ua-tmp-false');
						/* image panel never close - we need the size dropdown in focus */
						$('.block-editor-image-size-control').closest('.components-panel__body').addClass('ua-tmp-protected');
						
						
						/* we always need to close advanced if it open */
						/* sometimes react dont do this */
						if($(button).is('.is-opened button')){
							$(button).trigger('click');
						}

						/* insert classnames into side sortables */
						$('body').removeClass('typography-block-support-panel-show');
						if($(event.target).attr('data-type')){
							var type = $(event.target).attr('data-type'); 
							if($(event.target).closest('.wp-block-cover').get(0)){
								$('body').addClass('typography-block-support-panel-show');
							}
							$('body').addClass('typography-block-support-panel-show');
							if(type){
								type = type.replace('/', '-');
								var current = $('.block-editor-block-inspector').data('current-block');
								if(current){
									$('.block-editor-block-inspector').removeClass(current);
								}
								$('.block-editor-block-inspector').data('current-block', type).addClass(type);
							}
						}
						
						if(def_cleanup){
							$('.components-panel__body-toggle[aria-expanded=true]').not('.ua-tmp-protected *').trigger('click');
							/* seems stable since 5.9 */
							//$('.components-resizable-box__container').removeAttr('class').removeAttr('style');
						}

					}
					if(blockInspectorLoaded){
						clearInterval(blockInspectorLoadedInterval);
						/* trigger the loading functions */
						if(def_open){
							$(button).trigger('click');
						}
						/* restore panel toggle events */
						$(button).closest('.components-panel__body').removeClass('ua-tmp-false');
					}
				}, 300);
				
			});
			

			$(document).on('click', '.block-editor-block-inspector__advanced .components-panel__body-toggle', function(){
				let blockInspectorLoaded = false;
				let blockInspectorLoadedInterval = setInterval(function(){
					/* Find Additional CSS class(es) field */
					var input = $('.block-editor-block-inspector__advanced').find('.components-base-control:last-child input').get(0);
					if(input){
						blockInspectorLoaded = true;
						createElementEntex(input);
					}
					if(blockInspectorLoaded){
						clearInterval(blockInspectorLoadedInterval);
					}
				}, 300);
				
			});

		}
		
		/* reusable blocks are lazy loading, must init on first edit click */
		$('body').data('created-locations', 0);
		function createLocatedInfo(){
			console.log('start');
			if($('body').data('created-locations')) return;
			var $located = $('.editor-styles-wrapper .is-root-container [class*=-location-]');
			if(!$located.get(0)) return;
			console.log('found');
			$located.each(function(){
				var $block = $(this);
				var classnames = $(this).attr('class');
				$.each(locations, function(location, name){
					if(classnames.match(location)){
						$block.attr('title', name).attr('data-location', name);
					}
				});
			});
			$('body').data('created-locations', 1);
		}
		
		function createElementEntex(input){
			
			var $wrapper = $(input).closest('.components-base-control');
			if($wrapper.find('.entex-created-element').get(0)){
				$wrapper.find('.entex-created-element').remove();
			}
			
			var $root = $('.editor-styles-wrapper .is-root-container');
			var node = $root.find('.is-selected').get(0);
			var element = node.nodeName.toLowerCase();
			var type = $(node).attr('data-type');
			
			var $wr = $('<div />').addClass('entex-created-element').css('margin', '1em 0');
			$wrapper.append($wr);
			
			var css = {
				'padding': '0.5em',
				'border-width': '1px',
				'border-style': 'dashed',
				'border-color': '#ccc'
			};
			
			var $pl = $('<div />').addClass('entex-created-position').css('display', 'none').css({
				'margin': '0.5em 0 0 0',
				'padding': '0.25em 0 0.5em 0',
				'border-width': '1px 0px 0px 0px',
				'border-style': 'dashed',
				'border-color': '#ccc'
			});
			
			var ref = {
				'display': 'block',
				'float': 'right',
				'height': '16px',
				'width': '16px',
				'margin': '1px 5px 0px 5px',
				'border-width': '1px',
				'border-style': 'solid',
				'border-color': '#ccc'
			};
			
			
			if(Arr[type] === undefined) var has_css = false;
				else var has_css = true;
				
			if(Arr['core/all'] !== undefined){
				if(has_css){
					var AllA = Object.assign({}, Arr[type], Arr['core/all']);
				} else {
					var AllA = Arr['core/all'];
					has_css = true;
				}
			}
				
			if(has_css){
			
			var $innerHTML = $('<div />').addClass('entex-created-group entex-created-additional').css(css).css('margin-bottom', '1em');
			var $headingHTML = $('<div />').addClass('entex-created-heading').css('margin', '0.5em 0 0.5em 0').text(txt_1);
			$wr.append($headingHTML, $innerHTML);
			$.each(AllA, function(classname, name){
				var valid = '*';
				if(Arr['is'][classname] !== undefined) valid = Arr['is'][classname];
				
				var $label = $('<label />').text(' ' + name).css('display', 'block').css('margin', '0.25em 0').data('validate', classname);
				var $el = $('<input type="checkbox" />');
				$label.prepend($el);
				$innerHTML.append($label.hide());
				var not_valid = false;
				if($(node).is(valid)) $label.show();
					else not_valid = true;

				var cls = classname;
				var initial = $(input).val();
				if(initial && initial.match(cls)){
					$el.prop('checked', true);
				}
				$el.on('click', function(){
					var value = $(input).val();
					if(!$(this).is(':checked')){
						var classes = value.split(' ').filter(function(c) {
							return c.lastIndexOf(cls, 0) !== 0;
						});
						classes = classes.join(' ').trim();
					} else {
						var classes = value + ' ' + cls;
					}
					var native = Object.getOwnPropertyDescriptor(window.HTMLInputElement.prototype, 'value').set;
					native.call(input, classes);
					input.dispatchEvent(new Event('input', {'bubbles': true}));
						
					$innerHTML.find('label').each(function(){
						var validated = '*';
						var validate = $(this).data('validate'); 
						if(Arr['is'][validate] !== undefined) validated = Arr['is'][validate];
						if($(node).is(validated)){
							$(this).show();
						} else {
							if($(this).find('input:checked').get(0)){
								$(this).find('input:checked').each(function(){
									$(this).trigger('click');
								});
							}
							//$(this).find('input').prop('checked', false);
							$(this).hide();
						}
					});
						
				});
					
				if(not_valid && $el.is(':checked')){ 
					$el.trigger('click'); 
				}
			});
			}
			
			
			if($(node).is('.is-root-container > *, .wp-block.is-reusable > div > *')){
				
			var $innerLocations = $('<div />').addClass('entex-created-group').css(css);
			var $headingLocations = $('<div />').addClass('entex-created-heading').css('margin', '0 0 0.5em 0').text(txt_2);
			$wr.append($headingLocations, $innerLocations);
			$.each(locations, function(location, name){
				
				var $label = $('<label />').text(' ' + name).css('display', 'block').css('margin', '0.25em 0');
				var $monitor = $('<span />').text('').css('display', 'block').css('float', 'right').css('margin-left', '5px').attr('data-location', location);
				var $el = $('<input type="checkbox" />').attr('id', location);
				$label.prepend($el);
				$innerLocations.append($label.append($monitor));
				
				var disable = false;
				var added = $('.' + location).get();
				if(added.length) {
					var monited = added.length;
					if(location.match('-section-') && monited == 4) disable = true;
					$(added.reverse()).each(function(){
						var $dom = $(this);
						var $reference = $('<span />').text('').css(ref).attr('title', $dom.attr('data-type'));
						$reference.click(function(){
							$dom.focus();
							return false;
						});
						$label.append($reference);
					});
				} else var monited = '0';
				$monitor.text(monited);
				
				if(location == 'entex-location-sidebar'){
					$el.val(location);
				} else $el.val('');

				var cls = location;
				var initial = $(input).val();
				var init = false;
				if(initial && initial.match(cls)){
					$el.prop('checked', true);
					init = true;
				}
				$el.on('click', function(){
					var value = $(input).val();
					if(!$(this).is(':checked')){ 
						var classes = value.split(' ').filter(function(c) {
							return c.lastIndexOf(cls, 0) !== 0;
						});
						classes = classes.join(' ').trim();
						/* content */
						$(node).removeAttr('title').removeAttr('data-location');
						
						if($(this).val() == 'entex-location-sidebar'){
							var $box = $(this).parent().next('.entex-created-position');
							if($box.find(':checked')){
								$box.find(':checked').prop('checked', false);
								classes = classes.replace('entex-position-replace', '').trim();
							}
							$box.slideUp('fast');
						}
					} else {
						if(disable){
							alert(txt_4);
							return false;
						}
						var classes = value + ' ' + cls;
						if($(this).val() == 'entex-location-sidebar'){
							$(this).parent().next('.entex-created-position').slideDown('fast').find('input').prop('checked', false).parent().css('opacity', '');
						}
						/* content */
						$(node).attr('title', name).attr('data-location', name);
					}
					var native = Object.getOwnPropertyDescriptor(window.HTMLInputElement.prototype, 'value').set;
					native.call(input, classes);
					input.dispatchEvent(new Event('input', {'bubbles': true}));
					createElementEntex(input);
				});
				
				if(location == 'entex-location-sidebar'){
					
					var pl_name = txt_3;
					var $pl_label = $('<label />').text(' ' + pl_name).css('display', 'block').css('margin', '0.25em 0 0.5em 0');
					var $pl_el = $('<input type="checkbox" />').attr('id', 'entex-remove-current-widgets');
					$pl_label.prepend($pl_el);
					$innerLocations.append($pl.append($pl_label));
					if(init) $pl.show();

					initial = $(input).val();
					if(initial && initial.match('entex-position-replace')){
						$pl_el.prop('checked', true);
					}
					
					$pl_el.data('monitored', 0);
					if($('.is-root-container .entex-position-replace').get(0)){
						var $repo = $('<span />').text('A').css('display', 'block').css('float', 'right').click(function(){
							$($('.is-root-container .entex-position-replace').get(0)).focus();
							return false;
						});
						$pl_label.append($repo);
						$pl.show();
						
						if(!$pl_el.prop('checked')){
							$pl_label.css('opacity', '0.5');
							$pl_el.prop('checked', true).data('monitored', 1);
						}
					}
					
					$pl_el.on('click', function(){
						var recheck = 0;
						if(!$('#entex-location-sidebar').is(':checked')) return false;
						if($(this).data('monitored')){
							$(this).data('monitored', 0).parent().css('opacity', '');
							recheck = 1;
						}
						var pl_value = $(input).val();
						if(!$(this).is(':checked') && !recheck){
							var pl_classes = pl_value.split(' ').filter(function(c) {
								return c.lastIndexOf('entex-position-replace', 0) !== 0;
							});
							pl_classes = pl_classes.join(' ').trim();
						} else {
							var pl_classes = pl_value + ' ' + 'entex-position-replace';
							if(recheck) $(this).prop('checked', true);
						}
						var pl_native = Object.getOwnPropertyDescriptor(window.HTMLInputElement.prototype, 'value').set;
						pl_native.call(input, pl_classes);
						input.dispatchEvent(new Event('input', {'bubbles': true}));
					});
					
				}
			});
			
			} else {
				$.each(locations, function(location, name){
					var cls = location;
					var initial = $(input).val();
					if(initial && initial.match(cls)){
						var value = $(input).val();
						var classes = value.split(' ').filter(function(c) {
							return c.lastIndexOf(cls, 0) !== 0;
						});
						classes = classes.join(' ').trim();
						var native = Object.getOwnPropertyDescriptor(window.HTMLInputElement.prototype, 'value').set;
						native.call(input, classes);
						input.dispatchEvent(new Event('input', {'bubbles': true}));
					}
				});
			}
			

		}

	});

})(jQuery);
