
/* 
* ENTEX THEME YOAST javascript plugin file, thanks to Jonas Lundman
*
* Version: 1.0
* Applies to Wordpress back-end
*
* More information and documentations at
* http://entex.info
* http://intervik.com
*
*/

// UPDATED 2021 11 21


(function(){

	EntexExcerptYoastPlugin = function(){
		YoastSEO.app.registerPlugin( 'entexExcerptYoastPlugin', {status: 'ready'} );
  
		/**
		* @param modification 	{string} 	The name of the filter
		* @param callable 		{function} 	The callable
		* @param pluginName 	{string} 	The plugin that is registering the modification.
		* @param priority 		{number} 	(optional) Used to specify the order in which the callables
		* 						associated with a particular filter are called. Lower numbers
		* 						correspond with earlier execution.
		*/
		YoastSEO.app.registerModification( 'data_meta_desc', this.modifyDescription, 'entexExcerptYoastPlugin', 1 );
	}

	/* only if excerpt if empty - Yoast settings will remain */
	EntexExcerptYoastPlugin.prototype.modifyDescription = function(description){
		if(!description) description = ENTEX_THEME_ADMIN_YOAST.excerpt; 
		return description;
	};
  
	/** if Yoast SEO is already loaded, instantiate the plugin */
	if ( typeof YoastSEO !== 'undefined' && typeof YoastSEO.app !== 'undefined' ) {
		new EntexExcerptYoastPlugin();
	}
	/** Yoast SEO will trigger a ready event when initialized. Load the plugin right after. */
	else {
		jQuery(window).on(
			'YoastSEO:ready',
			function() {
				new EntexExcerptYoastPlugin();
			}
		);
	}
}());
