<?php
/**
 * Displays site header style three.
 *
 * @package enron WordPress Theme
 * @subpackage Aqwa
 * @since  1.0
 *
 */

$wrapper_classes  = 'site-header';
$wrapper_classes .= has_custom_logo() ? ' has-logo' : '';
$wrapper_classes .= display_header_text() ? ' has-title-and-tagline' : '';
$wrapper_classes .= has_nav_menu( 'primary' ) ? ' has-menu' : '';
$wrapper_classes .= ' header-style-three';

$aqwa_blog_info    = get_bloginfo( 'name' );
$aqwa_description  = get_bloginfo( 'description', 'display' );
$aqwa_header_class = display_header_text() ? 'site-title' : 'screen-reader-text';

?>
<header id="main-header" class="main-header <?php echo esc_attr( $wrapper_classes ) ?> ">

	<div class="about-topbar-desktop">
		<button class="close-btn" data-bs-toggle="collapse" aria-expanded="false"> <i class="fas fa-times"> </i> </button>
		<?php do_action( 'Aqwa_Header_Top_Bar' ) ?>
		<div class="middle-bar">
			<div class="container">
				<div class="space-betwee">
					<div class="logo"> 
						<?php if ( has_custom_logo() ) : ?>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
								<?php the_custom_logo(); ?>
							</a>
						<?php endif; ?>
						<?php if( display_header_text() ) :	 ?>
							<div class="site-branding">
								<h1 class="<?php echo esc_attr( $aqwa_header_class ); ?>">
									<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo esc_html( $aqwa_blog_info ); ?></a></h1>
									<p class="site-description">
										<?php echo esc_html($aqwa_description);  ?>
									</p>
								</div>

							<?php endif; ?>	
						</div>
						

						<nav class="navbar navbar-expand-lg">
							<div class="logo">
								<?php if ( has_custom_logo() ) : ?>
									<?php the_custom_logo(); ?>
								<?php endif; ?>	
								<?php if( display_header_text() ) :	 ?>
									<div class="site-branding">
										<h1 class="<?php echo esc_attr( $aqwa_header_class ); ?>"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo esc_html( $aqwa_blog_info ); ?></a></h1>
										<p class="site-description">
											<?php echo esc_html($aqwa_description);  ?>
										</p>
									</div>
								<?php endif; ?>					
							</div>
							<div class="hiddn-btn">				
								<button  type="button"  class="sidbar-btn icon" data-bs-toggle="collapse" href="#sidbar" role="button" aria-expanded="false"> <span></span> </button>
								<div class="collapse about-sidbar" id="sidbar">
									<div class="sidbar-container">
										<button class="close-btn" data-bs-toggle="collapse" href="#sidbar" aria-expanded="false"> <i class="fas fa-times"> </i> </button>
										<?php do_action( 'Aqwa_Header_Top_Bar' ) ?>
										<div class="middle-bar">
											<div class="container">
												<div class="space-betwee">								
													<?php do_action( 'Aqwa_Header_Contact_Details') ?>	
												</div>
											</div>
										</div>
									</div>
								</div>
								<button class="navbar-toggler menu icon" type="button" data-bs-toggle="collapse" data-bs-target="#navbarTogglerDemo01" aria-controls="navbarTogglerDemo01" aria-expanded="false" aria-label="Toggle navigation">
									<span></span>
								</button>					
							</div>

							<div class="collapse navbar-collapse" id="navbarTogglerDemo01">			
								<?php 
								wp_nav_menu( 
									array(  
										'theme_location' => 'primary',
										'container'  => '',
										'menu_class' => 'navbar-nav me-auto mb-2 mb-lg-0',
										'fallback_cb' => 'Aqwa_WP_Bootstrap_Navwalker::fallback',
										'walker' => new Aqwa_WP_Bootstrap_Navwalker()
									) 
								);
								?>
								<?php do_action( 'Aqwa_Navbar_Search_Button') ?>
								<button class="navbar-toggler2 last-menu" type="button" data-bs-toggle="collapse" data-bs-target="#navbarTogglerDemo01" aria-controls="navbarTogglerDemo01" aria-expanded="true" aria-label="Toggle navigation"><span class="fas fa-times"></span></button>
							</div>
						</nav>
						
					</div>
				</div>
			</div>
		</div>
		<?php do_action('Aqwa_Overlay_Search_Container'); ?>
	</header>	
	