<?php
/**
 * The Header for our theme.
 *
 * @since 1.0.0 
 *
 * @package Enron WordPress Theme
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
	<link rel="pingback" href="<?php echo esc_url(get_bloginfo( 'pingback_url' )); ?>">
<?php endif; ?>
<?php wp_head(); ?>

</head>
<body <?php body_class('bg-white'); ?>>
	<?php wp_body_open(); ?>
	<div class="aqwa-wrapper">
		<a class="skip-link screen-reader-text" href="#main_content"><?php esc_html_e('Skip to content', 'enron'); ?></a>
		<?php
		enron_header_style();
		get_template_part('template-parts/sections/section-breadcrumb');
		?>
		<div id="main_content" class="aqwa-main-content">