<?php
/**
 * enron functions and definitions
 *
 * enron only works in WordPress 5.6 or later.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package enron WordPress Theme
 */


if ( ! function_exists( 'wp_body_open' ) ) {

	function wp_body_open() {
		/**
		 * Triggered after the opening <body> tag.
		 */
		do_action( 'wp_body_open' );
	}
}

if ( ! function_exists( 'enron_header_style' ) ) {
	/**
	 * Theme header style
	 * 
	 */
	function enron_header_style() {
		get_template_part( 'template-parts/header/header-style' );
	}
}

// 

if ( ! class_exists( 'enron_General_Operation' ) ) {

	class enron_General_Operation{

		/**
		 * Constructor start
		 */
		public function __construct() {	
					
			add_action( 'wp_enqueue_scripts', array( $this, 'scripts' ), 999 );
		}

		// theme style & scripts
		public function scripts(){
			$parent_style = 'aqwa-parent-style';
			wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
			wp_enqueue_style( 'enron-style', get_stylesheet_uri(), array( $parent_style ) );
			wp_enqueue_style('enron-header-style',get_stylesheet_directory_uri().'/assets/css/header-style.css');			
			wp_enqueue_script('enron-custom',get_stylesheet_directory_uri().'/assets/js/custom.js',array('jquery'));			
			
		}

		
	}

	new enron_General_Operation();
}

