<?php 

global $elonissa_fn_option;
$post_type				= 'post';
if (isset($args['post_type'])) {
	$post_type 			= $args['post_type'];
}
$has_sidebar			= 'full';
if (isset($args['has_sidebar'])) {
	$has_sidebar 		= $args['has_sidebar'];
}
if (have_posts()) : while (have_posts()) : the_post();
	$post_ID 			= get_the_id();
	$authorMeta 		= elonissa_fn_get_author_meta($post_ID);
	$post_title			= '';
	if(get_the_title() !== ''){
		$post_title 	= '<div class="post_title"><h3 class="fn__title">'.get_the_title().'</h3></div>';
	}
		

	$post_thumbnail_id 	= get_post_thumbnail_id( $post_ID );
	$src 				= wp_get_attachment_image_src( $post_thumbnail_id, 'full');
	$image_URL 			= '';
	$has_image			= 0;
	if(isset($src[0])){
		$image_URL 		= $src[0];
	}
	if($image_URL != ''){
		$has_image		= 1;
	}
	$category_box		= elonissa_fn_get_category_info($post_ID,$post_type, 999);

	$getInfoAboutAuthor = elonissa_get_author_info();

	$extra_meta			= elonissa_fn_meta();
	
	
?>

<div class="elonissa_fn_pagetitle">
	<div class="fn-container">
		<div class="title_holder">
			<?php echo wp_kses($category_box, 'post');?>
			<?php echo wp_kses($post_title, 'post');?>
		</div>
	</div>
</div>



<!-- POST CONTENT -->
<div class="elonissa_fn_post_content fn_<?php echo esc_attr($has_sidebar);?>">
	
	<!-- Content without title, image and comments -->
	<div class="fn_single_content">
		
	<?php if($has_sidebar != 'full'){ ?>
	<div class="fn-container fn_single_sidebar">
		<div class="elonissa_fn_hassidebar">
			<div class="elonissa_fn_leftsidebar">
	<?php } ?>

	<div class="fn_post_image" data-image="<?php echo esc_attr($has_image);?>">
		<div class="fn-container">
			<img src="<?php echo esc_url($image_URL);?>" alt="<?php echo esc_attr__('Post Image', 'elonissa');?>" />
		</div>
	</div>
	
	<div class="blog_meta">
		<div class="fn-container">
			<?php echo wp_kses($extra_meta, 'post'); ?>
		</div>
	</div>
	
	
	<!-- Elementor and Classic Content -->
	<div class="blog_content">
		<div class="fn-container">
		<?php the_content(); ?>
		</div>
	</div>
	<!-- /Elementor and Classic Content -->

	
					
	<!-- Information -->
	<div class="blog_info">
		<div class="fn-container">
			<?php echo wp_kses($getInfoAboutAuthor, 'post');?>
			<?php if(has_tag()){?>
				<div class="elonissa_fn_tags">
					<label><?php echo wp_kses(elonissa_fn_getSVG_theme('tag'),'post'); the_tags(esc_html_e('Tags:', 'elonissa').'</label>', ', '); ?>
				</div>
			<?php } ?>
		</div>
		<?php wp_link_pages(
			array(
				'before'      => '<div class="fn_narrow_container"><div class="elonissa_fn_pagelinks"><span class="title">' . esc_html__( 'Pages:', 'elonissa' ). '</span>',
				'after'       => '</div></div>',
				'link_before' => '<span class="number">',
				'link_after'  => '</span>',
			)); 
		?>
	</div>
	<!-- /Information -->
		
	<?php if($has_sidebar != 'full'){?>
				</div>
			<div class="elonissa_fn_rightsidebar">
				<?php get_sidebar(); ?>
			</div>
		</div>
	</div>
	<?php } ?>
	</div>
	<!-- /Content without title, image and comments -->
	
	<?php if ( comments_open() || get_comments_number()){?>
	<!-- POST COMMENT -->
	<div class="elonissa_fn_comment_wrapper">
		<div class="fn-container">
			<div class="elonissa_fn_comment" id="comments">
				<div class="comment_in">
					<?php comments_template(); ?>
				</div>
			</div>
		</div>
	</div>
	<!-- /POST COMMENT -->
	<?php } ?>
	
	
</div>
<?php endwhile; endif;wp_reset_postdata();?>