<?php

get_header();

global $post, $elonissa_fn_option;


$layout 			= 'boxed';
if(isset($elonissa_fn_option['search_layout'])){
	$layout			= $elonissa_fn_option['search_layout'];
}

$seo_page_title 			= 'h3';
if(isset($elonissa_fn_option['seo_page_title'])){
	$seo_page_title 		= $elonissa_fn_option['seo_page_title'];
}
$seo_page_title__start 		= sprintf( '<%1$s class="fn__title">', $seo_page_title );
$seo_page_title__end 		= sprintf( '</%1$s>', $seo_page_title );


// SEO
$seo_404_desc 				= 'p';
if(isset($elonissa_fn_option['seo_404_desc'])){
	$seo_404_desc 			= $elonissa_fn_option['seo_404_desc'];
}
$seo_404_desc__start 		= sprintf( '<%1$s class="fn__desc">', $seo_404_desc );
$seo_404_desc__end 			= sprintf( '</%1$s>', $seo_404_desc );

$layout = 'full';
if(elonissa_fn_if_has_sidebar()){
	$layout = 'ws';
}
?>
	
<div class="elonissa_fn_search_page">

	<div class="elonissa_fn_pagetitle">
		<div class="fn-container">
			<div class="title_holder">
				<?php echo wp_kses($seo_page_title__start,'post'); ?>
				<?php printf( esc_html__('Results For: "%s"', 'elonissa'), get_search_query() ); ?>
				<?php echo wp_kses($seo_page_title__end,'post'); ?>
			</div>
		</div>
	</div>

	<div class="elonissa_fn_searchpagelist">
		<?php if(have_posts()){ ?>
		<div class="fn-container">
		<?php } ?>
		<?php if(have_posts()){ ?>
			
			<?php if($layout == 'ws'){ ?>
			<div class="elonissa_fn_hassidebar">
				<div class="elonissa_fn_leftsidebar">
					<div class="sidebar_in">
						<div class="fn-container">
							<ul class="elonissa_fn_searchlist">
								<?php get_template_part( 'template-parts/posts', '', array('from_page' => 'search')  );?>
							</ul>
							<div class="clearfix"></div>
							<?php elonissa_fn_pagination(); ?>
						</div>
					</div>
				</div>

				<div class="elonissa_fn_rightsidebar">
					<div class="sidebar_in">
						<?php get_sidebar(); ?>
					</div>
				</div>
			</div>
			
			<?php }else{ ?>
			<div class="fn-container">
				<ul class="elonissa_fn_searchlist">
					<?php get_template_part( 'template-parts/posts', '', array('from_page' => 'search')  );?>
				</ul>
				<div class="clearfix"></div>
				<?php elonissa_fn_pagination(); ?>
			</div>
			<?php } ?>
			
			<?php }else{ ?>
			<div class="elonissa_fn_search_not_found">
				<div class="fn-container">
					<div class="title_holder">
						<?php 
							echo wp_kses($seo_404_desc__start,'post');
							esc_html_e('Sorry, no content matched your criteria. Try searching for something else.', 'elonissa');
							echo wp_kses($seo_404_desc__end,'post');
						?>
					</div>
					<div class="search_holder">
						<form action="<?php echo esc_url(home_url('/')); ?>" method="get" >
							<div>
								<input type="text" placeholder="<?php esc_attr_e('Search anything...','elonissa');?>" name="s" autocomplete="off" />
								<input type="submit" class="pe-7s-search" value="" />
								<span><?php echo wp_kses(elonissa_fn_getSVG_theme('search'), 'post');?></span>
							</div>
						</form>
					</div>
				</div>
			</div>
			<?php } ?>
		<?php if(have_posts()){ ?>
		</div>
		<?php } ?>
	</div>

	<?php wp_reset_postdata(); ?>
</div>
<!-- /SEARCH --> 
        
<?php get_footer('null'); ?>   