<?php
/*
	Template Name: Blog Page
*/
get_header();

global $post, $elonissa_fn_option;
$elonissa_fn_pagetitle 	= '';
$elonissa_fn_pagestyle 	= 'ws';

if(function_exists('rwmb_meta')){
	$elonissa_fn_pagetitle 		= get_post_meta(get_the_ID(), 'elonissa_fn_page_title', true);
	$elonissa_fn_pagestyle 		= get_post_meta(get_the_ID(), 'elonissa_fn_page_style', true);
}

if(isset($_GET['blog_layout'])){$elonissa_fn_pagestyle = $_GET['blog_layout'];}

if($elonissa_fn_pagestyle == 'ws' && !elonissa_fn_if_has_sidebar()){
	$elonissa_fn_pagestyle		= 'full';
}


// CHeck if page is password protected	
if(post_password_required($post)){
	$protected = elonissa_fn_protectedpage();
	echo wp_kses($protected, 'post');
}
else
{
	$seo_page_title 			= 'h3';
	if(isset($elonissa_fn_option['seo_page_title'])){
		$seo_page_title 		= $elonissa_fn_option['seo_page_title'];
	}
	$seo_page_title__start 		= sprintf( '<%1$s class="fn__title">', $seo_page_title );
	$seo_page_title__end 		= sprintf( '</%1$s>', $seo_page_title );
	
	$pageContent 				= get_the_content();
	$hasContent = 0; if($pageContent != ''){$hasContent = 1;}
?>
	
	<div class="elonissa_fn_blog_content" data-content="<?php echo esc_attr($hasContent);?>">
		<div class="blog_content">
			<?php the_content();?>
		</div>
	</div>
	
	<?php if($elonissa_fn_pagetitle !== 'disable'){ ?>
	<!-- PAGE TITLE -->
	<div class="elonissa_fn_pagetitle">
		<div class="fn-container">
			<div class="title_holder">
				<?php 
					elonissa_fn_breadcrumbs();
					echo wp_kses($seo_page_title__start,'post');
					the_title();
					echo wp_kses($seo_page_title__end,'post');
				?>
			</div>
		</div>
	</div>
	<!-- /PAGE TITLE -->
	<?php } ?>

	<div class="fn_page_blog" data-content="<?php echo esc_attr($hasContent);?>">
		<div class="fn-container">

			<?php if($elonissa_fn_pagestyle == 'full'){ ?>

			<!-- WITHOUT SIDEBAR -->
			<div class="elonissa_fn_nosidebar">
				<ul class="elonissa_fn_postlist">
					<?php get_template_part( 'template-parts/posts' );?>
				</ul>
				<div class="clearfix"></div>
				<?php elonissa_fn_pagination(); ?>
			</div>
			<!-- /WITHOUT SIDEBAR -->
			
			<?php }else{ ?>

			<!-- WITH SIDEBAR -->
			<div class="elonissa_fn_hassidebar">
				<div class="elonissa_fn_leftsidebar">
					<div class="sidebar_in">
						<ul class="elonissa_fn_postlist">
							<?php get_template_part( 'template-parts/posts' );?>
						</ul>
						<div class="clearfix"></div>
						<?php elonissa_fn_pagination(); ?>
					</div>
				</div>

				<div class="elonissa_fn_rightsidebar">
					<div class="sidebar_in">
						<?php get_sidebar(); ?>
					</div>
				</div>
			</div>
			<!-- /WITH SIDEBAR -->

			<?php } ?>
		</div>
	</div>


	


<?php } ?>

<?php get_footer(); ?>  