<!DOCTYPE html >
<html <?php language_attributes(); ?>>
<head>
<?php global $elonissa_fn_option, $post; ?>

<meta charset="<?php esc_attr(bloginfo( 'charset' )); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

<?php wp_head(); ?>

</head>
<?php 
	
	$options				= elonissa_fn_header_info();
	$page_title				= $options[0];
	$core_ready				= 'core_absent';
	if(isset($elonissa_fn_option)){
		$core_ready 		= 'core_ready';
	}
?>
<body <?php body_class();?>>
	<?php wp_body_open(); ?>
	
	
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'elonissa' ); ?></a>
	
	<!-- SEARCH POPUP -->
	<div class="elonissa_fn_searchpopup" role="dialog">
		<div class="search_inner">
			<div class="fn-container">
				<div class="search_box">
					<form action="<?php echo esc_url(home_url('/')); ?>" method="get" >
						<input type="text" placeholder="<?php esc_attr_e('Search anything...', 'elonissa');?>" name="s" autocomplete="off" />
						<input type="submit" class="pe-7s-search" value="" />
						<span><?php echo wp_kses_post(elonissa_fn_getSVG_theme('search-new'));?></span>
					</form>
				</div>
			</div>
		</div>
		<a class="search_closer" href="#">
			<span class="s_btn"></span>
		</a>
	</div>
	<!-- /SEARCH POPUP -->

	<!-- HTML starts here -->
	<div class="elonissa-fn-wrapper <?php echo esc_attr($core_ready); ?>" data-page-title="<?php echo esc_attr($page_title); ?>">


		<!-- Header starts here -->
		<?php get_template_part( 'template-parts/desktop-navigation' );?>
		<!-- Header ends here -->


		<!-- Mobile Menu starts here -->
		<?php get_template_part( 'template-parts/mobile-navigation' );?>
		<!-- Mobile Menu ends here -->


		<!-- All website content starts here -->
		<div class="elonissa_fn_content" id="content">
			
			<!-- All content without footer starts here -->
			<div class="elonissa_fn_pages">
				
				