<?php

	add_action( 'after_setup_theme', 'elonissa_fn_setup', 50 );

	function elonissa_fn_setup(){

		// REGISTER THEME MENU
		if(function_exists('register_nav_menus')){
			register_nav_menus(array('main_menu' 	=> esc_html__('Main Menu','elonissa')));
			register_nav_menus(array('mobile_menu' 	=> esc_html__('Mobile Menu','elonissa')));
			register_nav_menus(array('footer_menu' 	=> esc_html__('Footer Menu','elonissa')));
		}

		// This theme styles the visual editor with editor-style.css to match the theme style.
		add_action( 'wp_enqueue_scripts', 'elonissa_fn_scripts', 100 ); 
		add_action( 'wp_enqueue_scripts', 'elonissa_fn_styles', 100 );
		add_action( 'wp_enqueue_scripts', 'elonissa_fn_inline_styles', 150 );
		add_action( 'admin_enqueue_scripts', 'elonissa_fn_admin_scripts' );

		// Actions
		add_action( 'tgmpa_register', 'elonissa_fn_register_required_plugins' );

		// This theme uses post thumbnails
		add_theme_support( 'post-thumbnails' );
		
		
		add_theme_support( 'wp-block-styles' );
		add_theme_support( 'responsive-embeds' );
		add_theme_support( 'html5' );
		add_theme_support( 'custom-logo' );
		add_theme_support( 'custom-header' );
		add_theme_support( 'custom-background' );
		add_theme_support( 'align-wide' );

		set_post_thumbnail_size( 300, 300, true ); 								// Normal post thumbnails
		add_image_size( 'elonissa_fn_thumb-720-9999', 720, 9999, false);			
		add_image_size( 'elonissa_fn_thumb-1200-9999', 1200, 9999, false);			

		//Load Translation Text Domain
		load_theme_textdomain( 'elonissa', get_template_directory() . '/languages' );


		add_filter(	'widget_tag_cloud_args', 'elonissa_fn_tag_cloud_args');

		if ( ! isset( $content_width ) ) $content_width = 1170;

		// Add default posts and comments RSS feed links to head
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'wp_list_comments' );
		add_theme_support( 'title-tag' );

		add_editor_style() ;

		
		add_action( 'wp_ajax_nopriv_elonissa_fn_ajax_portfolio', 'elonissa_fn_ajax_portfolio' );
		add_action( 'wp_ajax_elonissa_fn_ajax_portfolio', 'elonissa_fn_ajax_portfolio' );
		
		
		// CONSTANT
		$my_theme 		= wp_get_theme( 'elonissa' );
		$version		= '1.0';
		if ( $my_theme->exists() ){
			$version 	= (string)$my_theme->get( 'Version' );
		}
		$version		= 'ver_'.$version;
		define('ELONISSA_VERSION', $version);
		define('ELONISSA_URI', get_template_directory_uri());
		
		
		
		function elonissa_plugins_admin_notice() {
			
			$list 				= '';
			$plugins 			= array();
			include_once ABSPATH . 'wp-admin/includes/plugin.php';
			if(!is_plugin_active('elonissa-core/elonissa-core.php')){
				$URL			= 'https://frenify.com/core-plugins/';
				$element		= '<a href="'.esc_url($URL).'" target="_blank">Elonissa Core</a>';
				array_push($plugins,$element);
			}
			if(!is_plugin_active('elementor/elementor.php')){
				$URL			= 'https://wordpress.org/plugins/elementor/';
				$element		= '<a href="'.esc_url($URL).'" target="_blank">Elementor</a>';
				array_push($plugins,$element);
			}
			if(!is_plugin_active('kirki/kirki.php')){
				$URL			= 'https://wordpress.org/plugins/kirki/';
				$element		= '<a href="'.esc_url($URL).'" target="_blank">Kirki</a>';
				array_push($plugins,$element);
			}
			if(!empty($plugins)){
				$list 	= '<strong>'; $separator = ', ';
				$count	= count($plugins);
				foreach($plugins as $key => $plugin){
					if(($count > 1) && ($key === ($count - 1))){
						$list 	= rtrim($list,$separator);
						$list .= ' and ';
					}
					$list .= $plugin . $separator;
				}
				$list  = rtrim($list,$separator);
				$list .= '</strong>';
			}
			if($list != ''){
				$class = 'notice notice-warning is-dismissible';

				printf( '<div class="%1$s"><p>We recommend installing the following plugins: %2$s.<br /> Please download the plugins and install them.</p></div>', esc_attr( $class ), $list );

			}

		}

		add_action( 'admin_notices', 'elonissa_plugins_admin_notice' );
		
		
		
		
		/* ------------------------------------------------------------------------ */
		/*  Inlcudes
		/* ------------------------------------------------------------------------ */
		include_once( get_template_directory().'/inc/elonissa_fn_functions.php'); 					// Custom Functions
		include_once( get_template_directory().'/inc/elonissa_fn_googlefonts.php'); 				// Google Fonts Init
		include_once( get_template_directory().'/inc/elonissa_fn_css.php'); 						// Inline CSS
		include_once( get_template_directory().'/inc/elonissa_fn_sidebars.php'); 					// Widget Area
		include_once( get_template_directory().'/inc/elonissa_fn_pagination.php'); 					// Pagination

}







/* ----------------------------------------------------------------------------------- */
/*  ENQUEUE STYLES AND SCRIPTS
/* ----------------------------------------------------------------------------------- */
	function elonissa_fn_scripts() {
		wp_enqueue_script('modernizr-custom', ELONISSA_URI . '/assets/js/modernizr.custom.js', array('jquery'), ELONISSA_VERSION, FALSE);
		wp_enqueue_script('elonissa-fn-init', ELONISSA_URI . '/assets/js/init.js', array('jquery'), ELONISSA_VERSION, TRUE);
		wp_localize_script( 'elonissa-fn-init', 'fn_ajax_object', array( 'fn_ajax_url' => admin_url( 'admin-ajax.php' )) );
		
		wp_localize_script('elonissa-fn-init', 'fn_object', array( 'siteurl' => esc_url(home_url()) ));
		if ( is_singular() ) wp_enqueue_script( 'comment-reply' );
	}
	
	function elonissa_fn_admin_scripts() {
		wp_enqueue_script('elonissa-fn-widget-upload', ELONISSA_URI . '/assets/js/widget.upload.js', array('jquery'), ELONISSA_VERSION, FALSE);
		wp_enqueue_style('elonissa-fn-fontello', ELONISSA_URI.'/assets/css/fontello.css', array(), ELONISSA_VERSION, 'all');
		wp_enqueue_style('elonissa-fn-admin-style', ELONISSA_URI.'/assets/css/admin.style.css', array(), ELONISSA_VERSION, 'all');
	}

	function elonissa_fn_styles(){
		wp_enqueue_style('elonissa-fn-font-url', elonissa_fn_font_url(), array(), null );
		wp_enqueue_style('fontello', ELONISSA_URI.'/assets/css/fontello.css', array(), ELONISSA_VERSION, 'all');
		wp_enqueue_style('elonissa-fn-base', ELONISSA_URI.'/assets/css/base.css', array(), ELONISSA_VERSION, 'all');
		wp_enqueue_style('elonissa-fn-skeleton', ELONISSA_URI.'/assets/css/skeleton.css', array(), ELONISSA_VERSION, 'all');
		wp_enqueue_style('elonissa-fn-wp-core', ELONISSA_URI.'/assets/css/wp-core.css', array(), ELONISSA_VERSION, 'all');
		wp_enqueue_style('elonissa-fn-stylesheet', get_stylesheet_uri(), array(), ELONISSA_VERSION, 'all' ); // Main Stylesheet
	}

	/**
	 * Fix skip link focus in IE11.
	 *
	 * This does not enqueue the script because it is tiny and because it is only for IE11,
	 * thus it does not warrant having an entire dedicated blocking script being loaded.
	 *
	 * @link https://git.io/vWdr2
	 */
	function elonissa_fn_skip_link_focus_fix() {
		// The following is minified via `terser --compress --mangle -- js/skip-link-focus-fix.js`.
		?>
		<script>
		/(trident|msie)/i.test(navigator.userAgent)&&document.getElementById&&window.addEventListener&&window.addEventListener("hashchange",function(){var t,e=location.hash.substring(1);/^[A-z0-9_-]+$/.test(e)&&(t=document.getElementById(e))&&(/^(?:a|select|input|button|textarea)$/i.test(t.tagName)||(t.tabIndex=-1),t.focus())},!1);
		</script>
		<?php
	}
	add_action( 'wp_print_footer_scripts', 'elonissa_fn_skip_link_focus_fix' );




/* ----------------------------------------------------------------------------------- */
/*  Tagcloud widget
/* ----------------------------------------------------------------------------------- */
	
	function elonissa_fn_tag_cloud_args($args){
		$my_args 	= array('smallest' => 14, 'largest' => 14, 'unit'=>'px', 'orderby'=>'count', 'order'=>'DESC' );
		$args 		= wp_parse_args( $args, $my_args );
		return $args;
	}




?>