



/*
 * Copyright (c) 2021 Codernelson
 * Author: Codernelson
 * This file is made for CURRENT THEME
*/


/*

	@Author: Codernelson
	@URL: https://frenify.com/


	This file contains the jquery functions for the actual theme, this
	is the file you need to edit to change the structure of the
	theme.

	This files contents are outlined below.

*/


var siteurl 	= fn_object.siteurl;


// All other theme functions
(function ($){

	"use strict";
	
    var ElonissaInit 		= {
		
		
		
		pageNumber: 1,
		
        init: function () {
			this.cursor();
			this.minHeightForPages();
			this.url_fixer();
			this.textSkin();
			this.portfolioFilter();
			this.hamburgerOpener__Mobile();
			this.submenu__Mobile();
			this.imgToSVG();
			this.dataFnBgImg();
			this.estimateWidgetHeight();
			this.runPlayer();
			this.newPlayer();
			this.right_bar_opener();	
			this.categoryHook();	
			this.toTopJumper();
			this.rating();
			this.search_opener();
			this.fixedTotopScroll();
			this.prev_next_posts();
			this.widget__pages();
			this.widget__archives();
			this.dataFnStyle();
			this.portfolioContentHeight();
			this.inputCheckBoxInComment();
			this.inlineStyle();
			this.addButtonToMenu();
        },
		
		addButtonToMenu: function(){
			var self		= this;
			var element 	= $('.menu-item-has-children');
			var count 		= element.length;
			var i			= 0;
			element.each(function(){
				$(this).children('a').append('<button></button');
				i++;if(i===count){self.addedButtonAction();}
			});
		},
		
		addedButtonAction: function(){
			var self		= this;
			$('.menu-item-has-children button').on('click',function(e){
				e.preventDefault();
				e.stopPropagation();
				var element = $(this);
				if(element.closest('.elonissa_fn_mobilemenu_wrap').length){
					self.submenu__Mobile__init(element.closest('li').children('a'));
					return false;
				}else{
					element.closest('li').toggleClass('active');
				}
			});
			$('.elonissa_fn_main_nav .menu-item-has-children').on('mouseenter',function(e){
				e.preventDefault();
				e.stopPropagation();
				var element = $(this);
				element.addClass('active');
			}).on('mouseleave',function(){
				$(this).removeClass('active');
			});
			$('.elonissa_fn_main_nav > li > a').focus(function(e){
				e.preventDefault();
				e.stopPropagation();
				var element = $(this);
			  	element.closest('li').siblings().removeClass('active').find('li').removeClass('active');
		  	});
			$('body').on('click',function(){
				$('.elonissa_fn_main_nav .active').removeClass('active');
			});
		},
		
		
		inlineStyle: function(){
			var s = '';
			$('.elonissa_fn_style').each(function(){
				var e = $(this), v = e.val(); e.val(''); s+= v;
			});
			$('body').append(s);
		},
		
		inputCheckBoxInComment: function(){
			if($('p.comment-form-cookies-consent input[type=checkbox]').length){
				$('p.comment-form-cookies-consent input[type=checkbox]').wrap('<label class="fn_checkbox"></label>').after('<span></span>');
			}
		},
		
		portfolioContentHeight: function(){
			var portfolio = $('.elonissa_fn_portfolio_page .portfolio_content');
			if(portfolio.height() === 0){
				portfolio.css({display: 'none'});
			}
		},
		
		dataFnStyle: function(){
			$('[data-fn-style]').each(function(){
				var el		= $(this);
				var s 		= el.attr('data-fn-style');
				$.each(s.split(';'),function(i,e){
					el.css(e.split(':')[0],e.split(':')[1]);
				});
			});
		},
		
		minHeightForPages: function(){
			var H 				= $(window).height(),
				W 				= $(window).width(),
				headerH 		= 0,
				mobileH 		= 0,
				adminBarH 		= 0,
				footerH 		= $('.elonissa_fn_footer').height(),
				mobile			= $('.elonissa_fn_mobilemenu_wrap'),
				header			= $('.elonissa_fn_header');
			if($('.elonissa-fn-wrapper').data('pos') === 'relative'){
				headerH 		= header.height();
			}
			if(mobile.css('display') !== 'none'){
				mobileH			= mobile.height();
				headerH			= 0;
			}
			if($('body').hasClass('admin-bar')){
				if(W<782){
					adminBarH	= 46;
				}else{
					adminBarH	= 32;
				}
			}
			$('.elonissa_fn_pages,.elonissa_fn_404').css({minHeight: (H-mobileH-headerH-footerH-adminBarH) + 'px'});	
		},
		
		url_fixer: function(){
			$('a[href*="fn_ex_link"]').each(function(){
				var oldUrl 	= $(this).attr('href'),
					array   = oldUrl.split('fn_ex_link/'),
					newUrl  = siteurl + "/" + array[1];
				$(this).attr('href', newUrl);
			});
		},
		
		textSkin: function(){
			$('body').addClass('fn__text_skin_'+$('.elonissa-fn-wrapper').data('text-skin'));
		},
		
		
		
		portfolioFilter: function(){
			var self					= this;
			$('.elonissa_fn_portfolio_page .fn_ajax_more a').off().on('click',function(){
				var thisButton 			= $(this);
				var more				= thisButton.closest('.fn_ajax_more');
				var input				= more.find('input');
				var abb					= thisButton.closest('.elonissa_fn_portfolio_page');
				var filter_page			= parseInt(input.val());
				if(thisButton.hasClass('active')){
					return false;
				}
				if(!abb.hasClass('go') && !more.hasClass('disabled')){
					abb.addClass('go');
					
					var requestData = {
						action: 'elonissa_fn_ajax_portfolio',
						filter_page: filter_page,
					};

					
					$.ajax({
						type: 'POST',
						url: fn_ajax_object.fn_ajax_url,
						cache: false,
						data: requestData,
						success: function(data) {
							var fnQueriedObj 	= $.parseJSON(data);
							var html			= fnQueriedObj.data;
							var $items;
							$items = $(html);
							input.val(filter_page+1);
							input.change();
							
							if(fnQueriedObj.disabled === 'disabled'){
								more.addClass('disabled');
							}
						 	
							self.dataFnStyle();
							self.dataFnBgImg();
							abb.removeClass('go');
						},
						error: function(xhr, textStatus, errorThrown){
							abb.removeClass('go');
						}
					});
				}
					
				
				return false;
			});	
		},

		cursor: function () {
			var myCursor = $('.codernelson-cursor');
			if (myCursor.length) {
				if ($("body").length) {
					const e = document.querySelector(".cursor-inner"),
						t = document.querySelector(".cursor-outer");
					var n, i = 0,
						o = !1;
					var buttons = "fn_cs_intro_testimonials .prev, .fn_cs_intro_testimonials .next, .fn_cs_swiper_nav_next, .fn_cs_swiper_nav_prev, .fn_dots, .swiper-button-prev, .swiper-button-next, .fn_cs_accordion .acc_head, .elonissa_fn_header .fn_finder, .elonissa_fn_header .fn_trigger, a, input[type='submit'], .cursor-link, button";
					var sliders = ".swiper-container, .cursor-link";
					// link mouse enter + move
					window.onmousemove = function(s) {
						o || (t.style.transform = "translate(" + s.clientX + "px, " + s.clientY + "px)"), e.style.transform = "translate(" + s.clientX + "px, " + s.clientY + "px)", n = s.clientY, i = s.clientX
					}, $("body").on("mouseenter", buttons, function() {
						e.classList.add("cursor-hover"), t.classList.add("cursor-hover")
					}), $("body").on("mouseleave", buttons, function() {
						$(this).is("a") && $(this).closest(".cursor-link").length || (e.classList.remove("cursor-hover"), t.classList.remove("cursor-hover"))
					}), e.style.visibility = "visible", t.style.visibility = "visible";
					
					
					// slider mouse enter
					$('body').on('mouseenter', sliders, function(){
						e.classList.add('cursor-slider');
						t.classList.add('cursor-slider');
					}).on('mouseleave', sliders,function(){
						e.classList.remove('cursor-slider');
						t.classList.remove('cursor-slider');
					});
					
					// slider mouse hold
					$('body').on('mousedown', sliders, function(){
						e.classList.add('mouse-down');
						t.classList.add('mouse-down');
					}).on('mouseup', sliders, function(){
						e.classList.remove('mouse-down');
						t.classList.remove('mouse-down');
					});
				}
			}
		},
		
		
		widget__archives: function(){
			$('.widget_archive li').each(function(){
				var e = $(this);
				var a = e.find('a').clone();
				$('body').append('<div class="codernelson_hidden_item"></div>');
				$('.codernelson_hidden_item').html(e.html());
				$('.codernelson_hidden_item').find('a').remove();
				var suffix = $('.codernelson_hidden_item').html().match(/\d+/); // 1234567890
				$('.codernelson_hidden_item').remove();
				suffix = parseInt(suffix);
				if(isNaN(suffix)){
					return false;
				}
				suffix = '<span class="count">'+suffix+'</span>';
				e.html(a);
				e.addClass('has-count');
				e.append(suffix);
			});
		},
		
		prev_next_posts: function(){
			if($('.elonissa_fn_siblings')){
				$(document).keyup(function(e) {
					if(e.key.toLowerCase() === 'p') {
						var a = $('.elonissa_fn_siblings').find('a.previous_project_link');
						if(a.length){
							window.location.href = a.attr('href');
							return false;
						}
					}
					if(e.key.toLowerCase() === 'n') {
						var b = $('.elonissa_fn_siblings').find('a.next_project_link');
						if(b.length){
							window.location.href = b.attr('href');
							return false;
						}
					}
				});
			}
		},
		
		fixedTotopScroll: function(){
			var totop			= $('.elonissa_fn_totop');
			var height 			= parseInt(totop.find('input').val());
			if(totop.length){
				if($(window).scrollTop() > height){
					totop.addClass('scrolled');
				}else{
					totop.removeClass('scrolled');
				}
			}
		},
		
		
		search_placeholder: function(searchinput,text,i,speed){
			setTimeout(function(){
				searchinput.attr('placeholder',text);
			},i*speed);
		},
		
		search_opener: function(){
			var self		= this;
			var speed		= 20;
			var searchbox 	= $('.elonissa_fn_searchpopup');
			var opener 		= $('.elonissa_fn_header .fn_finder');
			var searchinput = $('.elonissa_fn_searchpopup input[type=text]');
			if(opener.length){
				opener.off().on('click',function(){
					if($('body').hasClass('open_search_popup')){
						searchbox.removeClass('focused');
						$('body').removeClass('open_search_popup');
					}else{
						var placeholder = searchinput.attr('placeholder');
						searchinput.attr('placeholder','');
						var array 		= placeholder.split('');
						$('body').addClass('open_search_popup');
						setTimeout(function(){
							var text = '';
							for(var i=0;i<array.length;i++){
								text+= array[i];
								self.search_placeholder(searchinput,text,i,speed);
							}
							setTimeout(function(){
								searchinput.focus();
								searchinput.trigger('click');
							},speed*array.length);
						},500);
					}
					return false;
				});
			}
			if(searchbox.length){
				var closer  	= searchbox.find('.search_closer,.extra_closer');
				var inputText  	= searchbox.find('input[type=text]');
				var inputSubmit	= searchbox.find('input[type=submit]');
				searchbox.find('.search_inner').on('click',function(){
					searchbox.removeClass('focused');
				});
				inputText.on('click',function(event){
					searchbox.addClass('focused');
					event.stopPropagation();
				});
				inputSubmit.on('click',function(event){
					event.stopPropagation();
				});
				closer.on('click',function(event){
					event.stopPropagation();
					$('.helper_extra .fn_finder').focus();
					searchbox.removeClass('focused');
					$('body').removeClass('open_search_popup');
					closer.addClass('closed');
					setTimeout(function(){
						closer.removeClass('closed');
					},500);
					return false;
				});
			}	
		},
		
		
		getQueryVariable: function(url, variable) {
			var query = url.substring(1);
			var vars = query.split('&');
			for (var i=0; i<vars.length; i++) {
				var pair = vars[i].split('=');
				if (pair[0] === variable) {
					return pair[1];
				}
			}

			return false;
		},
		
		
		right_bar_opener: function(){
			var hamburger 	= $('.elonissa_fn_header .fn_trigger');hamburger.addClass('ready');
			var trigger 	= $('.elonissa_fn_right_panel .extra_closer, .elonissa_fn_right_panel .fn_closer');
			trigger.on('click',function(){
				$('body').toggleClass('fn_opened');
				return false;
			});
			hamburger.on('click',function(){
				$('body').addClass('fn_opened');
				return false;
			});
			var i = null;
			hamburger.on('mouseenter',function(){
				i = setTimeout(function(){
					$('body').addClass('fn_opened');
				},700);
			}).on('mouseleave',function(){
				clearTimeout(i);
			});
		},
		
		categoryHook: function(){
			var self = this;
			var list = $('.wp-block-archives li, .widget_elonissa_custom_categories li, .widget_categories li, .widget_archive li');
			list.each(function(){
				var item = $(this);
				if(item.find('ul').length){
					item.addClass('has-child');
				}
			});
			
			
			var html = $('.elonissa_fn_hidden.more_cats').html();
			var cats = $('.widget_categories,.widget_archive,.widget_elonissa_custom_categories');
			if(cats.length){
				cats.each(function(){
					var element = $(this);
					var limit	= 3;
					element.append(html);
					var li = element.find('ul:not(.children) > li');
					if(li.length > limit){
						var h = 0;
						li.each(function(i,e){
							if(i < limit){
								h += $(e).outerHeight(true,true);
							}else{
								return false;
							}
						});
						element.find('ul:not(.children)').css({height: h + 'px'});
						element.find('.elonissa_fn_more_categories .fn_count').html('('+(li.length-limit)+')');
					}else{
						element.addClass('all_active');
					}
				});
				self.categoryHookAction();
			}
		},
		
		categoryHookAction: function(){
			var self			= this;
			$('.elonissa_fn_more_categories').find('a').off().on('click',function(){
				var e 			= $(this);
				var limit		= 3;
				var myLimit		= limit;
				var parent 		= e.closest('.widget_block');
				var li 			= parent.find('ul:not(.children) > li');
				var liHeight	= li.outerHeight(true,true);
				var h			= liHeight*limit;
				var liLength	= li.length;
				var speed		= (liLength-limit)*50;
				e.toggleClass('show');
				if(e.hasClass('show')){
					myLimit		= liLength;
					h			= liHeight*liLength;
					e.find('.text').html(e.data('less'));
					e.find('.fn_count').html('');
				}else{
					e.find('.text').html(e.data('more'));
					e.find('.fn_count').html('('+(liLength-limit)+')');
				}
				
				
				var H = 0;
				li.each(function(i,e){
					if(i < myLimit){
						H += $(e).outerHeight(true,true);
					}else{
						return false;
					}
				});
				
				speed = (speed > 300) ? speed : 300;
				speed = (speed < 1500) ? speed : 1500;
				parent.find('ul:not(.children)').animate({height:H},speed);
			
				
				
				return false;
			});
		},
		
		
		rating: function(){
			var radio 	= $('.comments-rating input[type="radio"]');
			radio.on('click',function(){
				var el 	= $(this);
				var id	= el.attr('id');
				$('.comments-rating .fn_radio').removeClass('clicked');
				$('.comments-rating .'+id).addClass('clicked');
		 	}).on('mouseenter',function(){
				var el 	= $(this);
				var id	= el.attr('id');
				$('.comments-rating .fn_radio').removeClass('hovered');
				$('.comments-rating .'+id).addClass('hovered');
		 	}).on('mouseleave',function(){
				$('.comments-rating .fn_radio').removeClass('hovered');
		 	});
		},
		
		
		
		
		toTopJumper: function(){
			var totop		= $('.elonissa_fn_footer .footer_totop a,a.elonissa_fn_totop,.elonissa_fn_footer .footer_right_totop a');
			if(totop.length){
				totop.on('click', function(e) {
					e.preventDefault();		
					$("html, body").animate(
						{ scrollTop: 0 }, 'slow');
					return false;
				});
			}
		},
		
		
		
		runPlayer: function(){
			var parent		= $('.elonissa_fn_main_audio');
			var audioVideo 	= parent.find('audio,video');
			audioVideo.each(function(){
				var element = $(this);
				element.mediaelementplayer({
					// Do not forget to put a final slash (/)
					pluginPath: 'https://cdnjs.com/libraries/mediaelement/',
					// this will allow the CDN to use Flash without restrictions
					// (by default, this is set as `sameDomain`)
					shimScriptAccess: 'always',
					success: function(mediaElement, domObject) {
						mediaElement.addEventListener('play', function() {
							parent.removeClass('fn_pause').addClass('fn_play');
						}, false);
						mediaElement.addEventListener('pause', function() {
							parent.removeClass('fn_play').addClass('fn_pause');
						}, false);
					},
				});
			});
		},
		
		newPlayer: function(){
			var parent		= $('.elonissa_fn_main_audio');
			var closer 	  	= parent.find('.fn_closer');
			var audioVideo 	= parent.find('audio,video');
			var icon 		= parent.find('.podcast_icon');
			var audios		= $('.elonissa_fn_audio_button');
			var playButton	= $('.elonissa_fn_audio_button a');
			var self		= this;
			audioVideo.each(function(){
				var element = $(this);
				element.mediaelementplayer({
					// Do not forget to put a final slash (/)
					pluginPath: 'https://cdnjs.com/libraries/mediaelement/',
					// this will allow the CDN to use Flash without restrictions
					// (by default, this is set as `sameDomain`)
					shimScriptAccess: 'always',
					success: function(mediaElement, domObject) {
						mediaElement.addEventListener('pause', function() {
							parent.removeClass('fn_play').addClass('fn_pause');
						}, false);
						mediaElement.addEventListener('play', function() {
							parent.removeClass('fn_pause').addClass('fn_play');
						}, false);
					},
				});
			});
			closer.off().on('click', function(){
				if(parent.hasClass('closed')){
					parent.removeClass('closed');
					closer.find('span').html(closer.attr('data-close-text'));
				}else{
					parent.addClass('closed');
					closer.find('span').html(closer.attr('data-open-text'));
				}
			});
			icon.off().on('click', function(){
				if(parent.find('audio,video').length){
					if(parent.hasClass('fn_pause')){
						parent.removeClass('fn_pause').addClass('fn_play').find('audio,video')[0].play();
					}else{
						parent.removeClass('fn_play').addClass('fn_pause').find('audio,video')[0].pause();
					}
				}
			});
			playButton.off().on('click',function(){
				var button		= $(this);
				var wrapper		= button.parent();
				if(!wrapper.hasClass('active')){
					audios.removeClass('active fn_play fn_pause');
					wrapper.addClass('active');
				}
				if(wrapper.hasClass('fn_pause')){
					wrapper.removeClass('fn_pause').addClass('fn_play');
					parent.find('audio,video')[0].play();
				}else if(wrapper.hasClass('fn_play')){
					wrapper.removeClass('fn_play').addClass('fn_pause');
					parent.find('audio,video')[0].pause();
				}else{
					wrapper.addClass('fn_play');
					var src			= wrapper.attr('data-mp3');
					var audio	 	= '<audio controls><source src="'+src+'" type="audio/mpeg"></audio>';
					$('.elonissa_fn_main_audio .audio_player').html(audio);
					self.runPlayer();
					setTimeout(function(){
						parent.find('audio,video')[0].play();
						parent.removeClass('fn_pause').addClass('fn_play');
						parent.removeClass('closed');
						closer.find('span').html(closer.attr('data-close-text'));
						self.playerSpace();
					},50);
				}
				
				return false;
			});
		},
		
		widget__pages: function(){
			var nav 						= $('.widget_pages ul');
			nav.each(function(){
				$(this).find('a').off().on('click', function(e){
					var element 			= $(this);
					var parentItem			= element.parent('li');
					var parentItems			= element.parents('li');
					var parentUls			= parentItem.parents('ul.children');
					var subMenu				= element.next();
					var allSubMenusParents 	= nav.find('li');

					allSubMenusParents.removeClass('opened');

					if(subMenu.length){
						e.preventDefault();

						if(!(subMenu.parent('li').hasClass('active'))){
							if(!(parentItems.hasClass('opened'))){parentItems.addClass('opened');}

							allSubMenusParents.each(function(){
								var el = $(this);
								if(!el.hasClass('opened')){el.find('ul.children').slideUp();}
							});

							allSubMenusParents.removeClass('active');
							parentUls.parent('li').addClass('active');
							subMenu.parent('li').addClass('active');
							subMenu.slideDown();


						}else{
							subMenu.parent('li').removeClass('active');
							subMenu.slideUp();
						}
						return false;
					}
				});
			});
		},
		
		submenu__Mobile: function(){
			var self						= this;
			$('.vert_menu_list a, .widget_nav_menu .menu a').on('click', function(){
				var element 			= $(this);
				self.submenu__Mobile__init(element);
				return false;
			});
		},
		
		submenu__Mobile__init: function(element){
			var parent				= element.closest('li');
			var submenu				= element.siblings('.sub-menu');
			
			if(submenu.length){
				if(parent.hasClass('active')){
					parent.removeClass('active').find('.active').removeClass('active');
					parent.find('.sub-menu').slideUp();
				}else{
					var siblingActive	= parent.siblings('.active');
					if(siblingActive.length){
						siblingActive.removeClass('active').find('.active').removeClass('active');
						siblingActive.find('.sub-menu').slideUp();
					}
					submenu.slideDown();
					parent.addClass('active');
				}
				return false;
			}
		},
		
		hamburgerOpener__Mobile: function(){
			var opener			= $('.elonissa_fn_mobilemenu_wrap .ham_wrapper');
			var hamburger		= $('.elonissa_fn_mobilemenu_wrap .hamburger');
			opener.on('click',function(){
				var menupart	= $('.elonissa_fn_mobilemenu_wrap .mobilemenu');
				if(hamburger.hasClass('is-active')){
					hamburger.removeClass('is-active');
					menupart.removeClass('opened');
					menupart.slideUp(500);
				}else{
					hamburger.addClass('is-active');
					menupart.addClass('opened');
					menupart.slideDown(500);
				}
				return false;
			});
		},
		

		imgToSVG: function(){
			$('img.elonissa_fn_svg,img.elonissa_w_fn_svg').each(function(){
				var img 		= $(this);
				var imgClass	= img.attr('class');
				var imgURL		= img.attr('src');

				$.get(imgURL, function(data) {
					var svg 	= $(data).find('svg');
					if(typeof imgClass !== 'undefined') {
						svg 	= svg.attr('class', imgClass+' replaced-svg');
					}
					img.replaceWith(svg);

				}, 'xml');

			});	
		},
		
		
		dataFnBgImg: function(){
			var bgImage 	= $('*[data-fn-bg-img]');
			bgImage.each(function(){
				var element = $(this);
				var attrBg	= element.attr('data-fn-bg-img');
				var bgImg	= element.data('fn-bg-img');
				if(typeof(attrBg) !== 'undefined'){
					element.addClass('codernelson-ready').css({backgroundImage:'url('+bgImg+')'});
				}
			});
		},
		
		
		estimateWidgetHeight: function(){
			var est 	= $('.elonissa_fn_widget_estimate');
			est.each(function(){
				var el 	= $(this);
				var h1 	= el.find('.helper1');
				var h2 	= el.find('.helper2');
				var h3 	= el.find('.helper3');
				var h4 	= el.find('.helper4');
				var h5 	= el.find('.helper5');
				var h6 	= el.find('.helper6');
				var eW 	= el.outerWidth();
				var w1 	= Math.floor((eW * 80) / 300);
				var w2 	= eW-w1;
				var e1 	= Math.floor((w1 * 55) / 80);
				h1.css({borderLeftWidth:	w1+'px', borderTopWidth: e1+'px'});
				h2.css({borderRightWidth:	w2+'px', borderTopWidth: e1+'px'});
				h3.css({borderLeftWidth:	w1+'px', borderTopWidth: w1+'px'});
				h4.css({borderRightWidth:	w2+'px', borderTopWidth: w1+'px'});
				h5.css({borderLeftWidth:	w1+'px', borderTopWidth: w1+'px'});
				h6.css({borderRightWidth:	w2+'px', borderTopWidth: w1+'px'});
			});
		},
    };
	
	
	
	// ready functions
	$(document).ready(function(){
		ElonissaInit.init();
	});
	
	// resize functions
	$(window).on('resize',function(e){
		e.preventDefault();
		ElonissaInit.estimateWidgetHeight();
	});
	
	// scroll functions
	$(window).on('scroll', function(e) {
		e.preventDefault();
		ElonissaInit.fixedTotopScroll();
    });
	
	// load functions
	$(window).on('load', function() {
		
	});
	
})(jQuery);



// add all the elements inside modal which you want to make focusable
var focusableElements 		= 'button, [href], input, select, textarea, [tabindex]:not([tabindex="-1"])';
var modal 					= document.querySelector('.elonissa_fn_searchpopup'); // select the modal by it's id or class

var firstFocusableElement 	= modal.querySelectorAll(focusableElements)[0]; // get first element to be focused inside modal
var focusableContent 		= modal.querySelectorAll(focusableElements);
var lastFocusableElement 	= focusableContent[focusableContent.length - 1]; // get last element to be focused inside modal


document.addEventListener('keydown', function(e) {
	"use strict";
	var isTabPressed = e.key === 'Tab' || e.keyCode === 9;

	if (!isTabPressed) {return;}

	if (e.shiftKey) { // if shift key pressed for shift + tab combination
		if (document.activeElement === firstFocusableElement) {
			lastFocusableElement.focus(); // add focus for the last focusable element
			e.preventDefault();
		}
	} else { // if tab key is pressed
		if (document.activeElement === lastFocusableElement) { // if focused has reached to last focusable element then focus first focusable element after pressing tab
			firstFocusableElement.focus(); // add focus for the first focusable element
			e.preventDefault();
		}
	}
});

firstFocusableElement.focus();


var modal2 					= document.querySelector('.elonissa_fn_mobilemenu_wrap');

var firstFocusableElement2 	= modal2.querySelectorAll(focusableElements)[0];
var focusableContent2 		= modal2.querySelectorAll(focusableElements);
var lastFocusableElement2 	= focusableContent2[focusableContent2.length - 1]; // get last element to be focused inside modal


document.addEventListener('keydown', function(e) {
	"use strict";
	var isTabPressed = e.key === 'Tab' || e.keyCode === 9;

	if (!isTabPressed) {return;}

	if (e.shiftKey) { // if shift key pressed for shift + tab combination
		if (document.activeElement === firstFocusableElement2) {
			lastFocusableElement2.focus(); // add focus for the last focusable element
			e.preventDefault();
		}
	} else { // if tab key is pressed
		if (document.activeElement === lastFocusableElement2) { // if focused has reached to last focusable element then focus first focusable element after pressing tab
			firstFocusableElement2.focus(); // add focus for the first focusable element
			e.preventDefault();
		}
	}
});

if(firstFocusableElement2){	
	firstFocusableElement2.focus();
}


