<?php
/**
 * Functions for ELLA Corporate Child Theme
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

 function ella_corporate_child_theme_setup() {
    // Add support for the title tag
    add_theme_support( 'title-tag' );

    // Add support for automatic feed links
    add_theme_support( 'automatic-feed-links' );
}
add_action( 'after_setup_theme', 'ella_corporate_child_theme_setup' );

function ella_corporate_child_theme_widgets_init() {
    register_sidebar( array(
       'name'          => esc_html__( 'Sidebar', 'ella-corporate' ),
        'id'            => 'sidebar-1',
        'description'   => esc_html__( 'Add widgets here.', 'ella-corporate' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );
}
add_action( 'widgets_init', 'ella_corporate_child_theme_widgets_init' );


/**
 * Enqueue parent and child theme styles, and custom parent CSS
 */
function ella_corporate_enqueue_styles() {
    // Enqueue parent style
    wp_enqueue_style(
        'ello-parent-style',
        get_template_directory_uri() . '/style.css'
    );
}
add_action( 'wp_enqueue_scripts', 'ella_corporate_enqueue_styles' );

/**
 * Admin Notice for Spiral Lite One Page Theme (Child Theme)
 */

function ella_corporate_child_theme_remove_parent_admin_notice() {
    remove_action('admin_notices', 'ellapress_admin_notice');
}

add_action('init', 'ella_corporate_child_theme_remove_parent_admin_notice'); // Remove the parent theme's notice

