<?php
$elevate_wp_theme_svg_icons = array(
	'fort-awesome'         => array(
		'name'    => 'font-awesome/fort-awesome',
		'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="fort-awesome" viewBox="0 0 1792 1896.0833"><path d="M640 1008V784q0-16-16-16h-96q-16 0-16 16v224q0 16 16 16h96q16 0 16-16zm512 0V784q0-16-16-16h-96q-16 0-16 16v224q0 16 16 16h96q16 0 16-16zm512 32v752h-640v-320q0-80-56-136t-136-56-136 56-56 136v320H0v-752q0-16 16-16h96q16 0 16 16v112h128V528q0-16 16-16h96q16 0 16 16v112h128V528q0-16 16-16h96q16 0 16 16v112h128V528q0-6 2.5-9.5t8.5-5 9.5-2 11.5 0 9 .5V121q-32-15-32-50 0-23 16.5-39T832 16t38.5 16T887 71q0 35-32 50v17q45-10 83-10 21 0 59.5 7.5t54.5 7.5q17 0 47-7.5t37-7.5q16 0 16 16v210q0 15-35 21.5t-62 6.5q-18 0-54.5-7.5T945 367q-40 0-90 12v133q1 0 9-.5t11.5 0 9.5 2 8.5 5 2.5 9.5v112h128V528q0-16 16-16h96q16 0 16 16v112h128V528q0-16 16-16h96q16 0 16 16v624h128v-112q0-16 16-16h96q16 0 16 16z"/></svg>',
	),
	'phone'                => array(
		'name'    => 'font-awesome/phone',
		'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="phone" viewBox="0 0 1408 1896.0833"><path d="M1408 1240q0 27-10 70.5t-21 68.5q-21 50-122 106-94 51-186 51-27 0-53-3.5t-57.5-12.5-47-14.5T856 1485t-49-18q-98-35-175-83-127-79-264-216T152 904q-48-77-83-175-3-9-18-49t-20.5-55.5-14.5-47T3.5 520 0 467q0-92 51-186 56-101 106-122 25-11 68.5-21t70.5-10q14 0 21 3 18 6 53 76 11 19 30 54t35 63.5 31 53.5q3 4 17.5 25t21.5 35.5 7 28.5q0 20-28.5 50t-62 55-62 53-28.5 46q0 9 5 22.5t8.5 20.5 14 24 11.5 19q76 137 174 235t235 174q2 1 19 11.5t24 14 20.5 8.5 22.5 5q18 0 46-28.5t53-62 55-62 50-28.5q14 0 28.5 7t35.5 21.5 25 17.5q25 15 53.5 31t63.5 35 54 30q70 35 76 53 3 7 3 21z"/></svg>',
	),
	'phone-square'         => array(
		'name'    => 'font-awesome/phone-square',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="phone-square" viewBox="0 0 1536 1896.0833"><path d="M1280 1193q0-11-2-16t-18-16.5-40.5-25-47.5-26.5-45.5-25-28.5-15q-5-3-19-13t-25-15-21-5q-15 0-36.5 20.5t-39.5 45-38.5 45T885 1167q-7 0-16.5-3.5T853 1157t-17-9.5-14-8.5q-99-55-170-126.5T525 842q-2-3-8.5-14t-9.5-17-6.5-15.5T497 779q0-13 20.5-33.5t45-38.5 45-39.5T628 631q0-10-5-21t-15-25-13-19q-3-6-15-28.5T555 492t-26.5-47.5-25-40.5-16.5-18-16-2q-48 0-101 22-46 21-80 94.5T256 631q0 16 2.5 34t5 30.5 9 33 10 29.5 12.5 33 11 30q60 164 216.5 320.5T843 1358q6 2 30 11t33 12.5 29.5 10 33 9 30.5 5 34 2.5q57 0 130.5-34t94.5-80q22-53 22-101zm256-777v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z"></path></svg>',
	),
	'map'                  => array(
		'name'    => 'font-awesome/map-o',
		'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="map-o" viewBox="0 0 2048 1896.0833"><path d="M2020 11q28 20 28 53v1408q0 20-11 36t-29 23l-640 256q-24 11-48 0l-616-246-616 246q-10 5-24 5-19 0-36-11-28-20-28-53V320q0-20 11-36t29-23L680 5q24-11 48 0l616 246L1960 5q32-13 60 6zM736 146v1270l576 230V376zM128 363v1270l544-217V146zm1792 1066V159l-544 217v1270z"/></svg>',
	),
	'map-marker'           => array(
		'name'    => 'font-awesome/map-marker',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="map-marker" viewBox="0 0 1049.8953 1896.0833"><path d="M768 640q0-106-75-181t-181-75-181 75-75 181 75 181 181 75 181-75 75-181zm256 0q0 109-33 179l-364 774q-16 33-47.5 52t-67.5 19-67.5-19-46.5-52L33 819Q0 749 0 640q0-212 150-362t362-150 362 150 150 362z"></path></svg>',
	),
	'envelope-open'        => array(
		'name'    => 'font-awesome/envelope-open-o',
		'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="envelope-open-o" viewBox="0 0 1792 1896.0833"><path d="M1474 913l39 51q8 11 6.5 23.5T1508 1008q-43 34-126.5 98.5t-146.5 113-67 51.5q-39 32-60 48t-60.5 41-76.5 36.5-74 11.5h-2q-37 0-74-11.5t-76-36.5-61-41.5-60-47.5q-5-4-65-50.5t-143.5-111T293 1015q-11-8-12.5-20.5T287 971l37-52q8-11 21.5-13t24.5 7q94 73 306 236 5 4 43.5 35t60.5 46.5 56.5 32.5 58.5 17h2q24 0 58.5-17t56.5-32.5 60.5-46.5 43.5-35q258-198 313-242 11-8 24-6.5t21 12.5zm190 719V704q-90-83-159-139-91-74-389-304-3-2-43-35t-61-48-56-32.5-59-17.5h-2q-24 0-59 17.5T780 178t-61 48-43 35Q461 427 360.5 506.5T231 610.5 149 685q-14 12-21 19v928q0 13 9.5 22.5t22.5 9.5h1472q13 0 22.5-9.5t9.5-22.5zm128-928v928q0 66-47 113t-113 47H160q-66 0-113-47T0 1632V704q0-56 41-94 123-114 350-290.5T624 138q36-30 59-47.5t61.5-42 76-36.5T895 0h2q37 0 74.5 12t76 36.5 61.5 42 59 47.5q43 36 156 122t226 177 201 173q41 38 41 94z"/></svg>',
	),
	'envelope'             => array(
		'name'    => 'font-awesome/envelope',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="envelope" viewBox="0 0 1792 1896.0833"><path d="M1792 710v794q0 66-47 113t-113 47H160q-66 0-113-47T0 1504V710q44 49 101 87 362 246 497 345 57 42 92.5 65.5t94.5 48 110 24.5h2q51 0 110-24.5t94.5-48 92.5-65.5q170-123 498-345 57-39 100-87zm0-294q0 79-49 151t-122 123q-376 261-468 325-10 7-42.5 30.5t-54 38-52 32.5-57.5 27-50 9h-2q-23 0-50-9t-57.5-27-52-32.5-54-38T639 1015q-91-64-262-182.5T172 690q-62-42-117-115.5T0 438q0-78 41.5-130T160 256h1472q65 0 112.5 47t47.5 113z"></path></svg>',
	),
	'facebook'             => array(
		'name'    => 'font-awesome/facebook-square',
		'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="facebook-square" viewBox="0 0 1536 1896.0833"><path d="M1248 128q119 0 203.5 84.5T1536 416v960q0 119-84.5 203.5T1248 1664h-188v-595h199l30-232h-229V689q0-56 23.5-84t91.5-28l122-1V369q-63-9-178-9-136 0-217.5 80T820 666v171H620v232h200v595H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960z"/></svg>',
	),
	'twitter'              => array(
		'name'    => 'font-awesome/twitter-square',
		'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="twitter-square" viewBox="0 0 1536 1896.0833"><path d="M1280 610q-56 25-121 34 68-40 93-117-65 38-134 51-61-66-153-66-87 0-148.5 61.5T755 722q0 29 5 48-129-7-242-65T326 550q-29 50-29 106 0 114 91 175-47-1-100-26v2q0 75 50 133.5t123 72.5q-29 8-51 8-13 0-39-4 21 63 74.5 104t121.5 42q-116 90-261 90-26 0-50-3 148 94 322 94 112 0 210-35.5t168-95 120.5-137 75-162T1176 746q0-18-1-27 63-45 105-109zm256-194v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z"/></svg>',
	),
	'youtube'              => array(
		'name'    => 'font-awesome/youtube-square',
		'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="youtube-square" viewBox="0 0 1536 1896.0833">                                <path d="M919 1303v-157q0-50-29-50-17 0-33 16v224q16 16 33 16 29 0 29-49zm184-122h66v-34q0-51-33-51t-33 51v34zM532 915v70h-80v423h-74V985h-78v-70h232zm201 126v367h-67v-40q-39 45-76 45-33 0-42-28-6-17-6-54v-290h66v270q0 24 1 26 1 15 15 15 20 0 42-31v-280h67zm252 111v146q0 52-7 73-12 42-53 42-35 0-68-41v36h-67V915h67v161q32-40 68-40 41 0 53 42 7 21 7 74zm251 129v9q0 29-2 43-3 22-15 40-27 40-80 40-52 0-81-38-21-27-21-86v-129q0-59 20-86 29-38 80-38t78 38q21 29 21 86v76h-133v65q0 51 34 51 24 0 30-26 0-1 .5-7t.5-16.5V1281h68zM785 457v156q0 51-32 51t-32-51V457q0-52 32-52t32 52zm533 713q0-177-19-260-10-44-43-73.5t-76-34.5q-136-15-412-15-275 0-411 15-44 5-76.5 34.5T238 910q-20 87-20 260 0 176 20 260 10 43 42.5 73t75.5 35q137 15 412 15t412-15q43-5 75.5-35t42.5-73q20-84 20-260zM563 519l90-296h-75l-51 195-53-195h-78q7 23 23 69l24 69q35 103 46 158v201h74V519zm289 81V470q0-58-21-87-29-38-78-38-51 0-78 38-21 29-21 87v130q0 58 21 87 27 38 78 38 49 0 78-38 21-27 21-87zm181 120h67V350h-67v283q-22 31-42 31-15 0-16-16-1-2-1-26V350h-67v293q0 37 6 55 11 27 43 27 36 0 77-45v40zm503-304v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z"></path></svg>',
	),
	'vimeo'                => array(
		'name'    => 'font-awesome/vimeo-square',
		'content' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="vimeo-square" viewBox="0 0 1536 1896.0833">                                <path d="M1292 638q10-216-161-222-231-8-312 261 44-19 82-19 85 0 74 96-4 57-74 167t-105 110q-43 0-82-169-13-54-45-255-30-189-160-177-59 7-164 100l-81 72-81 72 52 67q76-52 87-52 57 0 107 179 15 55 45 164.5t45 164.5q68 179 164 179 157 0 383-294 220-283 226-444zm244-222v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z"></path></svg>',
	),
	'pinterest'            => array(
		'name'    => 'font-awesome/pinterest-square',
		'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="pinterest-square" viewBox="0 0 1536 1896.0833"><path d="M1248 128q119 0 203.5 84.5T1536 416v960q0 119-84.5 203.5T1248 1664H523q85-122 108-210 9-34 53-209 21 39 73.5 67t112.5 28q181 0 295.5-147.5T1280 819q0-84-35-162.5t-96.5-139-152.5-97T799 384q-104 0-194.5 28.5t-153 76.5T344 598.5t-66.5 128T256 859q0 102 39.5 180T412 1149q13 5 23.5 0t14.5-19q10-44 15-61 6-23-11-42-50-62-50-150 0-150 103.5-256.5T778 514q149 0 232.5 81t83.5 210q0 168-67.5 286T853 1209q-60 0-97-43.5T733 1062q8-34 26.5-92.5t29.5-102 11-74.5q0-49-26.5-81.5T698 679q-61 0-103.5 56.5T552 875q0 72 24 121l-98 414q-24 100-7 254H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960z"/></svg>',
	),
	'behance'              => array(
		'name'    => 'font-awesome/behance-square',
		'content' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="behance-square" viewBox="0 0 1536 1896.0833"><path d="M1248 128q119 0 203.5 84.5T1536 416v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960zM499 495H128v787h382q117 0 197-57.5t80-170.5q0-158-143-200 107-52 107-164 0-57-19.5-96.5T675 533t-79-29.5-97-8.5zm-22 318H301V629h163q119 0 119 90 0 94-106 94zm9 335H301V931h189q124 0 124 113 0 104-128 104zm650 32q-68 0-104-38t-36-107h411q1-10 1-30 0-132-74.5-220.5T1130 696q-128 0-210 86t-82 216q0 135 79 217t213 82q205 0 267-191h-138q-11 34-47.5 54t-75.5 20zm-10-366q113 0 124 122H996q4-56 39-89t91-33zM964 548h319v77H964v-77z"/></svg>',
	),

	'logoNav'              => array(
		'name'    => 'logoNav',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47" xmlns="http://www.w3.org/2000/svg"><path d="M16.11 22.7h7.96v1.58h-7.96zM26.05 22.7h7.96v1.58h-7.96zM36 22.7h7.96v1.58H36zM7.11 21a2.48 2.48 0 11-2.45 2.51A2.48 2.48 0 017.11 21m0-1.59a4.07 4.07 0 104.07 4.07 4.09 4.09 0 00-4.07-4.05z"></path></svg>',
	),
	'logoAbove'            => array(
		'name'    => 'logoAbove',
		'content' => '<svg  width="47" height="47" viewBox="0 0 47 47" xmlns="http://www.w3.org/2000/svg"><path d="M9.6 28.1h7.96v1.58H9.6zM19.53 28.1h7.96v1.58h-7.96zM29.44 28.1h7.96v1.58h-7.96zM23.52 18.91a2.48 2.48 0 010 4.95A2.49 2.49 0 0121 21.38a2.49 2.49 0 012.49-2.47m0-1.6a4.07 4.07 0 104.05 4.09 4.08 4.08 0 00-4.02-4.09z"></path></svg>',
	),
	'logoNavCta'           => array(
		'name'    => 'logoNavCta',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47" xmlns="http://www.w3.org/2000/svg"><path d="M14.51 22.7h7.96v1.58h-7.96zM24.45 22.7h7.96v1.58h-7.96zM43.16 22.7a.8.8 0 010 1.6h-6.38a.8.8 0 110-1.6h6.38m0-1.58h-6.38a2.38 2.38 0 000 4.76h6.38a2.38 2.38 0 100-4.76zM5.54 21a2.48 2.48 0 11-2.48 2.5A2.48 2.48 0 015.54 21m0-1.59a4.07 4.07 0 104.06 4.1 4.08 4.08 0 00-4.06-4.08z"></path></svg>',
	),
	'navLogoCta'           => array(
		'name'    => 'navLogoCta',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47" xmlns="http://www.w3.org/2000/svg"><path d="M9.94 22.7h7.96v1.58H9.94zM0 22.7h7.96v1.58H0zM38.24 22.7h6.38a.8.8 0 110 1.6h-6.38a.8.8 0 010-1.6m-2.38.8a2.38 2.38 0 002.38 2.38h6.38a2.38 2.38 0 100-4.76h-6.38a2.38 2.38 0 00-2.38 2.38zM26.87 21a2.49 2.49 0 012.49 2.48A2.48 2.48 0 1126.87 21m-4.06 2.5a4.07 4.07 0 104.06-4.08 4.07 4.07 0 00-4.06 4.09z"></path></svg>',
	),
	'logoNavCta2'          => array(
		'name'    => 'logoNavCta2',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47" xmlns="http://www.w3.org/2000/svg"><path d="M9.6 28.1h7.96v1.58H9.6zM19.54 28.1h7.96v1.58h-7.96zM29.45 28.1h7.96v1.58h-7.96zM43.16 20.58a.8.8 0 010 1.6h-6.37a.8.8 0 010-1.6h6.37m0-1.58h-6.37a2.38 2.38 0 100 4.76h6.37a2.38 2.38 0 100-4.76zM5.55 18.91a2.48 2.48 0 11-2.48 2.47 2.47 2.47 0 012.48-2.47m0-1.6A4.07 4.07 0 109.6 21.4a4.07 4.07 0 00-4.05-4.09z"></path></svg>',
	),
	'customLogo'           => array(
		'name'    => 'customLogo',
		'content' => '<svg height="14" enable-background="new 0 0 41 9" viewBox="0 0 41 9" xmlns="http://www.w3.org/2000/svg"><path d="m17.8 4.5c-.3-.2-.8-.4-1.3-.6s-1-.3-1.2-.5-.3-.4-.3-.6c0-.3.1-.6.3-.7s.5-.3.9-.3.8.1 1 .3.3.5.3.9h1.2c0-.4-.1-.8-.3-1.1s-.4-.7-.8-.8-.8-.3-1.3-.3c-.7 0-1.4.2-1.8.6-.5.4-.7.8-.7 1.4 0 .7.3 1.2 1 1.6.3.2.8.4 1.4.6s1 .3 1.2.5.3.4.3.7-.1.5-.3.7-.5.3-1 .3-.9-.1-1.1-.3-.4-.5-.4-.9h-1.2c0 .4.1.8.4 1.2s.6.6 1 .8.9.3 1.4.3c.8 0 1.4-.2 1.8-.5s.7-.8.7-1.4c0-.4-.1-.7-.2-1s-.6-.7-1-.9z"/><path d="m11.3 5.6c0 1-.5 1.5-1.4 1.5-.5 0-.8-.1-1.1-.4s-.3-.6-.3-1.1v-4.7h-1.3v4.7c0 .8.3 1.4.8 1.8s1.1.7 1.9.7 1.4-.2 1.9-.7.7-1 .7-1.8v-4.7h-1.2z"/><path d="m2.3 2.4c.3-.4.7-.6 1.2-.6s.8.1 1.1.3.4.6.4 1.1h1.2c0-.7-.3-1.3-.8-1.8s-1.1-.6-1.9-.6c-.6 0-1.1.1-1.5.4s-.8.7-1 1.2-.4 1.1-.4 1.8v.7c0 .7.1 1.2.4 1.7s.6.9 1 1.1.9.4 1.5.4c.8 0 1.5-.2 1.9-.6s.8-1 .8-1.8h-1.2c-.1.5-.2.9-.5 1.1s-.6.3-1 .3c-.5 0-.9-.2-1.2-.6s-.4-1-.4-1.8v-.6c-.1-.8.1-1.3.4-1.7z"/><path d="m38.6.9-2.1 5.4-2-5.4h-1.6v7.1h1.2v-2.3l-.1-3.2 2.1 5.5h.9l2.1-5.5-.2 3.2v2.3h1.3v-7.1z"/><path d="m19.4 1.9h2.2v6.1h1.2v-6.1h2.2v-1h-5.6z"/><path d="m30.2 1.2c-.4-.3-1-.4-1.5-.4s-1.1.1-1.5.4-.8.7-1 1.2-.4 1.1-.4 1.8v.4c0 .7.1 1.3.4 1.8s.6.9 1 1.2 1 .4 1.5.4c.6 0 1.1-.1 1.5-.4s.8-.7 1-1.2.4-1.1.4-1.8v-.4c0-.7-.1-1.3-.4-1.8s-.5-.9-1-1.2zm.2 3.4c0 .8-.1 1.4-.4 1.8s-.7.6-1.3.6c-.5 0-1-.2-1.3-.6s-.4-1-.4-1.8v-.4c0-.8.2-1.4.5-1.8s.7-.6 1.3-.6c.5 0 1 .2 1.3.6s.4 1 .4 1.8v.4z"/></svg>',
	),

	'textOnly'             => array(
		'name'    => 'textOnly',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47"  xmlns="http://www.w3.org/2000/svg"><path d="M0 17.93h47v2.58H0zM2.06 23.01h42.88v1.29H2.06zM17.81 27.12h11.38v1.95H17.81z"></path></svg>',
	),
	'textWithMediaOnRight' => array(
		'name'    => 'textWithMediaOnRight',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47"  xmlns="http://www.w3.org/2000/svg"><path d="M46.14 12.5H25.86a.85.85 0 00-.86.84v20.3a.85.85 0 00.84.86h20.3a.85.85 0 00.86-.84v-20.3a.85.85 0 00-.84-.86zm-.43 1.29v13.57l-3.33-2.58a1.92 1.92 0 00-2.28 0l-2.39 1.72a.77.77 0 01-1-.06L34.1 24a1.89 1.89 0 00-2.48 0l-5.35 4.2V13.79zM26.29 33.21v-3.4l6.15-4.9a.62.62 0 01.81 0l2.61 2.41a2.07 2.07 0 002.6.16l2.39-1.72a.6.6 0 01.74 0L45.71 29v4.22z"></path><path d="M40.66 22.19a2.87 2.87 0 10-2.88-2.87 2.88 2.88 0 002.88 2.87zm0-4.46a1.59 1.59 0 11-1.59 1.59 1.59 1.59 0 011.59-1.59zM0 17.93h20v2.58H0zM0 23.01h15.88v1.29H0zM0 27.12h5.69v1.95H0z"></path></svg>',
	),
	'textWithMediaOnLeft'  => array(
		'name'    => 'textWithMediaOnLeft',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47"  xmlns="http://www.w3.org/2000/svg"><path d="M21.14 12.5H.86a.85.85 0 00-.86.84v20.3a.85.85 0 00.84.86h20.3a.85.85 0 00.86-.84v-20.3a.85.85 0 00-.84-.86zm-.43 1.29v13.57l-3.33-2.58a1.92 1.92 0 00-2.28 0l-2.39 1.72a.77.77 0 01-1-.06L9.12 24a1.88 1.88 0 00-2.48-.09l-5.35 4.25V13.79zM1.29 33.21v-3.4l6.15-4.9a.62.62 0 01.81 0l2.61 2.41a2.07 2.07 0 002.6.16l2.39-1.72a.6.6 0 01.74 0L20.71 29v4.22z"></path><path d="M15.66 22.19a2.87 2.87 0 10-2.88-2.87 2.88 2.88 0 002.88 2.87zm0-4.46a1.59 1.59 0 11-1.59 1.59 1.59 1.59 0 011.59-1.59zM27 17.93h20v2.58H27zM27 23.01h15.88v1.29H27zM27 27.12h5.69v1.95H27z"></path></svg>',
	),
	'textWithMediaAbove'   => array(
		'name'    => 'textWithMediaAbove',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47"  xmlns="http://www.w3.org/2000/svg"><path d="M33.64 4.5H13.36a.85.85 0 00-.86.84v20.3a.85.85 0 00.84.86h20.3a.85.85 0 00.86-.84V5.36a.85.85 0 00-.84-.86zm-.43 1.29v13.57l-3.33-2.58a1.92 1.92 0 00-2.28 0l-2.39 1.72a.77.77 0 01-1-.06L21.6 16a1.89 1.89 0 00-2.48 0l-5.35 4.2V5.79zM13.79 25.21v-3.4l6.15-4.9a.62.62 0 01.81 0l2.61 2.41a2.07 2.07 0 002.64.18l2.39-1.72a.6.6 0 01.74 0L33.25 21v4.22z"></path><path d="M28.16 14.19a2.87 2.87 0 10-2.88-2.87 2.88 2.88 0 002.88 2.87zm0-4.46a1.59 1.59 0 11-1.59 1.59 1.59 1.59 0 011.59-1.59zM12.5 31.36h22v2.58h-22zM14.56 36.44h17.88v1.29H14.56zM20.66 40.55h5.69v1.95h-5.69z"></path></svg>',
	),
	'textWithMediaBelow'   => array(
		'name'    => 'textWithMediaBelow',
		'content' => '<svg width="47" height="47" viewBox="0 0 47 47"  xmlns="http://www.w3.org/2000/svg"><path d="M33.64 20.5H13.36a.85.85 0 00-.86.84v20.3a.85.85 0 00.84.86h20.3a.85.85 0 00.86-.84v-20.3a.85.85 0 00-.84-.86zm-.43 1.29v13.57l-3.33-2.58a1.92 1.92 0 00-2.28 0l-2.39 1.72a.77.77 0 01-1-.06L21.6 32a1.89 1.89 0 00-2.48 0l-5.35 4.2V21.79zM13.79 41.21v-3.4l6.15-4.9a.62.62 0 01.81 0l2.61 2.41a2.07 2.07 0 002.64.18l2.39-1.72a.6.6 0 01.74 0L33.25 37v4.22z"></path><path d="M28.16 30.19a2.87 2.87 0 10-2.88-2.87 2.88 2.88 0 002.88 2.87zm0-4.46a1.59 1.59 0 11-1.59 1.59 1.59 1.59 0 011.59-1.59zM12.5 4.5h22v2.58h-22zM14.56 9.58h17.88v1.29H14.56zM20.66 13.68h5.69v1.95h-5.69z"></path></svg>',
	),
	'customMedia'          => array(
		'name'    => 'customMedia',
		'content' => '<svg height="14" enable-background="new 0 0 41 9" viewBox="0 0 41 9" xmlns="http://www.w3.org/2000/svg"><path d="m17.8 4.5c-.3-.2-.8-.4-1.3-.6s-1-.3-1.2-.5-.3-.4-.3-.6c0-.3.1-.6.3-.7s.5-.3.9-.3.8.1 1 .3.3.5.3.9h1.2c0-.4-.1-.8-.3-1.1s-.4-.7-.8-.8-.8-.3-1.3-.3c-.7 0-1.4.2-1.8.6-.5.4-.7.8-.7 1.4 0 .7.3 1.2 1 1.6.3.2.8.4 1.4.6s1 .3 1.2.5.3.4.3.7-.1.5-.3.7-.5.3-1 .3-.9-.1-1.1-.3-.4-.5-.4-.9h-1.2c0 .4.1.8.4 1.2s.6.6 1 .8.9.3 1.4.3c.8 0 1.4-.2 1.8-.5s.7-.8.7-1.4c0-.4-.1-.7-.2-1s-.6-.7-1-.9z"/><path d="m11.3 5.6c0 1-.5 1.5-1.4 1.5-.5 0-.8-.1-1.1-.4s-.3-.6-.3-1.1v-4.7h-1.3v4.7c0 .8.3 1.4.8 1.8s1.1.7 1.9.7 1.4-.2 1.9-.7.7-1 .7-1.8v-4.7h-1.2z"/><path d="m2.3 2.4c.3-.4.7-.6 1.2-.6s.8.1 1.1.3.4.6.4 1.1h1.2c0-.7-.3-1.3-.8-1.8s-1.1-.6-1.9-.6c-.6 0-1.1.1-1.5.4s-.8.7-1 1.2-.4 1.1-.4 1.8v.7c0 .7.1 1.2.4 1.7s.6.9 1 1.1.9.4 1.5.4c.8 0 1.5-.2 1.9-.6s.8-1 .8-1.8h-1.2c-.1.5-.2.9-.5 1.1s-.6.3-1 .3c-.5 0-.9-.2-1.2-.6s-.4-1-.4-1.8v-.6c-.1-.8.1-1.3.4-1.7z"/><path d="m38.6.9-2.1 5.4-2-5.4h-1.6v7.1h1.2v-2.3l-.1-3.2 2.1 5.5h.9l2.1-5.5-.2 3.2v2.3h1.3v-7.1z"/><path d="m19.4 1.9h2.2v6.1h1.2v-6.1h2.2v-1h-5.6z"/><path d="m30.2 1.2c-.4-.3-1-.4-1.5-.4s-1.1.1-1.5.4-.8.7-1 1.2-.4 1.1-.4 1.8v.4c0 .7.1 1.3.4 1.8s.6.9 1 1.2 1 .4 1.5.4c.6 0 1.1-.1 1.5-.4s.8-.7 1-1.2.4-1.1.4-1.8v-.4c0-.7-.1-1.3-.4-1.8s-.5-.9-1-1.2zm.2 3.4c0 .8-.1 1.4-.4 1.8s-.7.6-1.3.6c-.5 0-1-.2-1.3-.6s-.4-1-.4-1.8v-.4c0-.8.2-1.4.5-1.8s.7-.6 1.3-.6c.5 0 1 .2 1.3.6s.4 1 .4 1.8v.4z"/></svg>',
	),
);

$elevate_wp_theme_divider_style = array(
	'tilt-flipped' => '<svg xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none"  viewBox="0 0 1000 100">  <path id="path2" d="M 1000,0 H 0 v 100 z" class="svg-white-bg" /></svg>',
	'tilt'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">	<path class="svg-white-bg" d="M-0 0L1000 0 1000 100z"/></svg>',
);

$elevate_wp_gradients = array(
	'night_fade'  =>
		array(
			'name'  => 'night_fade',
			'angle' => '0',
			'steps' =>
				array(
					0 =>
						array(
							'color'    => '#a18cd1',
							'position' => '0',
						),
					1 =>
						array(
							'color'    => '#fbc2eb',
							'position' => '100',
						),
				),
		),
	'juicy_peach' =>
		array(
			'name'  => 'juicy_peach',
			'angle' => '90',
			'steps' =>
				array(
					0 =>
						array(
							'color'    => '#ffecd2',
							'position' => '0',
						),
					1 =>
						array(
							'color'    => '#fcb69f',
							'position' => '100',
						),
				),
		),
	'mean_fruit'  =>
		array(
			'name'  => 'mean_fruit',
			'angle' => '120',
			'steps' =>
				array(
					0 =>
						array(
							'color'    => '#fccb90',
							'position' => '0',
						),
					1 =>
						array(
							'color'    => '#d57eeb',
							'position' => '100',
						),
				),
		),

);
$elevate_wp_theme_action_button =  'Action Button %d';

$elevate_wp_theme_click_pen_to_edit_title =  'Click the pencil icon to edit the text';
$elevate_wp_lorem_ipsum                   = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enimnad minim veniam, quis nostrud exercitation ullamco laboris nisi.';


return array(
	'default_icon'                      => $elevate_wp_theme_svg_icons['fort-awesome'],
	'icons'                             => $elevate_wp_theme_svg_icons,
	'divider_style'                     => $elevate_wp_theme_divider_style,
	'lorem_ipsum'                       => $elevate_wp_lorem_ipsum,
	'edit_this_text_in_customizer'      => $elevate_wp_theme_click_pen_to_edit_title,
	'gradients'                         => $elevate_wp_gradients,

	'assets_js_key'                     => 'kubioFrontendData',

	'front-header'                      => array(
		'navigation'   => array(
			'props' => array(
				'showTopBar' => false,
			),

			'style' => array(
				'padding' => array(
					'top' => array(
						'value' => 20,
						'unit'  => 'px',
					),
				),
			),
		),
		'header-menu'  => array(
			'props' => array(
				'hoverEffect' => array(
					'group' => array(
						'border' => array(
							'transition' => 'effect-borders-grow grow-from-left',
						),
					),
					'type'  => 'bordered-active-item bordered-active-item--bottom',
				),
			),
		),
		'logo'         => array(
			'props' => array(
				'layoutType' => 'text',
			),
		),
		'buttons'      => array(
			'show'  => true,
			'style' => array(
				'textAlign' => 'center',
			),
			'value' => array(
				array(
					'label'       => sprintf( $elevate_wp_theme_action_button, 1 ),
					'url'         => '#',
					'button_type' => '0',
					'index'       => 0,
				),
				array(
					'label'       => sprintf( $elevate_wp_theme_action_button, 2 ),
					'url'         => '#',
					'button_type' => '1',
					'index'       => 1,
				),
			),
		),
		'title'        => array(
			'show'  => true,
			'value' => $elevate_wp_theme_click_pen_to_edit_title,
			'style' => array(
				'descendants' => array(
					'text' => array(
						'textAlign' => 'center',
					),
				),
			),
		),
		'subtitle'     => array(
			'show'  => true,
			'value' => $elevate_wp_theme_click_pen_to_edit_title,
			'style' => array(
				'descendants' => array(
					'text' => array(
						'textAlign' => 'center',
					),
				),
			),
		),
		'hero'         => array(
			'style'             => array(
				'descendants' => array(
					'outer' => array(
						'background' => array(
							'overlay'   =>
								array(
									'type'             => 'color',
									'color'            => array(
										'value' => 'rgba(0,0,0,0.6)',
									),
									'gradient'         => $elevate_wp_gradients['night_fade'],
									'gradient_opacity' => 50,
									'shape'            =>
										array(
											'value'  => 'none',
											'isTile' => false,
										),
								),
							'slideshow' => array(
								'duration' => array( 'value' => 1500 ),
								'speed'    => array( 'value' => 500 ),
								'slides'   => array(
									array(
										'url' => get_template_directory_uri() . '/resources/images/beach-landscape-sea-water-nature-sand-1061655-pxhere.com.jpg',
									),
									array(
										'url' => get_template_directory_uri() . '/resources/images/landscape-tree-water-nature-grass-outdoor-1327743-pxhere.com.jpg',
									),
									array(
										'url' => get_template_directory_uri() . '/resources/images/leaf-nature-water-green-freshness-dew-1440543-pxhere.com.jpg',
									),
								),
							),
							'video'     => array(
								'videoType'   => 'external',
								'externalUrl' => 'https://www.youtube.com/watch?v=xXRy-JQ8G0Y',
								'internalUrl' => 'https://static-assets.kubiobuilder.com/defaults/demo-video.mp4',
								'poster'      =>
									array(
										'url' => 'https://static-assets.kubiobuilder.com/defaults/demo-video-cover.jpg',
									),
							),
							'image'     => array(
								array(
									'source'     => array(
										'url'      => get_template_directory_uri() . '/resources/images/background-image.jpg',
										'gradient' => $elevate_wp_gradients['night_fade'],
									),
									'attachment' => 'scroll',
								),
							),
						),

						'separators' => array(
							'separatorBottom' => array(
								'type'     => 'tilt',
								'color'    => '#FFFFFF',
								'height'   => array( 'value' => 100 ),
								'enabled'  => false,
								'negative' => false,
							),
						),
					),
				),
			),
			'hero_column_width' => 80,
			'props'             => array(
				'heroSection' => array(
					'layout' => 'textOnly',
				),
			),
			'image'             => array(
				'style' => array(
					'descendants' => array(
						'image'      => array(
							'boxShadow' => array(
								'layers'  => array(
									array(
										'x'      => 0,
										'y'      => 0,
										'spread' => 20,
										'blur'   => 0,
										'color'  => 'rgba(255, 255, 255, 1)',
									),
								),
								'enabled' => false,
							),
						),
						'frameImage' => array(
							'backgroundColor' => 'rgba(255, 255, 255, 1)',
							'width'           => 100,
							'height'          => 100,
							'transform'       => array(
								'translate' => array(
									'x_value' => 10,
									'y_value' => 10,
								),
							),
							'thickness'       => 10,
						),
					),
				),
				'props' => array(
					'frame'              => array(
						'type' => 'border',
					),
					'showFrameOverImage' => true,
					'showFrameShadow'    => false,
					'enabledFrameOption' => false,
				),
			),
			'full_height'       => true,
		),
		'social_icons' => array(
			'show'       => true,
			'localProps' => array(
				'iconList' => array(
					array(
						'icon'       => $elevate_wp_theme_svg_icons['facebook'],
						'link_value' => 'http://www.facebook.com/',
						'index'      => 0,
					),
					array(
						'icon'       => $elevate_wp_theme_svg_icons['twitter'],
						'link_value' => 'http://www.twitter.com/',
						'index'      => 1,
					),
					array(
						'icon'       => $elevate_wp_theme_svg_icons['youtube'],
						'link_value' => 'http://www.youtube.com/',
						'index'      => 2,
					),
					array(
						'icon'       => $elevate_wp_theme_svg_icons['vimeo'],
						'link_value' => 'http://www.vimeo.com/',
						'index'      => 3,
					),
				),
			),
		),
		'icon_list'    => array(
			'show'       => true,
			'localProps' => array(
				'iconList' => array(
					array(
						'icon'       => $elevate_wp_theme_svg_icons['map-marker'],
						'text'       => 'Location, State, Country',
						'link_value' => 'https://maps.google.com/',
						'index'      => 0,
					),
					array(
						'icon'       => $elevate_wp_theme_svg_icons['phone-square'],
						'text'       => '(000) 123 12345',
						'link_value' => 'tel:(000) 123 12345',
						'index'      => 1,
					),
					array(
						'icon'       => $elevate_wp_theme_svg_icons['envelope'],
						'text'       => 'email@yoursite.com',
						'link_value' => 'mailto:email@yoursite.com',
						'index'      => 2,
					),
				),
			),
		),
	),

	'header'                            => array(
		'navigation'   => array(
			'props' => array(
				'showTopBar' => false,
			),
			'style' => array(
				'padding' => array(
					'top' => array(
						'value' => 20,
						'unit'  => 'px',
					),
				),
			),
		),
		'header-menu'  => array(
			'props' => array(
				'hoverEffect' => array(
					'group' => array(
						'border' => array(
							'transition' => 'effect-borders-grow grow-from-left',
						),
					),
					'type'  => 'bordered-active-item bordered-active-item--bottom',
				),
			),
		),
		'logo'         => array(
			'props' => array(
				'layoutType' => 'text',
			),
		),
		'title'        => array(
			'show' => true,
		),
		'hero'         => array(
			'style' => array(
				'descendants' => array(
					'outer' => array(
						'background' => array(
							'overlay'   =>
								array(
									'type'             => 'color',
									'color'            => array(
										'value' => 'rgba(0,0,0,0.6)',
									),
									'gradient'         => $elevate_wp_gradients['night_fade'],
									'gradient_opacity' => 50,
									'shape'            =>
										array(
											'value'  => 'none',
											'isTile' => false,
										),
								),
							'slideshow' => array(
								'duration' => array( 'value' => 1500 ),
								'speed'    => array( 'value' => 500 ),
								'slides'   => array(
									array(
										'url' => get_template_directory_uri() . '/resources/images/beach-landscape-sea-water-nature-sand-1061655-pxhere.com.jpg',
									),
									array(
										'url' => get_template_directory_uri() . '/resources/images/landscape-tree-water-nature-grass-outdoor-1327743-pxhere.com.jpg',
									),
									array(
										'url' => get_template_directory_uri() . '/resources/images/leaf-nature-water-green-freshness-dew-1440543-pxhere.com.jpg',
									),
								),
							),
							'video'     => array(
								'videoType'   => 'external',
								'externalUrl' => 'https://www.youtube.com/watch?v=xXRy-JQ8G0Y',
								'internalUrl' => 'https://static-assets.kubiobuilder.com/defaults/demo-video.mp4',
								'poster'      =>
									array(
										'url' => 'https://static-assets.kubiobuilder.com/defaults/demo-video-cover.jpg',
									),
							),
							'image'     => array(
								array(
									'source'     => array(
										'url'      => get_template_directory_uri() . '/resources/images/background-image.jpg',
										'gradient' => $elevate_wp_gradients['night_fade'],
									),
									'attachment' => 'scroll',
								),
							),
						),

						'separators' => array(
							'separatorBottom' => array(
								'type'     => 'tilt',
								'color'    => '#FFF',
								'height'   => array( 'value' => 100 ),
								'enabled'  => false,
								'negative' => false,
							),
						),
					),
				),
			),
		),
		'social_icons' => array(
			'show'       => true,
			'localProps' => array(
				'icons' => array(
					array(
						'icon'       => $elevate_wp_theme_svg_icons['facebook'],
						'link_value' => '#',
						'index'      => 0,
					),
					array(
						'icon'       => $elevate_wp_theme_svg_icons['twitter'],
						'link_value' => '#',
						'index'      => 1,
					),
					array(
						'icon'       => $elevate_wp_theme_svg_icons['youtube'],
						'link_value' => '#',
						'index'      => 2,
					),
					array(
						'icon'       => $elevate_wp_theme_svg_icons['vimeo'],
						'link_value' => '#',
						'index'      => 3,
					),
				),
			),
		),
		'icon_list'    => array(
			'show'       => true,
			'localProps' => array(
				'iconList' => array(
					array(
						'icon'       => $elevate_wp_theme_svg_icons['map-marker'],
						'text'       => 'Location, State, Country',
						'link_value' => '#',
						'index'      => 0,
					),
					array(
						'icon'       => $elevate_wp_theme_svg_icons['phone-square'],
						'text'       => '(000) 123 12345',
						'link_value' => '#',
						'index'      => 1,
					),
					array(
						'icon'       => $elevate_wp_theme_svg_icons['envelope'],
						'text'       => 'email@yoursite.com',
						'link_value' => 'mailto:email@yoursite.com',
						'index'      => 2,
					),
				),
			),
		),

	),
	'blog_post_thumb_placeholder_color' => 'rgb(204,204,204)',
	'blog_show_post_thumb_placeholder'  => true,
	'blog_posts_per_row'                => 2,
	'blog_enable_masonry'               => true,
);
