<?php
if (!function_exists('elegant_magazine_banner_slider')) :
  /**
   * Banner Slider
   *
   * @since Elegant Magazine 1.0.0
   *
   */
  function elegant_magazine_banner_slider()
  {

    if (1 != elegant_magazine_get_option('show_main_news_section')) {
      return null;
    }

    $em_slider_category = elegant_magazine_get_option('select_slider_news_category');
    $em_number_of_slides = 3;
    $em_featured_category = elegant_magazine_get_option('select_featured_news_category');
    $em_number_of_featured_news = 2;


?>

    <section class="af-blocks af-main-banner">
      <div class="container">
        <div class="row no-gutter">
          <div class="col-md-6 col-sm-12 no-gutter-col" data-mh="banner-height">
            <div class="main-slider">
              <?php
              $slider_posts = elegant_magazine_get_posts($em_number_of_slides, $em_slider_category);
              if ($slider_posts->have_posts()) :
                while ($slider_posts->have_posts()) : $slider_posts->the_post();

                  global $post;
                  $thumbnail_size = 'large';

              ?>
                  <figure class="slick-item">

                    <div class="data-bg-hover data-bg-slide read-bg-img">
                      <a class="em-figure-link" href="<?php the_permalink(); ?>" aria-label="<?php echo esc_attr(get_the_title($post->ID)); ?>">
                        <?php if (has_post_thumbnail()):
                          the_post_thumbnail($thumbnail_size);
                        endif;
                        ?>
                      </a>
                      <figcaption class="slider-figcaption slider-figcaption-1">
                        <div class="figure-categories figure-categories-bg">
                          <?php echo elegant_magazine_post_format($post->ID); ?>
                          <?php elegant_magazine_post_categories(); ?>
                        </div>
                        <div class="title-heading">
                          <h3 class="article-title slide-title">
                            <a href="<?php the_permalink(); ?>" aria-label="<?php echo esc_attr(get_the_title($post->ID)); ?>"><?php the_title(); ?></a>
                          </h3>
                        </div>
                        <div class="grid-item-metadata grid-item-metadata-1">
                          <?php elegant_magazine_post_item_meta(); ?>
                        </div>
                      </figcaption>
                    </div>
                  </figure>
              <?php
                endwhile;
              endif;
              wp_reset_postdata();
              ?>
            </div>

            <div class="af-navcontrols">
              <div class="slide-count">
                <span class="current"></span> of
                <span class="total"></span>
              </div>
            </div>

          </div>


          <?php
          $featured_posts = $slider_posts = elegant_magazine_get_posts($em_number_of_featured_news, $em_featured_category);
          ?>
          <?php

          if ($featured_posts->have_posts()) :
            while ($featured_posts->have_posts()) :
              $featured_posts->the_post();
              global $post;
              $thumbnail_size = 'elegant-magazine-medium';

          ?>
              <div class="col-md-3 col-6-3 col-xs-6 no-gutter-col banner-half">
                <figure class="featured-article">
                  <div class="featured-article-wrapper">
                    <div class="data-bg-hover data-bg-featured read-bg-img">
                      <a class="em-figure-link" href="<?php the_permalink(); ?>" aria-label="<?php echo esc_attr(get_the_title($post->ID)); ?>">
                        <?php if (has_post_thumbnail()):
                          the_post_thumbnail($thumbnail_size);
                        endif;
                        ?>
                      </a>
                      <div class="figure-categories figure-categories-1 figure-categories-bg">
                        <?php echo elegant_magazine_post_format($post->ID); ?>
                        <?php elegant_magazine_post_categories(); ?>
                      </div>
                    </div>
                  </div>
                </figure>

                <figcaption>
                  <div class="title-heading">
                    <h3 class="article-title article-title-1">
                      <a href="<?php the_permalink(); ?>" aria-label="<?php echo esc_attr(get_the_title($post->ID)); ?>">
                        <?php the_title(); ?>
                      </a>
                    </h3>
                  </div>
                  <div class="grid-item-metadata">
                    <?php elegant_magazine_post_item_meta(); ?>
                  </div>
                </figcaption>
              </div>

          <?php endwhile;
          endif;
          wp_reset_postdata();
          ?>

        </div>
      </div>
    </section>

    <!-- end slider-section -->
<?php
  }
endif;
add_action('elegant_magazine_action_front_page', 'elegant_magazine_banner_slider', 40);
