<?php
/**
 * Title: Trending Products
 * Slug: electronics-market/trending-products
 * Categories: electronics-market, trending-products
 */
?>

<?php if (class_exists('WooCommerce')) { ?>
	<!-- wp:group {"className":"trending-sec trending-static-box","style":{"spacing":{"padding":{"bottom":"var:preset|spacing|80","top":"var:preset|spacing|80"}}},"layout":{"type":"constrained","contentSize":"85%"}} -->
	<div class="wp-block-group trending-sec trending-static-box" style="padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:group {"className":"sec-head-box","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} -->
	<div class="wp-block-group sec-head-box"><!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"600","fontSize":"35px"}}} -->
	<h2 class="wp-block-heading" style="font-size:35px;font-style:normal;font-weight:600"><?php esc_html_e('Trending Products','electronics-market'); ?></h2>
	<!-- /wp:heading -->

	<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|body-text"}}},"typography":{"fontSize":"18px"}},"textColor":"body-text"} -->
	<p class="has-body-text-color has-text-color has-link-color" style="font-size:18px"><a href="#"><?php esc_html_e('See All Trending products','electronics-market'); ?></a></p>
	<!-- /wp:paragraph --></div>
	<!-- /wp:group -->

	<!-- wp:woocommerce/product-collection {"queryId":3,"query":{"perPage":9,"pages":0,"offset":0,"postType":"product","order":"asc","orderBy":"title","search":"","exclude":[],"inherit":false,"taxQuery":{"product_cat":[]},"isProductCollectionBlock":true,"featured":false,"woocommerceOnSale":false,"woocommerceStockStatus":["instock","outofstock","onbackorder"],"woocommerceAttributes":[],"woocommerceHandPickedProducts":[],"filterable":true,"relatedBy":{"categories":true,"tags":true}},"tagName":"div","displayLayout":{"type":"flex","columns":4,"shrinkColumns":true},"dimensions":{"widthType":"fill"},"queryContextIncludes":["collection"],"__privatePreviewState":{"isPreview":false,"previewMessage":"Actual products will vary depending on the page being viewed."}} -->
	<div class="wp-block-woocommerce-product-collection"><!-- wp:woocommerce/product-template -->
	<!-- wp:group {"className":"product-inner-box","style":{"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|70","right":"var:preset|spacing|70"}},"border":{"radius":"10px","width":"1px"}},"borderColor":"border-color","layout":{"type":"default"}} -->
	<div class="wp-block-group product-inner-box has-border-color has-border-color-border-color" style="border-width:1px;border-radius:10px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--70)"><!-- wp:woocommerce/product-image {"imageSizing":"thumbnail","isDescendentOfQueryLoop":true} /-->

	<!-- wp:post-terms {"term":"product_tag","style":{"elements":{"link":{"color":{"text":"var:preset|color|body-text"}}},"typography":{"fontSize":"16px","fontStyle":"normal","fontWeight":"400","textTransform":"capitalize"},"spacing":{"margin":{"top":"var:preset|spacing|20"}}},"textColor":"body-text"} /-->

	<!-- wp:post-title {"textAlign":"center","level":3,"isLink":true,"style":{"spacing":{"margin":{"bottom":"0rem","top":"var:preset|spacing|20"}},"typography":{"fontStyle":"normal","fontWeight":"500","fontSize":"20px"}},"__woocommerceNamespace":"woocommerce/product-collection/product-title"} /-->

	<!-- wp:woocommerce/product-price {"isDescendentOfQueryLoop":true,"textAlign":"center","textColor":"secondary","style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"700"},"elements":{"link":{"color":{"text":"var:preset|color|secondary"}}},"spacing":{"margin":{"top":"var:preset|spacing|20"}}}} /-->

	<!-- wp:woocommerce/product-button {"textAlign":"center","isDescendentOfQueryLoop":true,"className":"add-to-cart-sec","fontSize":"small"} /--></div>
	<!-- /wp:group -->
	<!-- /wp:woocommerce/product-template --></div>
	<!-- /wp:woocommerce/product-collection --></div>
	<!-- /wp:group -->
<?php } else { ?>
	<!-- wp:group {"className":"trending-sec trending-static-box","style":{"spacing":{"padding":{"bottom":"var:preset|spacing|80","top":"var:preset|spacing|80"}}},"layout":{"type":"constrained","contentSize":"85%"}} -->
	<div class="wp-block-group trending-sec trending-static-box" style="padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:group {"className":"sec-head-box","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} -->
	<div class="wp-block-group sec-head-box"><!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"600","fontSize":"35px"}}} -->
	<h2 class="wp-block-heading" style="font-size:35px;font-style:normal;font-weight:600"><?php esc_html_e('Trending Products','electronics-market'); ?></h2>
	<!-- /wp:heading -->

	<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|body-text"}}},"typography":{"fontSize":"18px"}},"textColor":"body-text"} -->
	<p class="has-body-text-color has-text-color has-link-color" style="font-size:18px"><a href="#"><?php esc_html_e('See All Trending products','electronics-market'); ?></a></p>
	<!-- /wp:paragraph --></div>
	<!-- /wp:group -->

	<!-- wp:columns {"className":"trending-product-sec-cols"} -->
	<div class="wp-block-columns trending-product-sec-cols"><!-- wp:column {"width":"","className":"product-box-1"} -->
	<div class="wp-block-column product-box-1"><!-- wp:group {"className":"product-inner-box","style":{"border":{"radius":"10px","width":"1px"},"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|70","right":"var:preset|spacing|70"}}},"borderColor":"border-color","layout":{"type":"default"}} -->
	<div class="wp-block-group product-inner-box has-border-color has-border-color-border-color" style="border-width:1px;border-radius:10px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--70)"><!-- wp:image {"id":18,"sizeSlug":"full","linkDestination":"none","align":"center"} -->
	<figure class="wp-block-image aligncenter size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/trending1.png'); ?>" alt="" class="wp-image-18"/></figure>
		<!-- /wp:image -->

	<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"16px"},"spacing":{"margin":{"top":"var:preset|spacing|20","bottom":"0"}}}} -->
	<p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--20);margin-bottom:0;font-size:16px"><?php esc_html_e('Laptop','electronics-market'); ?></p>
	<!-- /wp:paragraph -->

	<!-- wp:heading {"textAlign":"center","level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"500","fontSize":"20px"},"spacing":{"margin":{"top":"var:preset|spacing|20","bottom":"0"}}}} -->
	<h3 class="wp-block-heading has-text-align-center" style="margin-top:var(--wp--preset--spacing--20);margin-bottom:0;font-size:20px;font-style:normal;font-weight:500"><a href="#"><?php esc_html_e('Laptop White Mac','electronics-market'); ?></a></h3>
	<!-- /wp:heading -->

	<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"700"},"elements":{"link":{"color":{"text":"var:preset|color|secondary"}}},"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"0"}}},"textColor":"secondary"} -->
	<p class="has-text-align-center has-secondary-color has-text-color has-link-color" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:0;font-size:14px;font-style:normal;font-weight:700"><?php esc_html_e('$685,00','electronics-market'); ?></p>
	<!-- /wp:paragraph -->

	<!-- wp:group {"className":"product-cart-icon","style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"},"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"primary","layout":{"type":"default"}} -->
	<div class="wp-block-group product-cart-icon has-primary-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:image {"id":175,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/cart.png'); ?>" alt="" class="wp-image-175"/></figure>
	<!-- /wp:image --></div>
	<!-- /wp:group --></div>
	<!-- /wp:group --></div>
	<!-- /wp:column -->

	<!-- wp:column {"width":"","className":"product-box-2"} -->
	<div class="wp-block-column product-box-2"><!-- wp:group {"className":"product-inner-box","style":{"border":{"radius":"10px","width":"1px"},"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|70","right":"var:preset|spacing|70"}}},"borderColor":"border-color","layout":{"type":"default"}} -->
	<div class="wp-block-group product-inner-box has-border-color has-border-color-border-color" style="border-width:1px;border-radius:10px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--70)"><!-- wp:image {"id":20,"sizeSlug":"full","linkDestination":"none","align":"center"} -->
	<figure class="wp-block-image aligncenter size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/trending2.png'); ?>" alt="" class="wp-image-20"/></figure>
	<!-- /wp:image -->

	<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"16px"},"spacing":{"margin":{"top":"var:preset|spacing|20","bottom":"0"}}}} -->
	<p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--20);margin-bottom:0;font-size:16px"><?php esc_html_e('Speakers','electronics-market'); ?></p>
	<!-- /wp:paragraph -->

	<!-- wp:heading {"textAlign":"center","level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"500","fontSize":"20px"},"spacing":{"margin":{"top":"var:preset|spacing|20","bottom":"0"}}}} -->
	<h3 class="wp-block-heading has-text-align-center" style="margin-top:var(--wp--preset--spacing--20);margin-bottom:0;font-size:20px;font-style:normal;font-weight:500"><a href="#"></a><a href="#"><?php esc_html_e('Purple Solo 2 Wireless','electronics-market'); ?></a></h3>
	<!-- /wp:heading -->

	<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"700"},"elements":{"link":{"color":{"text":"var:preset|color|secondary"}}},"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"0"}}},"textColor":"secondary"} -->
	<p class="has-text-align-center has-secondary-color has-text-color has-link-color" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:0;font-size:14px;font-style:normal;font-weight:700"><?php esc_html_e('$685,00','electronics-market'); ?></p>
	<!-- /wp:paragraph -->

	<!-- wp:group {"className":"product-cart-icon","style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"},"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"primary","layout":{"type":"default"}} -->
	<div class="wp-block-group product-cart-icon has-primary-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:image {"id":175,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/cart.png'); ?>" alt="" class="wp-image-175"/></figure>
	<!-- /wp:image --></div>
	<!-- /wp:group --></div>
	<!-- /wp:group --></div>
	<!-- /wp:column -->

	<!-- wp:column {"width":"","className":"product-box-3"} -->
	<div class="wp-block-column product-box-3"><!-- wp:group {"className":"product-inner-box","style":{"border":{"radius":"10px","width":"1px"},"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|70","right":"var:preset|spacing|70"}}},"borderColor":"border-color","layout":{"type":"default"}} -->
	<div class="wp-block-group product-inner-box has-border-color has-border-color-border-color" style="border-width:1px;border-radius:10px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--70)"><!-- wp:image {"id":24,"sizeSlug":"full","linkDestination":"none","align":"center"} -->
	<figure class="wp-block-image aligncenter size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/trending3.png'); ?>" alt="" class="wp-image-24"/></figure>
	<!-- /wp:image -->

	<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"16px"},"spacing":{"margin":{"top":"var:preset|spacing|20","bottom":"0"}}}} -->
	<p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--20);margin-bottom:0;font-size:16px"><?php esc_html_e('Printer','electronics-market'); ?></p>
	<!-- /wp:paragraph -->

	<!-- wp:heading {"textAlign":"center","level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"500","fontSize":"20px"},"spacing":{"margin":{"top":"var:preset|spacing|20","bottom":"0"}}}} -->
	<h3 class="wp-block-heading has-text-align-center" style="margin-top:var(--wp--preset--spacing--20);margin-bottom:0;font-size:20px;font-style:normal;font-weight:500"><a href="#"><?php esc_html_e('Full Color LaserJet Pro M452dn','electronics-market'); ?></a></h3>
	<!-- /wp:heading -->

	<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"700"},"elements":{"link":{"color":{"text":"var:preset|color|secondary"}}},"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"0"}}},"textColor":"secondary"} -->
	<p class="has-text-align-center has-secondary-color has-text-color has-link-color" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:0;font-size:14px;font-style:normal;font-weight:700"><?php esc_html_e('$685,00','electronics-market'); ?></p>
	<!-- /wp:paragraph -->

	<!-- wp:group {"className":"product-cart-icon","style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"},"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"primary","layout":{"type":"default"}} -->
	<div class="wp-block-group product-cart-icon has-primary-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:image {"id":175,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/cart.png'); ?>" alt="" class="wp-image-175"/></figure>
	<!-- /wp:image --></div>
	<!-- /wp:group --></div>
	<!-- /wp:group --></div>
	<!-- /wp:column -->

	<!-- wp:column {"width":"","className":"product-box-4"} -->
	<div class="wp-block-column product-box-4"><!-- wp:group {"className":"product-inner-box","style":{"border":{"radius":"10px","width":"1px"},"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|70","right":"var:preset|spacing|70"}}},"borderColor":"border-color","layout":{"type":"default"}} -->
	<div class="wp-block-group product-inner-box has-border-color has-border-color-border-color" style="border-width:1px;border-radius:10px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--70)"><!-- wp:image {"id":27,"sizeSlug":"full","linkDestination":"none","align":"center"} -->
	<figure class="wp-block-image aligncenter size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/trending4.png'); ?>" alt="" class="wp-image-27"/></figure>
	<!-- /wp:image -->

	<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"16px"},"spacing":{"margin":{"top":"var:preset|spacing|20","bottom":"0"}}}} -->
	<p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--20);margin-bottom:0;font-size:16px"><?php esc_html_e('Game','electronics-market'); ?></p>
	<!-- /wp:paragraph -->

	<!-- wp:heading {"textAlign":"center","level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"500","fontSize":"20px"},"spacing":{"margin":{"top":"var:preset|spacing|20","bottom":"0"}}}} -->
	<h3 class="wp-block-heading has-text-align-center" style="margin-top:var(--wp--preset--spacing--20);margin-bottom:0;font-size:20px;font-style:normal;font-weight:500"><a href="#"><?php esc_html_e('GameConsole Destiny Special Edition','electronics-market'); ?></a></h3>
	<!-- /wp:heading -->

	<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"700"},"elements":{"link":{"color":{"text":"var:preset|color|secondary"}}},"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"0"}}},"textColor":"secondary"} -->
	<p class="has-text-align-center has-secondary-color has-text-color has-link-color" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:0;font-size:14px;font-style:normal;font-weight:700"><?php esc_html_e('$685,00','electronics-market'); ?></p>
	<!-- /wp:paragraph -->

	<!-- wp:group {"className":"product-cart-icon","style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"},"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"primary","layout":{"type":"default"}} -->
	<div class="wp-block-group product-cart-icon has-primary-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:image {"id":175,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/cart.png'); ?>" alt="" class="wp-image-175"/></figure>
	<!-- /wp:image --></div>
	<!-- /wp:group --></div>
	<!-- /wp:group --></div>
	<!-- /wp:column --></div>
	<!-- /wp:columns --></div>
	<!-- /wp:group -->
<?php } ?>