<?php

add_action( 'admin_menu', 'electronics_market_gettingstarted' );
function electronics_market_gettingstarted() {
	add_theme_page( esc_html__('Begin Installation', 'electronics-market'), esc_html__('Begin Installation', 'electronics-market'), 'edit_theme_options', 'electronics-market-guide-page', 'electronics_market_guide');
}

if ( ! defined( 'ELECTRONICS_MARKET_SUPPORT' ) ) {
define('ELECTRONICS_MARKET_SUPPORT',__('https://wordpress.org/support/theme/electronics-market/','electronics-market'));
}
if ( ! defined( 'ELECTRONICS_MARKET_REVIEW' ) ) {
define('ELECTRONICS_MARKET_REVIEW',__('https://wordpress.org/support/theme/electronics-market/reviews/','electronics-market'));
}
if ( ! defined( 'ELECTRONICS_MARKET_LIVE_DEMO' ) ) {
define('ELECTRONICS_MARKET_LIVE_DEMO',__('https://trial.ovationthemes.com/electronics-market/','electronics-market'));
}
if ( ! defined( 'ELECTRONICS_MARKET_BUY_PRO' ) ) {
define('ELECTRONICS_MARKET_BUY_PRO',__('https://www.ovationthemes.com/products/electronics-market-wordpress-theme','electronics-market'));
}
if ( ! defined( 'ELECTRONICS_MARKET_PRO_DOC' ) ) {
define('ELECTRONICS_MARKET_PRO_DOC',__('https://trial.ovationthemes.com/docs/electronics-market-pro-doc/','electronics-market'));
}
if ( ! defined( 'ELECTRONICS_MARKET_FREE_DOC' ) ) {
define('ELECTRONICS_MARKET_FREE_DOC',__('https://trial.ovationthemes.com/docs/electronics-market-free-doc/','electronics-market'));
}
if ( ! defined( 'ELECTRONICS_MARKET_THEME_NAME' ) ) {
define('ELECTRONICS_MARKET_THEME_NAME',__('Premium Electronics Market Theme','electronics-market'));
}
if ( ! defined( 'ELECTRONICS_MARKET_BUNDLE_LINK' ) ) {
define('ELECTRONICS_MARKET_BUNDLE_LINK',__('https://www.ovationthemes.com/products/wordpress-bundle','electronics-market'));
}
/**
 * Theme Info Page
 */
function electronics_market_guide() {

	// Theme info
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( '' ); ?>

	<div class="getting-started__header">
		<div class="header-box-left">
			<h2><?php echo esc_html( $theme ); ?></h2>
			<p><?php esc_html_e('Version: ', 'electronics-market'); ?><?php echo esc_html($theme['Version']);?></p>
		</div>
		<div class="header-box-right">
			<div class="btn_box">
				<a class="button-primary" href="<?php echo esc_url( ELECTRONICS_MARKET_FREE_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation', 'electronics-market'); ?></a>
				<a class="button-primary" href="<?php echo esc_url( ELECTRONICS_MARKET_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support', 'electronics-market'); ?></a>
				<a class="button-primary" href="<?php echo esc_url( ELECTRONICS_MARKET_REVIEW ); ?>" target="_blank"><?php esc_html_e('Review', 'electronics-market'); ?></a>
			</div>
		</div>
	</div>

	<div class="wrap getting-started">
		<div class="box-container">
			<div class="box-left-main">
				<div class="leftbox">
					<h3><?php esc_html_e('Documentation','electronics-market'); ?></h3>
					<p><?php $theme = wp_get_theme(); 
						echo wp_kses_post( apply_filters( 'description', esc_html( $theme->get( 'Description' ) ) ) );
					?></p>

					<h4><?php esc_html_e('Edit Your Site','electronics-market'); ?></h4>
					<p><?php esc_html_e('Now create your website with easy drag and drop powered by gutenburg.','electronics-market'); ?></p>
					<a class="button-primary" href="<?php echo esc_url( admin_url() . 'site-editor.php' ); ?>" target="_blank"><?php esc_html_e('Edit Your Site','electronics-market'); ?></a>

					<h4><?php esc_html_e('Visit Your Site','electronics-market'); ?></h4>
					<p><?php esc_html_e('To check your website click here','electronics-market'); ?></p>
					<a class="button-primary" href="<?php echo esc_url( home_url() ); ?>" target="_blank"><?php esc_html_e('Visit Your Site','electronics-market'); ?></a>

					<h4><?php esc_html_e('Theme Documentation','electronics-market'); ?></h4>
					<p><?php esc_html_e('Check the theme documentation to easily set up your website.','electronics-market'); ?></p>
					<a class="button-primary" href="<?php echo esc_url( ELECTRONICS_MARKET_FREE_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation','electronics-market'); ?></a>
				</div>
       	</div>
			<div class="box-right-main">
				<h3><?php echo esc_html(ELECTRONICS_MARKET_THEME_NAME); ?></h3>
				<img class="electronics_market_img_responsive" style="width: 100%;" src="<?php echo esc_url( $theme->get_screenshot() ); ?>" />
				<div class="pro-links">
					<div class="pro-links-inner">
						<a class="button-primary livedemo" href="<?php echo esc_url( ELECTRONICS_MARKET_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'electronics-market'); ?></a>
						<a class="button-primary buynow" href="<?php echo esc_url( ELECTRONICS_MARKET_BUY_PRO ); ?>" target="_blank"><?php esc_html_e('Buy Now', 'electronics-market'); ?></a>
						<a class="button-primary docs" href="<?php echo esc_url( ELECTRONICS_MARKET_PRO_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation', 'electronics-market'); ?></a>
					</div>
						<a class="button-primary bundle-btn" href="<?php echo esc_url( ELECTRONICS_MARKET_BUNDLE_LINK ); ?>" target="_blank"><?php esc_html_e('WordPress Theme Bundle (125+ Themes at Just $99)', 'electronics-market'); ?></a>
				</div>
				<ul style="padding-top:10px">
					<li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Responsive Design', 'electronics-market');?> </li>                 
					<li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Demo Importer', 'electronics-market');?> </li>
					<li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Section Reordering', 'electronics-market');?> </li>
					<li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Contact Page Template', 'electronics-market');?> </li>
					<li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Multiple Blog Layouts', 'electronics-market');?> </li>
					<li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Unlimited Color Options', 'electronics-market');?> </li>
					<li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Cross Browser Support', 'electronics-market');?> </li>
					<li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Detailed Documentation Included', 'electronics-market');?> </li>
					<li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('WPML Compatible (Translation Ready)', 'electronics-market');?> </li>
					<li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Woo-commerce Compatible', 'electronics-market');?> </li>
					<li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Full Support', 'electronics-market');?> </li>
					<li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('10+ Sections', 'electronics-market');?> </li>
					<li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('SEO Friendly', 'electronics-market');?> </li>
               <li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Supper Fast', 'electronics-market');?> </li>
            </ul>
        	</div>
		</div>
	</div>

<?php }?>