<?php
/**
 * Electronics Market: Customizer
 *
 * @subpackage Electronics Market
 * @since 1.0
 */

function electronics_market_customize_register( $wp_customize ) {

	wp_enqueue_style('customizercustom_css', esc_url( get_template_directory_uri() ). '/inc/customizer/customizer.css');

	// Pro Section
 	$wp_customize->add_section('electronics_market_pro', array(
        'title'    => __('ELECTRONICS MARKET PREMIUM', 'electronics-market'),
        'priority' => 1,
    ));
    $wp_customize->add_setting('electronics_market_pro', array(
        'default'           => null,
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control(new Electronics_Market_Pro_Control($wp_customize, 'electronics_market_pro', array(
        'label'    => __('ELECTRONICS MARKET PREMIUM', 'electronics-market'),
        'section'  => 'electronics_market_pro',
        'settings' => 'electronics_market_pro',
        'priority' => 1,
    )));
}
add_action( 'customize_register', 'electronics_market_customize_register' );


define('ELECTRONICS_MARKET_PRO_LINK',__('https://www.ovationthemes.com/products/electronics-market-wordpress-theme','electronics-market'));

define('ELECTRONICS_MARKET_BUNDLE_BTN',__('https://www.ovationthemes.com/products/wordpress-bundle','electronics-market'));

/* Pro control */
if (class_exists('WP_Customize_Control') && !class_exists('Electronics_Market_Pro_Control')):
    class Electronics_Market_Pro_Control extends WP_Customize_Control{

    public function render_content(){?>
        <label style="overflow: hidden; zoom: 1;">
	        <div class="col-md upsell-btn">
                <a href="<?php echo esc_url( ELECTRONICS_MARKET_PRO_LINK ); ?>" target="blank" class="btn btn-success btn"><?php esc_html_e('UPGRADE ELECTRONICS MARKET PREMIUM','electronics-market');?> </a>
	        </div>
            <div class="col-md">
                <img class="electronics_market_img_responsive " src="<?php echo esc_url(get_template_directory_uri()); ?>/screenshot.png">
            </div>
	        <div class="col-md">
                <ul style="padding-top:10px">
                    <li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Responsive Design', 'electronics-market');?> </li>                 
                    <li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Demo Importer', 'electronics-market');?> </li>
                    <li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Section Reordering', 'electronics-market');?> </li>
                    <li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Contact Page Template', 'electronics-market');?> </li>
                    <li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Multiple Blog Layouts', 'electronics-market');?> </li>
                    <li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Unlimited Color Options', 'electronics-market');?> </li>
                    <li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Cross Browser Support', 'electronics-market');?> </li>
                    <li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Detailed Documentation Included', 'electronics-market');?> </li>
                    <li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('WPML Compatible (Translation Ready)', 'electronics-market');?> </li>
                    <li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Woo-commerce Compatible', 'electronics-market');?> </li>
                    <li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Full Support', 'electronics-market');?> </li>
                    <li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('10+ Sections', 'electronics-market');?> </li>
                    <li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('SEO Friendly', 'electronics-market');?> </li>
                    <li class="upsell-electronics_market"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Supper Fast', 'electronics-market');?> </li>
                </ul>
        	</div>
            <div class="col-md upsell-btn upsell-btn-bottom">
                <a href="<?php echo esc_url( ELECTRONICS_MARKET_BUNDLE_BTN ); ?>" target="blank" class="btn btn-success btn"><?php esc_html_e('WP Theme Bundle (125+ Themes)','electronics-market');?> </a>
            </div>
        </label>
    <?php } }
endif;