<?php 

function electronics_market_add_admin_menu() {
    add_menu_page(
        'Theme Settings', // Page title
        'Theme Settings', // Menu title
        'manage_options', // Capability
        'electronics-market-theme-settings', // Menu slug
        'electronics_market_settings_page' // Function to display the page
    );
}
add_action( 'admin_menu', 'electronics_market_add_admin_menu' );

function electronics_market_settings_page() {
    ?>
    <div class="wrap">
        <h1><?php esc_html_e( 'Theme Settings', 'electronics-market' ); ?></h1>
        <form action="options.php" method="post">
            <?php
            settings_fields( 'electronics_market_settings_group' );
            do_settings_sections( 'electronics-market-theme-settings' );
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

function electronics_market_register_settings() {
    register_setting( 'electronics_market_settings_group', 'electronics_market_enable_animations' );

    add_settings_section(
        'electronics_market_settings_section',
        __( 'Animation Settings', 'electronics-market' ),
        null,
        'electronics-market-theme-settings'
    );

    add_settings_field(
        'electronics_market_enable_animations',
        __( 'Enable Animations', 'electronics-market' ),
        'electronics_market_enable_animations_callback',
        'electronics-market-theme-settings',
        'electronics_market_settings_section'
    );
}
add_action( 'admin_init', 'electronics_market_register_settings' );

function electronics_market_enable_animations_callback() {
    $checked = get_option( 'electronics_market_enable_animations', true );
    ?>
    <input type="checkbox" name="electronics_market_enable_animations" value="1" <?php checked( 1, $checked ); ?> />
    <?php
}

