<?php
/**
 * Electronics Market: Block Patterns
 *
 * @since Electronics Market 1.0
 */

/**
 * Registers block patterns and categories.
 *
 * @since Electronics Market 1.0
 *
 * @return void
 */
function electronics_market_register_block_patterns() {
	$electronics_market_block_pattern_categories = array(
		'electronics-market'    => array( 'label' => __( 'Electronics Market', 'electronics-market' ) ),
	);

	$electronics_market_block_pattern_categories = apply_filters( 'electronics_market_block_pattern_categories', $electronics_market_block_pattern_categories );

	foreach ( $electronics_market_block_pattern_categories as $name => $properties ) {
		if ( ! WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
			register_block_pattern_category( $name, $properties );
		}
	}
}
add_action( 'init', 'electronics_market_register_block_patterns', 9 );
