<?php
$typography_preset_choices = apply_filters(
	'elearning_site_layout_choices',
	array(
		'preset-1' => array(
			'label'              => '',
			'body_typography'    => array(
				'font-family'    => 'Segoe UI',
				'font-weight'    => '400',
				'font-size'      => array(
					'desktop' => array(
						'size' => '15',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.8',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
			'heading_typography' => array(
				'font-family'    => 'Segoe UI',
				'font-weight'    => '500',
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.3',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
		),
		'preset-2' => array(
			'label'              => '',
			'body_typography'    => array(
				'font-family'    => 'Inter',
				'font-size'      => array(
					'desktop' => array(
						'size' => '16',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'subsets'        => array( 'latin' ),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.8',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
			'heading_typography' => array(
				'font-family'    => 'Manrope',
				'font-weight'    => '400',
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.3',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
		),
		'preset-3' => array(
			'label'              => '',
			'body_typography'    => array(
				'font-family'    => 'Lato',
				'font-weight'    => '400',
				'subsets'        => array( 'latin' ),
				'font-size'      => array(
					'desktop' => array(
						'size' => '16',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.8',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
			'heading_typography' => array(
				'font-family'    => 'Montserrat',
				'font-weight'    => '700',
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.3',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
		),
		'preset-4' => array(
			'label'              => '',
			'body_typography'    => array(
				'font-family'    => 'Roboto',
				'font-weight'    => '400',
				'subsets'        => array( 'latin' ),
				'font-size'      => array(
					'desktop' => array(
						'size' => '16',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.8',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
			'heading_typography' => array(
				'font-family'    => 'Poppins',
				'font-weight'    => '700',
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.3',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
		),
		'preset-5' => array(
			'label'              => '',
			'body_typography'    => array(
				'font-family'    => 'Nunito',
				'font-weight'    => '400',
				'font-size'      => array(
					'desktop' => array(
						'size' => '16',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.8',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
			'heading_typography' => array(
				'font-family'    => 'Merriweather',
				'font-weight'    => '700',
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.3',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
		),
		'preset-6' => array(
			'label'              => '',
			'body_typography'    => array(
				'font-family'    => 'DM Sans',
				'font-weight'    => '400',
				'font-size'      => array(
					'desktop' => array(
						'size' => '16',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.8',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
			'heading_typography' => array(
				'font-family'    => 'DM Serif Display',
				'font-weight'    => '700',
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.3',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
		),
	)
);
$options                   = apply_filters(
	'elearning_typography_options',
	array(
		'elearning_typography_presets'           => array(
			'type'       => 'customind-typography-preset',
			'default'    => typography_should_migrate() ? '' : 'preset-1',
			'title'      => esc_html__( 'Presets', 'elearning' ),
			'body_id'    => 'elearning_base_typography_body',
			'heading_id' => 'elearning_base_typography_heading',
			'section'    => 'elearning_typography',
			'choices'    => $typography_preset_choices,
			'columns'    => 3,
		),
		'elearning_fonts_typography_heading'     => array(
			'type'    => 'customind-heading',
			'title'   => esc_html__( 'Fonts', 'elearning' ),
			'section' => 'elearning_typography',
		),
		'elearning_base_typography_body'         => array(
			'default'   => array(
				'font-family'    => 'inherit',
				'font-weight'    => '400',
				'font-size'      => array(
					'desktop' => array(
						'size' => '15',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.8',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'font-style'     => 'normal',
				'text-transform' => 'none',
			),
			'type'      => 'customind-typography',
			'transport' => 'postMessage',
			'title'     => esc_html__( 'Body', 'elearning' ),
			'section'   => 'elearning_typography',
		),
		'elearning_base_typography_heading'      => array(
			'default'            => apply_filters(
				'elearning_base_typography_heading_filter',
				array(
					'font-family'    => 'inherit',
					'font-weight'    => '400',
					'line-height'    => array(
						'desktop' => array(
							'size' => '1.3',
							'unit' => '-',
						),
						'tablet'  => array(
							'size' => '',
							'unit' => '',
						),
						'mobile'  => array(
							'size' => '',
							'unit' => '',
						),
					),
					'font-style'     => 'normal',
					'text-transform' => 'none',
				)
			),
			'type'               => 'customind-typography',
			'title'              => esc_html__( 'Heading', 'elearning' ),
			'transport'          => 'postMessage',
			'section'            => 'elearning_typography',
			'allowed_properties' => array(
				'font-family',
				'font-weight',
				'line-height',
				'font-style',
				'text-transform',
			),
		),
		'elearning_headings_typography_subtitle' => array(
			'type'    => 'customind-divider',
			'variant' => 'solid',
			'section' => 'elearning_typography',
		),
		'elearning_typography_h1'                => array(
			'default'   => apply_filters(
				'elearning_typography_h1_filter',
				array(
					'font-family'    => 'inherit',
					'font-weight'    => '500',
					'subsets'        => array( 'latin' ),
					'font-size'      => array(
						'desktop' => array(
							'size' => '2.5',
							'unit' => 'rem',
						),
						'tablet'  => array(
							'size' => '',
							'unit' => '',
						),
						'mobile'  => array(
							'size' => '',
							'unit' => '',
						),
					),
					'line-height'    => array(
						'desktop' => array(
							'size' => '1.3',
							'unit' => '-',
						),
						'tablet'  => array(
							'size' => '',
							'unit' => '',
						),
						'mobile'  => array(
							'size' => '',
							'unit' => '',
						),
					),
					'font-style'     => 'normal',
					'text-transform' => 'none',
				)
			),
			'type'      => 'customind-typography',
			'transport' => 'postMessage',
			'title'     => esc_html__( 'H1', 'elearning' ),
			'section'   => 'elearning_typography',
		),
		'elearning_typography_h2'                => array(
			'default'   => apply_filters(
				'elearning_typography_h2_filter',
				array(
					'font-family'    => 'inherit',
					'font-weight'    => '500',
					'subsets'        => array( 'latin' ),
					'font-size'      => array(
						'desktop' => array(
							'size' => '2.5',
							'unit' => 'rem',
						),
						'tablet'  => array(
							'size' => '',
							'unit' => '',
						),
						'mobile'  => array(
							'size' => '',
							'unit' => '',
						),
					),
					'line-height'    => array(
						'desktop' => array(
							'size' => '1.3',
							'unit' => '-',
						),
						'tablet'  => array(
							'size' => '',
							'unit' => '',
						),
						'mobile'  => array(
							'size' => '',
							'unit' => '',
						),
					),
					'font-style'     => 'normal',
					'text-transform' => 'none',
				)
			),
			'type'      => 'customind-typography',
			'transport' => 'postMessage',
			'title'     => esc_html__( 'H2', 'elearning' ),
			'section'   => 'elearning_typography',
		),
		'elearning_typography_h3'                => array(
			'default'   => apply_filters(
				'elearning_typography_h3_filter',
				array(
					'font-family'    => 'inherit',
					'font-weight'    => '500',
					'subsets'        => array( 'latin' ),
					'font-size'      => array(
						'desktop' => array(
							'size' => '2',
							'unit' => 'rem',
						),
						'tablet'  => array(
							'size' => '',
							'unit' => '',
						),
						'mobile'  => array(
							'size' => '',
							'unit' => '',
						),
					),
					'line-height'    => array(
						'desktop' => array(
							'size' => '1.3',
							'unit' => '-',
						),
						'tablet'  => array(
							'size' => '',
							'unit' => '',
						),
						'mobile'  => array(
							'size' => '',
							'unit' => '',
						),
					),
					'font-style'     => 'normal',
					'text-transform' => 'none',
				)
			),
			'type'      => 'customind-typography',
			'title'     => esc_html__( 'H3', 'elearning' ),
			'transport' => 'postMessage',
			'section'   => 'elearning_typography',
		),
		'elearning_typography_h4'                => array(
			'default'   => apply_filters(
				'elearning_typography_h4_filter',
				array(
					'font-family'    => 'inherit',
					'font-weight'    => '500',
					'subsets'        => array( 'latin' ),
					'font-size'      => array(
						'desktop' => array(
							'size' => '1.75',
							'unit' => 'rem',
						),
						'tablet'  => array(
							'size' => '',
							'unit' => '',
						),
						'mobile'  => array(
							'size' => '',
							'unit' => '',
						),
					),
					'line-height'    => array(
						'desktop' => array(
							'size' => '1.3',
							'unit' => '-',
						),
						'tablet'  => array(
							'size' => '',
							'unit' => '',
						),
						'mobile'  => array(
							'size' => '',
							'unit' => '',
						),
					),
					'font-style'     => 'normal',
					'text-transform' => 'none',
				)
			),
			'type'      => 'customind-typography',
			'title'     => esc_html__( 'H4', 'elearning' ),
			'transport' => 'postMessage',
			'section'   => 'elearning_typography',
		),
		'elearning_typography_h5'                => array(
			'default'   => apply_filters(
				'elearning_typography_h5_filter',
				array(
					'font-family'    => 'inherit',
					'font-weight'    => '500',
					'subsets'        => array( 'latin' ),
					'font-size'      => array(
						'desktop' => array(
							'size' => '1.313',
							'unit' => 'rem',
						),
						'tablet'  => array(
							'size' => '',
							'unit' => '',
						),
						'mobile'  => array(
							'size' => '',
							'unit' => '',
						),
					),
					'line-height'    => array(
						'desktop' => array(
							'size' => '1.3',
							'unit' => '-',
						),
						'tablet'  => array(
							'size' => '',
							'unit' => '',
						),
						'mobile'  => array(
							'size' => '',
							'unit' => '',
						),
					),
					'font-style'     => 'normal',
					'text-transform' => 'none',
				)
			),
			'type'      => 'customind-typography',
			'title'     => esc_html__( 'H5', 'elearning' ),
			'transport' => 'postMessage',
			'section'   => 'elearning_typography',
		),
		'elearning_typography_h6'                => array(
			'default'   => apply_filters(
				'elearning_typography_h6_filter',
				array(
					'font-family'    => 'inherit',
					'font-weight'    => '500',
					'subsets'        => array( 'latin' ),
					'font-size'      => array(
						'desktop' => array(
							'size' => '1.125',
							'unit' => 'rem',
						),
						'tablet'  => array(
							'size' => '',
							'unit' => '',
						),
						'mobile'  => array(
							'size' => '',
							'unit' => '',
						),
					),
					'line-height'    => array(
						'desktop' => array(
							'size' => '1.3',
							'unit' => '-',
						),
						'tablet'  => array(
							'size' => '',
							'unit' => '',
						),
						'mobile'  => array(
							'size' => '',
							'unit' => '',
						),
					),
					'font-style'     => 'normal',
					'text-transform' => 'none',
				)
			),
			'type'      => 'customind-typography',
			'title'     => esc_html__( 'H6', 'elearning' ),
			'transport' => 'postMessage',
			'section'   => 'elearning_typography',
		),
	),
);

elearning_customind()->add_controls( $options );
