<?php if ( true == get_theme_mod( 'elearning_school_why_join_us_on_off', 'on' ) ) : ?>
<?php

$elearning_school_courses_count = get_theme_mod('elearning_school_courses_count');
$elearning_school_why_join_us_short_heading = get_theme_mod('elearning_school_why_join_us_short_heading');
$elearning_school_industry_why_join_us_heading = get_theme_mod('elearning_school_industry_why_join_us_heading');

?>
<section id="home_our_cases" class="py-5">
  <div class="container">
    <div class="course-heading text-center pb-4 wow fadeInDown" data-wow-duration="2s">
      <?php if ( ! empty( $elearning_school_why_join_us_short_heading ) ) : ?>
          <h5 class="mb-0"><?php echo esc_html( $elearning_school_why_join_us_short_heading ); ?></h5>
        <?php endif; ?>
        <?php if ( ! empty( $elearning_school_industry_why_join_us_heading ) ): ?>
          <h4 class="text-left mb-2"><?php echo esc_html( $elearning_school_industry_why_join_us_heading ); ?></h4>
          <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/course-heading.png">
        <?php endif; ?>
    </div>
    <div class="owl-carousel">
      <?php for ($i=1; $i <= $elearning_school_courses_count; $i++) {
        $elearning_school_courses_image = get_theme_mod('elearning_school_courses_image'.$i);
        $elearning_school_couses_heading = get_theme_mod('elearning_school_couses_heading'.$i);
        $elearning_school_courses_lesson_number = get_theme_mod('elearning_school_courses_lesson_number'.$i);
        $elearning_school_courses_student_number = get_theme_mod('elearning_school_courses_student_number'.$i);
        $elearning_school_courses_time = get_theme_mod('elearning_school_courses_time'.$i);
        $elearning_school_courses_team_image = get_theme_mod('elearning_school_courses_team_image'.$i);
        $elearning_school_courses_team_name = get_theme_mod('elearning_school_courses_team_name'.$i);
        $elearning_school_courses_team_designation = get_theme_mod('elearning_school_courses_team_designation'.$i);
        $elearning_school_courses_button_link = get_theme_mod('elearning_school_courses_button_link'.$i); 
        $elearning_school_courses_button_text = get_theme_mod('elearning_school_courses_button_text'.$i);
        ?>
        <?php if ( ! empty( $elearning_school_courses_image) ) : ?>
          <div class="courses_main_box wow fadeInUp" data-wow-duration="2s">
            <div class="row">
              <div class="col-lg-5 col-md-5 align-self-center course-image">
                <?php if ( ! empty( $elearning_school_courses_image) ) : ?>
                  <img src="<?php echo esc_url( $elearning_school_courses_image ); ?>">
                <?php endif; ?>
              </div>
              <div class="col-lg-7 col-md-7 align-self-center">
                <?php if (! empty( $elearning_school_couses_heading ) ): ?>
                  <h2><?php echo esc_html( $elearning_school_couses_heading ); ?></h2>
                <?php endif; ?>
                <div class="row">
                  <?php if ( ! empty( $elearning_school_courses_lesson_number ) ) : ?>
                    <div class="col-lg-6 col-md-6 col-sm-6 col-6 couses-lesson">
                      <i class="fas fa-book"></i><?php esc_html_e('Lesson : ','elearning-school'); ?><?php echo esc_html( $elearning_school_courses_lesson_number ); ?>
                    </div>
                  <?php endif; ?>
                  <?php if ( ! empty( $elearning_school_courses_student_number ) ) : ?>
                      <div class="col-lg-6 col-md-6 col-sm-6 col-6 couses-lesson">
                        <i class="fas fa-user"></i><?php esc_html_e('Student : ','elearning-school'); ?><?php echo esc_html( $elearning_school_courses_student_number ); ?>
                      </div>
                  <?php endif; ?>
                </div>
                <?php if ( ! empty( $elearning_school_courses_time ) ) : ?>
                  <p><?php echo esc_html( $elearning_school_courses_time ); ?></p>
                <?php endif; ?>
                <div class="border-box">
                  <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/border.png">
                </div>
                <div class="row">
                  <div class="col-lg-7 col-md-7 col-sm-7 col-12 align-self-center">
                    <div class="row">
                      <div class="col-lg-4 col-md-4 col-sm-4 col-4 team-image align-self-center">
                        <?php if ( ! empty( $elearning_school_courses_team_image) ) : ?>
                          <img src="<?php echo esc_url( $elearning_school_courses_team_image ); ?>">
                        <?php endif; ?>
                      </div>
                      <div class="col-lg-8 col-md-8 col-sm-8 col-8 team-content align-self-center">
                        <?php if (! empty( $elearning_school_courses_team_name ) ): ?>
                          <h6 class="mb-1"><?php echo esc_html( $elearning_school_courses_team_name ); ?></h6>
                        <?php endif; ?>
                        <?php if (! empty( $elearning_school_courses_team_designation ) ): ?>
                          <p><?php echo esc_html( $elearning_school_courses_team_designation ); ?></p>
                        <?php endif; ?>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-5 col-md-5 col-sm-5 col-12 align-self-center">
                    <div class="courses_button text-end">
                      <?php if ( ! empty( $elearning_school_courses_button_link ) || ! empty( $elearning_school_courses_button_text ) ): ?>
                        <a class="button1" href="<?php echo esc_url( $elearning_school_courses_button_link ); ?>"><?php echo esc_html( $elearning_school_courses_button_text ); ?><i class="fas fa-chevron-right"></i></a>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        <?php endif; ?>
      <?php } ?>
    </div>
  </div>
</section>
<?php endif; ?>
