<?php

add_action( 'admin_menu', 'elearning_school_getting_started' );
function elearning_school_getting_started() {
    add_theme_page( 
		esc_html__('Getting Started', 'elearning-school'), 
		esc_html__('Getting Started', 'elearning-school'), 
		'manage_options', 
		'elearning-school-guide-page', 
		'elearning_school_test_guide'
	);
}

if ( ! defined( 'ELEARNING_SCHOOL_DOCS_FREE' ) ) {
define('ELEARNING_SCHOOL_DOCS_FREE',__('https://www.mishkatwp.com/instruction/elearning-school-free-docs/','elearning-school'));
}
if ( ! defined( 'ELEARNING_SCHOOL_DOCS_PRO' ) ) {
define('ELEARNING_SCHOOL_DOCS_PRO',__('https://www.mishkatwp.com/instruction/elearning-school-pro-docs/','elearning-school'));
}
if ( ! defined( 'ELEARNING_SCHOOL_BUY_NOW' ) ) {
define('ELEARNING_SCHOOL_BUY_NOW',__('https://www.mishkatwp.com/themes/school-wordpress-theme/','elearning-school'));
}
if ( ! defined( 'ELEARNING_SCHOOL_SUPPORT_FREE' ) ) {
define('ELEARNING_SCHOOL_SUPPORT_FREE',__('https://wordpress.org/support/theme/elearning-school','elearning-school'));
}
if ( ! defined( 'ELEARNING_SCHOOL_REVIEW_FREE' ) ) {
define('ELEARNING_SCHOOL_REVIEW_FREE',__('https://wordpress.org/support/theme/elearning-school/reviews/#new-post','elearning-school'));
}
if ( ! defined( 'ELEARNING_SCHOOL_DEMO_PRO' ) ) {
define('ELEARNING_SCHOOL_DEMO_PRO',__('https://mishkatwp.com/pro/elearning-school/','elearning-school'));
}
if ( ! defined( 'ELEARNING_SCHOOL_BUNDLE' ) ) {
define('ELEARNING_SCHOOL_BUNDLE',__('https://www.mishkatwp.com/themes/wordpress-theme-bundle/','elearning-school'));
}
if ( ! defined( 'ELEARNING_SCHOOL_FREE_LINK' ) ) {
define('ELEARNING_SCHOOL_FREE_LINK',__('https://www.mishkatwp.com/themes/free-elearning-wordpress-theme/','elearning-school'));
}

function elearning_school_test_guide() { ?>
	<?php $elearning_school_theme = wp_get_theme();?>
	<div class="wrap" id="main-page">
		<div id="righty">
			<div class="getstart-postbox donate">
				<h4><?php esc_html_e( 'Discount Upto 25%', 'elearning-school' ); ?> <span><?php esc_html_e( '"Special25"', 'elearning-school' ); ?></span></h4>
				<h3 class="hndle"><?php esc_html_e( 'Upgrade to Premium', 'elearning-school' ); ?></h3>
				<div class="inside">
					<p><?php esc_html_e('Click to upgrade to see the enhanced pro features available in the premium version.','elearning-school'); ?></p>
					<div id="admin_pro_links">
						<a class="blue-button-2" href="<?php echo esc_url( ELEARNING_SCHOOL_BUY_NOW ); ?>" target="_blank"><?php esc_html_e( 'Go Pro', 'elearning-school' ); ?></a>
						<a class="blue-button-1" href="<?php echo esc_url( ELEARNING_SCHOOL_DEMO_PRO ); ?>" target="_blank"><?php esc_html_e( 'Live Demo', 'elearning-school' ) ?></a>
						<a class="blue-button-2" href="<?php echo esc_url( ELEARNING_SCHOOL_DOCS_PRO ); ?>" target="_blank"><?php esc_html_e( 'Pro Docs', 'elearning-school' ) ?></a>
					</div>
				</div>
				<div class="d-table">
				    <ul class="d-column">
				      <li class="feature"><?php esc_html_e('Features','elearning-school'); ?></li>
				      <li class="free"><?php esc_html_e('Pro','elearning-school'); ?></li>
				      <li class="plus"><?php esc_html_e('Free','elearning-school'); ?></li>
				    </ul>
				    <ul class="d-row">
				      <li class="points"><?php esc_html_e('24hrs Priority Support','elearning-school'); ?></li>
				      <li class="right"><span class="dashicons dashicons-yes"></span></li>
				      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
				    </ul>
				    <ul class="d-row">
				      <li class="points"><?php esc_html_e('LearnPress Campatiblity','elearning-school'); ?></li>
				      <li class="right"><span class="dashicons dashicons-yes"></span></li>
				      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
				    </ul>
				    <ul class="d-row">
				      <li class="points"><?php esc_html_e('Kirki Framework','elearning-school'); ?></li>
				      <li class="right"><span class="dashicons dashicons-yes"></span></li>
				      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
				    </ul>
				    <ul class="d-row">
				      <li class="points"><?php esc_html_e('Advance Posttype','elearning-school'); ?></li>
				      <li class="right"><span class="dashicons dashicons-yes"></span></li>
				      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
				    </ul>
				    <ul class="d-row">
				      <li class="points"><?php esc_html_e('One Click Demo Import','elearning-school'); ?></li>
				      <li class="right"><span class="dashicons dashicons-yes"></span></li>
				      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
				    </ul>
				    <ul class="d-row">
				      <li class="points"><?php esc_html_e('Section Reordering','elearning-school'); ?></li>
				      <li class="right"><span class="dashicons dashicons-yes"></span></li>
				      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
				    </ul>
				    <ul class="d-row">
				      <li class="points"><?php esc_html_e('Enable / Disable Option','elearning-school'); ?></li>
				      <li class="right"><span class="dashicons dashicons-yes"></span></li>
				      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
				    </ul>
				    <ul class="d-row">
				      <li class="points"><?php esc_html_e('Multiple Sections','elearning-school'); ?></li>
				      <li class="right"><span class="dashicons dashicons-yes"></span></li>
				      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
				    </ul>
				    <ul class="d-row">
				      <li class="points"><?php esc_html_e('Advance Color Pallete','elearning-school'); ?></li>
				      <li class="right"><span class="dashicons dashicons-yes"></span></li>
				      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
				    </ul>
				    <ul class="d-row">
				      <li class="points"><?php esc_html_e('Advance Widgets','elearning-school'); ?></li>
				      <li class="right"><span class="dashicons dashicons-yes"></span></li>
				      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
				    </ul>
				    <ul class="d-row">
				      <li class="points"><?php esc_html_e('Page Templates','elearning-school'); ?></li>
				      <li class="right"><span class="dashicons dashicons-yes"></span></li>
				      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
				    </ul>
	  			</div>
			</div>
		</div>
		<div id="lefty">
			<div id="description">
				<h3><?php esc_html_e('Welcome! Thank you for choosing ','elearning-school'); ?><?php echo esc_html( $elearning_school_theme ); ?>  <span><?php esc_html_e('Version: ', 'elearning-school'); ?><?php echo esc_html($elearning_school_theme['Version']);?></span></h3>
				<div class="demo-import-box">
					<h4><?php echo esc_html('IMPORT HOMEPAGE','elearning-school'); ?></h4>
					<p><?php echo esc_html('Get started with the wordpress theme installation','elearning-school'); ?></p>
					<a href="<?php echo esc_url( admin_url( 'themes.php?page=elearningschool-wizard' ) ); ?>" class="blue-button-1">
					    <?php echo esc_html__( 'Demo Importer', 'elearning-school' ); ?>
					</a>
				</div>
				<h4 class="feature-head"><?php esc_html_e('Begin with our theme features:-','elearning-school'); ?></h4>
				<div class="customizer-inside">
					<div class="elearning-school-theme-setting-item">
                        <div class="elearning-school-theme-setting-item-header">
                            <?php esc_html_e( 'Add Menus', 'elearning-school' ); ?>                            
                       	</div>
                        <div class="elearning-school-theme-setting-item-content">
                        	<a target="_blank" href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=nav_menus') ); ?>"><?php esc_html_e('Go to Menu', 'elearning-school'); ?></a>
                     	</div>
                     	<p><?php esc_html_e( 'After Clicking go to customizer >> Go to menu >> Select menu which you had created >> Then Publish ', 'elearning-school' ); ?></p>
                	</div>
                	<div class="elearning-school-theme-setting-item">
                        <div class="elearning-school-theme-setting-item-header">
                            <?php esc_html_e( 'Add Logo', 'elearning-school' ); ?>                            
                       	</div>
                        <div class="elearning-school-theme-setting-item-content">
                        	<a target="_blank" href="<?php echo esc_url( admin_url('customize.php?autofocus[control]=custom_logo') ); ?>"><?php esc_html_e('Go to Site Identity', 'elearning-school'); ?></a>
                     	</div>
                     	<p><?php esc_html_e( 'After Clicking go to customizer >> Go to Site Identity >> Select Logo Add Title or Tagline >> Then Publish ', 'elearning-school' ); ?></p>
                	</div>
                	<div class="elearning-school-theme-setting-item">
                        <div class="elearning-school-theme-setting-item-header">
                            <?php esc_html_e( 'Home Page Section', 'elearning-school' ); ?>                            
                       	</div>
                        <div class="elearning-school-theme-setting-item-content">
                        	<a target="_blank" href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=elearning_school_home_page_section') ); ?>"><?php esc_html_e('Go to Home Page Section', 'elearning-school'); ?></a>
                     	</div>
                     	<p><?php esc_html_e( 'After Clicking go to customizer >> Go to Home Page Sections >> Then go to different section which ever you want >> Then Publish ', 'elearning-school' ); ?></p>
                	</div>
                	<div class="elearning-school-theme-setting-item">
                        <div class="elearning-school-theme-setting-item-header">
                            <?php esc_html_e( 'Post Options', 'elearning-school' ); ?>                            
                       	</div>
                        <div class="elearning-school-theme-setting-item-content">
                        	<a target="_blank" href="<?php echo esc_url( admin_url('customize.php?autofocus[control]=elearning_school_post_image_on_off') ); ?>"><?php esc_html_e('Go to Post Options', 'elearning-school'); ?></a>
                     	</div>
                     	<p><?php esc_html_e( 'After Clicking go to customizer >> Go to Post Options >> Then go to different settings which ever you want >> Then Publish ', 'elearning-school' ); ?></p>
                	</div>
                	<div class="elearning-school-theme-setting-item">
                        <div class="elearning-school-theme-setting-item-header">
                            <?php esc_html_e( 'Post Layout Options', 'elearning-school' ); ?>                            
                       	</div>
                        <div class="elearning-school-theme-setting-item-content">
                        	<a target="_blank" href="<?php echo esc_url( admin_url('customize.php?autofocus[control]=elearning_school_post_layout') ); ?>"><?php esc_html_e('Go to Post Layout Options', 'elearning-school'); ?></a>
                     	</div>
                     	<p><?php esc_html_e( 'After Clicking go to customizer >> Go to Post Layout Options >> Then go to different settings which ever you want >> Then Publish ', 'elearning-school' ); ?></p>
                	</div>
                	<div class="elearning-school-theme-setting-item">
                        <div class="elearning-school-theme-setting-item-header">
                            <?php esc_html_e( 'General Options Options', 'elearning-school' ); ?>                            
                       	</div>
                        <div class="elearning-school-theme-setting-item-content">
                        	<a target="_blank" href="<?php echo esc_url( admin_url('customize.php?autofocus[control]=elearning_school_preloader_setting') ); ?>"><?php esc_html_e('Go to General Options', 'elearning-school'); ?></a>
                     	</div>
                     	<p><?php esc_html_e( 'After Clicking go to customizer >> Go to Post General Options >> Then go to different settings which ever you want >> Then Publish ', 'elearning-school' ); ?></p>
                	</div>
                	
                	<a target="_blank" href="<?php echo esc_url( ELEARNING_SCHOOL_BUY_NOW ); ?>" class="elearning-school-theme-setting-item elearning-school-theme-setting-item-unavailable">
					    <div class="elearning-school-theme-setting-item-header">
					        <span><?php esc_html_e("Customize All Fonts", "elearning-school"); ?></span> <span><?php esc_html_e("Premium", "elearning-school"); ?></span>
					    </div>
					    <div class="elearning-school-theme-setting-item-content">
					        <span><?php esc_html_e("Go to Customizer", "elearning-school"); ?></span>
					    </div>
					</a>

					<a target="_blank" href="<?php echo esc_url( ELEARNING_SCHOOL_BUY_NOW ); ?>" class="elearning-school-theme-setting-item elearning-school-theme-setting-item-unavailable">
					    <div class="elearning-school-theme-setting-item-header">
					        <span><?php esc_html_e("Customize All Color", "elearning-school"); ?></span> <span><?php esc_html_e("Premium", "elearning-school"); ?></span>
					    </div>
					    <div class="elearning-school-theme-setting-item-content">
					        <span><?php esc_html_e("Go to Customizer", "elearning-school"); ?></span>
					    </div>
					</a>

					<a target="_blank" href="<?php echo esc_url( ELEARNING_SCHOOL_BUY_NOW ); ?>" class="elearning-school-theme-setting-item elearning-school-theme-setting-item-unavailable">
					    <div class="elearning-school-theme-setting-item-header">
					        <span><?php esc_html_e("Section Reorder", "elearning-school"); ?></span> <span><?php esc_html_e("Premium", "elearning-school"); ?></span>
					    </div>
					    <div class="elearning-school-theme-setting-item-content">
					        <span><?php esc_html_e("Go to Customizer", "elearning-school"); ?></span>
					    </div>
					</a>

					<a target="_blank" href="<?php echo esc_url( ELEARNING_SCHOOL_BUY_NOW ); ?>" class="elearning-school-theme-setting-item elearning-school-theme-setting-item-unavailable">
					    <div class="elearning-school-theme-setting-item-header">
					        <span><?php esc_html_e("Typography Options", "elearning-school"); ?></span> <span><?php esc_html_e("Premium", "elearning-school"); ?></span>
					    </div>
					    <div class="elearning-school-theme-setting-item-content">
					        <span><?php esc_html_e("Go to Customizer", "elearning-school"); ?></span>
					    </div>
					</a>

					<a target="_blank" href="<?php echo esc_url( ELEARNING_SCHOOL_BUY_NOW ); ?>" class="elearning-school-theme-setting-item elearning-school-theme-setting-item-unavailable">
					    <div class="elearning-school-theme-setting-item-header">
					        <span><?php esc_html_e("One Click Demo Import", "elearning-school"); ?></span> <span><?php esc_html_e("Premium", "elearning-school"); ?></span>
					    </div>
					    <div class="elearning-school-theme-setting-item-content">
					        <span><?php esc_html_e("Go to Customizer", "elearning-school"); ?></span>
					    </div>
					</a>
					<a target="_blank" href="<?php echo esc_url( ELEARNING_SCHOOL_BUY_NOW ); ?>" class="elearning-school-theme-setting-item elearning-school-theme-setting-item-unavailable">
					    <div class="elearning-school-theme-setting-item-header">
					        <span><?php esc_html_e("Background  Settings", "elearning-school"); ?></span> <span><?php esc_html_e("Premium", "elearning-school"); ?></span>
					    </div>
					    <div class="elearning-school-theme-setting-item-content">
					        <span><?php esc_html_e("Go to Customizer", "elearning-school"); ?></span>
					    </div>
					</a>
					
				</div>
			</div>
		</div>
		<div id="righty">
			<div class="elearning-school-theme-setting-sidebar-item">
		        <div class="elearning-school-theme-setting-sidebar-header"><?php esc_html_e( 'Theme Bundle', 'elearning-school' ) ?></div>
		        <div class="elearning-school-theme-setting-sidebar-content">
		            <p class="m-0"><?php esc_html_e( 'Get our all themes in single pack.', 'elearning-school' ) ?></p>
		            <div id="admin_links">
		            	<a href="<?php echo esc_url( ELEARNING_SCHOOL_BUNDLE ); ?>" target="_blank" class="blue-button-2"><?php esc_html_e( 'Theme Bundle', 'elearning-school' ) ?></a>
		            </div>
		        </div>
		    </div>
			<div class="elearning-school-theme-setting-sidebar-item">
		        <div class="elearning-school-theme-setting-sidebar-header"><?php esc_html_e( 'Free Documentation', 'elearning-school' ) ?></div>
		        <div class="elearning-school-theme-setting-sidebar-content">
		            <p class="m-0"><?php esc_html_e( 'Our guide is available if you require any help configuring and setting up the theme.', 'elearning-school' ) ?></p>
		            <div id="admin_links">
		            	<a href="<?php echo esc_url( ELEARNING_SCHOOL_DOCS_FREE ); ?>" target="_blank" class="blue-button-1"><?php esc_html_e( 'Free Documentation', 'elearning-school' ) ?></a>
		            </div>
		        </div>
		    </div>
		    <div class="elearning-school-theme-setting-sidebar-item">
		        <div class="elearning-school-theme-setting-sidebar-header"><?php esc_html_e( 'Support', 'elearning-school' ) ?></div>
		        <div class="elearning-school-theme-setting-sidebar-content">
		            <p class="m-0"><?php esc_html_e( 'Visit our website to contact us if you face any issues with our lite theme!', 'elearning-school' ) ?></p>
		            <div id="admin_links">
		            	<a class="blue-button-2" href="<?php echo esc_url( ELEARNING_SCHOOL_SUPPORT_FREE ); ?>" target="_blank" class="btn3"><?php esc_html_e( 'Support', 'elearning-school' ) ?></a>
		            </div>
		        </div>
		    </div>
		    <div class="elearning-school-theme-setting-sidebar-item">
		        <div class="elearning-school-theme-setting-sidebar-header"><?php esc_html_e( 'Review', 'elearning-school' ) ?></div>
		        <div class="elearning-school-theme-setting-sidebar-content">
		            <p class="m-0"><?php esc_html_e( 'Are you having fun with Elearning School? Review us on WordPress.org to show your support!', 'elearning-school' ) ?></p>
		            <div id="admin_links">
		            	<a href="<?php echo esc_url( ELEARNING_SCHOOL_REVIEW_FREE ); ?>" target="_blank" class="blue-button-1"><?php esc_html_e( 'Review', 'elearning-school' ) ?></a>
		            </div>
		        </div>
		    </div>
		</div>
	</div>

<?php } ?>