<?php
 /**
 * Enqueue scripts and styles.
 */
function elearning_school_scripts() {
	
	// Styles

	wp_enqueue_style('dashicons' );

	wp_enqueue_style('bootstrap',get_template_directory_uri().'/css/bootstrap.css');
	
	wp_enqueue_style('font-awesome',get_template_directory_uri().'/css/fonts/font-awesome/css/font-awesome.min.css');
	
	wp_enqueue_style('elearning-school-widget',get_template_directory_uri().'/css/widget.css');

	wp_enqueue_style('owl-carousel',get_template_directory_uri().'/css/owl.carousel.css');
	
	wp_enqueue_style('elearning-school-color-default',get_template_directory_uri().'/css/colors/default.css');
	
	wp_enqueue_style('elearning-school-wp-test',get_template_directory_uri().'/css/wp-test.css');
	
	wp_enqueue_style('elearning-school-menu',get_template_directory_uri().'/css/menu.css');
	
	wp_enqueue_style('elearning-school-style', get_stylesheet_uri() );

	wp_style_add_data( 'elearning-school-style', 'rtl', 'replace' );
	
	wp_enqueue_style('elearning-school-gutenberg',get_template_directory_uri().'/css/gutenberg.css');
	
	wp_enqueue_style('elearning-school-responsive',get_template_directory_uri().'/css/responsive.css');
	
	// Scripts
	wp_enqueue_script('jquery-ui-core');
	
	wp_enqueue_script('bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array('jquery'), '4.3.1', true); 
	
	wp_enqueue_script('elearning-school-custom-js', get_template_directory_uri() . '/js/custom.js', array('jquery'), false, true);

	wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/js/owl.carousel.js', array('jquery'), true); 

	wp_enqueue_script('elearning-school-navigation-focus', get_template_directory_uri() . '/js/navigation-focus.js', array(), true );

	wp_enqueue_script('skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );

	if ( get_theme_mod( 'elearning-school_animation_enabled', true ) ) {
		wp_enqueue_script(
			'elearning-school-wow-script',
			get_template_directory_uri() . '/js/wow.js',
			array( 'jquery' ),
			'1.0',
			true
		);

		wp_enqueue_style(
			'elearning-school-animate',
			get_template_directory_uri() . '/css/animate.css',
			array(),
			'4.1.1'
		);
	}

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	require get_template_directory(). '/inc/common-inline.php';

	wp_add_inline_style( 'elearning-school-style',$elearning_school_common_inline_css );
}
add_action( 'wp_enqueue_scripts', 'elearning_school_scripts' );

//Admin Enqueue for Admin
function elearning_school_admin_enqueue_scripts(){
	wp_enqueue_style('elearning-school-style-customizer',get_template_directory_uri(). '/css/style-customizer.css');

	wp_enqueue_style( 'elearning-school-admin-style', get_template_directory_uri().'/inc/started/main.css' );

	wp_enqueue_script( 'elearning-school-admin-script', get_template_directory_uri() . '/inc/admin-notice/admin.js', array( 'jquery' ), '', true );

}
add_action( 'admin_enqueue_scripts', 'elearning_school_admin_enqueue_scripts' );

?>