<?php
/**
 * elearning-school Theme Customizer.
 *
 * @package elearning-school
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function elearning_school_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
	$wp_customize->get_setting( 'background_color' )->transport = 'postMessage';
	$wp_customize->get_setting('custom_logo')->transport = 'refresh';	
}
add_action( 'customize_register', 'elearning_school_customize_register' );

if ( ! defined( 'ELEARNING_SCHOOL_BUY_NOW_1' ) ) {
define('ELEARNING_SCHOOL_BUY_NOW_1',__('https://www.mishkatwp.com/themes/school-wordpress-theme/','elearning-school'));
}

if ( ! defined( 'ELEARNING_SCHOOL_BUNDLE_1' ) ) {
define('ELEARNING_SCHOOL_BUNDLE_1',__('https://www.mishkatwp.com/themes/wordpress-theme-bundle/','elearning-school'));
}

if ( class_exists("Kirki")){

    //Post & Pages Setting Panel
	new \Kirki\Panel(
		'elearning_school_post_pages_section',
		[
			'priority'    => 11,
			'title'       => esc_html__( 'Post & Pages Settings', 'elearning-school' ),
		]
	);

	/* Banner Options */

	new \Kirki\Section(
		'elearning_school_banner_options',
		[
			'title'       => esc_html__( 'Banner Image Settings', 'elearning-school' ),
			'priority'    => 30,
			'panel'		  => 'elearning_school_post_pages_section',
		]
	);

	new \Kirki\Field\Image(
		[
			'settings'    => 'elearning_school_custom_fallback_img',
			'label'       => esc_html__( 'Featured Header Image Banner Background', 'elearning-school' ),
			'section'     => 'elearning_school_banner_options',
			'default'     => '',
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
        'type'        => 'custom',
        'section'     => 'elearning_school_banner_options',
    ] );

	/* Single Post Options */

	new \Kirki\Section(
		'elearning_school_single_post_options',
		[
			'title'       => esc_html__( 'Single Post Options', 'elearning-school' ),
			'priority'    => 30,
			'panel'		  => 'elearning_school_post_pages_section',
		]
	);

	/* Single Post Content Option End */
	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_single_post_content_on_off',
			'label'       => esc_html__( 'Single Post Content On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_single_post_options',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	/* Single Post Meta Option End */
	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_single_meta_on_off',
			'label'       => esc_html__( 'Single Post Meta On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_single_post_options',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	/* Single Post Feature Image Option End */
	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_single_post_image_on_off',
			'label'       => esc_html__( 'Single Post Feature Image On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_single_post_options',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	/* Single Post Pagination Option End */
	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_single_post_pagination_on_off',
			'label'       => esc_html__( 'Single Post Pagination On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_single_post_options',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
	    'type'        => 'custom',
	    'priority'    => 100,
	    'section'     => 'elearning_school_single_post_options',
	] );

	/* Page Options */
		new \Kirki\Section(
		'elearning_school_single_page_options',
		[
			'title'       => esc_html__( 'Page Sidebar Options', 'elearning-school' ),
			'priority'    => 30,
			'panel'		  => 'elearning_school_post_pages_section',
		]
	);

	new \Kirki\Field\Radio(
	[
		'settings'    => 'elearning_school_single_page_sidebar_option',
		'label'       => esc_html__( 'Page Sidebar Settings', 'elearning-school' ),
		'section'     => 'elearning_school_single_page_options',
		'default'     => 'right',
		'priority'    => 10,
		'choices'     => [
			'right'   => esc_html__( 'Page With Right Sidebar', 'elearning-school' ),
			'left' => esc_html__( 'Page With Left Sidebar', 'elearning-school' ),
			'none'  => esc_html__( 'Page With No Sidebar', 'elearning-school' ),

		],
	]
);

		Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
	    'type'        => 'custom',
	    'priority'    => 100,
	    'section'     => 'elearning_school_single_page_options',
	] );
	/* Page Options End*/

	/* Post Options */

	new \Kirki\Section(
		'elearning_school_post_options',
		[
			'title'       => esc_html__( 'Post Options', 'elearning-school' ),
			'priority'    => 30,
			'panel'		  => 'elearning_school_post_pages_section',
		]
	);
    
    /* Post Image Option End */
	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_post_image_on_off',
			'label'       => esc_html__( 'Post Image On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_post_options',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	/* Post Heading Option End */
	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_post_heading_on_off',
			'label'       => esc_html__( 'Post Heading On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_post_options',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	/* Post Content Option End */
	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_post_content_on_off',
			'label'       => esc_html__( 'Post Content On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_post_options',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	/* Post Date Option End */
	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_post_date_on_off',
			'label'       => esc_html__( 'Post Date On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_post_options',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	/* Post Comments Option End */
	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_post_comment_on_off',
			'label'       => esc_html__( 'Post Comments On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_post_options',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	/* Post Author Option End */
	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_post_author_on_off',
			'label'       => esc_html__( 'Post Author On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_post_options',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	/* Post Categories Option End */
	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_post_categories_on_off',
			'label'       => esc_html__( 'Post Categories On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_post_options',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	/* Post limit Option End */
	new \Kirki\Field\Slider(
		[
			'settings'    => 'elearning_school_post_content_limit',
			'label'       => esc_html__( 'Post Content Limit', 'elearning-school' ),
			'section'     => 'elearning_school_post_options',
			'default'     => 15,
			'choices'     => [
				'min'  => 0,
				'max'  => 50,
				'step' => 1,
			],
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
	    'type'        => 'custom',
	    'priority'    => 100,
	    'section'     => 'elearning_school_post_options',
	] );

	/* Post Options End */

	/* Post Options */

	new \Kirki\Section(
		'elearning_school_post_layouts_section',
		[
			'title'       => esc_html__( 'Post Layout Options', 'elearning-school' ),
			'priority'    => 30,
			'panel'		  => 'elearning_school_post_pages_section',
		]
	);

	new \Kirki\Field\Radio_Image(
		[
			'settings'    => 'elearning_school_post_layout',
			'label'       => esc_html__( 'Blog Layout', 'elearning-school' ),
			'section'     => 'elearning_school_post_layouts_section',
			'default'     => 'two_column_right',
			'priority'    => 10,
			'choices'     => [
				'one_column'   => get_template_directory_uri().'/images/1column.png',
				'two_column_right' => get_template_directory_uri().'/images/right-sidebar.png',
				'two_column_left'  => get_template_directory_uri().'/images/left-sidebar.png',
				'three_column'  => get_template_directory_uri().'/images/3column.png',
				'four_column'  => get_template_directory_uri().'/images/4column.png',
				'grid_post'  => get_template_directory_uri().'/images/grid.png',
			],
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
	    'type'        => 'custom',
	    'priority'    => 100,
	    'section'     => 'elearning_school_post_layouts_section',
	] );

	/* Post Options End */

	/* 404 Page */

	new \Kirki\Section(
		'elearning_school_404_page_section',
		[
			'title'       => esc_html__( '404 Page', 'elearning-school' ),
			'description' => esc_html__( 'Here you can add 404 Page information.', 'elearning-school' ),
			'priority'    => 30,
		]
	);

	new \Kirki\Field\Text(
		[
			'settings' => 'elearning_school_404_page_heading',
			'label'    => esc_html__( 'Add Heading', 'elearning-school' ),
			'section'  => 'elearning_school_404_page_section',
			'default'  => esc_html__( '404', 'elearning-school' ),
			'priority' => 10,
		]
	);

	new \Kirki\Field\Text(
		[
			'settings' => 'elearning_school_404_page_content',
			'label'    => esc_html__( 'Add Content', 'elearning-school' ),
			'section'  => 'elearning_school_404_page_section',
			'default'  => esc_html__( 'Ops! Something happened...', 'elearning-school' ),
			'priority' => 10,
		]
	);

	new \Kirki\Field\Text(
		[
			'settings' => 'elearning_school_404_page_button',
			'label'    => esc_html__( 'Add Button', 'elearning-school' ),
			'section'  => 'elearning_school_404_page_section',
			'default'  => esc_html__( 'Home', 'elearning-school' ),
			'priority' => 10,
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
	    'type'        => 'custom',
	    'priority'    => 100,
	    'section'     => 'elearning_school_post_layouts_section',
	] );

	/* 404 Page End */

	/* General Options */

	new \Kirki\Section(
		'elearning_school_general_options_section',
		[
			'title'       => esc_html__( 'General Options', 'elearning-school' ),
			'priority'    => 30,
		]
	);

	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_sticky_header_setting',
			'label'       => esc_html__( 'Show Hide Sticky Header', 'elearning-school' ),
			'section'     => 'elearning_school_general_options_section',
			'default'     => 'off',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_preloader_setting',
			'label'       => esc_html__( 'Preloader On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_general_options_section',
			'default'     => 'off',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_scroll_to_top_setting',
			'label'       => esc_html__( 'Scroll To Top On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_general_options_section',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
	    'type'        => 'custom',
	    'priority'    => 100,
	    'section'     => 'elearning_school_general_options_section',
	] );

	/* General Options End */

	/* Responsive Options */

	new \Kirki\Section(
		'elearning_school_responsive_options_section',
		[
			'title'       => esc_html__( 'Responsive Options', 'elearning-school' ),
			'priority'    => 10,
		]
	);

	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_responsive_preloader_setting',
			'label'       => esc_html__( 'Preloader On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_responsive_options_section',
			'default'     => 'off',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_responsive_scroll_to_top_setting',
			'label'       => esc_html__( 'Scroll To Top On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_responsive_options_section',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
	    'type'        => 'custom',
	    'priority'    => 100,
	    'section'     => 'elearning_school_responsive_options_section',
	] );

	/* Logo */

	/* Logo Size limit Option End */
	new \Kirki\Field\Slider(
		[
			'settings'    => 'elearning_school_logo_resizer_setting',
			'label'       => esc_html__( 'Logo Size Limit', 'elearning-school' ),
			'section'     => 'title_tagline',
			'default'     => 70,
			'choices'     => [
				'min'  => 10,
				'max'  => 300,
				'step' => 10,
			],
		]
	);

	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_site_title_setting',
			'label'       => esc_html__( 'Site Title On / Off', 'elearning-school' ),
			'section'     => 'title_tagline',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_tagline_setting',
			'label'       => esc_html__( 'Tagline On / Off', 'elearning-school' ),
			'section'     => 'title_tagline',
			'default'     => 'off',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	/* Logo End */

	/* Typography Section */

	new \Kirki\Section(
		'elearning_school_theme_typography_section',
		[
			'title'       => esc_html__( 'Theme Typography', 'elearning-school' ),
			'description' => esc_html__( 'Here you can customize Heading or other body text font settings', 'elearning-school' ),
			'priority'    => 30,
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'elearning_school_all_headings_typography',
		'section'     => 'elearning_school_theme_typography_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading Of All Sections',  'elearning-school' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'elearning_school_all_headings_typography',
		'label'       => esc_html__( 'Heading Typography',  'elearning-school' ),
		'description' => esc_html__( 'Select the typography options for your heading.',  'elearning-school' ),
		'section'     => 'elearning_school_theme_typography_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'h1','h2','h3','h4','h5','h6', ),
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'elearning_school_body_content_typography',
		'section'     => 'elearning_school_theme_typography_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Body Content',  'elearning-school' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'elearning_school_body_content_typography',
		'label'       => esc_html__( 'Content Typography',  'elearning-school' ),
		'description' => esc_html__( 'Select the typography options for your content.',  'elearning-school' ),
		'section'     => 'elearning_school_theme_typography_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'body', ),
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
	    'type'        => 'custom',
	    'priority'    => 100,
	    'section'     => 'elearning_school_theme_typography_section',
	] );

    /* End Typography */

        /* Woocommerce Section */

	new \Kirki\Section(
		'elearning_school_theme_product_sidebar',
		[
			'title'       => esc_html__( 'Woocommerce Sidebars', 'elearning-school' ),
			'description' => esc_html__( 'Here you can change woocommerce sidebar', 'elearning-school' ),
			'panel' =>'woocommerce',
			'priority'    => 30,
		]
	);

	new \Kirki\Field\Select(
		[
			'settings'    => 'elearning_school_product_sidebar_position',
			'label'       => esc_html__( 'Sidebar Option', 'elearning-school' ),
			'section'     => 'elearning_school_theme_product_sidebar',
			'default'     => 'right',
			'choices'     => [
				'left' => esc_html__( 'Left Sidebar', 'elearning-school' ),
				'right' => esc_html__( 'Right Sidebar', 'elearning-school' ),
				'none' => esc_html__( 'No Sidebar', 'elearning-school' ),
			],
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
	    'type'        => 'custom',
	    'priority'    => 100,
	    'section'     => 'elearning_school_theme_product_sidebar',
	] );

    /* Woocommerce Section End */

    /* Global Color Section */

	new \Kirki\Section(
		'elearning_school_theme_color_section',
		[
			'title'       => esc_html__( 'Theme Colors Option', 'elearning-school' ),
			'description' => esc_html__( 'Here you can change your theme color', 'elearning-school' ),
			'priority'    => 30,
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'elearning_school_theme_color_1',
		'label'       => __( 'Select Your First Color', 'elearning-school' ),
		'section'     => 'elearning_school_theme_color_section',
		'default'     => '#FE602F',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'elearning_school_theme_color_2',
		'label'       => __( 'Select Your Second Color', 'elearning-school' ),
		'section'     => 'elearning_school_theme_color_section',
		'default'     => '#A2BF00',
	] );


	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
	    'type'        => 'custom',
	    'priority'    => 100,
	    'section'     => 'elearning_school_theme_color_section',
	] );

       /* Global Color End */

    /* Breadcrumb Section */

	new \Kirki\Section(
		'elearning_school_breadcrumb_section',
		[
			'title'       => esc_html__( 'Theme Breadcrumb Option', 'elearning-school' ),
			'description' => esc_html__( 'The breadcrumbs for your theme can be included here.', 'elearning-school' ),
			'priority'    => 30,
		]
	);

	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_breadcrumb_setting',
			'label'       => esc_html__( 'Enable Breadcrumbs Option', 'elearning-school' ),
			'section'     => 'elearning_school_breadcrumb_section',
			'default'     => true,
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'text',
	    'settings'    => 'elearning_school_breadcrumb_separator',
	    'label'       => esc_html__( 'Breadcrumb Separator Setting', 'elearning-school' ),
	    'section'     => 'elearning_school_breadcrumb_section',
	    'default'     => ' → ',
	    'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
	    'type'        => 'custom',
	    'priority'    => 100,
	    'section'     => 'elearning_school_breadcrumb_section',
	] );


    /* Breadcrumb section End */

	// PANEL
	Kirki::add_panel( 'elearning-school_panel_id_5', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Animations', 'elearning-school' ),
	) );

	// ANIMATION SECTION
	Kirki::add_section( 'elearning-school_section_animation', array(
	    'title'          => esc_html__( 'Animations', 'elearning-school' ),
	    'priority'       => 2,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'elearning-school_animation_enabled',
		'label'       => esc_html__( 'Turn To Show Animation', 'elearning-school' ),
		'section'     => 'elearning-school_section_animation',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'elearning-school' ),
			'off' => esc_html__( 'Disable', 'elearning-school' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
        'type'        => 'custom',
        'priority'    => 100,
        'section'     => 'elearning-school_section_animation',
    ] );
    

    /* Social Icon */

	new \Kirki\Section(
		'elearning_school_top_header_section',
		[
			'title'       => esc_html__( 'Header Social Icon', 'elearning-school' ),
			'description' => esc_html__( 'Here you can add social links.', 'elearning-school' ),
			'priority'    => 30,
		]
	);

	new \Kirki\Field\URL(
		[
			'settings' => 'elearning_school_top_twitter_link',
			'label'    => esc_html__( 'Add Twitter Link', 'elearning-school' ),
			'section'  => 'elearning_school_top_header_section',
			'default'  => '',
			'priority' => 10,
		]
	);

	new \Kirki\Field\URL(
		[
			'settings' => 'elearning_school_top_linkdin_link',
			'label'    => esc_html__( 'Add Linkdin Link', 'elearning-school' ),
			'section'  => 'elearning_school_top_header_section',
			'default'  => '',
			'priority' => 10,
		]
	);

	new \Kirki\Field\URL(
		[
			'settings' => 'elearning_school_top_youtube_link',
			'label'    => esc_html__( 'Add Youtube Link', 'elearning-school' ),
			'section'  => 'elearning_school_top_header_section',
			'default'  => '',
			'priority' => 10,
		]
	);

	new \Kirki\Field\URL(
		[
			'settings' => 'elearning_school_top_facebook_link',
			'label'    => esc_html__( 'Add Facebook Link', 'elearning-school' ),
			'section'  => 'elearning_school_top_header_section',
			'default'  => '',
			'priority' => 10,
		]
	);

	new \Kirki\Field\URL(
		[
			'settings' => 'elearning_school_top_instagram_link',
			'label'    => esc_html__( 'Add Instagram Link', 'elearning-school' ),
			'section'  => 'elearning_school_top_header_section',
			'default'  => '',
			'priority' => 10,
		]
	);

	//Home page Setting Panel
	new \Kirki\Panel(
		'elearning_school_home_page_section',
		[
			'priority'    => 10,
			'title'       => esc_html__( 'Home Page Sections', 'elearning-school' ),
		]
	);

	/* Social Icon */

	new \Kirki\Section(
		'elearning_school_top_header_section',
		[
			'title'       => esc_html__( 'Header Social Icon', 'elearning-school' ),
			'description' => esc_html__( 'Here you can add social links.', 'elearning-school' ),
			'priority'    => 30,
		]
	);

	new \Kirki\Field\URL(
		[
			'settings' => 'elearning_school_top_twitter_link',
			'label'    => esc_html__( 'Add Twitter Link', 'elearning-school' ),
			'section'  => 'elearning_school_top_header_section',
			'default'  => '',
			'priority' => 10,
		]
	);

	new \Kirki\Field\URL(
		[
			'settings' => 'elearning_school_top_linkdin_link',
			'label'    => esc_html__( 'Add Linkdin Link', 'elearning-school' ),
			'section'  => 'elearning_school_top_header_section',
			'default'  => '',
			'priority' => 10,
		]
	);

	new \Kirki\Field\URL(
		[
			'settings' => 'elearning_school_top_youtube_link',
			'label'    => esc_html__( 'Add Youtube Link', 'elearning-school' ),
			'section'  => 'elearning_school_top_header_section',
			'default'  => '',
			'priority' => 10,
		]
	);

	new \Kirki\Field\URL(
		[
			'settings' => 'elearning_school_top_facebook_link',
			'label'    => esc_html__( 'Add Facebook Link', 'elearning-school' ),
			'section'  => 'elearning_school_top_header_section',
			'default'  => '',
			'priority' => 10,
		]
	);

	new \Kirki\Field\URL(
		[
			'settings' => 'elearning_school_top_instagram_link',
			'label'    => esc_html__( 'Add Instagram Link', 'elearning-school' ),
			'section'  => 'elearning_school_top_header_section',
			'default'  => '',
			'priority' => 10,
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
	    'type'        => 'custom',
	    'priority'    => 100,
	    'section'     => 'elearning_school_top_header_section',
	] );

	/* Header */

	new \Kirki\Section(
		'elearning_school_header_button_section',
		[
			'title'       => esc_html__( 'Header', 'elearning-school' ),
			'description' => esc_html__( 'Here you can add header button text and link.', 'elearning-school' ),
			'panel'		  => 'elearning_school_home_page_section',
			'priority'    => 30,
		]
	);

	new \Kirki\Field\Text(
		[
			'settings' => 'elearning_school_header_phone_number',
			'label'    => esc_html__( 'Add Phone Number', 'elearning-school' ),
			'section'  => 'elearning_school_header_button_section',
			'default'  => '',
			'priority' => 10,
		]
	);

	new \Kirki\Field\Text(
		[
			'settings' => 'elearning_school_header_location',
			'label'    => esc_html__( 'Add Location', 'elearning-school' ),
			'section'  => 'elearning_school_header_button_section',
			'default'  => '',
			'priority' => 10,
		]
	);

	new \Kirki\Field\Text(
		[
			'settings' => 'elearning_school_header_email_address',
			'label'    => esc_html__( 'Add Email Address', 'elearning-school' ),
			'section'  => 'elearning_school_header_button_section',
			'default'  => '',
			'priority' => 10,
		]
	);

	new \Kirki\Field\Text(
		[
			'settings' => 'elearning_school_header_button_text',
			'label'    => esc_html__( 'Add Button Text', 'elearning-school' ),
			'section'  => 'elearning_school_header_button_section',
			'default'  => '',
			'priority' => 10,
		]
	);

	new \Kirki\Field\URL(
		[
			'settings' => 'elearning_school_header_button_link',
			'label'    => esc_html__( 'Add Button Url', 'elearning-school' ),
			'section'  => 'elearning_school_header_button_section',
			'default'  => '',
			'priority' => 10,
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
	    'type'        => 'custom',
	    'priority'    => 100,
	    'section'     => 'elearning_school_header_button_section',
	] );

	/* Home Slider */

	new \Kirki\Section(
		'elearning_school_home_slider_section',
		[
			'title'       => esc_html__( 'Home Slider', 'elearning-school' ),
			'description' => esc_html__( 'Here you can add slider image, title and text.', 'elearning-school' ),
			'panel'		  => 'elearning_school_home_page_section',
			'priority'    => 30,
		]
	);

	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_slide_on_off',
			'label'       => esc_html__( 'Slider On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_home_slider_section',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	new \Kirki\Field\Number(
		[
			'settings' => 'elearning_school_slide_count',
			'label'    => esc_html__( 'Slider Number Control', 'elearning-school' ),
			'section'  => 'elearning_school_home_slider_section',
			'default'  => '',
			'choices'  => [
				'min'  => 1,
				'max'  => 3	,
				'step' => 1,
			],
		]
	);

	$elearning_school_slide_count = get_theme_mod('elearning_school_slide_count');

	for ($i=1; $i <= $elearning_school_slide_count; $i++) { 
		
		new \Kirki\Field\Image(
			[
				'settings'    => 'elearning_school_slider_image_1'.$i,
				'label'       => esc_html__( 'Slider Image 1 0', 'elearning-school' ).$i,
				'section'     => 'elearning_school_home_slider_section',
				'default'     => '',
			]
		);

		new \Kirki\Field\Image(
			[
				'settings'    => 'elearning_school_slider_image_2'.$i,
				'label'       => esc_html__( 'Slider Image 2 0', 'elearning-school' ).$i,
				'section'     => 'elearning_school_home_slider_section',
				'default'     => '',
			]
		);

		new \Kirki\Field\URL(
			[
				'settings' => 'elearning_school_slider_image_video_url'.$i,
				'label'    => esc_html__( 'Slider Image Video Url ', 'elearning-school' ).$i,
				'section'  => 'elearning_school_home_slider_section',
				'default'  => '',
			]
		);

		new \Kirki\Field\Image(
			[
				'settings'    => 'elearning_school_slider_image_3'.$i,
				'label'       => esc_html__( 'Slider Image 3 0', 'elearning-school' ).$i,
				'section'     => 'elearning_school_home_slider_section',
				'default'     => '',
			]
		);

		new \Kirki\Field\URL(
			[
				'settings' => 'elearning_school_slider_image_video_url_3'.$i,
				'label'    => esc_html__( 'Slider Image Video Url ', 'elearning-school' ).$i,
				'section'  => 'elearning_school_home_slider_section',
				'default'  => '',
			]
		);

		new \Kirki\Field\Image(
			[
				'settings'    => 'elearning_school_slider_image_4'.$i,
				'label'       => esc_html__( 'Slider Image 4 0', 'elearning-school' ).$i,
				'section'     => 'elearning_school_home_slider_section',
				'default'     => '',
			]
		);

		new \Kirki\Field\Text(
			[
				'settings' => 'elearning_school_slider_short_heading'.$i,
				'label'    => esc_html__( 'Short Heading 0', 'elearning-school' ).$i,
				'section'  => 'elearning_school_home_slider_section',
			]
		);

		new \Kirki\Field\Text(
			[
				'settings' => 'elearning_school_slider_main_heading' .$i,
				'label'    => esc_html__( 'Slider Main Heading ', 'elearning-school' ).$i,
				'section'  => 'elearning_school_home_slider_section',
			]
		);

		new \Kirki\Field\Text(
			[
				'settings' => 'elearning_school_slider_content'.$i,
				'label'    => esc_html__( 'Slider Content ', 'elearning-school' ).$i,
				'section'  => 'elearning_school_home_slider_section',
			]
		);

		new \Kirki\Field\Text(
			[
				'settings' => 'elearning_school_slider_button_text'.$i,
				'label'    => esc_html__( 'Slider Button Text ', 'elearning-school' ).$i,
				'section'  => 'elearning_school_home_slider_section',
			]
		);

		new \Kirki\Field\URL(
			[
				'settings' => 'elearning_school_slider_button_link'.$i,
				'label'    => esc_html__( 'Slider Button Url ', 'elearning-school' ).$i,
				'section'  => 'elearning_school_home_slider_section',
				'default'  => '',
			]
		);

	}

	new \Kirki\Field\Text(
        [
            'settings' => 'elearning_school_slider_heading_single_word',
            'label'    => esc_html__( 'Slider Single  Word ', 'elearning-school' ) ,
            'section'  => 'elearning_school_home_slider_section',
        ]
    );

	new \Kirki\Field\Image(
		[
			'settings'    => 'elearning_school_slider_testimonial_image_1',
			'label'       => esc_html__( 'Slider Testimonial Image 1', 'elearning-school' ),
			'section'     => 'elearning_school_home_slider_section',
			'default'     => '',
		]
	);

	new \Kirki\Field\Image(
		[
			'settings'    => 'elearning_school_slider_testimonial_image_2',
			'label'       => esc_html__( 'Slider Testimonial Image 2', 'elearning-school' ),
			'section'     => 'elearning_school_home_slider_section',
			'default'     => '',
		]
	);

	new \Kirki\Field\Image(
		[
			'settings'    => 'elearning_school_slider_testimonial_image_3',
			'label'       => esc_html__( 'Slider Testimonial Image 3', 'elearning-school' ),
			'section'     => 'elearning_school_home_slider_section',
			'default'     => '',
		]
	);


	new \Kirki\Field\Text(
        [
            'settings' => 'elearning_school_slider_testimonial_heading',
            'label'    => esc_html__( 'Slider Testimonial Heading ', 'elearning-school' ) ,
            'section'  => 'elearning_school_home_slider_section',
        ]
    );

    new \Kirki\Field\Text(
        [
            'settings' => 'elearning_school_slider_testimonial_content',
            'label'    => esc_html__( 'Slider Testimonial Text ', 'elearning-school' ) ,
            'section'  => 'elearning_school_home_slider_section',
            'default'  => '',
        ]
    );

	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
	    'type'        => 'custom',
	    'priority'    => 100,
	    'section'     => 'elearning_school_home_slider_section',
	] );


	/* Home our Cause */

	new \Kirki\Section(
	    'elearning_school_home_industry_heroes_section',
	    [
	        'title'       => esc_html__( 'New Courses', 'elearning-school' ),
	        'description' => esc_html__( 'Here you can add New Courses related text to display New Courses.', 'elearning-school' ),
	        'panel'       => 'elearning_school_home_page_section',
	        'priority'    => 30,
	    ]
	);

	new \Kirki\Field\Checkbox_Switch(
	    [
	        'settings'    => 'elearning_school_why_join_us_on_off',
	        'label'       => esc_html__( 'New Courses On / Off', 'elearning-school' ),
	        'section'     => 'elearning_school_home_industry_heroes_section',
	        'default'     => 'on',
	        'choices'     => [
	            'on'  => esc_html__( 'Enable', 'elearning-school' ),
	            'off' => esc_html__( 'Disable', 'elearning-school' ),
	        ],
	    ]
	);

	new \Kirki\Field\Text(
	    [
	        'settings' => 'elearning_school_why_join_us_short_heading',
	        'label'    => esc_html__( 'Short Heading', 'elearning-school' ),
	        'section'  => 'elearning_school_home_industry_heroes_section',
	    ]
	);

	new \Kirki\Field\Text(
        [
            'settings' => 'elearning_school_industry_why_join_us_heading',
            'label'    => esc_html__( 'Main Heading', 'elearning-school' ) ,
            'section'  => 'elearning_school_home_industry_heroes_section',
        ]
    );

	new \Kirki\Field\Number(
		[
			'settings' => 'elearning_school_courses_count',
			'label'    => esc_html__( 'Courses Number Control', 'elearning-school' ),
			'section'  => 'elearning_school_home_industry_heroes_section',
			'default'  => '',
			'choices'  => [
				'min'  => 1,
				'max'  => 6	,
				'step' => 1,
			],
		]
	);

	$elearning_school_courses_count = get_theme_mod('elearning_school_courses_count');

	for ($i=1; $i <= $elearning_school_courses_count; $i++) { 
		
		new \Kirki\Field\Image(
			[
				'settings'    => 'elearning_school_courses_image'.$i,
				'label'       => esc_html__( 'Courses Image 0', 'elearning-school' ).$i,
				'section'     => 'elearning_school_home_industry_heroes_section',
				'default'     => '',
			]
		);

		new \Kirki\Field\Text(
			[
				'settings' => 'elearning_school_couses_heading'.$i,
				'label'    => esc_html__( 'Courses Heading 0', 'elearning-school' ).$i,
				'section'  => 'elearning_school_home_industry_heroes_section',
			]
		);

		new \Kirki\Field\Text(
			[
				'settings' => 'elearning_school_courses_lesson_number' .$i,
				'label'    => esc_html__( 'Courses Lesson Number ', 'elearning-school' ).$i,
				'section'  => 'elearning_school_home_industry_heroes_section',
			]
		);

		new \Kirki\Field\Text(
			[
				'settings' => 'elearning_school_courses_student_number'.$i,
				'label'    => esc_html__( 'Courses Student Number ', 'elearning-school' ).$i,
				'section'  => 'elearning_school_home_industry_heroes_section',
			]
		);

		new \Kirki\Field\Text(
			[
				'settings' => 'elearning_school_courses_time'.$i,
				'label'    => esc_html__( 'Duration ', 'elearning-school' ).$i,
				'section'  => 'elearning_school_home_industry_heroes_section',
			]
		);

		new \Kirki\Field\Image(
			[
				'settings'    => 'elearning_school_courses_team_image'.$i,
				'label'       => esc_html__( 'Courses Team Image 0', 'elearning-school' ).$i,
				'section'     => 'elearning_school_home_industry_heroes_section',
				'default'     => '',
			]
		);

		new \Kirki\Field\Text(
			[
				'settings' => 'elearning_school_courses_team_name'.$i,
				'label'    => esc_html__( 'Courses Team Name ', 'elearning-school' ).$i,
				'section'  => 'elearning_school_home_industry_heroes_section',
			]
		);

		new \Kirki\Field\Text(
			[
				'settings' => 'elearning_school_courses_team_designation'.$i,
				'label'    => esc_html__( 'Courses Team Designation ', 'elearning-school' ).$i,
				'section'  => 'elearning_school_home_industry_heroes_section',
			]
		);

		new \Kirki\Field\Text(
			[
				'settings' => 'elearning_school_courses_button_text'.$i,
				'label'    => esc_html__( 'Courses Button Text ', 'elearning-school' ).$i,
				'section'  => 'elearning_school_home_industry_heroes_section',
			]
		);

		new \Kirki\Field\URL(
			[
				'settings' => 'elearning_school_courses_button_link'.$i,
				'label'    => esc_html__( 'Courses Button Url ', 'elearning-school' ).$i,
				'section'  => 'elearning_school_home_industry_heroes_section',
				'default'  => '',
			]
		);

	}

		Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
	    'type'        => 'custom',
	    'priority'    => 100,
	    'section'     => 'elearning_school_home_industry_heroes_section',
	] );


	/* Footer */

	new \Kirki\Section(
		'elearning_school_footer_section',
		[
			'title'       => esc_html__( 'Footer', 'elearning-school' ),
			'panel'		  => 'elearning_school_home_page_section',
			'priority'    => 30,
		]
	);

	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_footer_widgets_on_off',
			'label'       => esc_html__( 'Footer Widgets On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_footer_section',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	new \Kirki\Field\Checkbox_Switch(
		[
			'settings'    => 'elearning_school_copyright_on_off',
			'label'       => esc_html__( 'Footer Copyright On / Off', 'elearning-school' ),
			'section'     => 'elearning_school_footer_section',
			'default'     => 'on',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'elearning-school' ),
				'off' => esc_html__( 'Disable', 'elearning-school' ),
			],
		]
	);

	new \Kirki\Field\Text(
		[
			'settings' => 'elearning_school_copyright_content_text',
			'label'    => esc_html__( 'Copyright Text', 'elearning-school' ),
			'section'  => 'elearning_school_footer_section',
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Buy Our Premium Theme For More Feature', 'elearning-school' ),
		'default'  => 
	        '<a class="premium_info_btn" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUY_NOW_1 ) . '">' . __( 'Buy Pro', 'elearning-school' ) . '</a>' .
	        '<a class="premium_info_btn bundle" target="_blank" href="' . esc_url( ELEARNING_SCHOOL_BUNDLE_1 ) . '">' . __( 'Buy All Themes In Single Package', 'elearning-school' ) . '</a>',
	    'type'        => 'custom',
	    'priority'    => 100,
	    'section'     => 'elearning_school_footer_section',
	] );

}

function elearning_school_customizer_settings( $wp_customize ) {

	$elearning_school_args = array(
       'type'                     => 'product',
        'child_of'                 => 0,
        'parent'                   => '',
        'orderby'                  => 'term_group',
        'order'                    => 'ASC',
        'hide_empty'               => false,
        'hierarchical'             => 1,
        'number'                   => '',
        'taxonomy'                 => 'product_cat',
        'pad_counts'               => false
    );

	$categories = get_categories($elearning_school_args);
	$cat_posts = array();
	$m = 0;
	$cat_posts[]='Select';
	foreach($categories as $category){
		if($m==0){
			$default = $category->slug;
			$m++;
		}
		$cat_posts[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('elearning_school_featured_product_category',array(
		'default'	=> 'select',
		'sanitize_callback' => 'elearning_school_sanitize_select',
	));

	$wp_customize->add_control('elearning_school_featured_product_category',array(
		'type'    => 'select',
		'choices' => $cat_posts,
		'label' => __('Select category to display products ','elearning-school'),
		'section' => 'elearning_school_home_product_section',
	));

}

add_action( 'customize_register', 'elearning_school_customizer_settings' );