<?php 
/*******************************************************************************
 *  Get Started Notice
 *******************************************************************************/

add_action( 'wp_ajax_elearning_school_dismissed_notice_handler', 'elearning_school_ajax_notice_handler' );

/** * AJAX handler to record dismissible notice status. */
function elearning_school_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function elearning_school_admin_notice_deprecated_hook() {
        $current_screen = get_current_screen();
        if ($current_screen->id !== 'toplevel_page_elearning-school-guide-page') {
        if ( ! get_option('dismissed-get_started', FALSE ) ) { ?>
            <div class="updated notice notice-get-started-class is-dismissible" data-notice="get_started">
                <div class="elearning-school-getting-started-notice clearfix">
                    <div class="elearning-school-theme-notice-content">
                        <h2 class="elearning-school-notice-h2">
                            <?php
                            echo esc_html__( 'Let\'s Create Your website With', 'elearning-school' ) . ' <strong>' . esc_html( wp_get_theme()->get('Name') ) . '</strong>';
                            ?>
                        </h2>
                        <span class="st-notification-wrapper">
                            <span class="st-notification-column-wrapper">
                                <span class="st-notification-column">
                                    <h2><?php echo esc_html('Features Rich Theme','elearning-school'); ?></h2>
                                    <ul class="st-notification-column-list">
                                        <li><?php echo esc_html('Live Customize','elearning-school'); ?></li>
                                        <li><?php echo esc_html('Detailed theme Options','elearning-school'); ?></li>
                                        <li><?php echo esc_html('Cleanly Coded','elearning-school'); ?></li>
                                        <li><?php echo esc_html('Search Engine Friendly','elearning-school'); ?></li>
                                    </ul>
                                </span>
                                <span class="st-notification-column">
                                    <h2><?php echo esc_html('Customize Your Site','elearning-school'); ?></h2>
                                    <ul>
                                        <li><a href="<?php echo esc_url( admin_url( 'customize.php' ) ) ?>" target="_blank" class="button button-primary"><?php echo esc_html('Customize','elearning-school'); ?></a></li>
                                        <li><a href="<?php echo esc_url( admin_url( 'widgets.php' ) ) ?>" class="button button-primary"><?php echo esc_html('Add Widgets','elearning-school'); ?></a></li>
                                        <li><a href="<?php echo esc_url( ELEARNING_SCHOOL_SUPPORT_FREE ); ?>" target="_blank" class="button button-primary"><?php echo esc_html('Get Support','elearning-school'); ?></a> </li>
                                        <li><a href="<?php echo esc_url( admin_url( 'themes.php?page=elearning-school-guide-page' ) ); ?>" class="button-primary button get-start"><?php echo esc_html('Getting Started','elearning-school'); ?></a></li>
                                    </ul>
                                </span>
                                <span class="st-notification-column">
                                    <h2><?php echo esc_html('Get More Options','elearning-school'); ?></h2>
                                    <ul>
                                        <li><a href="<?php echo esc_url( ELEARNING_SCHOOL_DEMO_PRO ); ?>" target="_blank" class="button button-primary"><?php echo esc_html('View Live Demo','elearning-school'); ?></a></li>
                                        <li><a href="<?php echo esc_url( ELEARNING_SCHOOL_BUY_NOW ); ?>" target="_blank" class="button button-primary premium"><?php echo esc_html('Purchase Now','elearning-school'); ?></a></li>
                                        <li><a href="<?php echo esc_url( ELEARNING_SCHOOL_DOCS_FREE ); ?>" target="_blank" class="button button-primary"><?php echo esc_html('Free Documentation','elearning-school'); ?></a> </li>
                                        <li><a href="<?php echo esc_url( admin_url( 'themes.php?page=elearningschool-wizard' ) ); ?>" class="button button-primary demo-import"><?php echo esc_html('Demo Importer','elearning-school'); ?></a> </li>
                                    </ul>
                                </span>
                            </span>
                            <span class="notice-img">
                                <img src="<?php echo esc_url( get_template_directory_uri() . '/images/notice.png' ); ?>">                                
                            </span>
                        </span>
                        <style>
                        </style>
                    </div>
                </div>
            </div>
        <?php }
    }
}

add_action( 'admin_notices', 'elearning_school_admin_notice_deprecated_hook' );

function elearning_school_switch_theme_function () {
    delete_option('dismissed-get_started', FALSE );
}

add_action('after_switch_theme', 'elearning_school_switch_theme_function');